#include <assert.h>
#include <mem.h>
#include <stdio.h>
#include <string.h>

#include "wctype.h"

char *LengthByteToNull(char *s, int maxlen)
{
  int lenbyte;

  lenbyte = s[0];
  assert(lenbyte < maxlen);

  memmove(&s[0], &s[1], lenbyte);
  memset(&s[lenbyte], 0, maxlen - lenbyte);

  return s;
}

char *NullToLengthByte(char *s, int maxlen)
{
  int lenbyte = strlen(s);
  assert(lenbyte < maxlen);

  memmove(&s[1], &s[0], lenbyte);
  s[0] = lenbyte;
  memset(&s[lenbyte + 1], 0, maxlen - lenbyte - 1);

  return s;
}

void ConvertUserFromPascal(TUserRec &user)
{
  LengthByteToNull(user.UserName,       sizeof(user.UserName));
  LengthByteToNull(user.From,           sizeof(user.From));
  LengthByteToNull(user.Password,       sizeof(user.Password));
  LengthByteToNull(user.PhoneNumber,    sizeof(user.PhoneNumber));
  LengthByteToNull(user.DataNumber,     sizeof(user.DataNumber));
  LengthByteToNull(user.FaxNumber,      sizeof(user.FaxNumber));
  LengthByteToNull(user.ComputerType,   sizeof(user.ComputerType));
  LengthByteToNull(user.SecLevel,       sizeof(user.SecLevel));
  LengthByteToNull(user.Secondary[0],   sizeof(user.Secondary[0]));
  LengthByteToNull(user.Secondary[1],   sizeof(user.Secondary[1]));
  LengthByteToNull(user.Secondary[2],   sizeof(user.Secondary[2]));
  LengthByteToNull(user.Secondary[3],   sizeof(user.Secondary[3]));
  LengthByteToNull(user.Secondary[4],   sizeof(user.Secondary[4]));
  LengthByteToNull(user.Company,        sizeof(user.Company));
  LengthByteToNull(user.Address1,       sizeof(user.Address1));
  LengthByteToNull(user.Address2,       sizeof(user.Address2));
  LengthByteToNull(user.City,           sizeof(user.City));
  LengthByteToNull(user.State,          sizeof(user.State));
  LengthByteToNull(user.Zip,            sizeof(user.Zip));
  LengthByteToNull(user.Country,        sizeof(user.Country));
  LengthByteToNull(user.Title,          sizeof(user.Title));
  LengthByteToNull(user.Alias,          sizeof(user.Alias));
  LengthByteToNull(user.NovellName,     sizeof(user.NovellName));
  LengthByteToNull(user.Language,       sizeof(user.Language));
  LengthByteToNull(user.Comment[0],     sizeof(user.Comment[0]));
  LengthByteToNull(user.Comment[1],     sizeof(user.Comment[1]));
  LengthByteToNull(user.Comment[2],     sizeof(user.Comment[2]));
  LengthByteToNull(user.Comment[3],     sizeof(user.Comment[3]));
  LengthByteToNull(user.Comment[4],     sizeof(user.Comment[4]));
}

void ConvertUserToPascal(TUserRec &user)
{
  NullToLengthByte(user.UserName,       sizeof(user.UserName));
  NullToLengthByte(user.From,           sizeof(user.From));
  NullToLengthByte(user.Password,       sizeof(user.Password));
  NullToLengthByte(user.PhoneNumber,    sizeof(user.PhoneNumber));
  NullToLengthByte(user.DataNumber,     sizeof(user.DataNumber));
  NullToLengthByte(user.FaxNumber,      sizeof(user.FaxNumber));
  NullToLengthByte(user.ComputerType,   sizeof(user.ComputerType));
  NullToLengthByte(user.SecLevel,       sizeof(user.SecLevel));
  NullToLengthByte(user.Secondary[0],   sizeof(user.Secondary[0]));
  NullToLengthByte(user.Secondary[1],   sizeof(user.Secondary[1]));
  NullToLengthByte(user.Secondary[2],   sizeof(user.Secondary[2]));
  NullToLengthByte(user.Secondary[3],   sizeof(user.Secondary[3]));
  NullToLengthByte(user.Secondary[4],   sizeof(user.Secondary[4]));
  NullToLengthByte(user.Company,        sizeof(user.Company));
  NullToLengthByte(user.Address1,       sizeof(user.Address1));
  NullToLengthByte(user.Address2,       sizeof(user.Address2));
  NullToLengthByte(user.City,           sizeof(user.City));
  NullToLengthByte(user.State,          sizeof(user.State));
  NullToLengthByte(user.Zip,            sizeof(user.Zip));
  NullToLengthByte(user.Country,        sizeof(user.Country));
  NullToLengthByte(user.Title,          sizeof(user.Title));
  NullToLengthByte(user.Alias,          sizeof(user.Alias));
  NullToLengthByte(user.NovellName,     sizeof(user.NovellName));
  NullToLengthByte(user.Language,       sizeof(user.Language));
  NullToLengthByte(user.Comment[0],     sizeof(user.Comment[0]));
  NullToLengthByte(user.Comment[1],     sizeof(user.Comment[1]));
  NullToLengthByte(user.Comment[2],     sizeof(user.Comment[2]));
  NullToLengthByte(user.Comment[3],     sizeof(user.Comment[3]));
  NullToLengthByte(user.Comment[4],     sizeof(user.Comment[4]));
}

void main()
{
  FILE *fp;
  TUserRec userrec;

  fp = fopen("userrec.bin", "rb");
  fread(&userrec, sizeof(TUserRec), 1, fp);
  fclose(fp);

  ConvertUserFromPascal(userrec);

  // Do something with userrec

  ConvertUserToPascal(userrec);

  fp = fopen("userrec.bin", "wb");
  fwrite(&userrec, sizeof(TUserRec), 1, fp);
  fclose(fp);
}
