#if 0
---------------------------------------------------------------------------
fmlist.h - definitions for linked list of handles

---------------------------------------------------------------------------
Changes:
	EOE: 07JUL92****: Beta C Freeze
										2.05 release freeze
---------------------------------------------------------------------------
#endif

#ifndef __FMLIST_H__
#define __FMLIST_H__

#define NOLENGTH	-1		// to store null terminated string
#define LISTF_INSHEAD	1	// insert at head not tail
#define LISTF_INSTAIL	0	// append to tail (default)
#define SUCCESS 1
#define FAILURE	0
//---------
// EOE 17JUL92/000: CHANGE:
// typedef LOCALHANDLE LISTHANDLE;
#define LISTHANDLE HLOCAL

typedef struct fmlist {
	LISTHANDLE next;
} FMLIST, FAR *LPFMLIST;

// access indexes for preallocated list headers
typedef enum FMLISTNAME {               // TpO 13Aug93 added typedef for C comp
	FMLIST_DEST,          // Destination list
	FMLIST_TRFILE,				// File list
	FMLIST_DIR,						// Not used in this version.
	FMLIST_MAX=FMLIST_DIR
} FMLISTNAME;

#ifdef __cplusplus                      // TpO 13Aug93 added for C comp
extern "C" {
#endif
LPFMLIST 	FAR PASCAL _export FmListNew( FMLISTNAME listi, WORD size, int insflag);
int 				FAR PASCAL _export FmListCount( FMLISTNAME i);
int 				FAR PASCAL _export FmListReset(FMLISTNAME);
LPFMLIST 	FAR PASCAL _export FmListNext(FMLISTNAME);
LISTHANDLE FAR PASCAL _export FmListUnlock( LPFMLIST l);
LPFMLIST 	FAR PASCAL _export FmListLock( LISTHANDLE h);

HGLOBAL 		FAR PASCAL _export FmMemGloStore(LPSTR buf, int len);
HLOCAL 		FAR PASCAL _export FmMemLocStore( LPSTR buf, int len);
LPSTR 			FAR PASCAL _export FmMemGloAllocPtr( int len);
// EOE 17JUL92/000: CHANGE: int -> HGLOBAL, GLOBALHANDLE -> HGLOBAL
HGLOBAL		FAR PASCAL _export FmMemGloFree( HGLOBAL h);
HGLOBAL		FAR PASCAL _export FmMemGloFreePtr( LPSTR p);
//--------------
// EOE 17JUL92/000: CHANGE: int -> HLOCAL, LOCALHANDLE -> HLOCAL
HLOCAL 		FAR PASCAL _export FmMemLocFree(HLOCAL h);
#ifdef __cplusplus                      // TpO 13Aug93 added for C comp
}
#endif

#endif
