/*********************************************************************/
/*                                                                   */
/*  FILE NAME:              SETENV.CMD                               */
/*                                                                   */
/*  AUTHOR:                 Jeffrey S. Kobal (AKA Psycho Murdoctor)  */
/*                                                                   */
/*  DATE:                   May 24, 1993                             */
/*                                                                   */
/*  PURPOSE:                Set Audio-device environmental variables */
/*                                                                   */
/*********************************************************************/

/*********************************************************************/
/* Load the DLL, initialize MCI REXX support                         */
/*********************************************************************/

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

   '@echo off'
   OnNum=0           /* Card number being checked         */
   AcpaNum=0         /* ACPA number being checked         */
   SbNum=0           /* Number of Sound Blaster card      */
   Pas16Num=0        /* Number of Pro-Audio Spectrum card */

   env='OS2ENVIRONMENT'             /* Access Environmental variables    */
   acpaid=value('ACPA-ID',,env)     /* Get env. var. for ACPA position   */
   sbid=value('SB-ID',,env)         /* Get env. var. for SB position     */
   pas16id=value('PAS16-ID',,env)   /* Get env. var. for PAS-16 position */

   call SendString "sysinfo waveaudio quantity wait"
   NumCards=save                          /* Get number of audio cards    */

   do while (OnNum < NumCards)            /* Loop through all audio cards */
      OnNum=OnNum+1                       /* For each audio card          */
      call SendString "sysinfo sequencer0"OnNum" installname" /* Get name */
      if (save="IBMSEQUENCER0"AcpaNum+1) then do   /* If card is ACPA */
         AcpaNum=AcpaNum+1                /* Increment number of ACPAs    */
         if (AcpaNum > 1) then            /* If not 1st ACPA              */
            'SET ACPA'AcpaNum'-ID=0'OnNum /* Set ACPAn-ID to current card */
         else
            if (acpaid = "") then         /* If ACPA-ID isn't set already */
               'SET ACPA-ID=0'OnNum       /* Set ACPA-ID to current card  */
            else if (acpaid <> "0"OnNum) then do  /* If ACPA-ID is different */
               'echo Unrecognized value for ACPA-ID: %ACPA-ID%'  /* Warning */
               'echo First ACPA detected as audio device 0'OnNum /* Message */
               'echo Please update your environmental variables and rerun SETENV'
               MacRC = mciRxExit()                               /* DONE */
               exit 1
            end
      end
      else if (save="IBMSEQSB0"SbNum+1) then do  /* If card is Sound Blaster */
         SbNum=SbNum+1                    /* Increment number of SBs    */
         if (sbid = "") then              /* If SB-ID isn't set already */
            'SET SB-ID=0'OnNum            /* Set SB-ID to current card  */
         else if (sbid <> "0"OnNum) then do  /* If SB-ID is different   */
            'echo Unrecognized value for SB-ID: %SB-ID%'    /* Give Warning */
            'echo Sound Blaster detected as audio device 0'OnNum /* Message */
            'echo Please update your environmental variables and rerun SETENV'
            MacRC = mciRxExit()                                  /* DONE */
            exit 1
         end
      end
      else if (save="IBMSEQPAS160"Pas16Num+1) then do /* If card is PAS-16 */
         Pas16Num=Pas16Num+1              /* Increment number of PAS16s    */
         if (pas16id = "") then           /* If PAS16-ID isn't set already */
            'SET PAS16-ID=0'OnNum         /* Set PAS16-ID to current card  */
         else if (pas16id <> "0"OnNum) then do  /* If PAS-16 is different  */
            'echo Unrecognized value for PAS16-ID: %PAS16-ID%' /* Warning Msg */
            'echo Pro Audio Spectrum-16 detected as audio device 0'OnNum
            'echo Please update your environmental variables and rerun SETENV'
            MacRC = mciRxExit()                                /* DONE */
            exit 1
         end
      end
      else                          /* If card is not ACPA, SB, or PAS-16 */
         say "Unknown card type for audio device #"OnNum": "save /* Error Msg */
   end

   DCStart=1                        /* Ready to set "Don't Care' variables */

   if (Pas16Num > 0) then do        /* If there is a Pro-Audio Spectrum  */
      'SET DC1-ID=%PAS16-ID%'       /* It becomes the first "Don't Care" */
      DCStart=2                     /* Continue with 2nd "Don't Care"    */
   end

   if (SbNum > 0) then do           /* If there is a Sound Blaster       */
      'SET DC1-ID=%SB-ID%'          /* If becomes the first "Don't Care" */
      DCStart=2                     /* Continue with 2nd "Don't Care"    */
   end

   if (AcpaNum < 4) then do         /* Count backwards down ACPAs */
      if (AcpaNum < 3) then do      /* (last ACPA is first "Don't Care" choice) */
         if (AcpaNum < 2) then do
            if (AcpaNum < 1) then
               'SET DC'DCStart'-ID='            /* No ACPA's, NULL DCn-ID */
            else
               'SET DC'DCStart'-ID=%ACPA-ID%'   /* 1 ACPA, becomes DCn-ID */
            'SET DC'DCStart+1'-ID=XX'           /* Overwrite other variables */
            'SET DC'DCStart+2'-ID=XX'
            'SET ACPA2-ID=XX'
         end
         else do
            'SET DC'DCStart'-ID=%ACPA2-ID%'     /* 2 ACPAs, set DCn-IDs   */
            'SET DC'DCStart+1'-ID=%ACPA-ID%'
            'SET DC'DCStart+2'-ID=XX'           /* Overwrite other variables */
         end
         'SET ACPA3-ID=XX'
      end
      else do
         'SET DC'DCStart'-ID=%ACPA3-ID%'        /* 3 ACPAs, set DC-IDs    */
         'SET DC'DCStart+1'-ID=%ACPA2-ID%'
         'SET DC'DCStart+2'-ID=%ACPA-ID%'
      end
      'SET ACPA4-ID=XX'                         /* Overwrite other variables */
   end
   else do
      'SET DC'DCStart'-ID=%ACPA4-ID%'           /* 4 ACPAs, set DC-IDs    */
      'SET DC'DCStart+1'-ID=%ACPA3-ID%'
      'SET DC'DCStart+2'-ID=%ACPA2-ID%'
   end

/*********************************************************************/
/* Terminate the REXX command file and Exit (DLL), return code = 0.  */
/*********************************************************************/

                      /****************************************/
MacRC = mciRxExit()   /* Terminate REXX command file          */
exit 0                /* Tell the DLL we're going away        */
                      /****************************************/

/*********************************************************************/
/*   --- SendString --                                               */
/* Call DLL function.  Pass the command to process and the           */
/* name of a REXX variable that will recieve textual return          */
/* information.                                                      */
/*********************************************************************/

SendString:
   arg CmndTxt
   Zero='0'
   MacRC = mciRxSendString(CmndTxt, 'RetSt', Zero, Zero)
   save=RetSt
   return MacRC

