/****************************************************************************/
/*                                                                          */
/* SAMPGDAT.C: Sample Codec Global Data.                                    */
/*                                                                          */
/* Copyright (c) IBM Corporation 1991,1992,1993        All Rights Reserved  */
/*                                                                          */
/****************************************************************************/

/* OS/2 and Multimedia Includes */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSPROCESS
#include <os2.h>
#include <os2me.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <memory.h>
#include "sampinst.h"
#include "svsh.h"
#include "hhpheap.h"
#include "codecsrv.h"



/****************************************************************************/
/*  DLL Global data.  There is one copy of these in memory and it is        */
/*                    shared by all processes and all instances.            */
/*                    Any additional data you may need here                 */
/*                                                                          */
/*  NOTE - These global data variables MUST be inititialized or they        */
/*         will NOT be placed in the shared segment.                        */
/****************************************************************************/

#pragma data_seg (CDC_SHR)    /* Pragma defining start of shared data seg.  */

/* This color conversion array is for decode only.  It is statically        */
/* allocated rather than dynamically allocated because the compiler will    */
/* code the table address in the decoder as a pointer offset rather than a  */
/* double memory reference giving marked speed gains.  Note also that for   */
/* any given system, there will be only one display plane, and hence only   */
/* one type of conversion will be done for any number of instances.         */
PBYTE aColorConv[512];

/* Define the function prototypes for common function array below.          */
ULONG AllocInstData        ( PCODEC_INST                                );
ULONG DeallocInstData      ( PCODEC_INST                                );
ULONG PaletteHandler       ( PGENPAL                                    );
ULONG CalcClipMask         ( ULONG, PRECTL, RECTL1, PDECODE_INST, ULONG );
ULONG DecompressBuffer     ( PMMDECOMPRESS, PCODEC_INST                 );
ULONG CompressBuffer       ( PMMCOMPRESS, PCODEC_INST                   );


/* This is the main function pointer array.  Place the name of the function */
/* that will be handling the message in the array.  Use "(PFN) NULL" if     */
/* your codec will not be supporting a particular function call message.    */
/* For instance, you may choose not to gain the performance advantage of    */
/* doing you own clipping, and you may only be doing a decompressor, in     */
/* which case, functions "CalcClipMask" and "CompressBuffer" would be NULL. */

CODECFNS codecfns=
   {
   (PFN) AllocInstData,    /* Allocate an instance of the codec.            */
   (PFN) DeallocInstData,  /* Deallocate an instance of the codec.          */
   (PFN) PaletteHandler,   /* Handle palette change notification message.   */
   (PFN) CalcClipMask,     /* Handle visible region change message.         */
   (PFN) DecompressBuffer, /* Handle call to decompress a buffer.           */
   (PFN) CompressBuffer,   /* Handle call to compress a buffer.             */
   (PFN) QryNameLength,    /* Return the length of the codec name.          */
   (PFN) QryNameString,    /* Return the name of the codec.                 */
   };


/* This variable is mandatory and holds capability flags of your codec.     */
ULONG ulGlobalCapsFlags=
         CODEC_COMPRESS         |  /* Does compression.                     */
         CODEC_DECOMPRESS       |  /* Does decompression.                   */
         CODEC_WINDOW_CLIPPING  |  /* Handles clipping messages.            */
         CODEC_PALETTE_TRANS    |  /* Does its own translation to palettes. */
         CODEC_SELFHEAL         |  /* Eventually paints all parts of image. */
         CODEC_MULAPERTURE      |  /* Can decode partial peices.            */
         CODEC_4_BIT_COLOR      |  /* Can decode to 16 color (4 bit) plane. */
         CODEC_8_BIT_COLOR      |  /* Can decode to CLUT8 (8 bit) plane.    */
         CODEC_16_BIT_COLOR     |  /* Can decode to RGB565 (16 bit) plane.  */
         CODEC_SYMMETRIC        |  /* Can compress in real-time.            */
         CODEC_ASYMMETRIC       |  /* Can compress off line (non-real-time).*/
         CODEC_DIRECT_DISPLAY   |  /* Can decode to non-contiguous spaces.  */
         CODEC_ORIGIN_LOWERLEFT |  /* Can decode bottom up.                 */
         CODEC_ORIGIN_UPPERLEFT;   /* Can decode top down.                  */

#pragma data_seg ()                /* Defining end of shared data seg.      */




/****************************************************************************/
/*  DLL Global Process Instance Data.  There is one copy of these variables */
/*  per instance (one "process" can have more than one active "instance").  */
/****************************************************************************/

HMTX           hmtxGlobalData= 0;           /* Critical section semaphore.  */
HHUGEHEAP      hHeap= (ULONG)NULL;          /* Heap Alloc/Dealloc handle.   */
PE_MOVIE_INST  Movie_Inst_Anchor= (PE_MOVIE_INST)NULL; /* Must init to null */
