.386p

INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

;*********************************************
; Define the C calling macros
LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm
;*********************************************

;*********************************************
; Define the RGB16_to_PAL8 - convert RGB16 to a PAL8 value
RGB16_to_PAL8 macro r_offset, d_offset, w_offset
        mov   ax,   Word Ptr [esi+r_offset]; get the RGB16 value   ; 4
        shr   ax,   1                      ; shift off LSB blue    ; 3
        ror   al,   4                      ; get green in LSB      ; 3
        shr   ax,   1                      ; shift out LSB green   ; 3
        shl   eax,  2                      ; x4 for table index    ; 3
        mov   al,   offset flat:ConvTable[eax+d_offset]            ; 4
        mov   Byte Ptr [edi+w_offset], al  ; Save Converted Value  ; 4
        endm
;*********************************************

;*********************************************
; Define the RGB16_to_2PAL8 - convert RGB16 to 2 PAL8 values
RGB16_to_2PAL8 macro r_offset, w2_offset, w_offset
        xor   eax,  eax
        mov   ax,   Word Ptr [esi+r_offset]; get the RGB16 value   ; 4
        shr   ax,   1                      ; shift off LSB blue    ; 3
        ror   al,   4                      ; get green in LSB      ; 3
        shr   ax,   1                      ; shift out LSB green   ; 3
        shl   eax,  2                      ; x4 for table index    ; 3
        mov   eax,  offset flat:ConvTable[eax]                     ; 4
        mov   Word Ptr [edi+w_offset], ax  ; Save Converted Value  ; 4
        ror   eax, 16                                              ; 2
        mov   Word Ptr [edi+w2_offset], ax ; Save Converted Value  ; 4
        endm
;*********************************************

;*********************************************
; Define the COPY_ESI_EDI - Copy a word from ESI+offset1 to EDI+offset2
COPY_ESI_EDI macro offsetD, offsetS
        mov   ax,   Word Ptr [esi+offsetS] ; get the Word value   ; 4
        mov   Word Ptr [edi+offsetD], ax   ; save Word Value      ; 2
        endm
;*********************************************

;*********************************************
; Define the COPY_ESI_EDI2 - Copy a word from ESI+offS to EDI+offD and
; EDI+offD+2 and EDI+offD+offL and EDI+offD+offL+2
; This macro doubles the data
COPY_ESI_EDI2 macro offD, offS, OffL
        mov   ax,   Word Ptr [esi+offS]        ; get the Word value   ; 4

                                               ; Double on first scanline
        mov   Word Ptr [edi+offD],        ax   ; save Word Value      ; 2
        mov   Word Ptr [edi+offD+2],      ax   ; save Word Value      ; 2
                                               ; Double on next Scanline
        mov   Word Ptr [edi+offD+offL],   ax   ; save Word Value      ; 2
        mov   Word Ptr [edi+offD+offL+2], ax   ; save Word Value      ; 2
        endm
;*********************************************


include devsym.inc
include basemaca.inc
include basedef.inc


_DATA   SEGMENT  DWORD USE32 PUBLIC 'DATA'      ; changed from code to data
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT


;** EXTRN        ConvTable:BYTE
ConvTable      DD   0


_DATA   ENDS






_TEXT   SEGMENT  DWORD USE32 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT



;**************************************************************************
; Procedure Name  :     RGB16_to_PAL8
;
; Description     :     Takes a 16-bit RGB565 image and converts it
;                       to an 8-bit RGB666 image from a lookup table.
;
; Input Parameters:
;                       ImageIn    : Pointer to a 16-bit image
;                       ImageOut   : Pointer to a 8-bit image space
;                       LineSize   : Bytess per output line (320=contiguous)
;                                     (XGA screen is 1024) (-320 invert image)
;                       X_width    :
;                       Y_height   :
;                       Double     : Double the output image size
;
; Register status :     All registers trashed
;                       ESP also used (no CALLs or PUSHs may be done)
;
; Restrictions    :
;                       X_width and Y_height must both be multiples of 4
;
;
;**************************************************************************
ALIGN 4
Procedure _RGB16_to_PAL8, NEAR
   ;*********************************************
   ; Parameters on stack
        ImageIn                 equ ebp+8
        ImageOut                equ ebp+12
        LineSize                equ ebp+16
        X_width                 equ ebp+20
        Y_height                equ ebp+24
        Double                  equ ebp+28

   ;*********************************************
   ; Local Variables on stack
        Save_esi                equ ebp-04
   ;*********************************************

            LBegin      4h
            cld
            mov   edi,  DWord Ptr [ImageOut]
            mov   esi,  DWord Ptr [ImageIn]

            mov   ebx, 0                ; skip to new line (PEL double only)
            mov   esp, [LineSize]       ; Size of display line
            sub   esp, [X_width]        ; Size to skip after line written to
; Double the image?
            cmp   dword ptr [double],1  ; should we double the image
            jnz   skip_double           ; NO - skip the double
            sub   esp, [X_width]        ; double the width to a new line
            mov   ebx, [LineSize]       ; Skip to new line for PEL double
skip_double:

            mov   edx,[Y_height]        ; Y lines in image
            xor   eax,eax               ; Zero - non-PEL double case need it
copy_line:
            mov   ecx,[X_width]         ; X lines in image

;.......................................................................
;..................E V E N   S C A N L I N E  copy .......................
;.......................................................................
copy_line_even:
            cmp   dword ptr [double],1         ; should we double the image
            jnz   skip_double_PEL_even        ; NO - skip the double

            movzx eax,  Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            add   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            sub   edi, ebx                     ; go back to first line

            movzx eax,  Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            add   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            sub   edi, ebx                     ; go back to first line

            jmp   copy_2PEL_done_even

skip_double_PEL_even:
            mov   ax,   Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4

            mov   ax,   Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax+1]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4
copy_2PEL_done_even:

            add   esi,4                        ; next byte in input

            sub   ecx,2                        ; count down to end of line
            jnz   Copy_line_even               ; Copy till end of line
            ;-------------------


            add   edi,esp                      ; Next line in display  ; 2
            add   edi,ebx                      ; if PEL double skip to next line
            mov   ecx,[X_width]                ; X lines in image

;.......................................................................
;..................O D D   S C A N L I N E  copy .......................
;.......................................................................
copy_line_odd:
            cmp   dword ptr [double],1         ; should we double the image
            jnz   skip_double_PEL_odd          ; NO - skip the double

            movzx eax,  Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            add   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            sub   edi, ebx                     ; go back to first line

            movzx eax,  Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            add   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            sub   edi, ebx                     ; go back to first line

            jmp   copy_2PEL_done_odd

skip_double_PEL_odd:
            mov   ax,   Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax+2]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4

            mov   ax,   Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax+3]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4
copy_2PEL_done_odd:

            add   esi,4                        ; next byte in input

            sub   ecx,2                        ; count down to end of line
            jnz   Copy_line_odd                ; Copy till end of line
            ;-------------------

            add   edi,esp                      ; Next line in display  ; 2
            add   edi,ebx                      ; if PEL double skip to next line
            sub   edx,2
            jnz   copy_line


copy_done:

            Lend
            RET


EndProc _RGB16_to_PAL8


;**************************************************************************
; Procedure Name  :     RGB16_to_IPAL8
;
; Description     :     Takes a 16-bit RGB565 image and converts and invert it
;                       to an 8-bit RGB666 image from a lookup table.
;
; Input Parameters:
;                       ImageIn    : Pointer to a 16-bit image
;                       ImageOut   : Pointer to a 8-bit image space
;                       LineSize   : Bytess per output line (320=contiguous)
;                                     (XGA screen is 1024) (-320 invert image)
;                       X_width    :
;                       Y_height   :
;                       Double     : Double the output image size
;
; Register status :     All registers trashed
;
; Restrictions    :
;                       X_width and Y_height must both be multiples of 4
;
;
;**************************************************************************
ALIGN 4
Procedure _RGB16_to_IPAL8, NEAR
   ;*********************************************
   ; Parameters on stack
        ImageIn                 equ ebp+8
        ImageOut                equ ebp+12
        LineSize                equ ebp+16
        X_width                 equ ebp+20
        Y_height                equ ebp+24
        Double                  equ ebp+28
   ;*********************************************
   ; Local Variables on stack
        Save_esi                equ ebp-04
   ;*********************************************

            LBegin      4h
            cld
            mov   edi,  DWord Ptr [ImageOut]
            mov   esi,  DWord Ptr [ImageIn]

            mov   ebx, 0                ; skip to new line (PEL double only)
            mov   esp, [LineSize]       ; Size of display line
            sub   esp, [X_width]        ; Size to skip after line written to
            ;Calculate the address of the output image buffer last line
            mov   eax,[X_width]         ; Width of input image
            mov   edx,[Y_height]        ; height of input image
            cmp   dword ptr [double],1  ; are we going to double the image
            jne   Iskip_double            ; NO - skip double size
            shl   eax,1                 ; double the height
            shl   edx,1                 ; double the width
            sub   esp, [X_width]        ; double the width to a new line
            mov   ebx, [LineSize]       ; Skip to new line for PEL double
                                        ;  output buffer
Iskip_double:
            sub   edx,1                 ; less 1 line for start of last line
            mul   EDX                   ; EAX*EDX goes into EDX:EAX
                                        ;  EDX will be zero
            add   EDI,EAX               ; point to last line of output buffer

            xor   eax,eax               ; Zero - non-PEL double case need it
            mov   edx,[Y_height]        ; Y lines in image
Icopy_line:
            mov   ecx,[X_width]         ; X lines in image
;.......................................................................
;..................E V E N   S C A N L I N E  copy .......................
;.......................................................................
Icopy_line_even:
; Double PELs on the scanline
            cmp   dword ptr [double],1         ; should we double the image
            jnz   iskip_double_PEL_even        ; NO - skip the double

            movzx eax,  Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            sub   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            add   edi, ebx                     ; go back to first line

            movzx eax,  Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            sub   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            add   edi, ebx                     ; go back to first line

            jmp   icopy_2PEL_done_even

iskip_double_PEL_even:
            mov   ax,   Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4

            mov   ax,   Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax+1]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4
icopy_2PEL_done_even:

            add   esi,4                        ; next byte in input

            sub   ecx,2                        ; count down to end of line
            jnz   ICopy_line_even              ; Copy till end of line
            ;-------------------



            sub   edi,esp                      ; Next line in display  ; 2
            sub   edi,[linesize]               ; skip to next line
            sub   edi,[linesize]               ; skip to next line
            sub   edi,ebx                      ; if PEL double skip to next line
            mov   ecx,[X_width]                ; X lines in image

;.......................................................................
;..................O D D   S C A N L I N E  copy .......................
;.......................................................................
Icopy_line_odd:
; Double PELs on the scanline
            cmp   dword ptr [double],1         ; should we double the image
            jnz   iskip_double_PEL_odd         ; NO - skip the double

            movzx eax,  Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            sub   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            add   edi, ebx                     ; go back to first line

            movzx eax,  Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3

            mov   eax,  offset flat:ConvTable[eax];Get dither conversion 4
            MOV   Word Ptr [edi], ax           ; Save Converted Value  ; 4
            ror   eax, 16                                              ; 2
            sub   edi, ebx                     ; next line
            STOSW                              ; Save Converted Value  ; 4
            add   edi, ebx                     ; go back to first line

            jmp   icopy_2PEL_done_odd

iskip_double_PEL_odd:
            mov   ax,   Word Ptr [esi]         ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax+2]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4

            mov   ax,   Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shr   ax,   1                      ; shift off LSB blue    ; 3
            ror   al,   4                      ; get green in LSB      ; 3
            shr   ax,   1                      ; shift out LSB green   ; 3
            shl   eax,  2                      ; x4 for table index    ; 3
            mov   al,offset flat:ConvTable[eax+3]; use table to convert  ; 4
            STOSB                              ; Save Converted Value  ; 4
icopy_2PEL_done_odd:

            add   esi,4                        ; next byte in input

            sub   ecx,2                        ; count down to end of line
            jnz   ICopy_line_odd               ; Copy till end of line
            ;-------------------



            sub   edi,esp                      ; Start of current line ; 2
            sub   edi,[linesize]               ; skip to next line
            sub   edi,[linesize]               ; skip to next line
            sub   edi,ebx                      ; if PEL double skip to next line
            sub   edx,2
            jnz   Icopy_line


Icopy_done:

            Lend
            RET


EndProc _RGB16_to_IPAL8


;**************************************************************************
; Procedure Name  :     RGB16_to_IRGB24
;
; Description     :     Takes a 16-bit RGB565 image and converts and invert it
;                       to an 24-bit RGB image
;
; Input Parameters:
;                       ImageIn    : Pointer to a RGB16-bit image
;                       ImageOut   : Pointer to a RGB24-bit image space
;                       X_width    :
;                       Y_height   :
;                       Double     : Double the output image size
;
; Register status :     All registers trashed
;
; Restrictions    :
;                       X_width and Y_height must both be multiples of 4
;
;
;**************************************************************************
ALIGN 4
Procedure _RGB16_to_IRGB24, NEAR
   ;*********************************************
   ; Parameters on stack
        ImageIn                 equ ebp+8
        ImageOut                equ ebp+12
        X_width                 equ ebp+16
        Y_height                equ ebp+20
        Double                  equ ebp+24
   ;*********************************************
   ; Local Variables on stack
        Save_esi                equ ebp-04
        DN_Line                 equ ebp-04
   ;*********************************************

            LBegin      8h
            cld
            mov   edi,  DWord Ptr [ImageOut]
            mov   esi,  DWord Ptr [ImageIn]

            mov   ebx, [X_width]        ; skip to new line (PEL double only)
            sub   esp, 0                ; Size to skip after line written to
            ;Calculate the address of the output image buffer last line
            mov   eax,[X_width]         ; Width of input image
            mov   dword ptr [dn_line],eax; Delta to next Line  width
            shl   dword ptr [dn_line],1  ; Delta to Next Line
            add   dword ptr [dn_line],eax; Delta to next Line  width*3 (24 bits)
            shl   dword ptr [dn_line],1  ; Start of Previous Line
            mov   edx,[Y_height]        ; height of input image
            cmp   dword ptr [double],1  ; are we going to double the image
            jne   Iskip_double24        ; NO - skip double size
            shl   eax,1                 ; double the height
            shl   edx,1                 ; double the width
            sub   esp, [X_width]        ; double the width to a new line
            shl   ebx, 1                ; Skip to new line for PEL double
                                        ;  output buffer
            shl   dword ptr [dn_line],1 ; Delta to Next Line  double if double

Iskip_double24:
            sub   edx,1                 ; less 1 line for start of last line
            mov   ecx,eax               ; Size Width in PELs
            shl   eax,1                 ; * 2
            add   eax,ecx               ; eax = width * 3 (bytes per PEL)
            mul   EDX                   ; EAX*EDX goes into EDX:EAX
                                        ;  EDX will be zero
            add   EDI,EAX               ; point to last line of output buffer
            xor   eax,eax               ; Zero - non-PEL double case need it
            mov   edx,[Y_height]        ; Y lines in image
            mov   ecx,[X_width]         ; X lines in image
;.......................................................................
;.................. S C A N L I N E  copy   ............................
;.......................................................................
Icopy_line24:
; Double PELs on the scanline
            cmp   dword ptr [double],1         ; should we double the image
            jnz   ICopy_SLine24                ; NO - skip the double

ICopy_DLine24:
            movzx eax,  Word Ptr [esi]         ; get the RGB16 value   ; 4
                                               ; 00000000 RRRRRGGG GGGBBBBB
            shl   eax,  5                      ; 000RRRRR GGGGGGBB BBB00000
            shr    ax,  3                      ;    "     000GGGGG GBBBBB00
            shl   eax,  3                      ; RRRRR000 GGGGGGBB BBB00000
            shr    ax,  2                      ;    "     00GGGGGG BBBBB000
            shl    ah,  2                      ; RRRRR... GGGGGG.. BBBBB...

            MOV   [edi], eax                   ; Save Converted Value  ; 2
            MOV   [edi+3], eax                 ; Save Converted Value  ; 2
            sub   edi, ebx                     ; next line             ; 2
            MOV   [edi], eax                   ; Save Converted Value  ; 2
            MOV   [edi+3], eax                 ; Save Converted Value  ; 2
            add   edi,6                        ; Next two RBG24 in dest; 2
            add   edi, ebx                     ; go back to first line

            movzx eax,  Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shl   eax,  5                      ;                       ; 3
            shr    ax,  3                      ;                       ; 3
            shl   eax,  3                      ;                       ; 3
            shr    ax,  2                      ;                       ; 3
            shl    ah,  2                      ; Now eax = RGB24       ; 3

            MOV   [edi], eax                   ; Save Converted Value  ; 2
            MOV   [edi+3], eax                 ; Save Converted Value  ; 2
            sub   edi, ebx                     ; next line             ; 2
            MOV   [edi], eax                   ; Save Converted Value  ; 2
            MOV   [edi+3], eax                 ; Save Converted Value  ; 2
            add   edi,6                        ; Next two RBG24 in dest; 2
            add   edi, ebx                     ; go back to first line

            add   esi,4                        ; next byte in input

            sub   ecx,2                        ; count down to end of line
            jnz   ICopy_Dline24                ; Copy till end of line
            ;-------------------

            jmp   icopy_2PEL_done24

ICopy_SLine24:
            movzx eax,  Word Ptr [esi]         ; get the RGB16 value   ; 4
            shl   eax,  5                      ;                       ; 3
            shr    ax,  3                      ;                       ; 3
            shl   eax,  3                      ;                       ; 3
            shr    ax,  2                      ;                       ; 3
            shl    ah,  2                      ; Now eax = RGB24       ; 3
            mov    [edi],eax                   ; Save Converted value  ; 2
            add    edi,3                       ; Next Byte in Dest     ; 2

            movzx eax,  Word Ptr [esi+2]       ; get the RGB16 value   ; 4
            shl   eax,  5                      ;                       ; 3
            shr    ax,  3                      ;                       ; 3
            shl   eax,  3                      ;                       ; 3
            shr    ax,  2                      ;                       ; 3
            shl    ah,  2                      ; Now eax = RGB24       ; 3
            mov    [edi],eax                   ; Save Converted value  ; 2
            add    edi,3                       ; Next Byte in Dest     ; 2

            add   esi,4                        ; next byte in input

            sub   ecx,2                        ; count down to end of line
            jnz   ICopy_Sline24                ; Copy till end of line
            ;-------------------

icopy_2PEL_done24:
            sub   edi,[dn_line]                ; Next line in output   ; 4
            mov   ecx,[X_width]                ; X lines in image
            sub   edx,1                        ; One Less Line
            jnz   Icopy_line24


Icopy_done24:

            Lend
            RET


EndProc _RGB16_to_IRGB24




;**************************************************************************
; Procedure Name  :     RGB16_B_W_Line
;
; Description     :     Takes a 16-bit RGB565 image and draw a black and white
;                       rectangle on it
;
; Input Parameters:
;                       ImageIn    : Pointer to a 16-bit image
;                       X_left     :
;                       Y_top      :
;                       X_width    :
;                       Y_height   :
;
; Register status :     All registers trashed
;
; Restrictions    :
;                       X_width and Y_height must both be multiples of 4.
;                       This routine only work on a 160x120 RGB16 image
;
;**************************************************************************
ALIGN 4
Procedure _RGB16_B_W_Line, NEAR
   ;*********************************************
   ; Parameters on stack
        ImageIn                 equ ebp+8
        X_left                  equ ebp+12
        Y_Top                   equ ebp+16
        X_width                 equ ebp+20
        Y_height                equ ebp+24


            LBegin      0h
            cld
;------------------------------
; Draw a line across the top
            mov   edi,  DWord Ptr [ImageIn]
            mov   eax,[y_top]
            shr   eax,2                 ; from 640x480 to 160x120
            mov   ecx,160*2             ; Width
            mul   ECX                   ; EAX*ECX goes into EDX:EAX
                                        ;  EDX will be zero
            add   edi,eax               ; point to last line of output buffer
            mov   eax,[x_left]
            shr   eax,1
            add   edi,eax               ; plus offset to X_left
            mov   ecx,[x_width]
            shr   ecx,3                 ; 2 PELs REP STOSD
            mov   eax,0000FFFFh         ; black and white line
            REP   STOSD                 ; Draw the line

;------------------------------
; Draw a line across the bottom
            mov   edi,  DWord Ptr [ImageIn]
            mov   eax,[y_top]
            shr   eax,2                 ; from 640x480 to 160x120
            mov   ebx,[Y_height]
            sub   ebx,1
            shr   ebx,2
            add   eax,ebx               ; start y + delta y
            mov   ecx,160*2             ; Width
            mul   ECX                   ; EAX*ECX goes into EDX:EAX
                                        ;  EDX will be zero
            add   edi,eax               ; point to last line of output buffer
            mov   eax,[x_left]
            shr   eax,1
            add   edi,eax               ; plus offset to X_left
            mov   ecx,[x_width]
            shr   ecx,3                 ; 2 PELs REP STOSD
            mov   eax,0000FFFFh         ; black and white line
            REP   STOSD                 ; Draw the line

;------------------------------
; Draw a line up left and right sides
            mov   edi,  DWord Ptr [ImageIn]
            mov   eax,[y_top]
            shr   eax,2                 ; from 640x480 to 160x120
            mov   ecx,160*2             ; width
            mul   ECX                   ; EAX*ECX goes into EDX:EAX
                                        ;  EDX will be zero
            add   edi,eax               ; point to last line of output buffer
            mov   eax,[X_left]
            shr   eax,1
            add   edi,eax               ; plus offset in the X
            mov   esi,edi               ;
            mov   eax,[x_width]
            sub   eax,1
            shr   eax,1
            add   esi,eax               ; plus offset in X to right side
            mov   ecx,[Y_height]
            shr   ecx,3                 ; 2 PELs REP STOSW
            mov   edx,160*2             ; offset to next line
draw_sides:
            mov   ax,0FFFFh             ; black part of line
            mov   [edi],ax              ; Draw the black part of the left  line
            mov   [esi],ax              ; Draw the black part of the right line
            add   edi,edx               ; down 1 line
            add   esi,edx               ; down 1 line
            mov   bx,0000h              ; White part of line
            mov   [edi],bx              ; Draw the white part of the left  line
            mov   [esi],bx              ; Draw the white part of the right line
            add   edi,edx               ; down 1 line
            add   esi,edx               ; down 1 line
            dec   ecx
            jnz   draw_sides

            Lend
            RET


EndProc _RGB16_B_W_Line


;*****************************************************************************;
; Procedure Name  :     Convert YUV411 to RGB16 (565)                         ;
;                                                                             ;
; Description     :     Convert a Width x Height 16-bit YUV411 image (PCVIDEO ;
;                       format) to RGB16 (Intel 5-Red, 6-Green, 5-Blue format);
;                       using tables for optimal speed                   .    ;
;                                                                             ;
; Register status :                                                           ;
;*****************************************************************************;
ALIGN 4
Procedure _YUV411_to_RGB16, NEAR
   ;*The-Stack***********************************
   ; The local variables:
                luma1                  equ ebp-4
                luma2                  equ ebp-5
                luma3                  equ ebp-6
                luma4                  equ ebp-7

   ; The passed parameters:
                aSrc                    equ ebp+8
                aDst                    equ ebp+12
                lWidth                  equ ebp+16
                lHeight                 equ ebp+20
   ;*The-Stack***********************************

                ; Leave some room on the stack for local variables
                enter   10,0
                pushfd
                pushad

                ; Move the image pointer to the source register.
                mov     esi,    [aSrc]

                ; Move the image pointer to the source register.
                mov     edi,    [adst]

                ; set direction flag to increment
                cld

CONVYUV_LINE:
                ; Set ECX to PELs in a ROW
                mov     ecx,    [lWidth]   ; Width in PELs
                shr     ecx,2              ; Width / 4

CONV_4PEL:
                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma1],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,0C030h           ; Save AH=Cr6:5 and AL=Cb6:5
                shl    al,2
                mov    dx,ax

                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma2],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,0C030h           ; Save AH=Cr4:3 and AL=Cb4:3
                shr    ah,2
                or     dx,ax

                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma3],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,0C030h           ; Save AH=Cr2:1 and AL=Cb2:1
                shr    ax,2
                shr    ah,2
                or     dx,ax

                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma4],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,08020h           ; Save AH=Cr0   and AL=Cb0
                shr    ax,4
                shr    ah,2
                or     dx,ax

                call   UnScaleChroma       ; EDX V = bit 31-16  U = bits 15-0

                movzx  bx,[luma1]           ; Y
                call   ConvertYUVToRGB24
                call   ConvertRGB24ToRGB16
                stosw

                movzx  bx,[luma2]           ; Y
                call   ConvertYUVToRGB24
                call   ConvertRGB24ToRGB16
                stosw

                movzx  bx,[luma3]           ; Y
                call   ConvertYUVToRGB24
                call   ConvertRGB24ToRGB16
                stosw

                movzx  bx,[luma4]           ; Y
                call   ConvertYUVToRGB24
                call   ConvertRGB24ToRGB16
                stosw

;               ; Convert from scaled to unsacled  (Cr to U)
;               movzx  ax,     offset flat: lookCr[dh]
;
;               ; Convert from scaled to unsacled  (Cb to V)
;               movzx  bx,     offset flat: lookCb[dl]

;               mov    dl,[luma1]           ; Y
;               shr    dl,2
;               movzx  ax,dl                ; Green
;               shl    ax,5
;               shr    dl,1
;               or     al,dl                ; Red
;               shl    dx,11
;               or     ax,dx                ; Blue
;               stosw
;
;               mov    dl,[luma2]           ; Y
;               shr    dl,2
;               movzx  ax,dl                ; Green
;               shl    ax,5
;               shr    dl,1
;               or     al,dl                ; Red
;               shl    dx,11
;               or     ax,dx                ; Blue
;               stosw
;
;               mov    dl,[luma3]           ; Y
;               shr    dl,2
;               movzx  ax,dl                ; Green
;               shl    ax,5
;               shr    dl,1
;               or     al,dl                ; Red
;               shl    dx,11
;               or     ax,dx                ; Blue
;               stosw
;
;               mov    dl,[luma4]           ; Y
;               shr    dl,2
;               movzx  ax,dl                ; Green
;               shl    ax,5
;               shr    dl,1
;               or     al,dl                ; Red
;               shl    dx,11
;               or     ax,dx                ; Blue
;               stosw
;


                ; Check to see if we are at the end of the line.
                dec     ecx
                jnz     CONV_4PEL

                dec     dword ptr [lHeight]
                jnz     CONVYUV_LINE


                ; Restore registers and the stack.
                popad
                popfd
                leave
                ret

EndProc _YUV411_to_RGB16

;*****************************************************************************;
; Procedure Name  :     Convert YUV411 to RGB24  and Invert                   ;
;                                                                             ;
; Description     :     Convert a Width x Height 16-bit YUV411 image (PCVIDEO ;
;                       format) to RGB24 (8-Red, 8-Green, 8-Blue format) and  ;
;                       Inver the image                                  .    ;
;                                                                             ;
; Register status :                                                           ;
;*****************************************************************************;
ALIGN 4
Procedure _YUV411_to_IRGB24, NEAR
   ;*The-Stack***********************************
   ; The local variables:
                luma1                  equ ebp-4
                luma2                  equ ebp-5
                luma3                  equ ebp-6
                luma4                  equ ebp-7
                backup                 equ ebp-12

   ; The passed parameters:
                aSrc                    equ ebp+8
                aDst                    equ ebp+12
                lWidth                  equ ebp+16
                lHeight                 equ ebp+20
   ;*The-Stack***********************************

                ; Leave some room on the stack for local variables
                enter   20,0
                pushfd
                pushad

                ; Move the image from source pointer
                mov     esi,    [aSrc]

                ; Move the image to the destination pointer
                mov     edi,    [adst]
                mov     edx,[lHeight]   ; Height of image
                sub   edx,1             ; less 1 line for start of last line
                mov   ecx,[lWidth]      ; Size Width in PELs
                mov   eax,ecx           ;
                shl   eax,1             ; * 2
                add   eax,ecx           ; eax = width * 3 (bytes per PEL)
                mul   EDX               ; EAX*EDX goes into EDX:EAX
                                        ;  EDX will be zero
                add   EDI,EAX           ; point to last line of output buffer

                ; Length to backup after each scanline in Destination buffer
                mov     eax,[lwidth]       ; Each Pixel is 3 Bytes (RGB24)
                shl     eax,1              ; Pixel_width*2
                add     eax,[lwidth]       ; Pixel_width*2 + Pixel_width = 3
                shl     eax,1              ; * 2 (back up for next Inverted line)
                mov    [backup],eax        ; Detla to Previous/Next line in Dest

                ; set direction flag to increment
                cld

ICONVYUV_LINE:
                ; Set ECX to PELs in a ROW
                mov     ecx,    [lWidth]   ; Width in PELs
                shr     ecx,2              ; Width / 4

ICONV_4PEL:
                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma1],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,0C030h           ; Save AH=Cr6:5 and AL=Cb6:5
                shl    al,2
                mov    dx,ax

                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma2],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,0C030h           ; Save AH=Cr4:3 and AL=Cb4:3
                shr    ah,2
                or     dx,ax

                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma3],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,0C030h           ; Save AH=Cr2:1 and AL=Cb2:1
                shr    ax,2
                shr    ah,2
                or     dx,ax

                lodsw
                and    al,0feh             ; Y LSB undefined make 0
                mov    [luma4],al          ; Save Y = Lumance
                mov    al,ah               ; Cr and Cb in al and Ah
                and    ax,08020h           ; Save AH=Cr0   and AL=Cb0
                shr    ax,4
                shr    ah,2
                or     dx,ax

                call   UnScaleChroma       ; EDX V = bit 31-16  U = bits 15-0

                movzx  bx,[luma1]          ; Y
                call   ConvertYUVToRGB24   ; BL=Red AH=Green AL=Blue
                shl    ebx,16              ; Move Red up to proper position
                and    eax,0FFFFh          ; Clear top for byte of Red
                or     eax,ebx             ; Combine Red in with Green and Blue
                mov    [edi],eax           ; Store RGB24 to 1 extra byte
                add    edi,3               ; Only 3 Valid Bytes but 4 written

                movzx  bx,[luma2]           ; Y
                call   ConvertYUVToRGB24
                shl    ebx,16              ; Move Red up to proper position
                and    eax,0FFFFh          ; Clear top for byte of Red
                or     eax,ebx             ; Combine Red in with Green and Blue
                mov    [edi],eax           ; Store RGB24 to 1 extra byte
                add    edi,3               ; Only 3 Valid Bytes but 4 written

                movzx  bx,[luma3]           ; Y
                call   ConvertYUVToRGB24
                shl    ebx,16              ; Move Red up to proper position
                and    eax,0FFFFh          ; Clear top for byte of Red
                or     eax,ebx             ; Combine Red in with Green and Blue
                mov    [edi],eax           ; Store RGB24 to 1 extra byte
                add    edi,3               ; Only 3 Valid Bytes but 4 written

                movzx  bx,[luma4]           ; Y
                call   ConvertYUVToRGB24
                shl    ebx,16              ; Move Red up to proper position
                and    eax,0FFFFh          ; Clear top for byte of Red
                or     eax,ebx             ; Combine Red in with Green and Blue
                mov    [edi],eax           ; Store RGB24 to 1 extra byte
                add    edi,3               ; Only 3 Valid Bytes but 4 written

                ; Check to see if we are at the end of the line.
                dec     ecx
                jnz     ICONV_4PEL

                sub     edi,[backup]       ; Backup to previous line to Invert
                dec     dword ptr [lHeight]
                jnz     ICONVYUV_LINE


                ; Restore registers and the stack.
                popad
                popfd
                leave
                ret

EndProc _YUV411_to_IRGB24


;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 ConvertYUVToRGB24                                                    3
;3                                                                      3
;3 This routine converts one YUV value to a 24 bit RGB value and        3
;3 returns the result in AX and BL.                                     3
;3                                                                      3
;3      U = B-Y         ->      B = U+Y                                 3
;3      V = R-Y         ->      R = V+Y                                 3
;3      Y  = 0.299*R + 0.587*G + 0.114*B        ->                      3
;3      G = 1.704*Y - 0.5094*R - 0.1942*B                               3
;3                                                                      3
;3 Entry:       DX  = U = B-Y                                           3
;3              EDX = V = R-Y (bit 31-16)                                          3
;3              BX  = Y = luma component                                3
;3 Exit:        AH  = Green                                             3
;3              AL  = Blue                                              3
;3              BL  = Red                                               3
;3 Note:        U and V are signed numbers.  Luma is unsigned.          3
;3 Modifies:    AX,BX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
ALIGN 4
Procedure ConvertYUVToRGB24, NEAR
        push    edx
Blue:   mov     ax,dx
        add     ax,bx                  ;AX = U + Y = Blue
        jge     @F
        xor     ax,ax
        jmp     Red
@@:     cmp     ax,0ffh
        jle     Red
        mov     ax,0ffh

Red:    shr     edx,16                  ; V
        add     dx,bx                   ;DX = V + Y = Red
        jge     @F
        xor     dx,dx
        jmp     have_red_and_blue
@@:     cmp     dx,0ffh
        jle     have_red_and_blue
        mov     dl,0ffh

have_red_and_blue:
        mov     dh,al
        xchg    dx,bx                   ;BH = Blue   BL = Red   DX = Luma

Green:  mov     ax,436                  ;(436/256) = 1.703
        mul     dx
        mov     dh,dl
        mov     dl,ah                   ;DX = 1.704 * luma

        mov     al,bl                   ;Red
        mov     ah,130                  ;(130/256) = 0.5078
        mul     ah
        mov     al,ah
        xor     ah,ah
        sub     dx,ax                   ;DX = 1.704*luma - 0.508*red
        mov     al,bh                   ;Blue
        mov     ah,50
        mul     ah
        mov     al,ah
        xor     ah,ah
        sub     dx,ax                   ;DX = 1.704*luma - 0.508*red - 0.195*blue
        jge     check_green_overflow
        xor     dl,dl                   ;Set green to zero.
        jmp     have_rgb

check_green_overflow:
        cmp     dh,0                    ;Is green > 255?
        je      have_rgb                ;No.
        mov     dl,0ffh                 ;Yes, set it to 255.

have_rgb:
        mov     al,bh
        mov     ah,dl                   ;AH = Green   AL = Blue   BL = Red
        pop     edx
        ret
EndProc ConvertYUVToRGB24

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 ConvertRGB24ToRGB16                                                  3
;3                                                                      3
;3 This routine converts a 24 bit RGB value to a 16 bit RGB value.      3
;3                                                                      3
;3 Entry:       AH = Green  AL = Blue  BL = Red                         3
;3 Exit:        AX = 16 bit value (Red D14:D10, Blue D4:D0,             3
;3                       Green D15,D9:D5)                               3
;3 Modifies:    AX,BX                                                   3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
ALIGN 4
Procedure ConvertRGB24ToRGB16, NEAR
        add     al,00000100b            ;Round blue to 5 bits.
        jnc     @F
        mov     al,0ffh
@@:     add     ah,00000010b            ;Round green to 6 bits
        jnc     @F
        mov     ah,0ffh
@@:     add     bl,00000100b            ;Round red to 5 bits.
        jnc     @F
        mov     bl,0ffh
@@:     shr     bl,3
        shl     bx,11
        shr     ah,2
        shr     ax,3
        or      ax,bx

        ret
EndProc ConvertRGB24ToRGB16

;ZDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD?
;3 UnScaleChroma                                                        3
;3                                                                      3
;3 This routine multiplies the two scaled 8 bits chroma components, U   3
;3 and V by the fractions 229/127 and 179/127, respectively.  The       3
;3 results are stored in the local variables U and V.                   3
;3                                                                      3
;3 Entry:       DL = scaled V                                           3
;3              DH = scaled U                                           3
;3 Exit:        EDX V = unscaled V bits 31-16                           3
;3              EDX U = unscaled U bits 15-0                            3
;3 Destroys:    AX,BX,DX                                                3
;@DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDY
ALIGN 4
Procedure UnScaleChroma, NEAR
        push    ecx
        mov     bl,dh                   ;BL = scaled U
        mov     al,dl
        cbw                             ;AX = scaled V (sign extended)
        mov     dx,361                  ;(361/256 = 179/127)
        imul    dx
        mov     al,ah
        mov     ah,dl
        mov     cx,ax                    ;CX = unscaled V

        mov     al,bl
        cbw                             ;AX = scaled U (sign extended)
        mov     dx,456                  ;(456/256 = 226/127)
        imul    dx
        mov     al,ah
        mov     ah,dl
;       mov     U,ax                    ;AX = unscaled U
        xor     edx,edx
        mov     dx,ax
        shl     ecx,16
        or      edx,ecx                 ; V bit 31-16 and U bit 15-0 of EDX
        pop     ecx
        ret
EndProc UnScaleChroma

;*****************************************************************************;
; Procedure Name  :     Convert RGB16 (565) to YUV24                          ;
;                                                                             ;
; Description     :     Convert a Width x Height 16-bit RGB:565 image (Intel  ;
;                       format) to Y, U, V using tables for optimal speed.    ;
;                                                                             ;
; Register status :                                                           ;
;*****************************************************************************;
ALIGN 4
Procedure _RGB16_to_YUV24, NEAR
   ;*The-Stack***********************************
   ; The local variables:
   ; The return Stack Pointer           equ esp
   ; The return address                 equ esp+4

   ; The passed parameters:
                aSrc                    equ ebp+8
                aDst                    equ ebp+12
                lWidth                  equ ebp+16
                lHeight                 equ ebp+20
   ;*The-Stack***********************************

                ; Leave some room on the stack for ebp storage.
                enter   0,0
                pushfd
                pushad

                ; Move the image pointer to the source register.
                mov     esi,    [aSrc]

                ; Move the image pointer to the source register.
                mov     edi,    [adst]

                ; set direction flag to increment
                cld

CONV_NEW_ROW:
                ; Set ECX to PELs in a ROW
                mov     ecx,    [lWidth]   ; Width in PELs

                ; Move in the low byte of the color to convert.
CONV_ROW:       lodsb

                ; Using the low byte, grab a piece for each component.
                mov     dh,     offset flat: lookYl [eax]
                mov     bl,     offset flat: lookUl [eax]
                mov     bh,     offset flat: lookVl [eax]

                ; Move in the high byte of the color to convert.
                lodsb

                ; Using the High byte, grab a piece for each component
                ; and sum with low byte.
                ; Note that there is no over- or under-flow so no
                ; bounds checking is done.
                add     dh,     offset flat: lookYh [eax]
                add     bl,     offset flat: lookUh [eax]
                add     bh,     offset flat: lookVh [eax]

                ; Save the YUV24 value in the Destination Buffer
                mov     es:[edi+0],dh    ; Y
                mov     es:[edi+1],bx    ; U & V
                add     edi,3            ; Next spot to write YUV24 data

                ; Check to see if we are at the end of the line.
                dec     ecx
                jnz     CONV_ROW

                dec     dword ptr [lHeight]
                jnz     CONV_NEW_ROW


                ; Restore registers and the stack.
                popad
                popfd
                leave
                ret

EndProc _RGB16_to_YUV24






;*****************************************************************************;
; Here lie the tables for rgb->yuv conversion.  6 byte tables= 1,536 bytes.   ;
;*****************************************************************************;


lookYh db      0,  19,  38,  57,  77,  96, 115, 134
       db      2,  22,  41,  60,  79,  98, 117, 136
       db      5,  24,  43,  62,  81, 101, 120, 139
       db      7,  26,  46,  65,  84, 103, 122, 141
       db     10,  29,  48,  67,  86, 105, 125, 144
       db     12,  31,  50,  70,  89, 108, 127, 146
       db     15,  34,  53,  72,  91, 110, 129, 149
       db     17,  36,  55,  74,  94, 113, 132, 151
       db     19,  39,  58,  77,  96, 115, 134, 153
       db     22,  41,  60,  79,  98, 118, 137, 156
       db     24,  43,  63,  82, 101, 120, 139, 158
       db     27,  46,  65,  84, 103, 122, 142, 161
       db     29,  48,  68,  87, 106, 125, 144, 163
       db     32,  51,  70,  89, 108, 127, 146, 166
       db     34,  53,  72,  92, 111, 130, 149, 168
       db     37,  56,  75,  94, 113, 132, 151, 170
       db     39,  58,  77,  96, 116, 135, 154, 173
       db     41,  61,  80,  99, 118, 137, 156, 175
       db     44,  63,  82, 101, 120, 140, 159, 178
       db     46,  65,  85, 104, 123, 142, 161, 180
       db     49,  68,  87, 106, 125, 144, 164, 183
       db     51,  70,  89, 109, 128, 147, 166, 185
       db     54,  73,  92, 111, 130, 149, 168, 188
       db     56,  75,  94, 113, 133, 152, 171, 190
       db     58,  78,  97, 116, 135, 154, 173, 192
       db     61,  80,  99, 118, 137, 157, 176, 195
       db     63,  82, 102, 121, 140, 159, 178, 197
       db     66,  85, 104, 123, 142, 161, 181, 200
       db     68,  87, 106, 126, 145, 164, 183, 202
       db     71,  90, 109, 128, 147, 166, 185, 205
       db     73,  92, 111, 130, 150, 169, 188, 207
       db     76,  95, 114, 133, 152, 171, 190, 209

lookYl db      0,   1,   2,   3,   4,   5,   6,   7
       db      7,   8,   9,  10,  11,  12,  13,  14
       db     15,  16,  17,  18,  19,  20,  20,  21
       db     22,  23,  24,  25,  26,  27,  28,  29
       db      2,   3,   4,   5,   6,   7,   8,   9
       db     10,  11,  12,  13,  14,  14,  15,  16
       db     17,  18,  19,  20,  21,  22,  23,  24
       db     25,  26,  27,  27,  28,  29,  30,  31
       db      5,   6,   7,   8,   8,   9,  10,  11
       db     12,  13,  14,  15,  16,  17,  18,  19
       db     20,  21,  22,  22,  23,  24,  25,  26
       db     27,  28,  29,  30,  31,  32,  33,  34
       db      7,   8,   9,  10,  11,  12,  13,  14
       db     15,  16,  16,  17,  18,  19,  20,  21
       db     22,  23,  24,  25,  26,  27,  28,  29
       db     29,  30,  31,  32,  33,  34,  35,  36
       db     10,  10,  11,  12,  13,  14,  15,  16
       db     17,  18,  19,  20,  21,  22,  23,  24
       db     24,  25,  26,  27,  28,  29,  30,  31
       db     32,  33,  34,  35,  36,  37,  37,  38
       db     12,  13,  14,  15,  16,  17,  18,  18
       db     19,  20,  21,  22,  23,  24,  25,  26
       db     27,  28,  29,  30,  31,  31,  32,  33
       db     34,  35,  36,  37,  38,  39,  40,  41
       db     14,  15,  16,  17,  18,  19,  20,  21
       db     22,  23,  24,  25,  25,  26,  27,  28
       db     29,  30,  31,  32,  33,  34,  35,  36
       db     37,  38,  39,  39,  40,  41,  42,  43
       db     17,  18,  19,  20,  20,  21,  22,  23
       db     24,  25,  26,  27,  28,  29,  30,  31
       db     32,  33,  33,  34,  35,  36,  37,  38
       db     39,  40,  41,  42,  43,  44,  45,  46

lookUh db    118, 107,  97,  86,  75,  65,  54,  43
       db    117, 106,  95,  85,  74,  63,  52,  42
       db    115, 105,  94,  83,  72,  62,  51,  40
       db    114, 103,  93,  82,  71,  60,  50,  39
       db    113, 102,  91,  80,  70,  59,  48,  38
       db    111, 100,  90,  79,  68,  58,  47,  36
       db    110,  99,  88,  78,  67,  56,  45,  35
       db    108,  98,  87,  76,  66,  55,  44,  33
       db    107,  96,  86,  75,  64,  53,  43,  32
       db    106,  95,  84,  73,  63,  52,  41,  31
       db    104,  94,  83,  72,  61,  51,  40,  29
       db    103,  92,  81,  71,  60,  49,  39,  28
       db    101,  91,  80,  69,  59,  48,  37,  26
       db    100,  89,  79,  68,  57,  46,  36,  25
       db     99,  88,  77,  67,  56,  45,  34,  24
       db     97,  87,  76,  65,  54,  44,  33,  22
       db     96,  85,  74,  64,  53,  42,  32,  21
       db     94,  84,  73,  62,  52,  41,  30,  19
       db     93,  82,  72,  61,  50,  40,  29,  18
       db     92,  81,  70,  60,  49,  38,  27,  17
       db     90,  80,  69,  58,  47,  37,  26,  15
       db     89,  78,  67,  57,  46,  35,  25,  14
       db     88,  77,  66,  55,  45,  34,  23,  13
       db     86,  75,  65,  54,  43,  33,  22,  11
       db     85,  74,  63,  53,  42,  31,  20,  10
       db     83,  73,  62,  51,  40,  30,  19,   8
       db     82,  71,  61,  50,  39,  28,  18,   7
       db     81,  70,  59,  48,  38,  27,  16,   6
       db     79,  68,  58,  47,  36,  26,  15,   4
       db     78,  67,  56,  46,  35,  24,  13,   3
       db     76,  66,  55,  44,  34,  23,  12,   1
       db     75,  64,  54,  43,  32,  21,  11,   0

lookUl db      9,  13,  18,  22,  26,  30,  34,  38
       db     42,  46,  51,  55,  59,  63,  67,  71
       db     75,  79,  83,  88,  92,  96, 100, 104
       db    108, 112, 116, 120, 125, 129, 133, 137
       db      8,  12,  16,  20,  24,  29,  33,  37
       db     41,  45,  49,  53,  57,  62,  66,  70
       db     74,  78,  82,  86,  90,  94,  99, 103
       db    107, 111, 115, 119, 123, 127, 131, 136
       db      7,  11,  15,  19,  23,  27,  31,  35
       db     40,  44,  48,  52,  56,  60,  64,  68
       db     73,  77,  81,  85,  89,  93,  97, 101
       db    105, 110, 114, 118, 122, 126, 130, 134
       db      5,   9,  14,  18,  22,  26,  30,  34
       db     38,  42,  46,  51,  55,  59,  63,  67
       db     71,  75,  79,  84,  88,  92,  96, 100
       db    104, 108, 112, 116, 121, 125, 129, 133
       db      4,   8,  12,  16,  20,  25,  29,  33
       db     37,  41,  45,  49,  53,  57,  62,  66
       db     70,  74,  78,  82,  86,  90,  95,  99
       db    103, 107, 111, 115, 119, 123, 127, 132
       db      3,   7,  11,  15,  19,  23,  27,  31
       db     36,  40,  44,  48,  52,  56,  60,  64
       db     68,  73,  77,  81,  85,  89,  93,  97
       db    101, 106, 110, 114, 118, 122, 126, 130
       db      1,   5,  10,  14,  18,  22,  26,  30
       db     34,  38,  42,  47,  51,  55,  59,  63
       db     67,  71,  75,  79,  84,  88,  92,  96
       db    100, 104, 108, 112, 117, 121, 125, 129
       db      0,   4,   8,  12,  16,  21,  25,  29
       db     33,  37,  41,  45,  49,  53,  58,  62
       db     66,  70,  74,  78,  82,  86,  90,  95
       db     99, 103, 107, 111, 115, 119, 123, 127

lookVh db     95,  81,  68,  54,  41,  27,  14,   0
       db     99,  86,  72,  58,  45,  31,  18,   4
       db    103,  90,  76,  62,  49,  35,  22,   8
       db    107,  94,  80,  67,  53,  39,  26,  12
       db    111,  98,  84,  71,  57,  44,  30,  16
       db    116, 102,  88,  75,  61,  48,  34,  21
       db    120, 106,  93,  79,  65,  52,  38,  25
       db    124, 110,  97,  83,  69,  56,  42,  29
       db    128, 114, 101,  87,  74,  60,  46,  33
       db    132, 118, 105,  91,  78,  64,  51,  37
       db    136, 123, 109,  95,  82,  68,  55,  41
       db    140, 127, 113, 100,  86,  72,  59,  45
       db    144, 131, 117, 104,  90,  76,  63,  49
       db    148, 135, 121, 108,  94,  81,  67,  53
       db    153, 139, 125, 112,  98,  85,  71,  58
       db    157, 143, 130, 116, 102,  89,  75,  62
       db    161, 147, 134, 120, 107,  93,  79,  66
       db    165, 151, 138, 124, 111,  97,  83,  70
       db    169, 155, 142, 128, 115, 101,  88,  74
       db    173, 160, 146, 132, 119, 105,  92,  78
       db    177, 164, 150, 137, 123, 109,  96,  82
       db    181, 168, 154, 141, 127, 114, 100,  86
       db    185, 172, 158, 145, 131, 118, 104,  90
       db    190, 176, 162, 149, 135, 122, 108,  95
       db    194, 180, 167, 153, 139, 126, 112,  99
       db    198, 184, 171, 157, 144, 130, 116, 103
       db    202, 188, 175, 161, 148, 134, 121, 107
       db    206, 192, 179, 165, 152, 138, 125, 111
       db    210, 197, 183, 169, 156, 142, 129, 115
       db    214, 201, 187, 174, 160, 146, 133, 119
       db    218, 205, 191, 178, 164, 151, 137, 123
       db    222, 209, 195, 182, 168, 155, 141, 128

lookVl db     33,  32,  31,  31,  30,  29,  29,  28
       db     27,  27,  26,  25,  25,  24,  23,  23
       db     22,  21,  21,  20,  19,  19,  18,  17
       db     17,  16,  15,  15,  14,  13,  13,  12
       db     31,  30,  29,  29,  28,  27,  27,  26
       db     26,  25,  24,  24,  23,  22,  22,  21
       db     20,  20,  19,  18,  18,  17,  16,  16
       db     15,  14,  14,  13,  12,  12,  11,  10
       db     29,  28,  28,  27,  26,  26,  25,  24
       db     24,  23,  22,  22,  21,  20,  20,  19
       db     18,  18,  17,  16,  16,  15,  14,  14
       db     13,  12,  12,  11,  10,  10,   9,   8
       db     27,  27,  26,  25,  25,  24,  23,  23
       db     22,  21,  21,  20,  19,  19,  18,  17
       db     17,  16,  15,  15,  14,  13,  13,  12
       db     11,  11,  10,   9,   9,   8,   7,   7
       db     26,  25,  24,  24,  23,  22,  22,  21
       db     20,  20,  19,  18,  18,  17,  16,  16
       db     15,  14,  14,  13,  12,  12,  11,  10
       db     10,   9,   8,   8,   7,   6,   6,   5
       db     24,  23,  23,  22,  21,  21,  20,  19
       db     19,  18,  17,  17,  16,  15,  15,  14
       db     13,  13,  12,  11,  11,  10,   9,   9
       db      8,   7,   7,   6,   5,   5,   4,   3
       db     22,  22,  21,  20,  20,  19,  18,  18
       db     17,  16,  16,  15,  14,  14,  13,  12
       db     12,  11,  10,  10,   9,   8,   8,   7
       db      6,   6,   5,   4,   4,   3,   2,   2
       db     21,  20,  19,  19,  18,  17,  17,  16
       db     15,  15,  14,  13,  13,  12,  11,  11
       db     10,   9,   9,   8,   7,   7,   6,   5
       db      5,   4,   3,   3,   2,   1,   1,   0



_TEXT   ENDS
END
