/************************************************************************
* Program:      PCVIDEO.DLL                                             *
* Module:       PCVIDEO.H                                               *
* Description:  'C' prototype definitions for routines                  *
* Version:      1.7                                                     *
* Copyright (C) Chips and Technologies, Inc. 1991, 1992                 *
************************************************************************/
//#include <typedef.h>
ULONG PCV_LoadConfiguration(PSZ, PVOID *, ULONG *, HFILE  *);
BOOL  PCV_SaveConfiguration(PVOID, ULONG);
WORD  PCV_GetProfileInt(PSZ, PSZ);
int   PCV_GetProfileString(PSZ,PSZ,PSZ,int);
// $$$ MCI 31 MODS
#define CAPTURE_BUFFER_WIDTH    1024    /* Dimensions of the capture */
#define CAPTURE_BUFFER_HEIGHT   512     /* buffer in pixels */
// $$$ MCI 31 MODS

#define LOCLK           0
#define HICLK           1

#define GPIO_CNTL       0x18
#define GPIO3           0x13
#define PLL_DIVISOR_INDEX 0x13
#define PLL_DIVISOR_DATA  0x12
#define PLL_DIVISOR_LO  0
#define PLL_DIVISOR_HI  1
#define INT_MASK_CNTL   0x09            /* Interrupt mask register */
#define AV_MODE_CNTL    0x20            /* Acquisition video mode register */
#define AW_MODE_CNTL    0x21            /* Acquisition window control register */
#define NON_MULTIPLEXED 0x10            /* Input is not multiplexed. */
#define ACQUIRE_FIELD   4
#define SHIFT_CLK_START 0x4C
#define DW_MODE_CNTL    0x40

#define INTERLACE_CNTL  0x50
#define INTERLACE_ON    1
#define REPLICATE_ON    8

#define BLUE_MASK_REG   4
#define LUM_MASK_REG    7
#define CHRO_MASK_REG   8
#define HORIZENTAL_FILTER_REG   4               //SAA7186
#define VERTICAL_FILTER_REG     8               //SAA7186
#define I2C_ADR         0
#define I2C_SUBADR      1
#define I2C_DAT         2

#define I2C_SCL         0
#define I2C_SDA         1

/* Color adjustments */
#define BRIGHTNESS      0
#define SATURATION      1
#define CONTRAST        2
#define HUE             3
#define RED             4
#define GREEN           5
#define BLUE            6

/* Phixel chip addresses */
#define ADRDMSD         0x8A    /* Digital multistandard decoder */
#define ADR7191         0x8A    /* Square pixel digital multistandard decoder 4:2:2 */
#define ADR7186         0xB8    /* Digital Video data scaler with embedded line memory */
#define ADR7192         0xE0    /* Color space converter */
#define ADR9051         0x8A    /* Digital multistandard decoder 4:1:1 */
#define ADR4680         0x88    /* Color processor */

#define HUE_CONTROL     7

/* System metrics */
#define SM_VIDEOWIDTH   0
#define SM_VIDEOHEIGHT  1
#define SM_BOARDTYPE    2
#define SM_VERSION      3
#define SM_INTERLACE    4
#define SM_REPLICATE    5
#define SM_IMAGEWIDTH   6
#define SM_IMAGEHEIGHT  7
#define SM_IMAGETYPE    8

/* Mode flags */
#define MF_PACKED       0x40
#define MF_PLANAR       0x00
#define MF_INTERLACED   0x02
#define MF_PLUSPOLARITY 0x08

/* Video board types */
#define BT_YUV411       0
#define BT_RGB16        1
#define BT_RGB24        2
#define BT_YUV211       3
#define BT_YUV422       4

/* Bitmap types */
#define BM_MASK         0xFF
#define BM_DIB24        0               /* Windows DIB 24 bit true color */
#define BM_DIB8P        1               /* Windows DIB 8 bit palettized */
#define BM_DIB8G        2               /* Windows DIB 8 bit gray-scale */
#define BM_DIB4D        3               /* Windows DIB 4 bit dithered */
#define BM_TRG32        4               /* Targa 32 bit true color */
#define BM_TRG24        5               /* Targa 24 bit true color */
#define BM_TRG16        6               /* Targa 16 bit true color */
#define BM_YUV411       7               /* IBM MMotion format 4:1:1 YUV */
#define BM_TIFF24       8               /* TIFF 24 bit true color */
#define BM_TIFF8P       9               /* TIFF 8 bit palettized */
#define BM_TIFF8G       10              /* TIFF 8 bit gray-scale */
#define BM_PCX8P        11              /* PCX 8 bit palettized */
#define BM_PCX8G        12              /* PCX 8 bit gray-scale */
#define BM_PCX4D        13              /* PCX 4 bit dithered */
#define BM_GIF8P        14              /* GIF 8 bit palettized */
#define BM_GIF8G        15              /* GIF 8 bit gray-scale */
#define BM_JFIF         BM_GIF8P        /* JPEG compressed 4:1:1 YUV */

/* Clipboard data types */
#define CLP_MASK        0xF000
#define CLP_BITMAP      0x1000
#define CLP_DIB         0x2000


/* Palette types */
#define WM_DIB          1
#define PM_DIB          2
#define PCX             3
#define TIFF            4

/*
Print options (passed in the wOptions parameter of SaveImageRect).  The
low 8 bits the wOptions parameter are reserved - these must be zero.
*/
#define STRETCH_MASK    0x0300          /* 0=no stretch, 1=2x, 2=3x, 3=4x */
#define COPY_TO_BUFFER  0x0400          /* Copy data to buffer, not file */
#define INFO_HDR_ONLY   0x0800          /* Return info header only */

#define MMP_HDR_STRING  "YUV12C"        /* Header string for MMotion file */
#define BMP_HDR_STRING  "BM"            /* Header string for Windows DIB */

typedef struct MMPHDR {
    char        mhIDString[6];
    WORD        mhReserved[3];
    WORD        mhWidth;
    WORD        mhHeight;
    } MMPHDR;
typedef MMPHDR FAR *LPMMPHDR;

typedef struct TRGHDR {
    BYTE        bIDFieldSize;           /* Characters in ID field */
    BYTE        bClrMapType;            /* Color map type */
    BYTE        bImageType;             /* Image type */
    BYTE        lClrMapSpec[5];         /* Color map specification */
    WORD        wXOrigin;               /* X origin */
    WORD        wYOrigin;               /* Y origin */
    WORD        wWidth;                 /* Bitmap width */
    WORD        wHeight;                /* Bitmap height */
    BYTE        bBitsPixel;             /* Bits per pixel */
    BYTE        bImageDescriptor;       /* Image descriptor */
    } TRGHDR;
typedef TRGHDR FAR *LPTRGHDR;

#define PLANE4_PALETTE_COLOR    16
#define PLANE8_PALETTE_COLOR    256

typedef struct PCXFILEHEADER {
    BYTE        bIDFieldSize;           /* Characters in ID field */
    BYTE        bVersion;               /* 0 = Version 2.5 */
                                        /* 2 = Version 2.8 with palette info */
                                        /* 3 = Version 2.8, 3.0 w/o palette info */
                                        /* 5 = Version 3.0 with palette info */
    BYTE        bEncode;                /* RLL encode */
    BYTE        bBitsPixel;             /* Bits per pixel */
    WORD        wXOrigin;               /* X origin */
    WORD        wYOrigin;               /* Y origin */
    WORD        wXright;                 /* X2 inclusive */
    WORD        wYbottom;                /* Y2 inclusive */
    WORD        wHres;                  /* Horizental resolution */
    WORD        wVres;                  /* Vertical resolution */
    } PCXFILEHEADER;
typedef PCXFILEHEADER FAR *LPPCXFILEHDR;

typedef struct COLORREG{
    BYTE        bRed;
    BYTE        bGreen;
    BYTE        bBlue;
    } COLORREG;

typedef struct PCXINFOHEADER{
    COLORREG    Palette[PLANE4_PALETTE_COLOR];
    BYTE        bVMode;                 /* Ignore should always be zero */
    BYTE        bNumPlanes;             /* Number of bit planes */
    WORD        wBytesPerLine;          /* Bytes per line */
    BYTE        aReserved[60];
    } PCXINFOHEADER;
typedef PCXINFOHEADER FAR *LPPCXINFOHDR;

#define TIFF_NEWSUBFILETYPE     0
#define TIFF_IMAGEWIDTH         1
#define TIFF_IMAGELENGTH        2
#define TIFF_ROWSPERSTRIP       3
#define TIFF_STRIPOFFSETS       4
#define TIFF_STRIPBYTECOUNTS    5
#define TIFF_XRESOLUTION        6
#define TIFF_YRESOLUTION        7
#define TIFF_RESOLUTIONUNIT     8
#define TIFF_SAMPLESPERPIXEL    9
#define TIFF_BITSPERSAMPLE      10
#define TIFF_COMPRESSION        11
#define TIFF_PHOTOMETRICINTERPRETATION  12

/* Tiff file tag value */

#define NewSubfileTypeTag       0xFE
#define ImageWidthTag           0x100
#define ImageLengthTag          0x101
#define RowsPerStripTag         0x116
#define StripOffsetsTag         0x111
#define StripByteCountsTag      0x117
#define ResolutionUnitTag       0x128
#define XResolutionTag          0x11A
#define YResolutionTag          0x11B
#define SamplesPerPixelTag      0x115
#define BitsPerSampleTag        0x102
#define CompressionTag          0x103
#define ColorMapTag             0x140
#define PlanarConfigurationTag  0x11C
#define PhotometricInterpretationTag    0x106

typedef struct TIFFFILEHEADER {
    WORD        bIDFieldSize;           /* Byte ordering ID field */
    WORD        Version;                /* Version = 42*/
    DWORD       Offset;
    } TIFFFILEHEADER;

typedef struct TIFFDE{
    WORD        wTag;           /* Tag name */
    WORD        wType;          /* Data type of the image parameter */
    DWORD       dCount;         /* Count of the specified data type */
    DWORD       dValueOffset;
    } TIFFDE;

typedef struct COLORMAP{
    WORD        wRed[256];
    WORD        wGreen[256];
    WORD        wBlue[256];
    } COLORMAP;

#define ORIGIN_TOP_LEFT 0x20            /* Origin is at top left. */

#define NO_COLOR_SETTINGS 8             /* Available color controls */
#define NO_COLOR_CONTROLS 7             /* Actual number of color controls */
#define NO_SKEW_FACTORS 7               /* Number of skew factors */
#define NO_VIDEO_MODES  16              /* Number of video modes supported */
#define NO_PHIXEL_CHIPS 4               /* Number of Phixel chips supported */

/* Configuration flags */
#define CF_PAL          0               /* Input format is PAL */
#define CF_NTSC         1               /* Input format is NTSC */
#define CF_SECAM        2               /* Input format is SECAM (SAA7191) */
#define CF_HASPLL       3               /* Board has a phase-locked loop */
#define CF_REPLICATE    REPLICATE_ON    /* Replicate field feature enabled */

/* Acquisition flags */
#define PAL_SECAM       0               /* Acquisition windows index */
#define NTSC            1

/* Skew adjustment IDs */
#define SF_DISPWINSKEWX         0       /* Display Window X Skew */
#define SF_DISPWINSKEWY         1       /* Display Window Y Skew */
#define SF_DISPADDRSKEWX        2       /* Display Address X Skew */
#define SF_DISPADDRSKEWY        3       /* Display Address Y Skew */
#define SF_SHIFTCLOCKSTART      4       /* Shift Clock Start */
#define SF_PALETTESKEW          5       /* Palette Skew */
#define SF_PLLDIVISOR           6       /* Phase Lock Loop Divisor */

/* Skew adjustment ranges */
#define DISPWINSKEWXRANGE       0x7FF   /* Display Window X Skew Range */
#define DISPWINSKEWYRANGE       0x7FF   /* Display Window Y Skew Range */
#define DISPADDRSKEWXRANGE      0x3FF   /* Display Address X Skew Range */
#define DISPADDRSKEWYRANGE      0x3FF   /* Display Address Y Skew Range */
#define SHIFTCLOCKSTARTRANGE    0x7F    /* Shift Clock Start Range */
#define PALETTESKEWRANGE        0x03    /* Palette Skew Range */
#define PLLDIVISORRANGE         0x3FF   /* Phase Lock Loop Divisor Range */

#define MAX_PALETTE_ENTRIES     236     /* Windows reserves 20 of the 256 colors */
#define PF_PALFILE              0x4000  /* Output a palette file */

typedef struct REGENTRY {
    BYTE        rIndex;                 /* Register index */
    BYTE        rData;                  /* Register data */
    } REGENTRY;

typedef struct PCVIDEOTBL {
    WORD        cPCVideoRegs;           /* Count of registers */
    REGENTRY    aPCVideoRegs[64];       /* Register index and data */
    } PCVIDEOTBL;

typedef struct PHIXELCHIP {
    char        aChipID[10];            /* i2c chip id */
    WORD        wPhixelAddr;            /* i2c address of chip */
    WORD        cPhixelRegs;            /* Count of registers */
    REGENTRY    aPhixelRegs[32];        /* Register index and data */
    } PHIXELCHIP;

typedef struct PHIXELTBL {
    WORD        cPhixelChips;
    PHIXELCHIP  aPhixelChips[NO_PHIXEL_CHIPS];
    } PHIXELTBL;

typedef struct MODE {
    WORD        DispWinSkewX;           /* Offset to add to display window registers */
    WORD        DispWinSkewY;
    WORD        DispAddrSkewX[4];       /* Offsets to be added to display address */
    WORD        DispAddrSkewY[4];
    WORD        ShiftClkStart[4];       /* Shift clock start position */
    WORD        PaletteSkew;            /* 2 MSBs of Display Window Control Reg.  */
    WORD        VGAWidth;               /* VGA resolution */
    WORD        VGAHeight;
    WORD        PLLDivisor;             /* Divisor for the PLL */
    WORD        fModeFlags;             /* Miscellaneous flags */
  } MODE;
typedef MODE *PMODE;

typedef struct CFGSTRUCT {
    WORD        wPortAddr;
    WORD        wVideoAddr;
    WORD        wCfgFlags;
    WORD        wVideoSource;
    BYTE        bColorSettings[NO_COLOR_SETTINGS];
    PCVIDEOTBL  PCVideoTable;
    PHIXELTBL   PhixelTable;
    MODE        aMode[NO_VIDEO_MODES+1];
    WORD        wPALAcqWindow[4];
    WORD        wNSTCAcqWindow[4];
    BYTE        aReserved[44];
    WORD        wBoardType;
  } CFGSTRUCT;


typedef struct ACQUISITIONRECT {
    WORD        aX1;
    WORD        aY1;
    WORD        aX2;
    WORD        aY2;
} ACQUISITIONRECT;

/*
 * NOTE: Similiar changes must be made to the MASM counter part in pcvideo.inc
 */
typedef struct  BOARDINITSTRUCT {
    int         (*fpfncInit)(); /* Pointer to init routine */
    BYTE        aName[16];              /* Name of the board */
} BOARDINITSTRUCT;

