/*********************************************************************/
/*                                                                   */
/*  FILE NAME:              HWCODE.CMD                               */
/*                                                                   */
/*  AUTHOR:                 Jeffrey S. Kobal (AKA Psycho Murdoctor)  */
/*                                                                   */
/*  DATE:                   June 02, 1993                            */
/*                                                                   */
/*  PURPOSE:                Display meaning of given hardware code   */
/*                                                                   */
/*********************************************************************/

parse arg blah                   /* Get command-line parameter     */

blah=TRANSLATE(blah)             /* Convert parameter to uppercase */

l=length(blah)                   /* If the length of the parameter */
if (l < 2) then do               /* is less than 2 characters      */
  say "Usage: HWCODE <code to translate>" /* Give Error Message    */
  exit 1                                  /* DONE */
end

parse var blah name '.' ext      /* Break the parameter into       */
                                 /* filename and extension         */

m=length(name)

if (ext = 'CMD' & m > 2) then do /* If this is a REXX test case    */
  char1=substr(name,m-1,1)       /* The hardware code is the last  */
  char2=substr(name,m,1)         /* 2 characters of the filename   */
end
else do
  char1=substr(blah,l-1,1)       /* For P2STRING, the code is the  */
  char2=substr(blah,l,1)         /* last 2 chars of the extension  */
end

  code1=c2d(char1)               /* Find value of first character  */
  if (code1 >= 48 & code1 <= 57) then
    code1=code1-48               /* '1'-'9' = 1-9                  */
  else if (code1 >= 65 & code1 <= 90) then
    code1=code1-55               /* 'A'-'Z' = 10-35                */
  else
    code1=100                    /* Character is not 1-9/A-Z       */

  code2=c2d(char2)               /* Find value of second character */
  if (code2 >= 48 & code2 <= 57) then
    code2=code2-48
  else if (code2 >= 65 & code2 <= 90) then
    code2=code2-55
  else
    code2=100                    /* Using the same formula above   */

  if (code1=100 | code2=100) then    /* If either character is out of range */
    say "Unrecognized hardware code" /* Display an error message            */
  else if (code1 < 32 & code2 < 32) then do  /* If both chars are bit-encoded */
    other=code1%8                /* 1st char, top 2 bits = unspecified audio */
    type=(code1-other*8)%4       /* 1st char, 3rd bit = OEM card type set    */
    acpas=code1//4               /* 1st char, bottom 2 bits = num of ACPAs   */
    cds=code2%8                  /* 2nd char, top 2 bits = num of CD-ROMs    */
    oem=code2//8                 /* 2nd char, bottom 3 bits = OEM card type  */

    if (acpas > 0) then do       /* If any ACPAs are needed by the test */
      say "ACPA(s) needed : "acpas
      say ""
    end
    if (cds > 0) then do         /* If any CD-ROMs are needed by the test */
      say "CD-ROM(s) needed : "cds
      say ""
    end
    if (oem+type > 0) then do    /* If any OEM cards are needed by the test*/
      if (type=0) then do        /* First OEM card type set (audio cards)  */
        if (oem=0) then          /* Display which card in the set          */
          say "Card(s) needed : None"
        else if (oem=1) then
          say "Card(s) needed : Sound Blaster Normal (OPL0)"
        else if (oem=2) then
          say "Card(s) needed : Unused"
        else if (oem=3) then
          say "Card(s) needed : Unused"
        else if (oem=4) then
          say "Card(s) needed : Sound Blaster 16-ASP"
        else if (oem=5) then
          say "Card(s) needed : Pro Audio Spectrum-16"
        else if (oem=6) then
          say "Card(s) needed : Sound Blaster Pro (any SB except OPL0)"
        else if (oem=7) then
          say "Card(s) needed : Sound Blaster (Any)"
      end
      else                       /* Second OEM card type set (video capture) */
        if (oem=0) then          /* Display which card(s) in the set         */
          say "Card(s) needed : Video Capture Adapter (Any)"
        else if (oem=1) then
          say "Card(s) needed : Any Video Capture Adapter + Sound Blaster 16-ASP"
        else if (oem=2) then
          say "Card(s) needed : Any Video Capture Adapter + Pro Audio Spectrum-16"
        else if (oem=3) then
          say "Card(s) needed : Unused"
        else if (oem=4) then
          say "Card(s) needed : Unused"
        else if (oem=5) then
          say "Card(s) needed : Unused"
        else if (oem=6) then
          say "Card(s) needed : Unused"
        else if (oem=7) then
          say "Card(s) needed : Unused"
      say ""
    end

    if (other > 0) then do       /* If any unspecified audio cards needed   */
      say "Unspecified card(s) (""don't cares"") needed : "other
      say ""
    end                          /* Display total number of audio cards needed */
    say "Total number of audio cards needed : "acpas+other+(oem > 0)
  end
  else if (code1 < 32) then do   /* If only first character is bit-encoded  */
    say "Special hardware code"  /* There are no defined hardware codes     */
  end
  else if (code2 < 32) then do   /* If only second character is bit-encoded */
    if (char1='W') then do       /* Test needs a certain type of Laserdisc  */
      if (code2=0) then do       /* Laserdisc type defined by 2nd character */
        say "Laserdisc needed: LD-V8000"
      end
      else if (code2=1) then do
        say "Laserdisc needed: LD-V4400"
      end
      else if (code2=2) then do
        say "Laserdisc needed: LD-V4200"
      end
      else if (code2=3) then do
        say "Laserdisc needed: LD-V4300D"
      end
      else
        say "Laserdisc needed: Type "char2
    end
    else if (char1='X') then do  /* Test needs a certain Video Capture Adapter */
      if (code2=0) then do       /* Adapter type defined by 2nd character      */
        say "Video Capture Adapter needed: IBM VCA - NTSC version"
      end
      else if (code2=1) then do
        say "Video Capture Adapter needed: Jovian SuperVIA - NTSC version"
      end
      else if (code2=2) then do
        say "Video Capture Adapter needed: Jovian QuickVIA - NTSC version"
      end
      else if (code2=3) then do
        say "Video Capture Adapter needed: Video Blaster - NTSC version"
      end
      else if (code2=4) then do
        say "Video Capture Adapter needed: IBM VCA - PAL version"
      end
      else if (code2=5) then do
        say "Video Capture Adapter needed: Jovian SuperVIA - PAL version"
      end
      else if (code2=6) then do
        say "Video Capture Adapter needed: Jovian QuickVIA - PAL version"
      end
      else if (code2=7) then do
        say "Video Capture Adapter needed: Video Blaster - PAL version"
      end
      else
        say "Video Capture Adapter needed: Type "char2
    end
    else
      say "Special hardware code"   /* 'Y' and 'Z' are undefined codes  */
  end
  else
    say "Special hardware code"     /* No defined codes if neither      */
                                    /* character is bit-encoded         */

exit 0
