/* TSR MAIL INSTALL */

'@Echo Off'

/* Set the installed object's title. */

Title = 'TSR Mail 1a'


/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installing TSR MAIL...'
Say ''


/* Verify the existence of the various component files. */

Language = 'ENGLISH'

Result = SysFileTree( 'TCMAIL.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: TCMAIL.EXE not found!'
  Signal DONE
  End

/* Ask for the target directory name. */
 
Say 'Please enter the full name of the directory to which'
Say '  you want TCMAIL installed (default C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End
Say ''


/* Perform the installation. */

Say 'Copying TSR MAIL to ' Directory '...'
Copy TCMAIL.EXE Directory                   '1>NUL'

Say 'Creating program object...'
Type = 'WPProgram'
Folder = '<WP_DESKTOP>'

Parms = 'EXENAME='Directory'\TCMAIL.EXE;STARTUPDIR='Directory

Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Object created!  Done.'
Else             
  Say 'ERROR: Object not created.'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
