/*********************************************************************
PM Patrol installation
*********************************************************************/
trace 'O'
address CMD

'@ECHO OFF'
'cls'
say "PM Patrol Installation"
say "----------------------"

/*********************************************************************
Initialization
*********************************************************************/
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

instdrive = ''
instpath = ''
bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)

/*********************************************************************
Get the installation drive
*********************************************************************/
say ""
say "Please enter the drive to install upon: (ie. C:)"
parse Upper Pull instdrive
if instdrive == '' then do
  instdrive=bootdrive
end
if right(instdrive, 1)<>':' then do
  instdrive=instdrive||':'
end 

/*********************************************************************
Get the installation path
*********************************************************************/
say ""
say "PM Patrol creates a subdirectory called PMP for it's files."
say "Please enter the directory where PMP should be placed: (blank for root)"
parse Upper Pull intpath
if intpath <> '' then do
  if left(intpath, 1) <> '\' then do
    intpath='\'||intpath
  end
end
intpath=instdrive||intpath
instpath=intpath||"\PMP"

/*********************************************************************
verify installation drive and path
*********************************************************************/
say ""
say "PM Patrol will be installed in: " instpath
say "Is this correct? (Y/N)"
parse Upper Pull response
if response <> 'Y' then do
  say "PM Patrol installation aborted.  Nothing installed."
  exit 1
end

/*********************************************************************
ask about wps objects
*********************************************************************/
say ""
say "Create the desktop PM Patrol Workplace Shell objects? (Y/N)"
parse Upper Pull wpsind

say ""
'md ' intpath  ' 1>nul 2>nul'
'md ' instpath ' 1>nul 2>nul'
say "Installing PM Patrol files..."
'copy * ' instpath ' 1>nul'
if rc <> 0 then do
  say "Problem copying files to " instpath
  exit 1
end

/*********************************************************************
Define and Create the Folder
*********************************************************************/
if wpsind == 'Y' then do
  say "Creating WorkPlace objects..."

  foldobj='<PMPatrol>'
  foldtitle='PM Patrol'
  foldicon='pmpfoldr.ico'

  call SysCreateObject 'WPFolder', foldtitle,'<WP_DESKTOP>','OBJECTID='||foldobj||';ICONFILE='||instpath||'\'||foldicon||';','R'

  /*********************************************************************
  Create Reference Program ICONs in the Folder
  *********************************************************************/
  progobj='PMP_Info'
  progname='view.exe'
  progtitle='Information'
  progpath=bootdrive||'\os2'
  progtype='PM'
  progparm='pmpatrol.inf'
  call CreateProgram

  progobj='PMP_Patrol'
  progname='pmpatrol.exe'
  progtitle='PM Patrol'
  progpath=instpath
  progtype='PM'
  progparm=''
  call CreateProgram
end

/*********************************************************************
let em know everything ok
*********************************************************************/
say ""
say "PM Patrol sucessfully installed."
exit 0

/*********************************************************************
create a program object in a folder
*********************************************************************/
CreateProgram:
  call SysCreateObject 'WPProgram',progtitle,foldobj,'OBJECTID='||progobj||';EXENAME='||progpath||'\'||progname||';PROGTYPE='||progtype||';PARAMETERS='||progparm||';STARTUPDIR='||instpath||';','R'
  return
