#define _EASYALIGNMENT_			/* This machine has no alignment problems */

/* (the following #define is due to a compiler quirk in C6.0.)	 */
#define lsbyte signed char				/* signed 8-bit integer */

typedef unsigned char		lubyte;		/* unsigned 8-bit integer */
typedef signed short int	lsshort;	/* signed 16-bit integer */
typedef unsigned short int	lushort;	/* unsigned 16-bit integer */
typedef signed long int		lslong;		/* signed 32-bit integer */
typedef unsigned long int	lulong;		/* unsigned 32-bit integer */
typedef signed short int	lbool;

typedef signed int			lsint;
typedef unsigned int		luint;

typedef lushort				lhwnd;
typedef lushort				lhdc;

#include "windows.h"

typedef lubyte far *lfpbyte;	/* like the old LPSTR */
typedef lubyte far *lplubyte;

typedef lushort lchar;			/* For 1- or 2-byte characters */
typedef lulong L24COLOR;		/* a 24 bit RGB color */

/* convert two lushorts into an lulong */
#define lmakeulong(lo, hi) \
	((lulong)(((lushort)(lo)) | (((lulong)((lushort)(hi))) << 16)))
/* retrieve low 16 bits of a lulong as lushort */
#define lloushort(lul) ((lushort)(lul))
/* retrieve low 16 bits of a lslong as lsshort */
#define llosshort(lsl) ((lsshort)(lsl))
/* retrieve high 16 bits of a lulong as lushort */
#define lhiushort(lul) ((lushort)(((lulong)(lul) >> 16) & 0xFFFF))
/* retrieve high 16 bits of a lslong as lsshort */
#define lhisshort(lsl) ((lsshort)(((lslong)(lsl) >> 16) & 0xFFFF))
/* retrieve low 8 bits of a lushort as lubyte */
#define lloubyte(lus) ((lubyte)(lus))
/* retrieve high 8 bits of a lushort as lubyte */
#define lhiubyte(lus) ((lubyte)(((lushort)(lus) >> 8) & 0xFF))

#define LTRUE	1
#define LFALSE	0
#define LNULL	0

class lpoint
{
public:
	lsshort x;
	lsshort y;
};

typedef lpoint far		*lplpoint;

class lrect
{
public:
	lsshort left;
	lsshort top;
	lsshort right;
	lsshort bottom;
};

#define min(a,b)    (((a) < (b)) ? (a) : (b))
