#ifndef WHELLO_H
#define WHELLO_H

long FAR PASCAL _export 	WndProc( HWND hWnd,  unsigned int iMessage, 
							unsigned int wParam, LONG lParam );
lslong FAR PASCAL _export 	HelpProc( lsshort , luint , lslong );

#define FORCED_SIZE 0x01
#include "ibmacro.h"
#include "dialogs.h"

/* edit icon struct */
typedef struct tagEDITCUSTOMICON
{
	HWND 		DialogBox;
	HICONBAR 	DialogIconBar;
	HANDLE 		hDIB;		// handle to the device independent bitmap
	POINT 		ActualOffset;	// offset into static2 of the actual size bitmap
	POINT 		ZoomedOffset;	// offset into static3 of the fat bits bitmap
	POINT 		ZoomedSize;	// offset into static3 of the fat bits bitmap
	WORD 		Scale;			// scale of Zoomed to Actual
	DWORD 		LColor;		// the color currently selected for the left button
	DWORD 		RColor;		// the color currently selected for the right button
	DWORD 		*IconColors;	// list of colors in the icon
	WORD 		NumColors;
	BOOL 		CurrentDIBChanged;
	BOOL 		AnyChanges;
	CUSTOMICON 	LastCustomIcon;
	int 		LastCustom;
	BOOL 		*ColorsUsed;	// list of colors indexes 
	BOOL 		MButtonsSwapped;
} EDITCUSTOMICON;

class CListItem;
typedef CListItem *pCListItem;

class CListHead
{
	private:
		static	pCListItem	cFirstListItem;

	public:
		static void				AddListItem( pCListItem );
		static void				RemoveListItem( pCListItem );
		static pCListItem		GetListItem( HANDLE );
};

class CListItem
{
	private:
		pCListItem		cNextListItem;
		HANDLE			cTask;

	public:
						CListItem(void);
						~CListItem(void);
		HANDLE			GetTask( void );
		void			SetNextListItem(pCListItem);
		pCListItem		GetNextListItem(void );
};

inline CListItem::CListItem()
{
	cTask = GetCurrentTask();
	cNextListItem = LNULL;
	CListHead::AddListItem(this);
}

inline CListItem::~CListItem()
{
	CListHead::RemoveListItem(this);
}

inline void
CListItem::SetNextListItem(pCListItem NewListItem)
{
	cNextListItem = NewListItem;
}

inline HANDLE
CListItem::GetTask()
{
	return cTask;
}

inline pCListItem
CListItem::GetNextListItem()
{
	return cNextListItem;
}

// Windows classes

class Main
{
	public:
		static HANDLE 	hInstance;
		static HANDLE 	hPrevInstance;
		static lsshort 		nCmdShow;
		static int 		MessageLoop( void );
};

class WWindow
{
	protected:
		HWND hWnd;
	public:
		inline HWND GetHandle( void ) 
						{ return hWnd; }
		inline lbool Show( lsshort nCmdShow ) 
						{ return ShowWindow( hWnd, nCmdShow ); }
		inline void Update( void ) 
						{ UpdateWindow( hWnd ); }
		virtual long WndProc(WORD iMessage,WORD wParam,LONG lParam ) = 0;
};

class MainWindow : public WWindow , public CListItem
{
	private:
		static char 	szClassName[14];
		HANDLE			IconManLibrary;			// Handle to library.
		HMANAGER 		IconManager;			// IconBar Manager.
		lubyte			IconSize;				// Current Size of icons.
		HICONBAR 		IconBar[8];			/* set our max to 8 */
		lubyte 			NumIconBars;		/* set our max to 8 */
		lubyte			IconFlags;
		lubyte			NumDialogBoxes;
		FARPROC			OldHook;
		lushort			DialogBoxID[4];
		EDITCUSTOMICON	*TmpPtr;
		lushort			cCurrentIconBar;
	public:
							MainWindow( void );
		static 	void 		Register( void );
				int 		MessageLoop( void );
				long 		WndProc(WORD iMessage,WORD wParam,LONG lParam );
				void 		PaintOneLineHelp(lubyte *String);
				void 		InvalidateOneLineHelp( void );
				void 		Paint( void );
		inline 	lubyte 		GetIconSize( void ) { return IconSize; };
				void 		SelectConfigurationFile( void );
				HMANAGER	GetIconMan( void );
				void 		SetIconMan( HWND );
				HICONBAR	GetIconBar( void );
				void 		SetIconBar( HICONBAR );
				void		CreateIconBar( void );
				void		ChangeIcon(lushort );
				lbool		EditIcon( LPCUSTOMICON );
				void		EndEditIcon( HWND );
				void		SelectionChange(void);
				void		DeselectIcon(void);
				void		TurnOnForce(void);
				void		TurnOffForce(void);
				lbool		IsForceOn(void);
				void		NewCopy(void);
				void		IncrementDialogBoxes(lushort);
				void		DecrementDialogBoxes(void);
				lbool		AnyDialogBoxes(void);
				void		StartHelpHook(void);
				void		EndHelpHook(void);
				lbool		AlreadyHooked(void);		
				lbool		ChangeIconSize(lubyte);
				void		EnableAllWindows(lbool);
				void		DestroyIconManager(void);
				void		CheckIcons(void);
				void		SendMenuItem(lushort);
				void		SendMacro(BYTE *);
				void		SetOldHook(FARPROC);
				FARPROC		GetOldHook(void);
				lslong 		Help(lsshort , luint , lslong );
				EDITCUSTOMICON *GetTmpPtr(void);
				lsbyte		GetIconBarIndex(HICONBAR);
				void		SetRect(HICONBAR,LPRECT);
				void		SetCurrentIconBar(lushort );
				void 		MakeDialogIconBar(HWND hDlg,LPCUSTOMICON Custom );
				lbool 		ComputeMacroPathName(BYTE * filepath);
				lbool 		SaveMacroToIcon(BYTE * filepath);
				lbool 		CreateNewIcon(HWND ,int ,BOOL ,HANDLE );
				void 		GetDefaultCustomPath(BYTE * );
				void 		AddMacroPathToMacro(BYTE * );
				void 		SetIconSize(BYTE );
				lbool 		GetLastPosition(void );
				lbool 		GetLastRect(LPRECT prect);
				BYTE 		GetLastIconSize(void);
				void 		SetLastRect(void);
				void 		SetLastPosition(void);
				void 		SetLastIconSize(void);
				lbool 		SaveDescription(void);
				void 		CopyClipboard(HWND );
				void 		SaveCustomBits(void);
				void 		SaveCustomIconSelection(void);
				lbool 		CreateNewIcon(HWND ,int ,lbool ,HANDLE );
				void		EndStub();
};

HMEMORY far _export 		MemoryAlloc(lulong );
HMEMORY far _export 		MemoryReAlloc(lushort ,lulong );
lubyte far * far _export 	MemoryLock(HMEMORY );
lbool far _export 			MemoryUnlock(HMEMORY );
lulong far _export 			MemorySize(HMEMORY );
lbool far _export 			MemoryFree(HMEMORY );
lulong far _export 			MessageProc(HPARENT , HMANAGER, HICONBAR,
									lushort , lulong , lulong );

static inline void
MainWindow::Register( void )
{
	WNDCLASS wndclass;   // Structure used to register Windows class.

	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = ::WndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = sizeof( MainWindow * );
	wndclass.hInstance     = Main::hInstance;
	wndclass.hIcon         = LoadIcon( Main::hInstance, "ICONSTUB" );
	wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
	wndclass.hbrBackground = GetStockObject( WHITE_BRUSH );
	wndclass.lpszMenuName  = "StubMenu";
	wndclass.lpszClassName = szClassName;

	if ( ! RegisterClass( &wndclass ) )
		exit( FALSE );
}

inline HICONBAR 
MainWindow::GetIconBar()
{
	return IconBar[cCurrentIconBar];
}

inline void
MainWindow::SetCurrentIconBar(lushort NewIB)
{
	HMENU hMenu;

	hMenu = GetMenu(hWnd);
	if (hMenu)
		CheckMenuItem(hMenu,MF_ICONBAR1 + cCurrentIconBar,
				MF_BYCOMMAND | MF_UNCHECKED );

	cCurrentIconBar = NewIB;

	if (hMenu)
		CheckMenuItem(hMenu,MF_ICONBAR1 + cCurrentIconBar,
				MF_BYCOMMAND | MF_CHECKED );
}

inline void
MainWindow::SetIconBar(HICONBAR NewIconBar)
{
	IconBar[NumIconBars - 1] = NewIconBar;
}

inline HMANAGER 
MainWindow::GetIconMan()
{
	return IconManager;
}

inline void
MainWindow::SetIconMan(HWND NewMan)
{
	IconManager = NewMan;
}

inline void		
MainWindow::TurnOnForce()
{
	IconFlags |= FORCED_SIZE;
}

inline void		
MainWindow::TurnOffForce()
{
	IconFlags &= ~FORCED_SIZE;
}

inline lbool		
MainWindow::IsForceOn()
{
	return IconFlags & FORCED_SIZE;
}

inline void		
MainWindow::IncrementDialogBoxes(lushort NewDialogID)
{
	DialogBoxID[NumDialogBoxes++] = NewDialogID;
}

inline void		
MainWindow::DecrementDialogBoxes()
{
	NumDialogBoxes--;
}

inline lbool		
MainWindow::AnyDialogBoxes()
{
	return (lbool)(NumDialogBoxes > 0);
}

inline lbool		
MainWindow::AlreadyHooked()		
{
	return (lbool)OldHook;
}

inline void		
MainWindow::SetOldHook(FARPROC Hook)
{
	OldHook = Hook;
}

inline FARPROC		
MainWindow::GetOldHook()
{
	return OldHook;
}

inline EDITCUSTOMICON *
MainWindow::GetTmpPtr()
{
	return TmpPtr;
}


long FAR PASCAL _export 	SelectConfiguration( HWND , WORD , WORD , LONG );
long FAR PASCAL _export 	EditIconDlg( HWND , WORD , WORD , LONG );
void GetStubPath(lubyte far *);

#define	GFI_FILENAME		1
#define	GFI_DIRPATH			2
#define DIRSEPARATOR	'\\'
void PASCAL GetFileNameInfo(BYTE * dest,BYTE * src,int type);
void PASCAL SetFileExtension(BYTE * filename, BYTE * extension);
lbool pascal ComputeFullPathName(HWND hdlg, BYTE * filepath);
void SetPointer( HWND hWnd, WWindow *pWindow );
WWindow *GetPointer( HWND hWnd );
void GetStubPath(lubyte *Path);

#endif
