#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include "wpddefs.h"
#include "sammenu.h"
#include "iconstub.h"
#include "ibmacro.h"
#include "dialogs.h"

/* GLOBALS */

HFONT DlgFont = LNULL;
ICONPROC IconProc;
HANDLE Main::hInstance = 0;
HANDLE Main::hPrevInstance = 0;
lsshort Main::nCmdShow = 0;
char MainWindow::szClassName[] = "Host IconStub";
lubyte NewCustomIcon[LEN_PATH];
HANDLE DialogLibrary = 0;

/* local routines */
static void LoadDlgFont(void);
void GetMacroFilePlusFunction(BYTE * dest,BYTE * src,int maxlen);
BOOL PASCAL AnyWildcardsInName(BYTE *);
void hmemcpydown(BYTE huge * dst, BYTE huge * src, DWORD cnt);
HANDLE MakeGraphicRightSize(HANDLE hDIB,HBITMAP hBitmap,int width,int height);

/* externs ( in icnoedit.cpp ) */

extern HANDLE PASCAL DIBFromBitmap(HBITMAP,DWORD,WORD);
extern void NEAR PASCAL IconEditDestroy(EDITCUSTOMICON *);
extern void NEAR PASCAL IconEditInit(EDITCUSTOMICON *,HWND , HANDLE );
extern HANDLE PASCAL CreateBorderLessDIB(HBITMAP);
extern WORD NEAR PASCAL DIBPaletteSize(void FAR *);
extern LONG FAR PASCAL IconControlProc(HWND, unsigned int, unsigned int, LONG);


/* Window message loop */

int Main::MessageLoop( void )
{
	MSG msg;

	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return msg.wParam;
};

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
                    int nCmdShow )
{

    Main::hInstance = hInstance;
    Main::hPrevInstance = hPrevInstance;
    Main::nCmdShow = nCmdShow;

    if ( ! Main::hPrevInstance ) {
		WNDCLASS wnd;

		MainWindow::Register();
		/* register our icon control in the edit icon dlg box */
		wnd.lpszClassName = (LPSTR)"stubiconctrl";
		wnd.lpfnWndProc = IconControlProc;
		wnd.hCursor = LoadCursor(NULL, IDC_ARROW);
		wnd.hbrBackground = COLOR_WINDOW + 1;
		wnd.style = CS_VREDRAW | CS_HREDRAW | CS_GLOBALCLASS;
		wnd.cbWndExtra = 0;
		wnd.cbClsExtra = 0;
		wnd.lpszMenuName = NULL;
		wnd.hInstance = hInstance;
		wnd.hIcon = NULL;
		RegisterClass((LPWNDCLASS)&wnd);
		LoadDlgFont();
    }

	MainWindow MainWnd;

    return Main::MessageLoop();
}

/* constructor for MainWindow */

MainWindow::MainWindow(  )
{
	lubyte Path[120];
	lubyte PathName[120];
	HANDLE Task;

	SetIconMan(LNULL);
	SetIconBar(LNULL);

	hWnd = 0;
	IconFlags = 0;
 	NumDialogBoxes = 0;
 	NumIconBars = 0;
	cCurrentIconBar = 0;

	/* Create the stub window */

	hWnd = CreateWindow( szClassName, szClassName, WS_OVERLAPPEDWINDOW,
				CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, Main::hInstance,
				(LPSTR) this );

	/* get the path to this exe. */

	GetStubPath(Path);

	/* add the name of the icon dll to the path. */

	strcpy(PathName,Path);
	strcat(PathName,"ltsicn04.dll");

	/* load the icon dll */

	if (32 > (IconManLibrary = LoadLibrary((LPSTR)PathName)))
		return;

	/* Create IconManager */

	SetIconMan(IconBarCreateManager(hWnd,Main::hInstance));

	if (GetIconMan() == LNULL)
		return;

	/* set the callbacks for the icon manager. */

	IconProc.MemoryAlloc = 
		(FARALLOCPROC)MakeProcInstance((FARPROC)MemoryAlloc,Main::hInstance);
	IconProc.MemoryReAlloc = 
		(FARREALLOCPROC)MakeProcInstance((FARPROC)MemoryReAlloc,
			Main::hInstance);
	IconProc.MemoryLock = 
		(FARLOCKPROC)MakeProcInstance((FARPROC)MemoryLock,Main::hInstance);
	IconProc.MemoryUnlock = 
		(FARUNLOCKPROC)MakeProcInstance((FARPROC)MemoryUnlock,Main::hInstance);
	IconProc.MemorySize = 
		(FARSIZEPROC)MakeProcInstance((FARPROC)MemorySize,Main::hInstance);
	IconProc.MemoryFree = 
		(FARFREEPROC)MakeProcInstance((FARPROC)MemoryFree,Main::hInstance);
	IconProc.MessageProc = 
		(FARMESSAGEPROC)MakeProcInstance((FARPROC)MessageProc,Main::hInstance);

	IconBarSetProcs(IconManager,(LPICONPROC)&IconProc);

	/* tell the icon manager what path to find the custom graphics */

	GetDefaultCustomPath(PathName);

	/* set path to find custom bitmaps */

	IconBarSetCustomPath(IconManager,PathName);

	/* set file to find iconstub.tbl ( any file name ) */
	/* default.smi should also be at this directory */

	strcpy(PathName,Path);
	strcat(PathName,"iconstub.tbl");
	IconBarSetDefaultFile(IconManager,PathName);

	/* tell the iconmanager where to find the ini files. */

	strcpy(PathName,Path);
	strcat(PathName,"ICONS");
	IconBarSetConfigPath(IconManager,REG_AMIPRO,PathName);

	Show( Main::nCmdShow );
	Update();

	/* set our task number */

	Task = GetCurrentTask();
};

/* Create a new IconBar */

void
MainWindow::CreateIconBar()
{
	lubyte StrBuffer[40];
	lubyte Output[40];
	HICONBAR NewIconBar;
	HMENU hMenu;

	if (NumIconBars == 8)
		return;

	hMenu = GetMenu(hWnd);

	/* let the user know he can configure a IconBar */

	if (hMenu)
	{
		EnableMenuItem(hMenu,MF_CONFIGURE,MF_BYCOMMAND | MF_ENABLED );
		EnableMenuItem(hMenu,MF_SELECT,MF_BYCOMMAND | MF_ENABLED );
	}

	/* create icon bar */

	SetCurrentIconBar(NumIconBars);

	TurnOnForce(); /* we are about to force a IMM_BARSIZED */
	NumIconBars++;
	NewIconBar = IconBarCreate(GetIconMan(),hWnd);
	SetIconBar(NewIconBar);

	TurnOffForce();	 /* done */

	/* see if we save a Configuration description for this IconBar */
	/* if not use, Default */

	strcpy(Output,"IconSet");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	GetPrivateProfileString((lfpbyte)"SmartIcons",(lfpbyte)Output, 
		(lfpbyte)"Default",(lfpbyte)StrBuffer,sizeof StrBuffer,
		(lfpbyte)"iconstub.ini");

	if (IconBarSelectConfigByDesc(GetIconMan(),StrBuffer))
		IconBarLoadConfig(NewIconBar);

	/* make sure the icons are in the right state */

	CheckIcons();

	/* iconbars are initially hidden. */

	IconBarShow(NewIconBar);
	IconBarPaint(NewIconBar);

	/* show on the menu we have another IconBar */

	hMenu = GetMenu(hWnd);
	if (hMenu)
	{
		EnableMenuItem(hMenu,MF_ICONBAR1 + NumIconBars - 1,MF_BYCOMMAND 
			| MF_ENABLED );
	}
}

/* find the matching index to this IconBar */

lsbyte		
MainWindow::GetIconBarIndex(HICONBAR TestIconBar)
{
	lubyte i =0;

	while (i < NumIconBars)
	{
		if (IconBar[i] == TestIconBar)
			return i;
		i++;
	}
	return -1;
}

/* see where we should set this IconBar */

void 
MainWindow::SetRect(HICONBAR TestIconBar,LPRECT Rect)
{
	lsbyte i = GetIconBarIndex(TestIconBar);
	lsbyte j;
	lushort height = 0;
	lrect IRect;

	if (i == -1)
		i = NumIconBars - 1;

	j = 0;
	while (j < i)
	{
		IconBarGetPosition(IconBar[j],&IRect);
		switch (IconBarGetPositionType(IconBar[j]))
		{
			case IBP_LEFT:
				Rect->left += IRect.right - IRect.left;
				break;
			case IBP_TOP:
				Rect->top += IRect.bottom - IRect.top;
				break;
			case IBP_RIGHT:
				Rect->right -= IRect.right - IRect.left;
				break;
			case IBP_BOTTOM:
				Rect->bottom -= IRect.bottom - IRect.top;
				break;
		}
		j++;
	}
}

/* PAINT routine */

void MainWindow::Paint( void )
{
    PAINTSTRUCT ps;

	BeginPaint( hWnd, &ps );
	EndPaint( hWnd, &ps );
}

/* main windows message routine */
long MainWindow::WndProc( WORD iMessage, WORD wParam, LONG lParam )
{
	lubyte HelpFile[LEN_PATH];

	switch (iMessage)
	{
		case WM_CREATE:
			return TRUE;

		case WM_COMMAND:
			switch(wParam)
			{
				case MF_SELECT:
					SelectConfigurationFile();
					break;

				case MF_CREATE:
					CreateIconBar();
					break;

				case MF_CONFIGURE:
					if (GetIconBar())
						SendMenuItem(MV_CHGSIDEBAR);
					break;
				case MF_ICONBAR1:
				case MF_ICONBAR2:
				case MF_ICONBAR3:
				case MF_ICONBAR4:
				case MF_ICONBAR5:
				case MF_ICONBAR6:
				case MF_ICONBAR7:
				case MF_ICONBAR8:
					SetCurrentIconBar(wParam - MF_ICONBAR1);
					break;
			}
			break;

		case WM_SIZE:

			/* need to tell the icon manager we changed size */

			if (GetIconMan() && GetIconBar())
			{
				TurnOnForce();	
				IconBarHostSizeChange(GetIconMan());
				TurnOffForce();	
			}
			break;

		case WM_PAINT:
			Paint();
			break;


		case WM_ENDSESSION:
			EndStub();
			break;

		case WM_CLOSE:
			EndStub();
            PostQuitMessage( 0 );
			break;

		case WM_DESTROY:
            break;

        default:
			return DefWindowProc( hWnd, iMessage, wParam, lParam );
    }
    return 0;
}

/* find the data pointer with for this hWnd */

WWindow *GetPointer( HWND hWnd )
{
	return (WWindow *) GetWindowWord( hWnd, 0 );
}
void SetPointer( HWND hWnd, WWindow *pWindow )
{
	SetWindowWord( hWnd, 0, (WORD) pWindow );
}

long FAR PASCAL _export 
WndProc( HWND hWnd, unsigned int iMessage, unsigned int wParam, LONG lParam )
{
	/* get the data for this window. */

	WWindow *pWindow = GetPointer( hWnd );

	if ( pWindow == 0 )
    {
        if ( iMessage == WM_CREATE )
        {
            LPCREATESTRUCT lpcs;

            lpcs = (LPCREATESTRUCT) lParam;
			pWindow = (WWindow *) lpcs->lpCreateParams;

			SetPointer( hWnd, pWindow );
			return pWindow->WndProc( iMessage, wParam, lParam );
        }
        else
			return DefWindowProc( hWnd, iMessage, wParam, lParam );
    }
	else
		return pWindow->WndProc( iMessage, wParam, lParam );
}

// Icon Manager Callbacks.

/* CallBack for allocing memory */

HMEMORY far pascal _export
MemoryAlloc(lulong Size)
{
	return GlobalAlloc(GHND,Size);
}

/* CallBack for reallocing memory */

HMEMORY far pascal _export
MemoryReAlloc(lushort Handle,lulong Size)
{
	return GlobalReAlloc(Handle,Size,GHND);
}

/* CallBack for locking memory */

lubyte far * far pascal _export
MemoryLock(HMEMORY Handle)
{
	return (lubyte far *)GlobalLock(Handle);
}

/* CallBack for unlocking memory */

lbool far pascal _export
MemoryUnlock(HMEMORY Handle)
{
	GlobalUnlock(Handle);
	return LTRUE;
}

/* CallBack for get memory size */

lulong far pascal _export
MemorySize(HMEMORY Handle)
{
	return GlobalSize(Handle);
}

/* CallBack for freeing memory */

lbool far pascal _export
MemoryFree(HMEMORY Handle)
{
	GlobalFree(Handle);
	return LTRUE;
}

lulong far pascal _export
MessageProc(HPARENT ParentWnd, HMANAGER ManagerWnd , HICONBAR Inst,
				lushort Msg, lulong Param1, lulong Param2)
{
	lubyte StrBuffer[120];
	lfpbyte macroptr;
	lushort MenuID;
	MainWindow *pWindow = (MainWindow *)GetPointer( ParentWnd );
	lbool retval;
	lubyte Index;

	switch ( Msg )
	{
		case IMM_ICONHITTEST:	/* no need for us to process this */
			return Param1;

		case IMM_GETLASTPOS:	
			return pWindow->GetLastPosition();

		case IMM_GETLASTICONSIZE:
			return pWindow->GetLastIconSize();

		case IMM_GETLASTRECT:
			return pWindow->GetLastRect((LPRECT)Param1);

		/* manager wants to know what size the current icons are. */

		case IMM_WHATICONS:
			return pWindow->GetIconSize();

		/* manager wants the host to load a new size of icons */

		case IMM_LOADICONS:
			return pWindow->ChangeIconSize((lubyte)Param1);

		/* only happens when EditIcon dialog box is up */
		case IMM_DESELECT:
			if (pWindow->GetTmpPtr() 
				&& (Inst == pWindow->GetTmpPtr()->DialogIconBar))
				pWindow->DeselectIcon();
			break;

		/* only happens when EditIcon dialog box is up */
		case IMM_SELECT:
			if (pWindow->GetTmpPtr()
				&& (Inst == pWindow->GetTmpPtr()->DialogIconBar))
				pWindow->SelectionChange();
			break;

		case IMM_ICONUP:
			if (IconBarGetIconState(ManagerWnd) & ICS_CUSTOM)
			{
				if (macroptr = IconBarGetMacro(ManagerWnd))
				{
					lstrcpy((LPSTR)StrBuffer,macroptr);
					pWindow->SendMacro(StrBuffer);
				}
			}
			else
			{
				if (MenuID = IconBarGetIconActionID(ManagerWnd))
					pWindow->SendMenuItem(MenuID);
			}
			break;
		
		/* we need to display the help string in the Param2 */

		case IMM_ICONHELP:
			lstrcpy(StrBuffer,(LPSTR)Param2);
			pWindow->PaintOneLineHelp(StrBuffer);
			return LTRUE;

		/* manager is done displaying help. clear the title bar */

		case IMM_ICONHELPDONE:
			pWindow->InvalidateOneLineHelp();
			return LTRUE;
		
		/* icon bars size changed. */

		case IMM_BARSIZED:
			if (pWindow->IsForceOn() == LFALSE)
			{
				/* resize if we have other child windows */
			}
			break;

		/* manager wants us to put rectangle we can place a fixed iconbar */
		/* inside of in the rectangle pointed to by Param2. */

		case IMM_HOSTSIZEREQUEST:
			GetClientRect(ParentWnd,(LPRECT)Param2);
			((LPRECT)Param2)->top += GetSystemMetrics(SM_CYCAPTION);
			pWindow->SetRect(Inst,(LPRECT)Param2);
			return LTRUE;

		case IMM_EDITICON:
			retval = pWindow->EditIcon((LPCUSTOMICON)Param1);
			return retval;

		case IMM_GETFOCUS:
			SetFocus(ParentWnd);
			return LTRUE;

		case IMM_MANAGERDESTROY:	/* save all data needed */
			pWindow->DestroyIconManager(); 
			return TRUE;
	}
	return 0;
};

void 
MainWindow::PaintOneLineHelp(lubyte *String)
{
	WORD cxsize, cxframe, cxborder, cyframe;
	RECT Rect, ClientRect;
	HBRUSH brush;
	HDC hdc;

	cxsize = GetSystemMetrics(SM_CXSIZE);
	cxframe = GetSystemMetrics(SM_CXFRAME);
	cyframe = GetSystemMetrics(SM_CYFRAME);
	cxborder = GetSystemMetrics(SM_CXBORDER);
	GetWindowRect(GetHandle(), (LPRECT)&ClientRect);

	hdc = GetWindowDC(GetHandle());
	Rect.left = cxframe + cxsize + (cxborder * 2);
	Rect.top = cyframe;
	Rect.right = (ClientRect.right - ClientRect.left) - (2 * cxsize) 
		- (2 * cxborder) - cxframe;
	Rect.bottom = cyframe + GetSystemMetrics(SM_CYCAPTION) - 
			(2 * GetSystemMetrics(SM_CYBORDER));
		
	IntersectClipRect(hdc, Rect.left, Rect.top, Rect.right, Rect.bottom);
	SetTextColor(hdc, GetSysColor(COLOR_CAPTIONTEXT));
	SetBkMode(hdc, TRANSPARENT);
	FillRect(hdc, (LPRECT)&Rect, 
		brush = CreateSolidBrush(GetSysColor(COLOR_ACTIVECAPTION)));
	DeleteObject(brush);

	TextOut(hdc, Rect.left + 8, Rect.top + 1, String, strlen(String));
	ReleaseDC(GetHandle(), hdc);
}

void
MainWindow::InvalidateOneLineHelp()
{
	SetWindowPos(GetHandle(), NULL, 0, 0, 0, 0, SWP_DRAWFRAME +
		SWP_NOMOVE + SWP_NOSIZE);
}

void
MainWindow::SelectConfigurationFile()
{
	FARPROC lpProc;

	lpProc =MakeProcInstance((FARPROC)SelectConfiguration,Main::hInstance);
	DialogBoxParam(Main::hInstance,"DLG_SELECT", GetHandle(),lpProc,
			(LONG)GetHandle());
	FreeProcInstance(lpProc);
}

/* allows the user to choose a configuration file for IconBars */

long FAR PASCAL _export 	
SelectConfiguration( HWND hDlg, WORD iMessage, WORD wParam, LONG lParam )
{
	static MainWindow *WndPtr;
	BYTE name[256];
	lubyte far *ptr;
	HWND hCtl;
	int index;

	switch (iMessage)
	{
		case WM_INITDIALOG:		   
			WndPtr = (MainWindow *)GetPointer((HWND)lParam);

			hCtl = GetDlgItem(hDlg,ID_LIST1);

			IconBarDeselectConfig(WndPtr->GetIconMan());

			/* get each class name */

			while (IconBarEnumConfig(WndPtr->GetIconMan()))
			{
				/* get the description and set it */

				if (ptr = IconBarGetConfigDesc(WndPtr->GetIconMan()))
					SendMessage(hCtl,LB_INSERTSTRING,(WORD)-1,(LONG)ptr);
			}

			if (IconBarSelectLoadedConfig(WndPtr->GetIconBar())
				&& ((ptr = IconBarGetConfigDesc(WndPtr->GetIconMan())) != NULL))
				SendMessage(hCtl,LB_SELECTSTRING, (WORD)-1, (LONG)(LPSTR)ptr);

			return (TRUE);

		case WM_COMMAND:		      
			switch(wParam)
			{
				case IDOK:
					WndPtr = (MainWindow *)GetPointer((HWND)GetParent(hDlg));
					hCtl = GetDlgItem(hDlg,ID_LIST1);
					if ((index = (int)SendMessage(hCtl,LB_GETCURSEL,0,0L)) 
							!= -1)
					{
						SendMessage(hCtl,LB_GETTEXT,index,(LONG)(LPSTR)name);
						IconBarSelectConfigByDesc(WndPtr->GetIconMan(),
								(lubyte far *)name);
						IconBarLoadConfig(WndPtr->GetIconBar());
					}
					EndDialog(hDlg, FALSE);	   
					return (TRUE);
				case IDCANCEL:
					EndDialog(hDlg, FALSE);	   
					return (TRUE);
			}
			break;
	}
	return (FALSE);			      
}

void
GetStubPath(lubyte *Path)
{
	lsshort i;

	GetModuleFileName(Main::hInstance,Path,119);
	i = strlen(Path) - 1;
	while(i && Path[i] != '\\')
		Path[i--] = NULL;
}

lbool 
MainWindow::EditIcon(LPCUSTOMICON lpCustom)
{
	FARPROC lpProc;
	lbool retval;

	lpProc = MakeProcInstance((FARPROC)EditIconDlg,Main::hInstance);
	retval = DialogBoxParam(Main::hInstance,"RS_EDITICON", GetHandle(),lpProc,
			(LONG)lpCustom);
	FreeProcInstance(lpProc);
	return retval;
}

void
MainWindow::CheckIcons()
{
	/* set to the current modes */
	ChangeIcon(MV_SHOWPICTS);
	ChangeIcon(MV_SHOWMARKS);
	ChangeIcon(MV_COLGUIDEON);
	ChangeIcon(MV_MARGINSCOLORON); 
	ChangeIcon(MV_VERTRULERON);
	ChangeIcon(MV_SHOWNOTESOFF );
	ChangeIcon(MV_TABSRETON);
}

void
MainWindow::SendMenuItem(lushort MenuID)
{
	lubyte StrBuffer[120];
	lubyte StrBuffer2[120];
	lfpbyte macroptr;
	HDC hdc;
	lbool retval;

	if (AnyDialogBoxes())
		return;
	switch(MenuID)
	{
		case MV_NEXTICONSET:
			if (IconBarSelectLoadedConfig(GetIconBar()))
			{
				if (IconBarEnumConfig(GetIconMan()) == FALSE)
					IconBarEnumConfig(GetIconMan());
				IconBarLoadConfig(GetIconBar());
			}
			return;

		case MV_CHGSIDEBAR:
			EnableAllWindows(FALSE);
			retval = IconBarConfigure(GetIconBar());
			EnableAllWindows(TRUE);
			if (retval == TRUE)
			{
				CheckIcons();
				IconBarHostSizeChange(GetIconMan());
			}
			return ;

		default:
			if (MenuID = IconBarGetIconActionID(GetIconMan()))
			{
				strcpy(StrBuffer,"Icon Let Up: MenuID =");
				itoa(MenuID,StrBuffer2,10);
				strcat(StrBuffer,StrBuffer2);
				strcat(StrBuffer,"                 ");
			}
			hdc = GetDC(GetHandle());
			TextOut(hdc,0,0,(lfpbyte)StrBuffer,strlen(StrBuffer));
			ReleaseDC(GetHandle(),hdc);
			return ;
	}
}


lbool 
MainWindow::ChangeIconSize(lubyte NewSize)
{
	lubyte OldSize;
	lubyte StrBuffer[LEN_PATH];

	if (NewSize != GetIconSize())
	{
		GetStubPath(StrBuffer);
		OldSize = GetIconSize();
		switch(NewSize)
		{
			case IS_SUPERVGA:
				SetIconSize(NewSize);
				strcat(StrBuffer,"amiicn8.dll");
				if (!IconBarSetResource(GetIconMan(),StrBuffer,1))
				{
					SetIconSize(OldSize);
					return FALSE;
				}
				return LTRUE;

			case IS_VGA:
				SetIconSize(NewSize);
				strcat((lfpbyte)StrBuffer,(lfpbyte)"amiicnv.dll");
				if (!IconBarSetResource(GetIconMan(),StrBuffer,1))
				{
					SetIconSize(OldSize);
					return FALSE;
				}
				return LTRUE;

			case IS_EGA:
				SetIconSize(NewSize);
				strcat(StrBuffer,"amiicne.dll");
				if (!IconBarSetResource(GetIconMan(),StrBuffer,1))
				{
					SetIconSize(OldSize);
					return FALSE;
				}
				return LTRUE;

			default:
				return FALSE;
		}
	}
	return FALSE;
}

void 
MainWindow::SendMacro(BYTE * Macro)
{
	HDC hdc;
	if (Macro[0] == NULL)
		return;

	if (AnyDialogBoxes())
		return ;

	if (Macro[1] != ':')
	{
		lsshort len;
		lubyte Buffer[LEN_PATH];

		GetStubPath(Buffer);
		strcat(Buffer,Macro);
		strcpy(Macro,Buffer);
	}
	hdc = GetDC(GetHandle());
	TextOut(hdc,0,0,(lfpbyte)Macro,strlen(Macro));
	ReleaseDC(GetHandle(),hdc);
}

void 
MainWindow::EnableAllWindows(lbool Enable)
{
	if (GetIconBar())
	{
		lubyte i = 0;

		while (i < NumIconBars)
		{
			if (Enable)
				IconBarEnable(IconBar[i]);
			else
				IconBarDisable(IconBar[i]);
			i++;
		}
	}

	EnableWindow(GetHandle(),Enable);


	if (Enable)
	{
		SetActiveWindow(GetHandle());
		SetFocus(GetHandle());
	}
}

void 
MainWindow::DestroyIconManager()
{
	if (GetIconMan())
	{
		lfpbyte ptr;
		lushort i;

		for (i = 0; i < NumIconBars; i++)
		{
			SetCurrentIconBar(i);
			if (IconBarSelectLoadedConfig(GetIconBar())
				&& ((ptr = IconBarGetConfigDesc(GetIconMan())) != NULL))
			{
				lubyte Output[30];

				strcpy(Output,"IconSet");
				itoa(cCurrentIconBar,Output + strlen(Output),10);
				WritePrivateProfileString((lfpbyte)"SmartIcons",
					(lfpbyte)Output,(lfpbyte)ptr, (lfpbyte)"iconstub.ini");
			}

			SetLastRect();
			SetLastPosition();
			SetLastIconSize();
		}

		IconManager = 0;
	}
}

void 
MainWindow::ChangeIcon(lushort MenuID)
{
	switch (MenuID)
	{
		case MV_HIDECLEANSCREEN:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWCLEANSCREEN,
						NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDECLEANSCREEN
					,NULL);
			break;

		case MV_SHOWCLEANSCREEN:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDECLEANSCREEN,
						NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWCLEANSCREEN
					,NULL);
			break;

		case MV_LAYOUT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_DRAFT,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_LAYOUT,NULL);
			break;

		case MV_DRAFT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_LAYOUT,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_DRAFT,NULL);
			break;

		case MV_FIT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_WORKING,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_FIT,NULL);
			if (IconBarSelectStandardIcon(GetIconMan(),MV_100,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_FIT,NULL);
			if (IconBarSelectStandardIcon(GetIconMan(),MV_200,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_FIT,NULL);
			break;

		case MV_WORKING:
		case MV_100:
		case MV_200:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_FIT,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MenuID,NULL);
			break;

		case MV_HIDEPICTS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWPICTS,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDEPICTS,
						NULL);
			break;

		case MV_SHOWPICTS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDEPICTS,
					NULL)) 
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWPICTS,
						NULL);
			break;

		case MV_HIDEMARKS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWMARKS,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDEMARKS,
						NULL);
			break;

		case MV_SHOWMARKS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDEMARKS,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWMARKS,
						NULL);
			break;

		case MV_TABRACK:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDETABRACK,
						NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_TABRACK,
						NULL);
			break;

		case MV_HIDETABRACK:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_TABRACK,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDETABRACK,
						NULL);
			break;

		case MV_MARGINSCOLOROFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_MARGINSCOLORON,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),
						MV_MARGINSCOLOROFF,NULL);
			break;

		case MV_MARGINSCOLORON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_MARGINSCOLOROFF,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),
						MV_MARGINSCOLORON,NULL);
			break;

		case MV_VERTRULERON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_VERTRULEROFF,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_VERTRULERON,
						NULL);
			break;

		case MV_VERTRULEROFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_VERTRULERON,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_VERTRULEROFF,
						NULL);
			break;

		case MV_SHOWNOTESOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWNOTESON,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWNOTESOFF,
						NULL);
			break;

		case MV_SHOWNOTESON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWNOTESOFF,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWNOTESON,
						NULL);
			break;

		case MV_TABSRETOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_TABSRETON,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_TABSRETOFF,
						NULL);
			break;

		case MV_TABSRETON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_TABSRETOFF,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_TABSRETON,
						NULL);
			break;

		case ML_QUICKENDRECORD:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_QUICKREC,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_QUICKENDRECORD,
						NULL);
			break;

		case ML_QUICKREC:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_QUICKENDRECORD,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_QUICKREC,
						NULL);
			break;

		case ML_MACROENDRECORD:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_MACRORECORD,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_MACROENDRECORD,
						NULL);
			break;

		case ML_MACRORECORD:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_MACROENDRECORD,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_MACRORECORD,
						NULL);
			break;

		case MV_LAY2OUT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_OUT2LAY,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_LAY2OUT,
						NULL);
			break;

		case MV_OUT2LAY:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_LAY2OUT,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_OUT2LAY,
						NULL);
			break;

		case MV_COLGUIDEON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_COLGUIDEOFF,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_COLGUIDEON,
						NULL);
			break;

		case MV_COLGUIDEOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_COLGUIDEON,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_COLGUIDEOFF,
						NULL);
			break;

		case MR_GROUPFRAMES:
			if (IconBarSelectStandardIcon(GetIconMan(),MR_UNGROUPFRAMES,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MR_GROUPFRAMES,
						NULL);
			break;

		case MR_UNGROUPFRAMES:
			if (IconBarSelectStandardIcon(GetIconMan(),MR_GROUPFRAMES,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),MR_UNGROUPFRAMES,
						NULL);
			break;

		case ML_REVMARKING:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_REVMARKINGOFF,
					NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_REVMARKING,
						NULL);
			break;

		case ML_REVMARKINGOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_REVMARKING,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_REVMARKINGOFF,
						NULL);
			break;

		case ML_FIELDHIDE:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_FIELDTOG,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_FIELDHIDE,
						NULL);
			break;

		case ML_FIELDTOG:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_FIELDHIDE,NULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_FIELDTOG,
						NULL);
			break;

	}
}

pCListItem CListHead::cFirstListItem = LNULL;

void
CListHead::AddListItem( pCListItem NewListItem)
{
	if (cFirstListItem == LNULL)
	{
		cFirstListItem = NewListItem;
		return;
	}

	NewListItem->SetNextListItem(cFirstListItem);
	cFirstListItem = NewListItem;
}

void
CListHead::RemoveListItem( pCListItem OldListItem)
{
	if (cFirstListItem == OldListItem)
	{
		cFirstListItem = OldListItem->GetNextListItem();
		return;
	}

	pCListItem ListPtr = cFirstListItem,BeforePtr = LNULL;

	while (ListPtr)
	{
		if (ListPtr == OldListItem)
		{
			BeforePtr->SetNextListItem(OldListItem->GetNextListItem());
			return;
		}
		BeforePtr = ListPtr;
		ListPtr = ListPtr->GetNextListItem();
	}
}

pCListItem
CListHead::GetListItem( HANDLE Task)
{
	pCListItem ListPtr = cFirstListItem;

	while (ListPtr)
	{
		if (ListPtr->GetTask() == Task)
			return ListPtr;
		ListPtr = ListPtr->GetNextListItem();
	}
	return LNULL;
}

LONG FAR PASCAL _export
EditIconDlg( HWND hDlg, WORD iMessage, WORD wParam, LONG lParam )
{
	BYTE Path[LEN_PATH];
	BYTE description[LEN_HELP];
	DWORD color;
	EDITCUSTOMICON *TmpPtr;
	lbool retval;
	RECT rect;
	MainWindow *pWindow;

	switch (iMessage)
	{
		case WM_INITDIALOG:		   
 			// in some video modes the drop down color bar
 			// does not fit on the screen.  Therefore, I want to move
 			// this box up so that it will always fit on the screen.
 			GetWindowRect(hDlg, &rect);
 			MoveWindow(hDlg, rect.left, 8, rect.right - rect.left, 
 						rect.bottom - rect.top, FALSE);

			SendDlgItemMessage(hDlg,ID_EDIT2,EM_LIMITTEXT,LEN_HELP - 1,0);
			SendDlgItemMessage(hDlg,ID_FILENAME,EM_LIMITTEXT,LEN_PATH - 1,0);

			pWindow = (MainWindow *)GetPointer(GetParent(hDlg));
			pWindow->MakeDialogIconBar(hDlg,(LPCUSTOMICON)lParam);
			SendMessage(GetDlgItem(hDlg, ID_EDIT2), WM_SETFONT, 
				DlgFont, 1L);
			SendMessage(GetDlgItem(hDlg, ID_STATIC5), WM_SETFONT, 
				DlgFont, 1L);
			SendMessage(GetDlgItem(hDlg, ID_STATIC6), WM_SETFONT, 
				DlgFont, 1L);
			TmpPtr = pWindow->GetTmpPtr();
			TmpPtr->RColor = RGB(0,0,0);
			TmpPtr->LColor = RGB(255,255,255);
			return (TRUE);

		case WM_COMMAND:		      
			pWindow = (MainWindow *)GetPointer(GetParent(hDlg));
			TmpPtr = pWindow->GetTmpPtr();
			switch(wParam)
			{
				case ID_OK:
					pWindow->DeselectIcon();
					IconBarDestroy(TmpPtr->DialogIconBar);
					retval = TmpPtr->AnyChanges;
					LocalFree((HANDLE)TmpPtr);
					EndDialog(hDlg, retval);	   
					return (TRUE);

				case ID_CANCEL:
					IconBarDestroy(TmpPtr->DialogIconBar);
					IconEditDestroy(TmpPtr);
					retval = TmpPtr->AnyChanges;
					LocalFree((HANDLE)TmpPtr);
					EndDialog(hDlg, retval);	   
					return (TRUE);

				case ID_DIRLIST:
					switch (HIWORD(lParam)) 
					{
						case LBN_DBLCLK:
							DlgDirSelect(hDlg, Path, ID_DIRLIST);
							AnsiLower(Path);
							SetDlgItemText(hDlg, ID_FILENAME, (LPSTR)Path);
							pWindow->ComputeMacroPathName(Path);
							break;
					}
					break;

				case ID_FILELIST:
					switch (HIWORD(lParam)) 
					{
						case LBN_SELCHANGE:
						case LBN_DBLCLK:
							DlgDirSelect(hDlg, Path, ID_FILELIST);
							AnsiLower(Path);
							SetDlgItemText(hDlg, ID_FILENAME, (LPSTR)Path);
							if (pWindow->ComputeMacroPathName(Path))
							{
								lstrcpy(description,"description");
								SetDlgItemText(hDlg, ID_EDIT2, 
										(LPSTR)description);
							}
							break;
					}
					break;

				case ID_PUSH1:
					if (pWindow->CreateNewIcon(hDlg,0,FALSE,NULL) == FALSE)
						IconBarSelectCustomIcon(pWindow->GetIconMan(),
								&TmpPtr->LastCustomIcon);
					break;

				case ID_PUSH2:
					if (pWindow->CreateNewIcon(hDlg,0,FALSE,TmpPtr->hDIB) 
							== FALSE)
						IconBarSelectCustomIcon(pWindow->GetIconMan(),
								&TmpPtr->LastCustomIcon);

					break;
			}
			break;
	}
	return (FALSE);			      
}

void 
MainWindow::MakeDialogIconBar(HWND hDlg,LPCUSTOMICON Custom )
{
 	RECT Rect,Rect2;

	TmpPtr = (EDITCUSTOMICON *)LocalAlloc(LMEM_FIXED,sizeof (EDITCUSTOMICON));
	TmpPtr->hDIB = NULL;
	TmpPtr->IconColors = NULL;
	TmpPtr->ColorsUsed = NULL;
	TmpPtr->DialogBox = hDlg;
	TmpPtr->AnyChanges = FALSE;

	TmpPtr->DialogIconBar = IconBarCreate(GetIconMan(),hDlg);

	IconBarMakeDialogIconBar(TmpPtr->DialogIconBar);

	IconBarDeselectIcon(GetIconMan());

	TmpPtr->LastCustom = 0;

	while (IconBarEnumIcons(GetIconMan()))
	{
		if (!(IconBarGetIconState(GetIconMan()) & ICS_NOTAVAILABLE)
				&& (IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
		{
			TmpPtr->LastCustom++;
			IconBarAddIcon(TmpPtr->DialogIconBar,-1);
		}
	}

	IconBarDeselectIcon(GetIconMan());

	while (IconBarEnumIcons(GetIconMan()))
	{
		if (!(IconBarGetIconState(GetIconMan()) & ICS_NOTAVAILABLE)
				&& !(IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
			IconBarAddIcon(TmpPtr->DialogIconBar,-1);
	}

	if (Custom)
		IconBarShowCustomIcon(TmpPtr->DialogIconBar,Custom);

	GetWindowRect(GetDlgItem(hDlg,ID_STATIC1),&Rect);
	GetWindowRect(GetDlgItem(hDlg,ID_STATIC6),&Rect2);
	Rect.right = Rect2.left;
	ScreenToClient(hDlg,(LPPOINT)&Rect);
	ScreenToClient(hDlg,(LPPOINT)&Rect.right);
	IconBarSetPosition(TmpPtr->DialogIconBar,&Rect);
	IconBarSetSize(TmpPtr->DialogIconBar,&Rect);

	IconBarShow(TmpPtr->DialogIconBar);
	IconBarPaint(TmpPtr->DialogIconBar);

}

void 
MainWindow::DeselectIcon()
{
	BYTE Path[LEN_PATH];

	IconBarSelectChosenIcon(TmpPtr->DialogIconBar);
	if (!(IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
		return;

	SaveCustomBits();

	IconEditDestroy(TmpPtr);

	if (!ComputeMacroPathName(Path))
	{
		if (SaveDescription())
			TmpPtr->AnyChanges = TRUE;
		return;
	}

	if (!SaveMacroToIcon(Path))
	{
		if (SaveDescription())
			TmpPtr->AnyChanges = TRUE;
		return;
	}
	SaveDescription();
	TmpPtr->AnyChanges = TRUE;
}

void 
MainWindow::SelectionChange()
{
	BYTE macro[LEN_PATH];
	BYTE description[LEN_HELP];
	BYTE path[LEN_PATH];
	BYTE filename[LEN_PATH];
	HBITMAP hBitmap;

	IconBarSelectChosenIcon(TmpPtr->DialogIconBar);

	if (!(IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
	{
		if (!CreateNewIcon(TmpPtr->DialogBox,
				IconBarGetIconActionID(GetIconMan()),TRUE,NULL))
			IconBarShowCustomIcon(TmpPtr->DialogIconBar,
				&TmpPtr->LastCustomIcon);
		return;
	}
	lstrcpy(macro,IconBarGetMacro(GetIconMan()));
	AnsiLower(macro);
	if (macro[0] != NULL)
	{
		AddMacroPathToMacro(macro);
		GetFileNameInfo(path,macro,GFI_DIRPATH);
		/* sub the 7 to give a cushion for checking for directory */
		GetMacroFilePlusFunction(filename,macro,LEN_PATH - lstrlen(path) - 7);
	}
	else
	{
		AddMacroPathToMacro(macro);
		lstrcpy(path,macro);
		path[strlen(path) - 1] = 0;
		macro[0] = 0;
		AnsiLower(path);
		filename[0] = 0;
	}

	lstrcpy((LPSTR)description,IconBarGetDescription(GetIconMan()));
	if ((description[0] == NULL) && (macro[0] != NULL))
		strcpy(description,"description");

	SetDlgItemText(TmpPtr->DialogBox, ID_EDIT2, (LPSTR)description);

	/* don't list macros if in same directory */
	getcwd(macro,LEN_PATH - 1);
	SetDlgItemText(TmpPtr->DialogBox, ID_FILENAME, (LPSTR)filename);

	if ((strcmp(macro,path) != 0)
		|| (SendDlgItemMessage(TmpPtr->DialogBox,ID_DIRLIST,LB_GETCOUNT,0,0)
				<= 0))
	{
		SetDlgItemText(TmpPtr->DialogBox, ID_FILEPATH, (LPSTR)path);
		strcat(path,"\\*.smm");
		DlgDirList(TmpPtr->DialogBox, (LPSTR)path, ID_FILELIST, 
				ID_FILEPATH,0x0000);
		DlgDirList(TmpPtr->DialogBox, (LPSTR)path, ID_DIRLIST, 0,0xC010);
	}
	SendDlgItemMessage(TmpPtr->DialogBox,ID_FILELIST,LB_SELECTSTRING,-1,
			(LONG)(LPSTR)filename);

	lstrcpy((LPSTR)path,IconBarGetCustomIconPath(GetIconMan()));
	AnsiLower(path);
	GetFileNameInfo(filename, path, GFI_FILENAME);
	SetDlgItemText(TmpPtr->DialogBox, ID_STATIC5, filename);

	if (IconBarGetIconState(GetIconMan()) & ICS_CUSTOM)
	{
		SaveCustomIconSelection();
		if (hBitmap = IconBarGetBitmap(GetIconMan()))
		{
			IconEditInit(TmpPtr,TmpPtr->DialogBox, 
					CreateBorderLessDIB(hBitmap));
			InvalidateRect(GetDlgItem(TmpPtr->DialogBox, ID_STATIC3),NULL,
					FALSE);
			InvalidateRect(GetDlgItem(TmpPtr->DialogBox, ID_STATIC2),NULL, 
					FALSE);
 			InvalidateRect(GetDlgItem(TmpPtr->DialogBox, ID_STATIC4),NULL, 
					FALSE);
		}
	}
}

lbool 
MainWindow::ComputeMacroPathName(BYTE *filepath)
{
	BYTE	filename[LEN_PATH];
	BYTE	path[LEN_PATH];
	BYTE	tmppath[LEN_PATH];
	BYTE	dirsep[4];
	WORD	len;
	WORD	changeddirs = FALSE, changedfiles = FALSE;

	dirsep[0] = '\\';
	dirsep[1] = 0;
	GetDlgItemText(TmpPtr->DialogBox, ID_FILENAME, filepath, LEN_PATH - 9);

	GetFileNameInfo(path, filepath, GFI_DIRPATH);

	GetMacroFilePlusFunction(filename,filepath,LEN_PATH - lstrlen(path) - 9);

	len = strlen(filepath);

	/* Is there a wild card in the name? */

	if (!AnyWildcardsInName(filepath))
	{
		BYTE temp[8];
		/* If there is no filename info use the default extension as
		 * the filename. */

		if (!((filepath[len - 1] == '\\') || (filepath[len - 1] == ':' )))
			strcat(filepath, dirsep);

		temp[0] = '*';
		temp[1] = NULL;
		strcat(temp,".smm");
		strcat(filepath, temp);
	}

	/* Update the directory list box. */

	AnsiLower(filepath);

	if (!DlgDirList(TmpPtr->DialogBox, (LPSTR)filepath, ID_FILENAME, 
						ID_FILEPATH,0x0000))
	{
		filepath[len] = 0;

		if (strchr(filepath, '\\') || strchr(filepath, ':'))
		{
			BYTE temp[8];

			/* look to see if there is a \ in the name if so take off the
			 * filename part - add the extension and try again. */

			strcpy(tmppath, filepath);
			strcpy(filepath, path);

			if (filepath[strlen(filepath) - 1] != '\\')
				strcat(filepath, dirsep);

			temp[1] = '*';
			temp[2] = NULL;
			strcat(temp,".smm");
			strcat(filepath, temp);

			AnsiLower(filepath);

			if (!DlgDirList(TmpPtr->DialogBox, (LPSTR)filepath, ID_FILELIST, 
						ID_FILEPATH, 0x4010))
			{
				/* if there is a : or a \ still in the name then we 
				 * have an invalid directory.  Other wise we have a
				 * filename. */

				GetDlgItemText(TmpPtr->DialogBox, ID_FILENAME, filename, 
						LEN_PATH - lstrlen(filepath) - 1);

				if (strchr(filename, '\\') || strchr(filename, ':')) 
				{
					DlgDirList(TmpPtr->DialogBox, (LPSTR)filepath, 
							ID_DIRLIST, 0, 0xC010);
					return FALSE;
				}

				strcpy(filepath, tmppath);
			}
			else
			{
				changeddirs = TRUE;
				strcpy(filepath, filename);
			}
		}
	}
	else
		changeddirs = FALSE;


	/* Update the filelist list box. */

	if (AnyWildcardsInName(filepath))
	{
		changedfiles = TRUE;
		DlgDirList(TmpPtr->DialogBox,(LPSTR)filepath,ID_FILELIST,ID_FILEPATH, 
				0x0000);
	}

	AnsiLower(filepath);

	SetDlgItemText(TmpPtr->DialogBox, ID_FILENAME, filepath);

	/* Build the full path name. */

	getcwd(filepath,LEN_PATH - 2);

	if (filepath[strlen(filepath)-1] != DIRSEPARATOR)
		strcat(filepath, dirsep);

	GetDlgItemText(TmpPtr->DialogBox, ID_FILENAME, filename, LEN_PATH 
			- strlen(filepath) - 1);

	strcat(filepath, filename);

	AnsiLower(filepath);

	DlgDirList(TmpPtr->DialogBox, (LPSTR)filepath, ID_DIRLIST, 0, 0xC010);

	return TRUE;
}

lbool 
MainWindow::SaveMacroToIcon(BYTE * filepath)
{
	BYTE tmpbuf[LEN_PATH];

	if (AnyWildcardsInName(filepath))
		return FALSE;

	GetMacroFilePlusFunction(tmpbuf,filepath,LEN_PATH - 2);

	if (tmpbuf[0] != 0)
	{
		IconBarSetMacro(GetIconMan(),filepath);
		return TRUE;
	}
	return FALSE;
}

LONG FAR PASCAL _export
CreateIconDlg( HWND hDlg, WORD iMessage, WORD wParam, LONG lParam )
{
	BYTE path[LEN_PATH];
	BYTE filename[LEN_PATH];
	EDITCUSTOMICON *TmpPtr;
	MainWindow *pWindow;

	switch (iMessage)
	{
		case WM_INITDIALOG:		   
			pWindow = (MainWindow *)GetPointer(GetParent(GetParent(hDlg)));
			SendDlgItemMessage(hDlg,ID_EDIT1,EM_LIMITTEXT,12,0);
			pWindow->GetDefaultCustomPath(path);
			AnsiLower(path);
			SetDlgItemText(hDlg, ID_FILEPATH, path);
			return (TRUE);

		case WM_COMMAND:		      
			pWindow = (MainWindow *)GetPointer(GetParent(GetParent(hDlg)));
			TmpPtr = pWindow->GetTmpPtr();
			switch(wParam)
			{
				case ID_OK:
					GetDlgItemText(hDlg, ID_EDIT1, path, LEN_PATH - 9);
					GetFileNameInfo(filename, path, GFI_FILENAME);

					/* if no filename */
					if (filename[0] == NULL)
					{
						SetFocus(GetDlgItem(hDlg,ID_EDIT1));
						return TRUE;
					}

					filename[8] = 0;
					pWindow->GetDefaultCustomPath(path);
					path[strlen(path) + 1] = NULL;
					path[strlen(path)] = '\\';
					strcat(path,filename);
					if (!AnyWildcardsInName(path))
					{
						BYTE Ext[5];
						Ext[0] = '.';
						Ext[1] = 'b';
						Ext[2] = 'm';
						Ext[3] = 'p';
						Ext[4] = NULL;
						SetFileExtension(path, Ext);
						lstrcpy(NewCustomIcon,path);
						EndDialog(hDlg, TRUE);	   
					}
					return (TRUE);

				case ID_CANCEL:
					EndDialog(hDlg, FALSE);	   
					return (TRUE);

			}
			break;
	}
	return (FALSE);			      
}

LONG FAR PASCAL _export
SaveIconDlg( HWND hDlg, WORD iMessage, WORD wParam, LONG lParam )
{
	BYTE path[LEN_PATH];
	BYTE filename[LEN_HELP];
	EDITCUSTOMICON *TmpPtr;
	MainWindow *pWindow;

	switch (iMessage)
	{
		case WM_INITDIALOG:		   
			pWindow = (MainWindow *)GetPointer(GetParent(GetParent(hDlg)));
			TmpPtr = pWindow->GetTmpPtr();
			SendDlgItemMessage(hDlg,ID_EDIT1,EM_LIMITTEXT,12,0);
			pWindow->GetDefaultCustomPath(path);
			AnsiLower(path);
			SetDlgItemText(hDlg, ID_FILEPATH, path);
			return (TRUE);

		case WM_COMMAND:		      
			pWindow = (MainWindow *)GetPointer(GetParent(GetParent(hDlg)));
			TmpPtr = pWindow->GetTmpPtr();
			switch(wParam)
			{
				case ID_OK:
					GetDlgItemText(hDlg, ID_EDIT1, path, LEN_PATH - 9);
					GetFileNameInfo(filename, path, GFI_FILENAME);

					/* if no filename */
					if (filename[0] == NULL)
					{
						SetFocus(GetDlgItem(hDlg,ID_EDIT1));
						return TRUE;
					}

					filename[8] = 0;
					pWindow->GetDefaultCustomPath(path);
					path[strlen(path) + 1] = NULL;
					path[strlen(path)] = '\\';
					strcat(path,filename);
					if (!AnyWildcardsInName(path))
					{
						BYTE Ext[5];
						Ext[0] = '.';
						Ext[1] = 'b';
						Ext[2] = 'm';
						Ext[3] = 'p';
						Ext[4] = NULL;
						SetFileExtension(path, Ext);
						lstrcpy(NewCustomIcon,path);
						EndDialog(hDlg, TRUE);	   
					}
					return (TRUE);

				case ID_CANCEL:
					EndDialog(hDlg, FALSE);	   
					return (TRUE);
			}
			break;
	}
	return (FALSE);			      
}

lbool 
MainWindow::CreateNewIcon(HWND hDlg,int MenuID,BOOL CreateIcon,HANDLE hDIB)
{
	CUSTOMICON NewIcon;
	HANDLE NewhDIB;
	LPSTR NewBits;
	HBITMAP hBitmap;
	LONG rval;
	FARPROC lpProc;

	NewIcon.MacroPath[0] = NULL;
	if (CreateIcon == FALSE)
	{
		lpProc =MakeProcInstance((FARPROC)CreateIconDlg,Main::hInstance);
		rval = DialogBox(Main::hInstance,"RS_SAVEICON", hDlg,lpProc);
	}
	else
	{
		lpProc =MakeProcInstance((FARPROC)SaveIconDlg,Main::hInstance);
		rval = DialogBox(Main::hInstance,"RS_CREATEICON", hDlg,lpProc);
	}
	FreeProcInstance(lpProc);

	if (rval == FALSE)
		return FALSE;

	lstrcpy(NewIcon.CustomPath,NewCustomIcon);
	if (hDIB == NULL)
	{
		IconBarSelectStandardIcon(GetIconMan(),MenuID,NULL);
		if (!(hBitmap = IconBarGetBitmap(GetIconMan())))
			return FALSE;
		if (!(NewhDIB = CreateBorderLessDIB(hBitmap)))
			return FALSE;
		if (!(NewBits = GlobalLock(NewhDIB)))
		{
			GlobalFree(NewhDIB);
			return FALSE;
		}
	}
	else
	{
		NewhDIB = hDIB;
		NewBits = GlobalLock(hDIB);
		if (!NewBits)
			return FALSE;
	}
	IconBarNewCustomIcon(GetIconMan());
 	if (!IconBarSetCustomIconPath(GetIconMan(),NewIcon.CustomPath,TRUE))
	{
		IconBarRemoveIcon(GetIconMan());
		GlobalUnlock(NewhDIB);
		if (!hDIB)
			GlobalFree(NewhDIB);
		return FALSE;
	}
	if (!IconBarSetCustomBits(GetIconMan(),NewBits))
	{
		IconBarRemoveIcon(GetIconMan());
		GlobalUnlock(NewhDIB);
		if (!hDIB)
			GlobalFree(NewhDIB);
		return FALSE;
	}
	GlobalUnlock(NewhDIB);
	if (!hDIB)
		GlobalFree(NewhDIB);
	else
		/* they saved the changes to a new bitmap, so do not save changes */
		TmpPtr->CurrentDIBChanged = FALSE;

	IconBarAddIcon(TmpPtr->DialogIconBar,TmpPtr->LastCustom);
	TmpPtr->LastCustom++;

	IconBarShowCustomIcon(TmpPtr->DialogIconBar,&NewIcon);

 	// Invalidate the mouse bitmap.  It may be out of date.
 	InvalidateRect(GetDlgItem(hDlg, ID_STATIC4), NULL, FALSE);

	return TRUE;
}

void 
MainWindow::GetDefaultCustomPath(BYTE * Path)
{
	GetStubPath(Path);
	strcat(Path,"ICONS");
}

void 
MainWindow::AddMacroPathToMacro(BYTE *Macro)
{
	BYTE Buffer[LEN_PATH];

	if (Macro[1] != ':')
	{
		GetStubPath(Buffer);
		AnsiLower(Buffer);
		strcat(Buffer,"macros\\");
		strcat(Buffer,Macro);
		strcpy(Macro,Buffer);
	}
}

void 
MainWindow::SaveCustomIconSelection()
{
	IconBarSelectChosenIcon(TmpPtr->DialogIconBar);
	if (IconBarGetIconState(GetIconMan()) & ICS_CUSTOM)
	{
		lstrcpy(TmpPtr->LastCustomIcon.CustomPath,
				IconBarGetCustomIconPath(GetIconMan()));
		lstrcpy(TmpPtr->LastCustomIcon.MacroPath,
				IconBarGetMacro(GetIconMan()));
	}
}

void 
MainWindow::SetIconSize(BYTE NewSize)
{
	IconSize = NewSize;
}

void 
MainWindow::SaveCustomBits()
{
	LPSTR Bits;

	if (TmpPtr->hDIB && TmpPtr->CurrentDIBChanged)
	{
		if (Bits = GlobalLock(TmpPtr->hDIB))
		{
			IconBarSetCustomBits(GetIconMan(),Bits);
			GlobalUnlock(TmpPtr->hDIB);
		}
	}
}

lbool 
MainWindow::GetLastRect(LPRECT prect)
{
	BYTE Buffer[120];
	BYTE comma[2];
	BYTE *cp;
	lubyte Output[30];


	strcpy(Output,"IconRect");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	GetPrivateProfileString((lfpbyte)"SmartIcons",(lfpbyte)Output, 
		(lfpbyte)"",(lfpbyte)Buffer,sizeof Buffer,
		(lfpbyte)"iconstub.ini");

	if (!Buffer[0])
		return FALSE;

	comma[0] = ','; comma[1] = NULL;

	cp = strtok(Buffer,comma);
	prect->left = atoi(Buffer);

	cp = strtok(NULL,comma);
	prect->top = atoi(cp);

	cp = strtok(NULL,comma);
	prect->right = atoi(cp);

	cp = strtok(NULL,comma);
	prect->bottom = atoi(cp);

	return TRUE;
}

BYTE 
MainWindow::GetLastIconSize()
{
	BYTE Buffer[120];

	GetPrivateProfileString((lfpbyte)"SmartIcons",(lfpbyte)"IconSize", 
		(lfpbyte)"",(lfpbyte)Buffer,sizeof Buffer,
		(lfpbyte)"iconstub.ini");

	if (!Buffer[0])
		return 0;

	return (BYTE)atoi(Buffer);
}

lbool 
MainWindow::GetLastPosition()
{
	BYTE Buffer[120];
	lubyte Output[30];

	strcpy(Output,"IconBarPosition");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	GetPrivateProfileString((lfpbyte)"SmartIcons",(lfpbyte)Output, 
		(lfpbyte)"",(lfpbyte)Buffer,sizeof Buffer,
		(lfpbyte)"iconstub.ini");

	if (!Buffer[0])
		return 0;

	return atoi(Buffer);
}

void 
MainWindow::SetLastRect()
{
	BYTE StrBuffer[120];
	BYTE Key[8];
	BYTE comma[2];
	RECT rect;
	lubyte Output[30];


	IconBarGetLastRect(GetIconBar(),(LPRECT)&rect);

	comma[0] = ','; comma[1] = NULL;

	itoa(rect.left,StrBuffer,10);
	strcat(StrBuffer,comma);

	itoa(rect.top,Key,10);

	strcat(StrBuffer,Key);
	strcat(StrBuffer,comma);
	
	itoa(rect.right,Key,10);

	strcat(StrBuffer,Key);
	strcat(StrBuffer,comma);
	
	itoa(rect.bottom,Key,10);

	strcat(StrBuffer,Key);

	strcpy(Output,"IconBarRect");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	WritePrivateProfileString((lfpbyte)"SmartIcons",(lfpbyte)Output, 
		(lfpbyte)StrBuffer, (lfpbyte)"iconstub.ini");
}

void 
MainWindow::SetLastIconSize()
{
	BYTE StrBuffer[120];

	itoa(IconSize,StrBuffer,10);

	WritePrivateProfileString((lfpbyte)"SmartIcons",(lfpbyte)"IconSize", 
		(lfpbyte)StrBuffer, (lfpbyte)"iconstub.ini");
}

void 
MainWindow::SetLastPosition()
{
	BYTE StrBuffer[120];
	BYTE Position;
	lubyte Output[30];

	Position = IconBarGetPositionType(GetIconBar());

	itoa(Position,StrBuffer,10);

	strcpy(Output,"IconBarPosition");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	WritePrivateProfileString((lfpbyte)"SmartIcons",(lfpbyte)Output, 
		(lfpbyte)StrBuffer, (lfpbyte)"iconstub.ini");
}

lbool 
MainWindow::SaveDescription()
{
	BYTE description[LEN_HELP];
	BYTE description2[LEN_HELP];
	
	IconBarSetDescription(GetIconMan(),description2);
	GetDlgItemText(TmpPtr->DialogBox,ID_EDIT2,(LPSTR)description,
			LEN_HELP - 1);
	if (strcmp(description,description2) != 0)
	{
		IconBarSetDescription(GetIconMan(),description);
		return TRUE;
	}
	return FALSE;
}

void 
GetMacroFilePlusFunction(BYTE * dest,BYTE * src,int maxlen)
{
	int	len, srclen;

	srclen = len = strlen(src);
	while (len > 0) {
		if (src[len] == DIRSEPARATOR || (src[len] == ':' && len == 1))
			break;
		len--;
	}

	if (srclen > len) 
	{
		if (src[len] == DIRSEPARATOR || src[len] == ':')
			len++;

		memcpy(dest,&src[len],min(maxlen,srclen - len));
		dest[min(maxlen,srclen - len)] = NULL;
	}
	else
		*dest = NULL;
}

void 
MainWindow::CopyClipboard(HWND hDlg)
{
	HANDLE hDIB = NULL;
	HBITMAP hBitmap = NULL;

	if (!OpenClipboard(hDlg))
		return;

	if (!(hDIB = GetClipboardData(CF_DIB)))
		hBitmap = GetClipboardData(CF_BITMAP);

	if (hDIB || hBitmap)
	{
		if (IconBarSelectStandardIcon(GetIconMan(),0,0))
		{
			POINT Size;
			HANDLE NewDIB;

			IconBarGetIconSize(GetIconMan(),&Size);

			/* take off the border */
			Size.x -= 3;
			Size.y -= 3;

			if (NewDIB = MakeGraphicRightSize(hDIB,hBitmap,Size.x,Size.y))
			{
				IconEditDestroy(TmpPtr);
				IconEditInit(TmpPtr,hDlg,NewDIB);
				TmpPtr->CurrentDIBChanged = TRUE;
				InvalidateRect(GetDlgItem(hDlg, ID_STATIC3),NULL, FALSE);
				InvalidateRect(GetDlgItem(hDlg, ID_STATIC2),NULL, FALSE);
				InvalidateRect(GetDlgItem(hDlg, ID_STATIC4),NULL, FALSE);
			}
		}
	}
	CloseClipboard();
}

HANDLE 
MakeGraphicRightSize(HANDLE hDIB,HBITMAP hBitmap,int width,int height)
{
	HBITMAP NewBitmap,Old1;
	HDC MemDC1,ScreenDC;
	LPBITMAPINFO lpbi;
	HANDLE NewDIB;
	BITMAP bm;

	if (hDIB)
	{
		if (!(lpbi = (LPBITMAPINFO)GlobalLock(hDIB)))
			return NULL;

		if ((lpbi->bmiHeader.biHeight == (WORD)height) 
				&& (lpbi->bmiHeader.biWidth == (WORD)width))
		{
			HANDLE MemHandle;
			BYTE huge *MemPtr;
			DWORD Size;

			if (MemHandle = GlobalAlloc(GMEM_MOVEABLE,Size = GlobalSize(hDIB)))
			{
				if (MemPtr = (BYTE huge *)GlobalLock(MemHandle))
				{
					hmemcpydown(MemPtr,(BYTE huge *)lpbi,Size);
					GlobalUnlock(MemHandle);
					GlobalUnlock(hDIB);
					return MemHandle;
				}
				GlobalFree(MemHandle);
			}
		}
	}
	else if (hBitmap)
	{

		GetObject(hBitmap,sizeof(bm),(LPSTR)&bm);
		if ((bm.bmWidth == width) && (bm.bmHeight == height))
			return DIBFromBitmap(hBitmap,BI_RGB,0);
	}
	else
		return NULL;

	if (!(ScreenDC = GetDC(NULL)))
	{
		if (hDIB)
			GlobalUnlock(hDIB);
		return NULL;
	}
	if (!(MemDC1 = CreateCompatibleDC(ScreenDC)))
	{
		if (hDIB)
			GlobalUnlock(hDIB);
		ReleaseDC(NULL,ScreenDC);
		return NULL;
	}
	if (!(NewBitmap = CreateCompatibleBitmap(ScreenDC,width , height)))
	{
		if (hDIB)
			GlobalUnlock(hDIB);
		ReleaseDC(NULL,ScreenDC);
		DeleteDC(MemDC1);
		return NULL;
	}
	ReleaseDC(NULL,ScreenDC);
	if (!(Old1 = SelectObject(MemDC1,NewBitmap)))
	{
		if (hDIB)
			GlobalUnlock(hDIB);
		DeleteDC(MemDC1);
		return NULL;
	}

	/* clear off the DC */
	PatBlt(MemDC1,0,0,width,height,WHITENESS);
	if (hDIB)
	{

#ifdef STRETCHIT
		StretchDIBits(MemDC1,0,0,width,height,0,0,(WORD)lpbi->bmiHeader.biWidth,
			(WORD)lpbi->bmiHeader.biHeight,(LPSTR)lpbi + 
				(WORD)lpbi->bmiHeader.biSize + DIBPaletteSize(lpbi),lpbi,
				DIB_RGB_COLORS,SRCCOPY);
#else
		if (width < (int)lpbi->bmiHeader.biWidth)
			width = (int)lpbi->bmiHeader.biWidth;
		if (height < (int)lpbi->bmiHeader.biHeight)
			height = (int)lpbi->bmiHeader.biHeight;

		StretchDIBits(MemDC1,0,0,width,height,0,0,width, height,(LPSTR)lpbi + 
				(WORD)lpbi->bmiHeader.biSize + DIBPaletteSize(lpbi),lpbi,
				DIB_RGB_COLORS,SRCCOPY);
#endif
		GlobalUnlock(hDIB);
	}
	else
	{
		HDC MemDC2;
		HBITMAP Old2;

		if (!(MemDC2 = CreateCompatibleDC(MemDC1)))
		{
			SelectObject(MemDC1,Old1);
			DeleteDC(MemDC1);
			DeleteObject(NewBitmap);
			return NULL;
		}
		if (!(Old2 = SelectObject(MemDC2,hBitmap)))
		{
			SelectObject(MemDC1,Old1);
			DeleteDC(MemDC1);
			DeleteDC(MemDC2);
			DeleteObject(NewBitmap);
			return NULL;
		}

		if (width < bm.bmWidth)
			width = bm.bmWidth;
		if (height < bm.bmHeight)
			height = bm.bmHeight;

		BitBlt(MemDC1,0,0,width,height,MemDC2,0,0,SRCCOPY);

		SelectObject(MemDC2,Old2);
		DeleteDC(MemDC2);
	}

	SelectObject(MemDC1,Old1);
	DeleteDC(MemDC1);

	NewDIB = DIBFromBitmap(NewBitmap,BI_RGB,0);
	DeleteObject(NewBitmap);
	return NewDIB;
}

/* copy cnt bytes from src to dst		*/
/* src and dst are huge pointers		*/
/* cnt is DWORD							*/
/* makes sure segments are not violated	*/
void 
hmemcpydown(BYTE huge * dst, BYTE huge * src, DWORD cnt)
{
	while (cnt != 0)
	{
		DWORD dleft, sleft;

		/* calculate how much is left in each segment */
		dleft = 0x10000L - (WORD)dst;
		sleft = 0x10000L - (WORD)src;

		/* use the min of dleft and sleft	*/

		if (dleft > sleft)
			dleft = sleft;
		
		/* but of course don't copy more than count */
		if (dleft > cnt)
			dleft = cnt;
		
		/* go ahead and adjust loop variable */
		cnt -= dleft;

		/* lmemcpy can't copy 0x10000 at a time, so split it up if necessary */
		if (dleft == 0x10000L)
		{
			memcpy((void *)dst, (void *)src, 0x8000);
			dst += 0x8000;
			src += 0x8000;
			dleft -= 0x8000;
		}
		memcpy((void *)dst, (void *)src, (WORD)dleft);
		dst += dleft;
		src += dleft;
	}
}

static void 
LoadDlgFont()
{
	LOGFONT	logfont;
	POINT	Point;
	HDC 	hdc;
	lubyte Path[LEN_PATH];

	hdc = GetDC(NULL);

	SetMapMode(hdc, MM_ANISOTROPIC);
	SetWindowExt(hdc, 1440, -1440);
	SetViewportExt(hdc, GetDeviceCaps(hdc, LOGPIXELSX),
		GetDeviceCaps(hdc, LOGPIXELSY));
	Point.x = Point.y = -200;
	LPtoDP(hdc, (LPPOINT)&Point, 1);
	SetMapMode(hdc, MM_TEXT);

	logfont.lfHeight = Point.y;
	logfont.lfWidth = logfont.lfEscapement = logfont.lfOrientation = 0;
	logfont.lfWeight = 400;
	logfont.lfItalic = logfont.lfUnderline = logfont.lfStrikeOut =
		logfont.lfCharSet = logfont.lfOutPrecision =
		logfont.lfClipPrecision = logfont.lfQuality = 0;
	logfont.lfPitchAndFamily = FF_SWISS;
	strcpy(logfont.lfFaceName, "Helv");
	DlgFont = CreateFontIndirect(&logfont);

	ReleaseDC(NULL, hdc);
}

void PASCAL
GetFileNameInfo(BYTE * dest,BYTE * src,int type)
{
	int	len, srclen;

	srclen = len = strlen(src);
	while (len > 0) {
		if (src[len] == DIRSEPARATOR || (src[len] == ':' && len == 1))
			break;
		len--;
	}

	if (srclen > len) 
	{
		switch (type) 
		{
			case GFI_FILENAME:
				if (src[len] == DIRSEPARATOR || src[len] == ':')
					len++;

				memcpy(dest,&src[len],min(LEN_PATH - 1,
					srclen - len));
				dest[min(LEN_PATH - 1,srclen - len)] = NULL;
				break;

			case GFI_DIRPATH:
				if ((src[len] == ':')
				|| ((len > 1) && src[len-1] == ':'))
					len++;
				memcpy(dest,src,len);
				dest[len] = NULL;
				break;

			default:
				*dest = NULL;
				break;
		}
	}
	else
		*dest = NULL;
}

/* Sets the file extension to the passed one. */
void PASCAL
SetFileExtension(BYTE * filename, BYTE * extension)
{
	BYTE *p;

	/* Get to last character of filename */
	p = &filename[strlen(filename)];

	/* Scan back until hit a . or a \ */
	while (p > filename) 
	{
		if (('.' == *p) || (DIRSEPARATOR == *p))
			break;
		p--;
	}

	/* Found no . - we'll just put the extension at the end of the whole */
	/* schmeer. */
	if ('.' != *p)
		p = &filename[strlen(filename)];
	else 
		filename = 0;
	strcpy(p, extension);
}

BOOL PASCAL
AnyWildcardsInName(BYTE * string)
{
	BOOL	wildcard;

	if (strchr(string, '?') 
	|| strchr(string, '*'))
		wildcard = TRUE;
	else
		wildcard = FALSE;

	return wildcard;
}

void
MainWindow::EndStub()
{
	if (IconManager)
	{
		IconBarDestroyManager(IconManager);
		IconManager = 0;
	}
	if (DialogLibrary)
	{
		FreeLibrary(DialogLibrary);
		DialogLibrary = 0;
	}
	if (DlgFont)
	{
		DeleteObject(DlgFont);
		DlgFont = 0;
	}
	if (IconManLibrary)
	{
		FreeLibrary(IconManLibrary);
		IconManLibrary = 0;
	}
	FreeProcInstance((FARPROC)IconProc.MemoryAlloc );
	FreeProcInstance((FARPROC)IconProc.MemoryReAlloc );
	FreeProcInstance((FARPROC)IconProc.MemoryLock );
	FreeProcInstance((FARPROC)IconProc.MemoryUnlock );
	FreeProcInstance((FARPROC)IconProc.MemorySize );
	FreeProcInstance((FARPROC)IconProc.MemoryFree );
	FreeProcInstance((FARPROC)IconProc.MessageProc );
}
