#ifndef IBMACRO_H
#define IBMACRO_H

typedef  HWND 			HMANAGER;
typedef  HWND			HPARENT;
typedef  HWND			HWINDOW;
typedef  HANDLE			HRESOURCE;
typedef  HANDLE			HMEMORY;
typedef  HBITMAP		HGRAPHIC;
typedef  WORD 			RESOURCEOFFSET;
typedef  DWORD			HICONBAR;
typedef  LPSTR			LPUSERDATA;

#define LEN_PATH				82
#define LEN_HELP				121
#define	INIDESCRIPTION_SIZE		16


typedef struct tagIBPRIMITIVEMSG
{
    HWND hwnd;
    WORD message;
    WORD wParam;
    LONG lParam;
	BOOL CanSendToDefProc;
} IBPRIMITIVEMSG;

typedef IBPRIMITIVEMSG far *LPPRIMITIVEMSG;

typedef struct tagIBHITTEST
{
	LONG lParam;
	WORD wParam;
	HANDLE Window;
} IBHITTEST;

typedef IBHITTEST far *LPIBHITTEST;

typedef struct tagSTANDARDICON
{
	int 		ActionID;
	HRESOURCE 	Library;
} STANDARDICON;

typedef STANDARDICON far *LPSTANDARDICON;

typedef struct tagCUSTOMICON
{
	BYTE 		CustomPath[LEN_PATH];
	BYTE		MacroPath[LEN_PATH];
} CUSTOMICON;

typedef CUSTOMICON far *LPCUSTOMICON;

/* PROCS	*/
typedef HMEMORY (far *FARALLOCPROC)(DWORD);
typedef HMEMORY (far *FARREALLOCPROC)(HMEMORY,DWORD);
typedef BYTE far *(far *FARLOCKPROC)(HMEMORY);
typedef BOOL (far *FARUNLOCKPROC)(HMEMORY);
typedef BOOL (far *FARFREEPROC)(HMEMORY);
typedef DWORD (far *FARSIZEPROC)(HMEMORY);
typedef DWORD (far *FARMESSAGEPROC)(HPARENT,HMANAGER,HICONBAR,WORD,
						DWORD,DWORD);

typedef struct tagICONPROC
{
	FARALLOCPROC	MemoryAlloc;		
	FARREALLOCPROC	MemoryReAlloc;		
	FARLOCKPROC		MemoryLock;		
	FARUNLOCKPROC	MemoryUnlock;		
	FARSIZEPROC		MemorySize;
	FARFREEPROC		MemoryFree;		
	FARMESSAGEPROC	MessageProc;		
}ICONPROC;

typedef ICONPROC *PICONPROC;
typedef ICONPROC NEAR *NPICONPROC;
typedef ICONPROC far *LPICONPROC;


/* Messages.	*/
#define 	IB_SETPROCS						WM_USER + 1
#define 	IB_PAINT						WM_USER + 2
#define 	IB_SHOW							WM_USER + 3
#define 	IB_HIDE							WM_USER + 4
#define		IB_SETSCREENPOSITION			WM_USER + 5
#define		IB_SETPOSITION					WM_USER + 6
#define		IB_SETRESOURCE					WM_USER + 7
#define		IB_HOSTSIZECHANGED				WM_USER + 8
#define		IB_SETCONFIGURATIONPATH			WM_USER + 9
#define		IB_SELECTCONFIGURATION			WM_USER + 10
#define		IB_LOADCONFIGURATION			WM_USER + 11
#define		IB_CONFIGURE					WM_USER + 12
#define		IB_GETICONSTATE					WM_USER + 13
#define		IB_GETICONACTIONID				WM_USER + 14
#define		IB_SETCUSTOMPATH				WM_USER + 15
#define		IB_SELECTSTANDARDICON			WM_USER + 16
#define		IB_SELECTCUSTOMICON				WM_USER + 17
#define		IB_REPLACEWITHSTANDARDICON		WM_USER + 18
#define		IB_REPLACEWITHCUSTOMICON		WM_USER + 19
#define		IB_DESELECTCONFIGURATION		WM_USER + 20
#define		IB_ENUMCONFIGURATIONS			WM_USER + 21
#define		IB_GETCONFIGURATIONDESCRIPTION	WM_USER + 22
#define		IB_SELECTCONFIGURATIONBYDESC 	WM_USER + 23
#define		IB_MAKEICONDEPRESSIBLE			WM_USER + 24
#define		IB_DESELECTICON					WM_USER + 25
#define		IB_ENUMICONS					WM_USER + 26
#define		IB_MAKEICONNOTDEPRESSIBLE		WM_USER + 27
#define		IB_SETROWSPACING				WM_USER + 28
#define		IB_SETNUMBERROWS				WM_USER + 29
#define		IB_CREATEICONBAR				WM_USER + 30
#define		IB_ADDICON						WM_USER + 31
#define		IB_MAKEDIALOGICONBAR			WM_USER + 32
#define		IB_SETSIZE						WM_USER + 33
#define		IB_SHOWSTANDARDICON				WM_USER + 34
#define		IB_GETMACRO						WM_USER + 35
#define		IB_GETDESCRIPTION				WM_USER + 36
#define		IB_SETMACRO						WM_USER + 37
#define		IB_SETDESCRIPTION				WM_USER + 38
#define		IB_SETDEFAULTFILE				WM_USER + 39
#define		IB_GETCUSTOMICONPATH			WM_USER + 40
#define		IB_GETSTATE						WM_USER + 41
#define		IB_GETSCREENPOSITION			WM_USER + 42
#define		IB_GETPOSITION					WM_USER + 43
#define		IB_ENABLE						WM_USER + 44
#define		IB_DISABLE						WM_USER + 45
#define		IB_DESTROYICONBAR				WM_USER + 46
#define		IB_TURNOFFTITLEBAR				WM_USER + 47
#define		IB_TURNONTITLEBAR				WM_USER + 48
#define		IB_TURNOFFSCALING				WM_USER + 49
#define		IB_TURNONSCALING				WM_USER + 50
#define		IB_TURNOFFFILESAVE				WM_USER + 51
#define		IB_TURNONFILESAVE				WM_USER + 52
#define		IB_SELECTLOADCONFIG				WM_USER + 53
#define		IB_SETCUSTOMBITS				WM_USER + 55
#define		IB_GETBITMAP					WM_USER + 56
#define		IB_NEWCUSTOMICON				WM_USER + 57
#define		IB_SETCUSTOMICONPATH			WM_USER + 58
#define		IB_SELECTCHOSENICON				WM_USER + 59
#define		IB_SHOWCUSTOMICON				WM_USER + 60
#define		IB_REMOVEICON					WM_USER + 61
#define		IB_GETLASTRECT					WM_USER + 62
#define		IB_GETRESOURCELIBRARY			WM_USER + 63
#define		IB_GETICONSIZE					WM_USER + 64
#define		IB_NEWSTANDARDICON				WM_USER + 65
#define		IB_TURNONWINCLOSEBOX			WM_USER + 66
#define		IB_TURNOFFWINCLOSEBOX			WM_USER + 67
#define		IB_TURNONTHICKFRAMES			WM_USER + 68
#define		IB_TURNOFFTHICKFRAMES			WM_USER + 69
#define		IB_DEPRESSICON					WM_USER + 70
#define		IB_LETUPICON					WM_USER + 71
#define		IB_GETCONFIGFILEPATH			WM_USER + 72
#define		IB_TURNONONEHELP				WM_USER + 73
#define		IB_TURNOFFONEHELP				WM_USER + 74
#define		IB_SETPRIMITIVE					WM_USER + 75
#define		IB_SETCACHE						WM_USER + 76
#define		IB_SETAUTOREPEAT				WM_USER + 77

/* Manager Macros.	*/

#define IconBarCreateManager(Parent,Instance) \
		((HMANAGER)CreateWindow((LPSTR)"MgrLTS04",(LPSTR)NULL,WS_POPUP, \
			0,0,0,0,Parent, NULL, Instance ,(LPSTR)NULL))

#define	IconBarSetProcs(Manager,Procs)	\
			((BOOL)SendMessage(Manager,IB_SETPROCS,0,(LONG)(LPICONPROC)Procs))

#define IconBarCreate(Manager,Parent) \
			((HICONBAR)SendMessage(Manager,IB_CREATEICONBAR,0,Parent))

#define	IconBarSetResource(Manager,Path,Offset)	\
			((BOOL)SendMessage(Manager,IB_SETRESOURCE,Offset,\
						(DWORD)(LPSTR)Path))

#define	IconBarHostSizeChange(Manager)	\
			((BOOL)SendMessage(Manager,IB_HOSTSIZECHANGED,0,0L))

#define	IconBarSetConfigPath(Manager,RegNumber,Path)	\
 			((BOOL)SendMessage(Manager,IB_SETCONFIGURATIONPATH,RegNumber, \
					(DWORD)(LPSTR)Path))

#define	IconBarSelectConfig(Manager,Name)	\
				((BOOL)SendMessage(Manager,IB_SELECTCONFIGURATION,0, \
						(DWORD)(LPSTR)Name))

#define	IconBarGetIconState(Manager)	\
				(SendMessage(Manager,IB_GETICONSTATE,0,0))

#define	IconBarGetIconActionID(Manager)	\
				((WORD)SendMessage(Manager,IB_GETICONACTIONID,0,0))

#define	IconBarSetCustomPath(Manager,Path)	\
				((BOOL)SendMessage(Manager,IB_SETCUSTOMPATH,0, \
					(LONG)(LPSTR)Path))

#define	IconBarSelectStandardIcon(Manager,MenuID, Resource)	\
				((BOOL)SendMessage(Manager,IB_SELECTSTANDARDICON,MenuID, \
					(LONG)Resource))

#define	IconBarSelectCustomIcon(Manager,CustomStrings)	\
				((BOOL)SendMessage(Manager,IB_SELECTCUSTOMICON,0 \
					,(LONG)(LPCUSTOMICON)CustomStrings))

#define	IconBarChangeToStandardIcon(Manager,MenuID, Resource)	\
				((BOOL)SendMessage(Manager,IB_REPLACEWITHSTANDARDICON,MenuID, \
						(LONG)Resource))

#define	IconBarChangeToCustomIcon(Manager,CustomStrings)	\
				((BOOL)SendMessage(Manager,IB_REPLACEWITHCUSTOMICON,0 \
					,(LONG)(LPSTR)CustomStrings))

#define	IconBarDeselectConfig(Manager)	\
				((BOOL)SendMessage(Manager,IB_DESELECTCONFIGURATION,0,0))

#define	IconBarEnumConfig(Manager)	\
				((BOOL)SendMessage(Manager,IB_ENUMCONFIGURATIONS,0,0))

#define	IconBarGetConfigDesc(Manager)	\
				((LPSTR)SendMessage(Manager,IB_GETCONFIGURATIONDESCRIPTION,0 \
						, 0))

#define	IconBarSelectConfigByDesc(Manager,Description)	\
				((BOOL)SendMessage(Manager,IB_SELECTCONFIGURATIONBYDESC,0, \
						(LONG)(LPSTR)Description))

#define	IconBarMakeIconDepressible(Manager)	\
				((BOOL)SendMessage(Manager,IB_MAKEICONDEPRESSIBLE,0,0))

#define	IconBarMakeIconNotDepressible(Manager)	\
				((BOOL)SendMessage(Manager,IB_MAKEICONNOTDEPRESSIBLE,0,0))

#define	IconBarDeselectIcon(Manager)	\
				((BOOL)SendMessage(Manager,IB_DESELECTICON,0,0))

#define	IconBarEnumIcons(Manager)	\
				((BOOL)SendMessage(Manager,IB_ENUMICONS,0,0))

#define IconBarGetMacro(Manager)	\
				((LPSTR)SendMessage(Manager,IB_GETMACRO, (WORD)0,0))

#define IconBarGetDescription(Manager)	\
				((LPSTR)SendMessage(Manager,IB_GETDESCRIPTION, (WORD)0,0))

#define IconBarSetMacro(Manager,Macro)	\
				((LPSTR)SendMessage(Manager,IB_SETMACRO, (WORD)0, \
					(LONG)(LPSTR)Macro))

#define IconBarSetDescription(Manager,Description)	\
				((LPSTR)SendMessage(Manager,IB_SETDESCRIPTION, (WORD)0, \
						(LONG)(LPSTR)Description))

#define IconBarSetDefaultFile(Manager,File)	\
				((BOOL)SendMessage(Manager,IB_SETDEFAULTFILE, (WORD)0, \
						(LONG)(LPSTR)File))

#define IconBarGetCustomIconPath(Manager)	\
				((LPSTR)SendMessage(Manager,IB_GETCUSTOMICONPATH, (WORD)0,0))

#define IconBarDestroyManager(Manager)	\
				DestroyWindow(Manager)
 
#define IconBarSetCustomBits(Manager,Bits)	\
				((BOOL)SendMessage(Manager,IB_SETCUSTOMBITS, (WORD)0, \
						(LONG)(LPSTR)Bits))
 
#define IconBarGetBitmap(Manager)	\
				((HBITMAP)SendMessage(Manager,IB_GETBITMAP, (WORD)0, 0))
 
#define IconBarNewCustomIcon(Manager)	\
				((BOOL)SendMessage(Manager,IB_NEWCUSTOMICON, (WORD)0, 0))
 
#define IconBarNewStandardIcon(Manager,ResourceID,lpStIcon)	\
				((BOOL)SendMessage(Manager,IB_NEWSTANDARDICON,(WORD)ResourceID \
					, (LONG)(LPSTANDARDICON)lpStIcon))
 
#define IconBarSetCustomIconPath(Manager,Path,New)	\
				((BOOL)SendMessage(Manager,IB_SETCUSTOMICONPATH, (WORD)New, \
						(DWORD)(LPSTR)Path))
 
#define IconBarRemoveIcon(Manager)	\
				((BOOL)SendMessage(Manager,IB_REMOVEICON, (WORD)0, 0))
 
#define IconBarGetResourceLibrary(Manager)	\
				((HRESOURCE)SendMessage(Manager,IB_GETRESOURCELIBRARY, \
					(WORD)0, 0))

#define IconBarGetIconSize(Manager,Pt)	\
				((BOOL)SendMessage(Manager,IB_GETICONSIZE, (WORD)0, \
					(DWORD)(LPPOINT)Pt))

#define IconBarTurnOnThickDialogs(Manager)	\
				((BOOL)SendMessage(Manager,IB_TURNONTHICKFRAMES, (WORD)0, 0))

#define IconBarTurnOffThickDialogs(Manager)	\
				((BOOL)SendMessage(Manager,IB_TURNOFFTHICKFRAMES, (WORD)0, 0))

#define IconBarDepressIcon(Manager)	\
				((BOOL)SendMessage(Manager,IB_DEPRESSICON, (WORD)0, 0))

#define IconBarLetUpIcon(Manager)	\
				((BOOL)SendMessage(Manager,IB_LETUPICON, (WORD)0, 0))

#define IconBarGetConfigFilePath(Manager,FileName)	\
				((BOOL)SendMessage(Manager,IB_GETCONFIGFILEPATH, (WORD)0, \
					(LONG)(LPSTR)FileName))

#define IconBarSetCache(Manager,Count)	\
				((BOOL)SendMessage(Manager,IB_SETCACHE, (WORD)Count, \
					(LONG)0))

/* IconBar Macros */

#define	IconBarPaint(IconBar)	\
			((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_PAINT, \
					(WORD)IconBar,0L))

#define	IconBarShow(IconBar)	\
			((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_SHOW, \
					(WORD)IconBar,0L))

#define	IconBarHide(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_HIDE, \
					(WORD)IconBar,0L))

#define	IconBarSetPositionType(IconBar,Type)	\
			((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_SETPOSITION, \
				(WORD)IconBar,Type))

#define	IconBarSetPosition(IconBar,Point)	\
			((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_SETSCREENPOSITION \
				,(WORD)IconBar,(DWORD)(LPPOINT)Point))

#define	IconBarSetSize(IconBar,BarRect)	\
			((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_SETSIZE \
				,(WORD)IconBar,(DWORD)(LPRECT)BarRect))

#define	IconBarLoadConfig(IconBar)	\
			((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
					IB_LOADCONFIGURATION,(WORD)IconBar,0))

#define	IconBarConfigure(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_CONFIGURE, \
					(WORD)IconBar,0))

#define	IconBarSetRowSpacing(IconBar,Spacing)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_SETROWSPACING \
					,(WORD)IconBar,Spacing))

#define	IconBarSetNumberRows(IconBar,NumRows)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_SETNUMBERROWS,\
					(WORD)IconBar,NumRows))

#define IconBarAddIcon(IconBar,Position)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_ADDICON, \
					(WORD)IconBar,(DWORD)Position))

#define IconBarMakeDialogIconBar(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),\
						IB_MAKEDIALOGICONBAR,(WORD)IconBar,0))

#define IconBarShowStandardIcon(IconBar,StandardIcon)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),	\
						IB_SHOWSTANARDICON, (WORD)IconBar, \
						(DWORD)(LPSTANDARDICON)StandardIcon))

#define IconBarShowCustomIcon(IconBar,CustomIcon)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),	\
						IB_SHOWCUSTOMICON, (WORD)IconBar, \
						(LONG)(LPCUSTOMICON)CustomIcon))

#define IconBarGetState(IconBar)	\
				(SendMessage((HMANAGER)(IconBar >> 16),	IB_GETSTATE, \
						(WORD)IconBar,0))

#define IconBarGetPosition(IconBar,BarRect)	\
				(SendMessage((HMANAGER)(IconBar >> 16),	IB_GETSCREENPOSITION, \
						(WORD)IconBar,(DWORD)(LPRECT)BarRect))

#define IconBarGetPositionType(IconBar)	\
				((BYTE)SendMessage((HMANAGER)(IconBar >> 16),IB_GETPOSITION, \
						(WORD)IconBar,0))

#define IconBarEnable(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_ENABLE, \
						(WORD)IconBar,0))

#define IconBarDisable(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16),IB_DISABLE, \
						(WORD)IconBar,0))

#define IconBarDestroy(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_DESTROYICONBAR, (WORD)IconBar,0))

#define IconBarTurnOffSystemBar(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNOFFTITLEBAR, (WORD)IconBar,0))

#define IconBarTurnOnSystemBar(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNONTITLEBAR, (WORD)IconBar,0))

#define IconBarTurnOffScaling(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNOFFSCALING, (WORD)IconBar,0))

#define IconBarTurnOnScaling(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNONSCALING, (WORD)IconBar,0))

#define IconBarTurnOffFileSave(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNOFFFILESAVE, (WORD)IconBar,0))

#define IconBarTurnOnFileSave(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNONFILESAVE, (WORD)IconBar,0))

#define	IconBarSelectLoadedConfig(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_SELECTLOADCONFIG, (WORD)IconBar,0))

#define	IconBarSelectChosenIcon(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_SELECTCHOSENICON, (WORD)IconBar,0))

#define	IconBarGetLastRect(IconBar,lpRect)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_GETLASTRECT, (WORD)IconBar,(DWORD)(LPRECT)lpRect))

#define	IconBarTurnOnWinCloseBox(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNONWINCLOSEBOX, (WORD)IconBar,0))

#define	IconBarTurnOffWinCloseBox(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNOFFWINCLOSEBOX, (WORD)IconBar,0))

#define	IconBarTurnOnOneHelp(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNONONEHELP, (WORD)IconBar,0))

#define	IconBarTurnOffOneHelp(IconBar)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_TURNOFFONEHELP, (WORD)IconBar,0))

#define	IconBarSetPrimitive(IconBar,On)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_SETPRIMITIVE, (WORD)IconBar,(DWORD)On))

#define	IconBarSetAutoRepeat(IconBar,On)	\
				((BOOL)SendMessage((HMANAGER)(IconBar >> 16), \
						IB_SETAUTOREPEAT, (WORD)IconBar,(DWORD)On))


/* Messages for MessageProc	*/
#define 	IMM_ICONDOWN		0x0001	/* user clicked down on icon	*/
#define		IMM_ICONUP			0x0002	/* user let up on icon	*/
#define		IMM_ICONHELP		0x0003	/* user wants help on icon	*/
#define		IMM_BARSIZED		0x0004	/* icon bar resized.	*/
#define		IMM_HOSTSIZEREQUEST	0x0005	/* lparam is a pointer to a lrect.	*/
										/* fill in the client area.	*/
#define		IMM_ICONHELPDONE	0x0006	/* finished sending help.	*/
#define		IMM_ICONDEPRESSED	0x0007	/* depressable icon set down.	*/
#define		IMM_ICONLETUP		0x0008	/* depressable icon set up.	*/
#define		IMM_WHATICONS		0x0009	/* what is the current icon size	*/
#define		IMM_LOADICONS		0x000A	/* request to load wParam icons	*/
#define		IMM_EDITICON		0x000B	/* the icon manager destroyed.	*/
#define		IMM_GETFOCUS		0x000C	/* set the focus to the host */
#define		IMM_DESELECT		0x000D	/* deselecting */
#define		IMM_SELECT			0x000E	/* selecting */
#define		IMM_MANAGERDESTROY	0x000F	/* Manager about to be destroyed */
#define		IMM_GETLASTRECT		0x0010	/* Manager about to be destroyed */
#define		IMM_GETLASTPOS		0x0011	/* Manager about to be destroyed */
#define		IMM_GETLASTICONSIZE	0x0012	/* Manager about to be destroyed */
#define		IMM_ICONHITTEST		0x0013	/* hit test on iconbar */
#define		IMM_ICONBARSHOW		0x0014	/* the user has hidden or shown the
											iconabr */
#define		IMM_WHATDLGICONS	0x0015	/* if you do not want the user the 
											ability to choose some icons */
#define		IMM_PRIMITIVEMESSAGE	0x0016	
#define		IMM_CONTROLCOLOR	0x0017	/* control color in dlg boxes */
#define		IMM_ICONSIZE		0x0018	

#define 	WHATICON_EGA		0x01
#define 	WHATICON_VGA		0x02
#define 	WHATICON_SUPERVGA	0x04

/* Icon States	*/
#define 	ICS_CUSTOM 			0x01
#define 	ICS_DEPRESSED		0x02
#define		ICS_DOWN			0x04
#define		ICS_NOTAVAILABLE	0x08

/* Icon Sizes	*/
#define 	IS_EGA				0x01
#define 	IS_VGA				0x02
#define 	IS_SUPERVGA			0x03

/* iconbar positions	*/

#define			IBP_LEFT			0x01
#define			IBP_TOP				0x02
#define			IBP_RIGHT			0x03
#define			IBP_BOTTOM			0x04
#define			IBP_FLOATING		0x05

/* Icon Bar States	*/

#define IBS_LEFT				0x0001	/* fixed at left		*/
#define IBS_TOP					0x0002	/* fixed at top			*/
#define IBS_RIGHT				0x0004	/* fixed at right		*/
#define IBS_BOTTOM				0x0008	/* fixed at bottom		*/
#define IBS_FIXED				0x0010	/* in fixed position	*/
#define IBS_SHOWING				0x0020	/* iconbar is showing	*/
#define IBS_SCROLL				0x0040	/* has scroll bar 		*/
#define IBS_HORZSYSTEMBAR		0x0080	/* has scroll bar 		*/
#define IBS_DONEWITHSLOTS		0x0100	/* has scroll bar 		*/
#define IBS_DIALOG				0x0200	/* depress the selection*/
#define IBS_STOPRESIZE			0x0400	/* being destroyed 		*/
#define IBS_INFLUX				0x0800	/* in between hide/show	*/
#define IBS_ONEHELP				0x1000	/* in between hide/show	*/
#define IBS_WINCLOSEBOX			0x2000	/* in between hide/show	*/
#define IBS_SENDPRIMITIVE		0x4000	/* in between hide/show	*/
 
/* Registered Applications */
#define		REG_DONTCARE	0
#define		REG_AMIPRO		1
#define		REG_ROCKPORT	2
#define		REG_WALDEN		3
#define		REG_REMINGTON	4
#define		REG_SMARTEXT	5
#define		REG_IMPROV		6
#define		REG_123G		7
#define		REG_ADS			8
#define		REG_AGENDA		9
#define		REG_CCMAIL		10
#define		REG_AMIDLGED	11
#define		REG_DARWIN		12
#define		REG_AMIOUTDLL	13
#define		REG_ORGANIZER	14
#define		REG_NOTES		15
#define		REG_NOTEBOOK	16
#define		REG_ANNOTATE	17
#define		REG_ALEXANDRIA	18
#define		REG_ANALYST		19
#define		REG_BUILDER		20
#define		REG_NOMAD		21
#define		REG_APPROACH	22
#endif
