

/*---------------------------------------------------------------------------
	Windows Bitmap platform-specifics.
  ---------------------------------------------------------------------------
*/
	#define HPALETTE		HPAL

	#define HINSTANCE	HMODULE
	#define HGLOBAL 	HANDLE
	#define HLOCAL		HANDLE
	#define GLOBALHANDLE HANDLE
	#define LOCALHANDLE HANDLE
	#define HANDLE		LHANDLE
	#define HMENU		HWND
	#define HCURSOR		HPOINTER

	#define LPSTR		PSZ
	#define NPSTR		PSZ
	#define LPBYTE		PSZ
	#define WORD		USHORT
	#define LPWORD		PSHORT
	#define LPINT		PINT

	#define DWORD		ULONG
	#define LPDWORD		PULONG

	#define LPVOID		PVOID
	#define POINT		POINTL

	#define LF_FACESIZE	FACESIZE

	#define LOWORD(l)	LOUSHORT(l)
	#define HIWORD(l)	HIUSHORT(l)
/*
	Windows bitmap symbolic constants
*/
#define BI_RGB						BCA_UNCOMP
/*
	Types for Windows Bitmap structure
*/
#define BITMAP						BITMAPINFOHEADER2
#define PBITMAP						PBITMAPINFOHEADER2
/*
	BITMAP struct field names
*/
#define   BMTYPE					  ulCompression
#define   BMWIDTH					  cx
#define   BMHEIGHT					  cy
#define   BMWIDTHBYTES				  /* no direct OS/2 equivalent */
#define   BMPLANES					  cPlanes
#define   BMBITSPIXEL				  cBitCount
#define   BMBITS					  /* no OS/2 equivalent */

/*
	Types for Windows BITMAPCORE | OS/2 BITMAPINFO structures
*/
#define BITMAPINFOHEADER_OLD		BITMAPINFOHEADER
#define PBITMAPINFOHEADER_OLD		PBITMAPINFOHEADER
#define LPBITMAPINFOHEADER_OLD		PBITMAPINFOHEADER
#define BITMAPINFO_OLD				BITMAPINFO
#define PBITMAPINFO_OLD				PBITMAPINFO
#define LPBITMAPINFO_OLD			PBITMAPINFO

/*
	Windows BITMAPCORE | OS/2 BITMAPINFO struct field names.
*/
#define BCSIZE						cbFix
#define BCWIDTH 					cx
#define BCHEIGHT					cy
#define BCPLANES					cPlanes
#define BCBITCOUNT					cBitCount

/*
	Types for Windows BITMAPINFO | OS/2 BITMAPINFO2 structures
*/
#define BITMAPINFOHEADER_NEW		BITMAPINFOHEADER2
#define PBITMAPINFOHEADER_NEW		PBITMAPINFOHEADER2
#define LPBITMAPINFOHEADER_NEW		PBITMAPINFOHEADER2
#define BITMAPINFO_NEW				BITMAPINFO2
#define PBITMAPINFO_NEW				PBITMAPINFO2
#define LPBITMAPINFO_NEW			PBITMAPINFO2
/*
	Windows BITMAPINFOHEADER | OS/2 BITMAPINFOHEADER2 struct field names
*/
#define   BISIZE					  cbFix
#define   BIWIDTH					  cx
#define   BIHEIGHT					  cy
#define   BIPLANES					  cPlanes
#define   BIBITCOUNT				  cBitCount
#define   BICOMPRESSION				  ulCompression
#define   BISIZEIMAGE				  cbImage
#define   BIXPELSPERMETER			  cxResolution
#define   BIYPELSPERMETER			  cyResolution
#define   BICLRUSED					  cclrUsed
#define   BICLRIMPORTANT			  cclrImportant

/*
	Windows BITMAPINFO | OS/2 BITMAPINFO2 struct field names
*/
#define   BMIHEADER_BISIZE			  cbFix
#define   BMIHEADER_BIWIDTH			  cx
#define   BMIHEADER_BIHEIGHT		  cy
#define   BMIHEADER_BIPLANES		  cPlanes
#define   BMIHEADER_BIBITCOUNT		  cBitCount
#define   BMIHEADER_BICOMPRESSION	  ulCompression
#define   BMIHEADER_BISIZEIMAGE		  cbImage
#define   BMIHEADER_BIXPELSPERMETER	  cxResolution
#define   BMIHEADER_BIYPELSPERMETER	  cyResolution
#define   BMIHEADER_BICLRUSED		  cclrUsed
#define   BMIHEADER_BICLRIMPORTANT	  cclrImportant

/*
	Types for Windows BITMAPFILEHEADER | OS/2 BITMAPFILEHEADER2 structures
*/
#define BITMAPFILEHEADER_NEW		BITMAPFILEHEADER2
#define PBITMAPFILEHEADER_NEW		PBITMAPFILEHEADER2
#define LPBITMAPFILEHEADER_NEW		PBITMAPFILEHEADER2

/*
	Windows BITMAPFILEHEADER  | OS/2 BITMAPFILEHEADER2 struct field names.
*/
#define BFTYPE		usType
#define BFSIZE		cbSize
#define BFRESERVED1 xHotspot
#define BFRESERVED2 yHotspot
#define BFOFFBITS	offBits

/*
	Types for RGB structures
*/
#define RGBQUAD 					RGB2
#define RGBTRIPLE					RGB

#define RGBTBLUE	bBlue
#define RGBTGREEN	bGreen
#define RGBTRED		bRed

/*
	Windows RGBQUAD | OS/2 RGB2 struct field names
*/
#define   RGBBLUE					  bBlue
#define   RGBGREEN					  bGreen
#define   RGBRED					  bRed
#define   RGBRESERVED				  fcOptions

/*
	Windows RGBTRIPLE | OS/2 RGB struct field names.
*/
#define   RGBTBLUE					  bBlue
#define   RGBTGREEN					  bGreen
#define   RGBTRED					  bRed

/* DIB color table identifiers: taken from Windows.h */

#define	DIB_RGB_COLORS	0	/* color table in RGBQuads */

/*	Windows Ternary raster operations */
#define SRCCOPY 		ROP_SRCCOPY
#define SRCPAINT		ROP_SRCPAINT
#define SRCAND			ROP_SRCAND
#define SRCINVERT		ROP_SRCINVERT
#define SRCERASE		ROP_SRCERASE
#define NOTSRCCOPY		ROP_NOTSRCCOPY
#define NOTSRCERASE 	ROP_NOTSRCERASE
#define MERGECOPY		ROP_MERGECOPY
#define MERGEPAINT		ROP_MERGEPAINT
#define PATCOPY 		ROP_PATCOPY
#define PATPAINT		ROP_PATPAINT
#define PATINVERT		ROP_PATINVERT
#define DSTINVERT		ROP_DSTINVERT
#define BLACKNESS		ROP_ZERO
#define WHITENESS		ROP_ONE

/* get component colors from lcolor */
#define LGet24RValue(rgb)	    ((lubyte)(rgb))
#define LGet24GValue(rgb)	    ((lubyte)(((lushort)(rgb)) >> 8))
#define LGet24BValue(rgb)	    ((lubyte)((rgb)>>16))


/* OS/2-specific typedefs and defines */
/* switch RGB value order */
#define LCOLOR_TO_OS2RGB(color) \
	(((lubyte) LGet24BValue(color)) | \
	(((lushort)LGet24GValue(color))<<8) | \
	(((lulong) LGet24RValue(color))<<16))

extern void DevicePatBlt(HPS hps, lsshort X, lsshort Y, lushort Width, lushort Height);
extern int GetBitmapObject(HBITMAP hObject, int nCount, LPSTR lpObject);
extern HPS CreateCompatibleDC(HPS hPS);
extern HBITMAP CreateCompatibleBitmap(HPS hDC, int nWidth, int nHeight);
extern BOOL DeleteDC(HPS hDC);
extern WORD StretchDIBits(HPS hDC, int DestX, int	DestY, int	wDestWidth,
	int wDestHeight, int SrcX, int	SrcY, int wSrcWidth, int wSrcHeight,
	lfpbyte lpBits, LPBITMAPINFO_NEW lpBitsInfo, luint wUsage, lulong dwRop);
extern HPS GetDC(HWND hWnd);
extern LONG BitBlt(HPS hDestDC, int X, int Y, int nWidth, int nHeight,
	HPS hSrcDC, int XSrc, int YSrc, DWORD dwRop);
extern int GetDIBits(HPS hDC, HBITMAP hBitmap, WORD nStartScan,
	WORD nNumScans, LPSTR lpBits, LPBITMAPINFOHEADER_NEW lpBitsInfo, WORD wUsage);

/*
   To emulate the Windows SelectPalette, 0 return value should mean an error
   occured.  So SelectPalette will return 0 when GpiSelectPalette returns
   PAL_ERROR and will return DEF_PALETTE (rather than 0) when
   the old palette was a default or loaded color table (GpiSelectPalette
   returns PAL_ERROR)
*/
#define DEF_PALETTE 	((HPALETTE)PAL_ERROR)
#define ERROR_PALETTE	((HPALETTE)0)

extern HPALETTE SelectPalette(HPS hDC,HPALETTE hPalette,
	BOOL bForceBackground); 

extern WORD	RealizePalette(HPS hDC); 

#define	VM_PAGESIZE	4096		/* OS/2's virtual memory page size */
