#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "wpddefs.h"
#include "winos2.h"
/* copy memory when the source and destination do not overlap */
#include <string.h>
#define fmemcpy(dest, src, cnt)				memcpy(dest, src, cnt);

extern HAB	Hab;
int GetBitmapObject(HBITMAP hObject, int nCount, LPSTR lpObject);
HPS CreateCompatibleDC(HPS hPS);
HBITMAP CreateCompatibleBitmap(HPS hDC, int nWidth, int nHeight);
BOOL DeleteDC(HPS hDC);
WORD StretchDIBits(HPS hDC, int DestX, int	DestY, int	wDestWidth,
	int wDestHeight, int SrcX, int	SrcY, int wSrcWidth, int wSrcHeight,
	lfpbyte lpBits, LPBITMAPINFO_NEW lpBitsInfo, luint wUsage, lulong dwRop);
HPS GetDC(HWND hWnd);
LONG BitBlt(HPS hDestDC, int X, int Y, int nWidth, int nHeight,
	HPS hSrcDC, int XSrc, int YSrc, DWORD dwRop);
void DeviceTextOut(lsshort X, lsshort Y, const lubyte far *Str, lushort Cnt);
lulong DeviceGetTextExtent(const lubyte far *Str, lushort Cnt);

HPS CreateCompatibleDC(HPS hDC)
{
	DEVOPENSTRUC devOpenStruct = {NULL, "Display", NULL};
	SIZEL sizel = {0, 0};
	HDC hdcMem;

	hdcMem = DevOpenDC(Hab, OD_MEMORY, (PSZ)"*",
		3, (PDEVOPENDATA)&devOpenStruct, (hDC ? GpiQueryDevice(hDC) :
		NULLHANDLE));

	return GpiCreatePS(Hab, hdcMem, &sizel, PU_PELS | GPIF_DEFAULT |
		GPIT_MICRO | GPIA_ASSOC);
}

HBITMAP CreateCompatibleBitmap(HPS hDC, int nWidth, int nHeight)
{
	LONG lformats[2];
	BITMAPINFOHEADER2 infoHeader2;

	GpiQueryDeviceBitmapFormats(hDC, 2, lformats);

	memset(&infoHeader2, 0, sizeof(infoHeader2));
	infoHeader2.cbFix	  = sizeof(infoHeader2);
	infoHeader2.cx		  = abs(nWidth);
	infoHeader2.cy		  = abs(nHeight);
	infoHeader2.cPlanes   = lformats[0];
	infoHeader2.cBitCount = lformats[1];

	return GpiCreateBitmap(hDC, &infoHeader2, 0, NULL, NULL);
}

BOOL DeleteDC(HPS hDC)
{
	HDC realHDC;

	realHDC = GpiQueryDevice(hDC);
	GpiDestroyPS(hDC);
	DevCloseDC(realHDC);
	return TRUE;
}

WORD StretchDIBits(HPS hDC, int DestX, int	DestY, int	wDestWidth,
	int wDestHeight, int SrcX, int	SrcY, int wSrcWidth, int wSrcHeight,
	lfpbyte lpBits, LPBITMAPINFO_NEW lpBitsInfo, luint wUsage, lulong dwRop)
{
	POINTL aptl[4];
	LONG	rc;
	APIRET	rc2;

	aptl[0].x = DestX;
	aptl[0].y = DestY;
	aptl[1].x = DestX + wDestWidth - 1;
	aptl[1].y = DestY + abs(wDestHeight) - 1; /* OS/2 Target is Inclusive */
	aptl[2].x = SrcX;
	aptl[2].y = SrcY;
	aptl[3].x = SrcX + wSrcWidth;		  /* OS/2 Source is Exclusive */
	aptl[3].y = SrcY + wSrcHeight;

	rc = GpiDrawBits(hDC, (PVOID)lpBits, lpBitsInfo, 4, aptl, dwRop,
		BBO_IGNORE);
	if (rc == GPI_OK)
	{
		if (!(GpiConvert(hDC, CVTC_WORLD, CVTC_DEVICE, 2, aptl)))
		{
			rc2 = WinGetLastError(Hab);
		}
		return (WORD)(aptl[1].y - aptl[0].y);
	}
	else
	{
		rc2 = WinGetLastError(Hab);
		return (WORD)0;
	}
}

int GetBitmapObject(HBITMAP hObject, int nCount, LPSTR lpObject)
{
	int rc;

	((PBITMAP)lpObject)->BISIZE = sizeof(BITMAP);
	if (GpiQueryBitmapInfoHeader(hObject, (PBITMAP)lpObject))
		return sizeof(BITMAP);
	else
		return 0;
}

HPS GetDC(HWND hWnd)
{
	SIZEL		sizel = {0,0};
	HPS 		hps;
	CHARBUNDLE	charBundle;

	/*	Create PS with units of PELS and RGB color table */
	hps = WinGetPS(hWnd);

	/* RGB mode so can use RGB values (all primitives) */
	GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0, NULL);
	return hps;
}

LONG BitBlt(HPS hDestDC, int X, int Y, int nWidth, int nHeight,
	HPS hSrcDC, int XSrc, int YSrc, DWORD dwRop)
{
	POINTL	aptl[4];

	aptl[0].x = X;
	aptl[0].y = Y;
	aptl[1].x = X + nWidth - 1;
	aptl[1].y = Y + abs(nHeight) - 1;
	aptl[2].x = XSrc;
	aptl[2].y = YSrc;
	aptl[3].x = XSrc + nWidth - 1;
	aptl[3].y = YSrc + abs(nHeight) - 1;
	GpiConvert(hDestDC, CVTC_WORLD, CVTC_DEVICE, 2, aptl);
	GpiConvert(hSrcDC, CVTC_WORLD, CVTC_DEVICE, 2, &aptl[2]);
	aptl[1].x += 1;			 /* +1 to be exclusive */
	aptl[1].y += 1;			 /* +1 to be exclusive */
	aptl[3].x += 1;			 /* +1 to be exclusive */
	aptl[3].y += 1;			 /* +1 to be exclusive */

	return GpiBitBlt(hDestDC, hSrcDC, 4, aptl, dwRop, BBO_IGNORE);
}


int GetDIBits(HPS hDC, HBITMAP hBitmap, WORD nStartScan,
	WORD nNumScans, LPSTR lpBits, LPBITMAPINFOHEADER_NEW lpBitsInfo, WORD wUsage)
{
	int nBits;
	HBITMAP oldBitmap;
	APIRET	rc;

	if (!lpBits)
	{
		GpiQueryBitmapInfoHeader(hBitmap, lpBitsInfo);
		return (int)0;
	}
	if (HBM_ERROR == (oldBitmap = GpiSetBitmap(hDC, hBitmap)))
	{
		rc = WinGetLastError(Hab);
		return 0;
	}
	if (-1 == (nBits = GpiQueryBitmapBits(hDC, nStartScan, nNumScans, lpBits, 
		(LPBITMAPINFO_NEW)lpBitsInfo)))
	{
		rc = WinGetLastError(Hab);
	}
	GpiSetBitmap(hDC, oldBitmap);
	return nBits;
}

lulong
MyDosReAllocMem(lulong hdl, lulong newsize)
{
	lulong	newhdl;
	lulong	oldsize, flags;

	oldsize = 128 * 1024 * 1024;
	DosQueryMem((PVOID)hdl, &oldsize, &flags);

	// see if the old and newsize round to the same page size
	newsize += VM_PAGESIZE-1;
	newsize -= newsize % VM_PAGESIZE;
	if (oldsize == newsize)
		return hdl;

	// allocate new memory and copy to it
	if (!DosAllocMem((PPVOID)&newhdl, newsize, PAG_COMMIT|PAG_WRITE|PAG_READ))
	{
		fmemcpy((PVOID)newhdl, (PVOID)hdl, min(oldsize,newsize));
		DosFreeMem((PVOID)hdl);
		return newhdl;
	}
	else
		return 0;
}
/*
   To emulate the Windows SelectPalette, 0 return value should mean an error
   occured.  So SelectPalette will return 0 when GpiSelectPalette returns
   PAL_ERROR and will return DEF_PALETTE (rather than 0) when
   the old palette was a default or loaded color table (GpiSelectPalette
   returns PAL_ERROR)
*/
HPALETTE SelectPalette(HPS hDC,HPALETTE hPalette, BOOL bForceBackground)
{
	HPAL hpalOldPalette;

	if (hPalette == DEF_PALETTE) hPalette = 0;
	hpalOldPalette = GpiSelectPalette((HPS)hDC, hPalette);
	switch (hpalOldPalette)
	{
		case (HPAL)PAL_ERROR:
			return ERROR_PALETTE;
		case (HPAL)0:
			return DEF_PALETTE;
		default:
			return hpalOldPalette;
	}
}
WORD RealizePalette(HPS hDC)
{
	ULONG cclr;
	return (WinRealizePalette(WinWindowFromDC(GpiQueryDevice(hDC)),hDC, &cclr));
}

void
DeviceRectangle(HPS hps, lulong left, lulong bottom, lulong right, lulong top)
{
	POINTL	ptlCurrent;
	POINTL	ptl;

	GpiQueryCurrentPosition(hps, &ptlCurrent);
	ptl.x = left;
	ptl.y = bottom;
	GpiMove(hps, &ptl);
	ptl.x = right;
	ptl.y = top; 
	GpiBox(hps, DRO_OUTLINE, &ptl, 0, 0);
	GpiMove(hps, &ptlCurrent);
}

void
DevicePatBlt(HPS hps, lsshort X, lsshort Y, lushort Width, lushort Height)
{
	POINTL	aptl[4];
	aptl[0].x = X;
	aptl[0].y = Y - 1; /* -1 to be bottom exclusive */
	aptl[1].x = X + Width - 1;			 /* -1 to be right exclusive  */
	aptl[1].y = Y;
	aptl[2].x = 0;
	aptl[2].y = 0;
	aptl[3].x = Width;
	aptl[3].y = Height;

	GpiWCBitBlt(hps, NULLHANDLE, 4, aptl, ROP_PATCOPY, BBO_IGNORE);
}


/* SelectObject = SelectBitmapObject = GpiSetBitmap */
/* DeleteObject = DeleteBitmapObject = GpiDeleteBitmap */

