#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include "wpddefs.h"
#include "sammenu.h"
#include "ibmacro.h"
#include "dialogs.h"
#include "winos2.h"
#include "filesys.h"
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <stat.h>
#include "iconstub.h"                    // Resource file symbolics

void SetDefaultFile(HMANAGER manager,lubyte * pathname);
void SetDefaultSMIFile(HMANAGER manager,lubyte * path);

HAB	Hab;

#define RGB(r,g,b)		((ULONG)(((UCHAR)(b)|((USHORT)(g)<<8))|(((ULONG)(UCHAR)(r))<<16)))
BOOL	Rmousedown = FALSE;
BOOL	Lmousedown = FALSE;

#define FORCED_SIZE 0x01
#define	GFI_FILENAME		1
#define	GFI_DIRPATH			2
#define DIRSEPARATOR	'\\'
#undef NULL
#define NULL 0L

ICONPROC IconProc;

// Function prototype for WndProc callback.
// This should be the entry point for all window classes

LHANDLE MakeGraphicRightSize(LHANDLE hDIB,HBITMAP hBitmap,int width,int height);
lbool EditIconProc(HWND hOwner, lulong lpCustom);
MRESULT EXPENTRY _export WndProc(HWND hWnd,ULONG iMessage,
    MPARAM mParam1, MPARAM mParam2);
MRESULT EXPENTRY _export SelectConfiguration(HWND, lulong, MPARAM, MPARAM);
MRESULT EXPENTRY _export EditIconDlg(HWND hDlg, lulong iMessage, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY _export CreateIconDlg(HWND hDlg, lulong iMessage, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY _export SaveIconDlg( HWND hDlg, lulong iMessage, MPARAM mp1, MPARAM mp2);
HMEMORY cdecl _export 		MemoryAlloc(lulong );
lulong cdecl _export 		MemoryReAlloc(HMEMORY ,lulong );
lubyte * cdecl _export 		MemoryLock(HMEMORY);
lbool cdecl _export 		MemoryUnlock(HMEMORY);
lulong cdecl _export 		MemorySize(HMEMORY);
lbool cdecl _export 		MemoryFree(HMEMORY);
lulong EXPENTRY _export MessageProc(HWND, HWND, HWND, lulong, lulong, lulong);

/* local routines */
void GetMacroFilePlusFunction(BYTE * dest,BYTE * src,int maxlen);
BOOL AnyWildcardsInName(BYTE *);
void hmemcpydown(BYTE huge * dst, BYTE huge * src, lulong cnt);

#define WIDTHBYTES(i)	((i+31)/32*4)		/* bitmap rounding equation */
lubyte NewCustomIcon[PATHLENGTH];

extern lulong MyDosReAllocMem(lulong hdl, lulong newsize);
extern void DeviceRectangle(HPS hps, lulong left, lulong bottom, lulong right, lulong top);

/* edit icon struct */
typedef struct tagEDITCUSTOMICON
{
	HWND 		DialogBox;
	HICONBAR 	DialogIconBar;
	LHANDLE 	hDIB;			// handle to the device independent bitmap
	POINTL 		ActualOffset;	// offset into static2 of the actual size bitmap
	POINTL		ZoomedOffset;	// offset into static3 of the fat bits bitmap
	POINTL 		ZoomedSize;		// offset into static3 of the fat bits bitmap
	int 		Scale;			// scale of Zoomed to Actual
	lulong 		LColor;		// the color currently selected for the left button
	lulong 		RColor;		// the color currently selected for the right button
	lulong 		*IconColors;	// list of colors in the icon
	int 		NumColors;
	BOOL 		CurrentDIBChanged;
	BOOL 		AnyChanges;
	CUSTOMICON 	LastCustomIcon;
	int 		LastCustom;
	BOOL 		*ColorsUsed;	// list of colors indexes 
	BOOL 		MButtonsSwapped;
} EDITCUSTOMICON;

// Function prototypes for all local routines.
LHANDLE CreateBorderLessDIB(HBITMAP);
LHANDLE DIBFromBitmap(HBITMAP,lulong,lushort);
lushort DIBPaletteSize(void *);
lushort DIBNumColors(void *);
void DrawActualBitmap(EDITCUSTOMICON *, HPS);
void DrawZoomedBitmap(EDITCUSTOMICON *, HPS);
void DrawIconFrame(HPS,POINTL,lushort,lushort,lushort);
void DrawMouseBitmap(HPS);
void DrawMouseButtons(EDITCUSTOMICON *, HPS, HWND);
BYTE GetColorIndex(LPBITMAPINFO_NEW, lulong, lulong *, lushort, BOOL *);
void SetColorIndex(LPBITMAPINFO_NEW, lulong, lushort, lulong *, BOOL *);
lulong * GetIconColors(LPBITMAPINFO_NEW, lushort);
void SetIconColors(LPBITMAPINFO_NEW, lushort, lulong);
void SetByte(LPBITMAPINFO_NEW, lulong *, lulong, lushort, lushort, lushort, BOOL *);
void SetNibble(LPBITMAPINFO_NEW, lulong *, lulong, lushort, lushort, lushort, BOOL *);
void SetBit(LPBITMAPINFO_NEW, lulong *, lulong, lushort, lushort, lushort);
void SetDWord(LPBITMAPINFO_NEW, lulong, lushort, lushort);
MRESULT EXPENTRY IconControlProc(HWND, lulong, MPARAM, MPARAM);
lushort WhichPixelClicked(EDITCUSTOMICON *, HWND, lushort, lushort, lushort);
void IconEditDestroy(EDITCUSTOMICON *);
void IconEditInit(EDITCUSTOMICON *TmpPtr,HWND hDlg, LHANDLE hDIB);

class CListItem;
typedef CListItem *pCListItem;

class CListHead
{
	private:
		static	pCListItem	cFirstListItem;

	public:
		static void				AddListItem( pCListItem );
		static void				RemoveListItem( pCListItem );
		static pCListItem		GetListItem( LHANDLE );
};

class CListItem
{
	private:
		pCListItem		cNextListItem;
		LHANDLE			cTask;

	public:
						CListItem(void);
						~CListItem(void);
		LHANDLE			GetTask( void );
		void			SetNextListItem(pCListItem);
		pCListItem		GetNextListItem(void );
};

inline CListItem::CListItem()
{
	cTask = 0;
	cNextListItem = LNULL;
	CListHead::AddListItem(this);
}

inline CListItem::~CListItem()
{
	CListHead::RemoveListItem(this);
}

inline void
CListItem::SetNextListItem(pCListItem NewListItem)
{
	cNextListItem = NewListItem;
}

inline LHANDLE
CListItem::GetTask()
{
	return cTask;
}

inline pCListItem
CListItem::GetNextListItem()
{
	return cNextListItem;
}

// Abstract class for all app windows
class Window
{
protected:
    HWND hWndFrame;
    HWND hWndClient;
public:
    // Provide (read) access to the windows Client or Frame
    // handles in case they're needed.
    HWND GetFrameHandle(void) { return hWndFrame; }
    HWND GetClient(void) { return hWndClient; }
	lbool Show(void) { return WinShowWindow(hWndFrame, TRUE); }
	void Update( void ) { WinUpdateWindow( hWndFrame ); }

    // Pure virtual function makes "Window" an abstract class
    virtual MRESULT WndProc(HWND hWnd, ULONG iMessage, MPARAM mParam1, MPARAM mParam2 ) = 0;
};


// Class main is a container of program global functions and variables
class Main
{
public:
    static HAB      hab;
    static HMQ      hmq;
    static char *szHi;
    static char *szHello;
    static HPOINTER icon[4];
    static Window   *tempthis;          // Used to hold the "this" pointer
                                        // that _export WndProc uses to vector
                                        // to the correct member function
                                        // WndProc

    // Standard PM Initilization sequence
    static BOOL Initialize(void) {
        if ((hab = WinInitialize(NULL)) == (HAB)NULL) return FALSE;
		Hab = hab;
        if ((hmq = WinCreateMsgQueue(NULL,0)) == (HMQ)NULL) return FALSE;
        	return TRUE;
    }

    static BOOL MessageLoop(void);

    // Standard PM Termination sequence
    static void Terminate(void) {
        WinDestroyMsgQueue( hmq );
         WinTerminate( hab );    
    }
};

// Declare and initialize all globals in Main
HAB Main::hab;
HMQ Main::hmq;
Window *Main::tempthis = NULL;
HPOINTER Main::icon[4];
char *Main::szHi = "ICON BAR";
char *Main::szHello = "This is the icon bar test jig for OS/2";


// Standard PM Message Loop
BOOL Main::MessageLoop(void) {
    BOOL rc;
    QMSG qmsg;
    while((rc = (BOOL)WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))!=FALSE)
        WinDispatchMsg(hab,&qmsg);
    return rc;
}

void GetStubPath(lubyte far *);
void GetFileNameInfo(BYTE * dest,BYTE * src,int type);
void SetFileExtension(BYTE * filename, BYTE * extension);
lbool ComputeFullPathName(HWND hdlg, BYTE * filepath);
void SetPointer( HWND hWnd, Window *pWindow );
Window *GetPointer( HWND hWnd );

class MainWindow : public Window, public CListItem
{
private:
    static char szClassName[14];
    static BOOL initialized;
	LHANDLE			IconManLibrary;			// Handle to library.
	HMANAGER 		IconManager;			// IconBar Manager.
	lubyte			IconSize;				// Current Size of icons.
	HICONBAR 		IconBar[8];			/* set our max to 8 */
	lubyte 			NumIconBars;		/* set our max to 8 */
	lubyte			IconFlags;
	lubyte			NumDialogBoxes;
	lushort			DialogBoxID[4];
	EDITCUSTOMICON	*TmpPtr;
	lushort			cCurrentIconBar;
public:
	void 		PaintOneLineHelp(lubyte *String);
	void 		InvalidateOneLineHelp( void );
	void 		Paint( void );
inline 	lubyte 		GetIconSize( void ) { return IconSize; };
	void 		SelectConfigurationFile( void );
	HMANAGER	GetIconMan( void );
	void 		SetIconMan( HWND );
	HICONBAR	GetIconBar( void );
	void 		SetIconBar( HICONBAR );
	void		CreateIconBar( void );
	void		ChangeIcon(lushort );
	lbool		EditIcon( LPCUSTOMICON);
	void		EndEditIcon( HWND );
	void		SelectionChange(void);
	void		DeselectIcon(char *);
	void		TurnOnForce(void);
	void		TurnOffForce(void);
	lbool		IsForceOn(void);
	void		NewCopy(void);
	void		IncrementDialogBoxes(lushort);
	void		DecrementDialogBoxes(void);
	lbool		AnyDialogBoxes(void);
	lbool		ChangeIconSize(lubyte);
	void		EnableAllWindows(lbool);
	void		DestroyIconManager(void);
	void		CheckIcons(void);
	void		SendMenuItem(lushort);
	void		SendMacro(BYTE *);
	EDITCUSTOMICON *GetTmpPtr(void);
	lsbyte		GetIconBarIndex(HICONBAR);
	void		SetRect(HICONBAR,PRECTL);
	void		SetCurrentIconBar(lushort );
	void 		MakeDialogIconBar(HWND hDlg,LPCUSTOMICON Custom );
	lbool 		SaveMacroToIcon(BYTE * filepath);
	lbool 		CreateNewIcon(HWND ,int ,BOOL ,LHANDLE );
	void 		GetDefaultCustomPath(BYTE * );
	void 		AddMacroPathToMacro(BYTE * );
	void 		SetIconSize(BYTE );
	lbool 		GetLastPosition(void );
	lbool 		GetLastRect(lrect * prect);
	BYTE 		GetLastIconSize(void);
	void 		SetLastRect(void);
	void 		SetLastPosition(void);
	void 		SetLastIconSize(void);
	lbool 		SaveDescription(void);
	void 		CopyClipboard(HWND );
	void 		SaveCustomBits(void);
	void 		SaveCustomIconSelection(void);
	void		EndStub();

    // Unlike Windows, in PM window class registration always
    // should happen within the app before the first time a
    // window is created. "initialized" keeps track of this
    // The first class Register (and thus the first creation of a
    // Mainwindow instance) must happen AFTER Main::Initialize()
    // has been called.
    static void Register(void)
    {
        if (!WinRegisterClass(
            Main::hab,
            szClassName,
            ::WndProc,              // use _export WndProc
                                    // which will vector the
                                    // call to MainWindow::WndProc
            CS_SIZEREDRAW,
            sizeof(Window *)        // Allocate space for the "this"
                                    // pointer after the end of the
                                    // window record PM creates.
                                    // This is used to vector to
                                    // MainWindow::WndProc
            )) 
                AbortStub(NULL,NULL);
        initialized = TRUE;
    }
    MainWindow(void)
    {
		lubyte Path[120];
		lubyte PathName[120];
		LHANDLE Task;
		CHAR	LoadError[100];
		HMODULE	hLib;
		FP_INIT_DLL	lpInitTerm;
		HWND	tempwnd = 5;
		LONG	error;
		lulong	Offset;
		lulong	pResource;
		APIRET	rc;
		LONG	color;

		IconFlags = 0;
		NumDialogBoxes = 0;
		NumIconBars = 0;
		cCurrentIconBar = 0;

        if (initialized == FALSE) Register();
        ULONG flCreate = FCF_STANDARD & // Set frame control flags
             ~FCF_SHELLPOSITION;

        Main::tempthis = this;          // Stuff "this" pointer in global
                                        // for use by _export WndProc
                                        // _export WndProc is called
                                        // directly as a result of
                                        // WndCreateStdWindow and will
                                        // shove this in the PM window
                                        // record and use it to vector to
                                        // MainWindow::WndProc

		if (HWND(NULL) == (hWndFrame = WinCreateStdWindow(HWND_DESKTOP, 
			0, &flCreate, szClassName, szClassName, 0, (HMODULE)NULL, 
			ID_WINDOW, &hWndClient))) 
				AbortStub(hWndFrame, hWndClient);

        // Set title bar fo window
        WinSetWindowText(hWndFrame, "Icon Bar Test Jig");

        if (!WinSetWindowPos( hWndFrame,
                       HWND_TOP,            // window at position 20, 100,
                       20, 100, 600, 300,   // and size 600, 300.
                       // Flags set to show and activate frame window
                       SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW
                     ))
        AbortStub(hWndFrame, hWndClient); /* Terminate the application    */

		/* get the path to this exe. */
		GetStubPath(Path);

		/* add the name of the icon dll to the path. */
		strcpy(PathName,Path);
		strcat(PathName,"ltsicn03.dll");

		/* load the icon dll */
		if (DosLoadModule((PSZ)LoadError,sizeof(LoadError), 
				(PSZ)PathName, &hLib))
			return;

		// call DLL to do initialization. You MUST do this.
		if (!(DosQueryProcAddr(hLib, (ULONG)1, (PSZ)"InitTermDLL", 
				(PFN *)&lpInitTerm)))
			lpInitTerm(hLib, 0);

		/* Create IconManager */
		SetIconMan(IconBarCreateManager(hWndClient,Main::hab));
		color = CLR_DARKGRAY;
		WinSetPresParam(GetIconMan(), PP_BACKGROUNDCOLORINDEX, 
			(ULONG)sizeof(color), (PVOID)&color);

		if (GetIconMan() == LNULL)
			return;

		/* set the callbacks for the icon manager. */
		IconProc.MemoryAlloc = (FARALLOCPROC)MemoryAlloc;
		IconProc.MemoryReAlloc = (FARREALLOCPROC)MemoryReAlloc;
		IconProc.MemoryLock = (FARLOCKPROC)MemoryLock;
		IconProc.MemoryUnlock = (FARUNLOCKPROC)MemoryUnlock;
		IconProc.MemorySize = (FARSIZEPROC)MemorySize;
		IconProc.MemoryFree = (FARFREEPROC)MemoryFree;
		IconProc.MessageProc = (FARMESSAGEPROC)MessageProc;

		IconBarSetProcs(IconManager,(LPICONPROC)&IconProc);

		/* tell the icon manager what path to find the custom graphics */
		GetDefaultCustomPath(PathName);

		/* set path to find custom bitmaps */
		IconBarSetCustomPath(IconManager,PathName);

		// Normally, the .tbl file and the default.smi file
		// must be located in the same path. If you want these
		// files to be in different paths, use the code below.
		// Reason for different paths: You may have a set up where
		// the default.smi is shared on a network and is therefore, read-
		// only. The .tbl MUST be written to, so it must always be in
		// a location with write privilidges.  If you will never have
		// a condition where the default.smi is read-only, these two
		// files may be in the same path.

#define SEPARATEPATHS
#ifdef SEPARATEPATHS
		/* set file to find iconstub.tbl (could be any file name ) */
		/* default.smi should also be at this directory */

		// default.smi (could be system-wide, read-only)
		SetDefaultSMIFile(IconManager, Path);	

		strcpy(PathName,Path);
		strcat(PathName, "ICONS\\");
		strcat(PathName,"iconstub.tbl");
		SetDefaultFile(IconManager, PathName);
#else
		strcpy(PathName,Path);
		strcat(PathName,"iconstub.tbl");
		IconBarSetDefaultFile(IconManager,PathName);
#endif

		/* tell the iconmanager where to find the .smi files. */
		strcpy(PathName,Path);
		strcat(PathName,"ICONS");
		IconBarSetConfigPath(IconManager,REG_AMIPRO,PathName);
    }

    // Destory window when object goes out of scope
    MRESULT WndProc(HWND hWnd,ULONG iMessage,MPARAM mParam1,MPARAM mParam2);
    ~MainWindow(void){
        WinDestroyWindow(hWndFrame);
    }
};

// Must be unique in the app
char MainWindow::szClassName[14] = "Host IconStub";  
BOOL MainWindow::initialized = FALSE;

// main entry point
void cdecl main()
{
    // Initialize PM first
    if (Main::Initialize() == FALSE)
        AbortStub((HWND)NULL,(HWND)NULL);

    {
        MainWindow MainWnd; // Set up new scope and create an instance
                            // of MainWindow, which causes it to
                            // Register the class and Create the
                            // main window.  When MainWnd goes out
                            // of scope, the destructor will be called
                            // which cleans up with WinDestroyWindow
		WinRegisterClass(Main::hab, (PSZ)"stubiconctrl", 
			(PFNWP)IconControlProc, CS_SIZEREDRAW, (USHORT)0);
        Main::MessageLoop();
    }
    Main::Terminate();
}


// AbortStub -- report an error returned from an API service.
VOID AbortStub(HWND hwndFrame,HWND hwndClient)
{
PERRINFO  pErrInfoBlk;
PSZ       pszOffSet;
void      stdprint(void);
PSZ  pszErrMsg;

      DosBeep(100,10);
      if ((pErrInfoBlk = WinGetErrorInfo(Main::hab)) != NULL)
      {
        pszOffSet = ((PSZ)pErrInfoBlk) + pErrInfoBlk->offaoffszMsg;
        pszErrMsg = ((PSZ)pErrInfoBlk) + *((PSHORT)pszOffSet);
        if (hwndFrame && hwndClient)
            WinMessageBox(HWND_DESKTOP,      // Parent window is desk top
                       hwndFrame,            // Owner window is our frame
                       (PSZ)pszErrMsg,       // PMWIN Error message
                       "Error Msg",          // Title bar message
                       MSGBOXID,             // Message identifier
                       MB_MOVEABLE | MB_CUACRITICAL | MB_CANCEL ); // Flags
        else
            WinMessageBox(HWND_DESKTOP,      // Parent window is desk top
                       HWND_DESKTOP,         // Owner window is desktop
                       (PSZ)pszErrMsg,       // PMWIN Error message
                       "Error Msg",          // Title bar message
                       MSGBOXID,             // Message identifier
                       MB_MOVEABLE | MB_CUACRITICAL | MB_CANCEL ); // Flags
        WinFreeErrorInfo(pErrInfoBlk);
      }
      WinPostMsg(hwndClient, WM_QUIT, (ULONG)0, (ULONG)0);
}


void
MainWindow::CreateIconBar()
{
	lubyte StrBuffer[40];
	lubyte Output[40];
	HWND NewIconBar;
	HWND hMenu;
	HINI	hini;

	if (NumIconBars == 8)
		return;

	hMenu = WinWindowFromID(WinQueryWindow(hWndClient, QW_PARENT), 
		(USHORT)FID_MENU);

	/* let the user know he can configure a IconBar */
	if (hMenu)
	{
		WinEnableMenuItem(hMenu, MF_CONFIGURE, TRUE);
		WinEnableMenuItem(hMenu, MF_SELECT, TRUE);
	}

	/* create icon bar */
	SetCurrentIconBar(NumIconBars);

	TurnOnForce(); /* we are about to force a IMM_BARSIZED */
	NumIconBars++;
	NewIconBar = IconBarCreate(GetIconMan(),hWndClient);
	SetIconBar(NewIconBar);

	TurnOffForce();	 /* done */

	/* see if we saved a Configuration description for this IconBar */
	/* if not use, Default */
	strcpy(Output,"IconSet");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
	PrfQueryProfileString(hini, (lfpbyte)"SmartIcons", 
		(lfpbyte)Output, (lfpbyte)"Default", (lfpbyte)StrBuffer, 
		sizeof(StrBuffer));
	PrfCloseProfile(hini);

	if (IconBarSelectConfigByDesc(GetIconMan(),StrBuffer))
		IconBarLoadConfig(GetIconMan(), NewIconBar);

	/* make sure the icons are in the right state */
	CheckIcons();

	/* iconbars are initially hidden. */
	IconBarShow(GetIconMan(), NewIconBar);
	IconBarPaint(GetIconMan(), NewIconBar);

	/* show on the menu we have another IconBar */
	hMenu = WinWindowFromID(WinQueryWindow(hWndClient, QW_PARENT), 
		(USHORT)FID_MENU);
	if (hMenu)
		WinEnableMenuItem(hMenu,MF_ICONBAR1 + NumIconBars - 1,TRUE);
}

/* find the matching index to this IconBar */
lsbyte		
MainWindow::GetIconBarIndex(HICONBAR TestIconBar)
{
	lubyte i =0;

	while (i < NumIconBars)
	{
		if (IconBar[i] == TestIconBar)
			return i;
		i++;
	}
	return -1;
}

/* see where we should set this IconBar */
void 
MainWindow::SetRect(HICONBAR TestIconBar,PRECTL Rect)
{
	lsbyte i = GetIconBarIndex(TestIconBar);
	lsbyte j;
	RECTL IRect;
	lrect	rect;

	if (i == -1)
		i = NumIconBars - 1;

	j = 0;
	while (j < i)
	{
		IconBarGetPosition(GetIconMan(), IconBar[j],&rect);
		// Note: this is returned in "Windows" type coords - so
		// switch them
		IRect.xLeft = (LONG)rect.left;
		IRect.yBottom = (LONG)rect.top;
		IRect.xRight = (LONG)rect.right;
		IRect.yTop = (LONG)rect.bottom;
		switch (IconBarGetPositionType(GetIconMan(), IconBar[j]))
		{
			case IBP_LEFT:
				Rect->xLeft += IRect.xRight - IRect.xLeft;
				break;
			case IBP_TOP:
				Rect->yTop += IRect.yTop - IRect.yBottom;
				break;
			case IBP_RIGHT:
				Rect->xRight -= IRect.xRight - IRect.xLeft;
				break;
			case IBP_BOTTOM:
				Rect->yBottom -= IRect.yTop - IRect.yBottom;
				break;
		}
		j++;
	}
}


/* PAINT routine */
void MainWindow::Paint( void )
{
    RECTL rect;
	HPS	hps;

	hps = WinBeginPaint(hWndClient, NULL, &rect);
	WinEndPaint(hps);
}

// MainWindow object window procedure
MRESULT MainWindow::WndProc(HWND hWnd,ULONG iMessage,MPARAM mParam1,
    MPARAM mParam2 )
{
	MRESULT	rc;
	APIRET	rc2;

    switch( iMessage )
    {
      case WM_CREATE:
        break;

      case WM_COMMAND:
        {
        USHORT command; 
        command = SHORT1FROMMP(mParam1);      // Extract the command value
        switch (command)
        {
			case MF_SELECT:
				SelectConfigurationFile();
				break;

			case MF_CREATE:
				CreateIconBar();
				break;

			case MF_CONFIGURE:
				if (GetIconBar())
					SendMenuItem(MV_CHGSIDEBAR);
				break;

			case MF_ICONBAR1:
			case MF_ICONBAR2:
			case MF_ICONBAR3:
			case MF_ICONBAR4:
			case MF_ICONBAR5:
			case MF_ICONBAR6:
			case MF_ICONBAR7:
			case MF_ICONBAR8:
				SetCurrentIconBar(command - MF_ICONBAR1);
				break;
          	case ID_EXITPROG:
          	  WinPostMsg( hWnd, WM_CLOSE, 0, 0 );
          	  break;
          	default:
          	  return WinDefWindowProc( hWnd, iMessage , mParam1, mParam2 );
        }
    
        break;
        }

	case WM_SETFOCUS:
		if (SHORT1FROMMP(mParam2))	
		{
			WinSetFocus(HWND_DESKTOP, hWnd);
			return (MRESULT)0;
		}
		else
        	return WinDefWindowProc( hWnd, iMessage , mParam1, mParam2 );

	  case WM_SIZE:
			/* need to tell the icon manager we changed size */
			if (GetIconMan() && GetIconBar())
			{
				TurnOnForce();	
				IconBarHostSizeChange(GetIconMan());
				TurnOffForce();	
			}
			break;

      case WM_ERASEBACKGROUND:
        return (MRESULT)( TRUE );

      case WM_PAINT:
		{
			// Window draw stuff here
			HPS    hps;
			RECTL  rc;

			hps = WinBeginPaint(hWnd, (HPS)NULL, &rc);
			WinFillRect(hps, &rc, CLR_WHITE);
			WinEndPaint(hps);
			return 0;
		}

      case WM_CLOSE:
		EndStub();
        // Do termination stuff and cleanup here
        WinPostMsg( hWnd, WM_QUIT, 0, 0 ); // Cause termination
        break;

      default:
          return WinDefWindowProc( hWnd, iMessage , mParam1, mParam2 );
      }
      return FALSE;
}

/* find the data pointer with for this hWnd */
Window *GetPointer(HWND hWnd)
{
	return (Window *) WinQueryWindowULong(hWnd, 0);
}

void SetPointer(HWND hWnd, Window *pWindow)
{
	WinSetWindowULong(hWnd, 0, (ULONG)pWindow);
}

MRESULT EXPENTRY _export WndProc(HWND hWnd,ULONG iMessage,
    MPARAM mParam1, MPARAM mParam2)
{
    // Pointer to the c++ window object
    Window *pWindow = (Window *)WinQueryWindowULong(hWnd,0);

    // The pointer pWindow will have an invalid value if the WM_CREATE
    // message has not yet been processed (we respond to the WM_CREATE
    // message by setting the extra bytes to be a pointer to the
    // (C++) object corresponding to the Window identified
    // by hWnd).  The messages that
    // precede WM_CREATE must be processed without using pWindow so we
    // pass them to WinDefWindowProc.

    if (pWindow == 0) 
	{
        if (iMessage == WM_CREATE) 
		{
            pWindow = Main::tempthis;
            WinSetWindowULong(hWnd,0,(ULONG)pWindow);
            return pWindow->WndProc(hWnd,iMessage,mParam1,mParam2);
        } 
		else
            return WinDefWindowProc(hWnd,iMessage,mParam1,mParam2);
    } 
	else
        return pWindow->WndProc(hWnd,iMessage,mParam1,mParam2);
}

/* CallBack for allocing memory */
HMEMORY cdecl _export
MemoryAlloc(lulong Size)
{
	HMEMORY	newhand;
	newhand = (HMEMORY)(lubyte *)new char[Size];
	return newhand;
}

/* CallBack for reallocing memory */
lulong cdecl _export
MemoryReAlloc(HMEMORY Handle,lulong Size)
{
	(void)Handle; (void)Size;
	// Not used right now
	return 1L;
}

/* CallBack for locking memory */
lubyte * cdecl _export
MemoryLock(HMEMORY Handle)
{
	return (lubyte *)Handle;
}

/* CallBack for unlocking memory */
lbool cdecl _export
MemoryUnlock(HMEMORY Handle)
{
	(void)Handle;
	return LTRUE;
}

/* CallBack for get memory size */
lulong cdecl _export
MemorySize(HMEMORY Handle)
{
	(void)Handle;
	// Not used right now.
	return 1L;
}

/* CallBack for freeing memory */
lbool cdecl _export
MemoryFree(HMEMORY Handle)
{
	delete (lubyte *)Handle;
	return LTRUE;
}

// Display a one-line description for the icon clicked on.
void 
MainWindow::PaintOneLineHelp(lubyte *String)
{
	RECTL rect;
	HPS	hps;
	POINTL	pt;
	HWND	frame, titlebar;

	frame = GetFrameHandle();
	titlebar = WinWindowFromID(frame, FID_TITLEBAR);
	WinQueryWindowRect(titlebar, (PRECTL)&rect);

	hps = WinGetClipPS(titlebar, NULL, PSF_CLIPSIBLINGS);
	// Change brush color to active caption text color
	WinFillRect(hps, (PRECTL)&rect, SYSCLR_ACTIVETITLE);
	pt.x = rect.xLeft + 3;
	pt.y = rect.yBottom + 5;
	GpiSetAttrMode(hps, AM_PRESERVE);
	GpiSetColor(hps, SYSCLR_ACTIVETITLETEXT);
	GpiCharStringPosAt(hps, &pt, &rect, CHS_CLIP, strlen(String),
			(PCH)String, (PLONG)0);
	GpiPop(hps, 1);
	WinReleasePS(hps);
}

void
MainWindow::InvalidateOneLineHelp()
{
	HWND	frame, titlebar;
	RECTL	rect;

	frame = GetFrameHandle();
	titlebar = WinWindowFromID(frame, FID_TITLEBAR);
	WinQueryWindowRect(titlebar, (PRECTL)&rect);
	WinInvalidateRect(titlebar, (PRECTL)&rect, TRUE);
}

void
MainWindow::SelectConfigurationFile()
{
	WinDlgBox(HWND_DESKTOP, GetFrameHandle(),
		SelectConfiguration, (HMODULE)NULL, DLG_SELECT,  
		(PVOID)this);
}

/* allows the user to choose a configuration file for IconBars */
MRESULT EXPENTRY _export 	
SelectConfiguration(HWND hDlg, lulong iMessage, MPARAM mp1, MPARAM mp2)
{
	static MainWindow *WndPtr;
	BYTE name[256];
	lubyte *ptr;
	HWND hCtl;
	lsshort index;
	lushort	wParam;
	HWND	hwnd;

	switch (iMessage)
	{
		case WM_INITDLG:		   

    		WndPtr = (MainWindow *)LONGFROMMP(mp2);
			hCtl = WinWindowFromID(hDlg,ID_LIST1);
			IconBarDeselectConfig(WndPtr->GetIconMan());
			/* get each class name */
			while (IconBarEnumConfig(WndPtr->GetIconMan()))
			{
				/* get the description and set it */
				if (ptr = (lubyte *)IconBarGetConfigDesc(WndPtr->GetIconMan()))
					WinSendMsg(hCtl,LM_INSERTITEM ,(MPARAM)LIT_END, 
							(MPARAM)ptr);
			}
			if (IconBarSelectLoadedConfig(WndPtr->GetIconMan(), 
				WndPtr->GetIconBar()) && 
				((ptr = IconBarGetConfigDesc(WndPtr->GetIconMan())) != NULL))
			{
				index = (lsshort)WinSendMsg(hCtl,LM_SEARCHSTRING, 
					MPFROM2SHORT(LSS_CASESENSITIVE | LSS_PREFIX, LIT_FIRST),
					(MPARAM)(lfpbyte)ptr);
				WinSendMsg(hCtl, LM_SELECTITEM, (MPARAM)index, (MPARAM)TRUE); 
			}
			return WinDefDlgProc(hDlg, iMessage, mp1, mp2);

		case WM_COMMAND:		      
			wParam = SHORT1FROMMP(mp1); 
         	switch(wParam) 
			{
				case ID_OK:
					WndPtr = (MainWindow *)WinQueryWindowULong
						(WinWindowFromID(WinQueryWindow(hDlg, QW_OWNER), 
						FID_CLIENT), 0);
					hCtl = WinWindowFromID(hDlg,ID_LIST1);
					/* get the newly selected index.	*/
					if (LIT_NONE != (index = 
						(lsshort)WinSendMsg(hCtl, LM_QUERYSELECTION, 
						(MPARAM)LIT_FIRST, (MPARAM)0L)))
					{
						WinSendMsg(hCtl,LM_QUERYITEMTEXT, 
							MPFROM2SHORT(index, 256),(MPARAM)(lfpbyte)name);
						IconBarSelectConfigByDesc(WndPtr->GetIconMan(),
								(lubyte far *)name);
						IconBarLoadConfig(WndPtr->GetIconMan(), 
								WndPtr->GetIconBar());
					}
					WinDismissDlg(hDlg, LTRUE);	      
					return (MRESULT)LTRUE;

				case ID_CANCEL:
					WinDismissDlg(hDlg, LFALSE);	      
					return (MRESULT)LTRUE;
			}
			break;

		default:
			return WinDefDlgProc(hDlg, iMessage, mp1, mp2);
	}
	return (MRESULT)LFALSE;			      
}


void
GetStubPath(lubyte *Path)
{
	lsshort i;

	ConstructExeFullDirectory(Path);
}

lbool 
MainWindow::EditIcon(LPCUSTOMICON lpCustom)
{
	(void)lpCustom;

	lbool retval;

	retval = EditIconProc(GetFrameHandle(), (lulong)lpCustom);
	return retval;
}

void
MainWindow::CheckIcons()
{
	/* set to the current modes */
	// NOTE: The following ids are used as icon id's in AmiPro.
	ChangeIcon(MV_SHOWPICTS);
	ChangeIcon(MV_SHOWMARKS);
	ChangeIcon(MV_COLGUIDEON);
	ChangeIcon(MV_MARGINSCOLORON); 
	ChangeIcon(MV_VERTRULERON);
	ChangeIcon(MV_SHOWNOTESOFF );
	ChangeIcon(MV_TABSRETON);
}

void
MainWindow::SendMenuItem(lushort MenuID)
{
	lubyte StrBuffer[120];
	lubyte StrBuffer2[120];
	lfpbyte macroptr;
	HPS hps;
	lbool retval;
	RECTL	rect;
	POINTL	pt;

	if (AnyDialogBoxes())
		return;

	// NOTE: The ids used below are used as icon id's in AmiPro.
	switch(MenuID)
	{
		case MV_NEXTICONSET:
			if (IconBarSelectLoadedConfig(GetIconMan(), GetIconBar()))
			{
				if (IconBarEnumConfig(GetIconMan()) == FALSE)
					IconBarEnumConfig(GetIconMan());
				IconBarLoadConfig(GetIconMan(), GetIconBar());
			}
			return;

		case MV_CHGSIDEBAR:
			retval = IconBarConfigure(GetIconMan(), GetIconBar());
			if (retval == TRUE)
			{
				CheckIcons();
				IconBarHostSizeChange(GetIconMan());
			}
			return ;

		default:
			if (MenuID = (lushort)IconBarGetIconActionID(GetIconMan()))
			{
				strcpy(StrBuffer,"Icon Let Up: MenuID =");
				itoa(MenuID,StrBuffer2,10);
				strcat(StrBuffer,StrBuffer2);
				strcat(StrBuffer,"                 ");
			}
			hps = WinGetPS(GetClient());
          	GpiSetBackMix(hps, BM_OVERPAINT );      // set text mix
			WinQueryWindowRect(GetClient(), &rect);
			pt.x = rect.xLeft;
			pt.y = (rect.yTop - 
				WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + 4);
			GpiCharStringAt(hps, &pt, strlen(StrBuffer), (PCH)StrBuffer);
			WinReleasePS(hps);
			return ;
	}
}

lbool 
MainWindow::ChangeIconSize(lubyte NewSize)
{
	lubyte OldSize;
	lubyte StrBuffer[PATHLENGTH];

	if (NewSize != GetIconSize())
	{
		GetStubPath(StrBuffer);
		OldSize = GetIconSize();
		switch(NewSize)
		{
			case IS_SUPERVGA:
				SetIconSize(NewSize);
				strcat(StrBuffer,"amiicn8.dll");
				if (!IconBarSetResource(GetIconMan(),StrBuffer,1))
				{
					SetIconSize(OldSize);
					return FALSE;
				}
				return LTRUE;

			case IS_VGA:
				SetIconSize(NewSize);
				strcat((lfpbyte)StrBuffer,(lfpbyte)"amiicnv.dll");

				if (!IconBarSetResource(GetIconMan(),StrBuffer,1))
				{
					SetIconSize(OldSize);
					return FALSE;
				}
				return LTRUE;

			default:
				return FALSE;
		}
	}
	return FALSE;
}

void 
MainWindow::SendMacro(BYTE * Macro)
{
	(void)Macro;
	POINTL	pt;
	RECTL	rect;
	HPS		hps;

	if (Macro[0] == NULL)
		return;

	if (AnyDialogBoxes())
		return ;

	if (Macro[1] != ':')
	{
		lsshort len;
		lubyte Buffer[PATHLENGTH];
	}
	hps = WinGetPS(GetClient());
	GpiSetBackMix(hps, BM_OVERPAINT );      // set text mix
	WinQueryWindowRect(GetClient(), &rect);
	pt.x = rect.xLeft;
	pt.y = (rect.yTop - 
		WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + 4);

	rect.yBottom = pt.y;
	WinFillRect(hps, &rect, CLR_WHITE);
	GpiCharStringAt(hps, &pt, strlen(Macro), (PCH)Macro);
	WinReleasePS(hps);
}

/* The purpose of this routine was to disable certain windows that are
 * children of the main window WHEN A DIALOG BOX IS DISPLAYED and TAKEN 
 * DOWN. This routine will need some work, if used.  If you call this 
 * from the commented sections above, then the main window will be enable, 
 * but the window that lies underneath the main window will be painted just 
 * before the main window gets the focus.  */
void 
MainWindow::EnableAllWindows(lbool Enable)
{
	if (GetIconBar())
	{
		lubyte i = 0;

		while (i < NumIconBars)
		{
			if (Enable)
				IconBarEnable(GetIconMan(), IconBar[i]);
			else
				IconBarDisable(GetIconMan(), IconBar[i]);
			i++;
		}
	}

	WinEnableWindow(GetFrameHandle(),Enable);

	if (Enable)
	{
		WinSetActiveWindow(HWND_DESKTOP, GetFrameHandle());
		WinSetFocus(HWND_DESKTOP, GetFrameHandle());
	}
}

void 
MainWindow::DestroyIconManager()
{
	HINI	hini;

	if (GetIconMan())
	{
		lfpbyte ptr;
		lushort i;

		for (i = 0; i < NumIconBars; i++)
		{
			SetCurrentIconBar(i);
			if (IconBarSelectLoadedConfig(GetIconMan(), GetIconBar())
				&& ((ptr = IconBarGetConfigDesc(GetIconMan())) != NULL))
			{
				BYTE Output[30];

				strcpy(Output,"IconSet");
				itoa(cCurrentIconBar,Output + strlen(Output),10);
				hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
				PrfWriteProfileString(hini, (lfpbyte)"SmartIcons", 
					(lfpbyte)Output, ptr);
				PrfCloseProfile(hini);
			}

			SetLastRect();
			SetLastPosition();
			SetLastIconSize();
		}

		IconManager = 0;
	}
}

void 
MainWindow::ChangeIcon(lushort MenuID)
{
	(void)MenuID;

	switch (MenuID)
	{
		case MV_HIDECLEANSCREEN:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWCLEANSCREEN,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDECLEANSCREEN
					,(MPARAM)LNULL);
			break;

		case MV_SHOWCLEANSCREEN:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDECLEANSCREEN,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWCLEANSCREEN,
						(MPARAM)LNULL);
			break;

		case MV_LAYOUT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_DRAFT,(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_LAYOUT,
						(MPARAM)LNULL);
			break;

		case MV_DRAFT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_LAYOUT,(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_DRAFT,
						(MPARAM)LNULL);
			break;

		case MV_FIT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_WORKING,(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_FIT,(MPARAM)LNULL);
			if (IconBarSelectStandardIcon(GetIconMan(),MV_100,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_FIT,(MPARAM)LNULL);
			if (IconBarSelectStandardIcon(GetIconMan(),MV_200,(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_FIT,(MPARAM)LNULL);
			break;

		case MV_WORKING:
		case MV_100:
		case MV_200:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_FIT,(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MenuID,(MPARAM)LNULL);
			break;

		case MV_HIDEPICTS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWPICTS,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDEPICTS,
					(MPARAM)LNULL);
			break;

		case MV_SHOWPICTS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDEPICTS,
					(MPARAM)LNULL)) 
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWPICTS,
						(MPARAM)LNULL);
			break;

		case MV_HIDEMARKS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWMARKS,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDEMARKS,
						(MPARAM)LNULL);
			break;

		case MV_SHOWMARKS:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDEMARKS,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWMARKS,
						(MPARAM)LNULL);
			break;

		case MV_TABRACK:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_HIDETABRACK,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_TABRACK,
						(MPARAM)LNULL);
			break;

		case MV_HIDETABRACK:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_TABRACK,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_HIDETABRACK,
						(MPARAM)LNULL);
			break;

		case MV_MARGINSCOLOROFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_MARGINSCOLORON,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),
						MV_MARGINSCOLOROFF,(MPARAM)LNULL);
			break;

		case MV_MARGINSCOLORON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_MARGINSCOLOROFF,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),
						MV_MARGINSCOLORON,(MPARAM)LNULL);
			break;

		case MV_VERTRULERON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_VERTRULEROFF,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_VERTRULERON,
						(MPARAM)LNULL);
			break;

		case MV_VERTRULEROFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_VERTRULERON,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_VERTRULEROFF,
						(MPARAM)LNULL);
			break;

		case MV_SHOWNOTESOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWNOTESON,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWNOTESOFF,
						(MPARAM)LNULL);
			break;

		case MV_SHOWNOTESON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_SHOWNOTESOFF,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_SHOWNOTESON,
						(MPARAM)LNULL);
			break;

		case MV_TABSRETOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_TABSRETON,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_TABSRETOFF,
						(MPARAM)LNULL);
			break;

		case MV_TABSRETON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_TABSRETOFF,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_TABSRETON,
						(MPARAM)LNULL);
			break;

		case ML_QUICKENDRECORD:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_QUICKREC,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_QUICKENDRECORD,
						(MPARAM)LNULL);
			break;

		case ML_QUICKREC:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_QUICKENDRECORD,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_QUICKREC,
						(MPARAM)LNULL);
			break;

		case ML_MACROENDRECORD:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_MACRORECORD,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_MACROENDRECORD,
						(MPARAM)LNULL);
			break;

		case ML_MACRORECORD:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_MACROENDRECORD,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_MACRORECORD,
						(MPARAM)LNULL);
			break;

		case MV_LAY2OUT:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_OUT2LAY,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_LAY2OUT,
						(MPARAM)LNULL);
			break;

		case MV_OUT2LAY:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_LAY2OUT,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_OUT2LAY,
						(MPARAM)LNULL);
			break;

		case MV_COLGUIDEON:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_COLGUIDEOFF,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_COLGUIDEON,
						(MPARAM)LNULL);
			break;

		case MV_COLGUIDEOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),MV_COLGUIDEON,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MV_COLGUIDEOFF,
						(MPARAM)LNULL);
			break;

		case MR_GROUPFRAMES:
			if (IconBarSelectStandardIcon(GetIconMan(),MR_UNGROUPFRAMES,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MR_GROUPFRAMES,
						(MPARAM)LNULL);
			break;

		case MR_UNGROUPFRAMES:
			if (IconBarSelectStandardIcon(GetIconMan(),MR_GROUPFRAMES,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),MR_UNGROUPFRAMES,
						(MPARAM)LNULL);
			break;

		case ML_REVMARKING:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_REVMARKINGOFF,
					(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_REVMARKING,
						(MPARAM)LNULL);
			break;

		case ML_REVMARKINGOFF:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_REVMARKING,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_REVMARKINGOFF,
						(MPARAM)LNULL);
			break;

		case ML_FIELDHIDE:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_FIELDTOG,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_FIELDHIDE,
						(MPARAM)LNULL);
			break;

		case ML_FIELDTOG:
			if (IconBarSelectStandardIcon(GetIconMan(),ML_FIELDHIDE,
						(MPARAM)LNULL))
				IconBarChangeToStandardIcon(GetIconMan(),ML_FIELDTOG,
						(MPARAM)LNULL);
			break;
	}
}

pCListItem CListHead::cFirstListItem = LNULL;

void
CListHead::AddListItem( pCListItem NewListItem)
{
	if (cFirstListItem == LNULL)
	{
		cFirstListItem = NewListItem;
		return;
	}

	NewListItem->SetNextListItem(cFirstListItem);
	cFirstListItem = NewListItem;
}

void
CListHead::RemoveListItem( pCListItem OldListItem)
{
	if (cFirstListItem == OldListItem)
	{
		cFirstListItem = OldListItem->GetNextListItem();
		return;
	}

	pCListItem ListPtr = cFirstListItem,BeforePtr = LNULL;

	while (ListPtr)
	{
		if (ListPtr == OldListItem)
		{
			BeforePtr->SetNextListItem(OldListItem->GetNextListItem());
			return;
		}
		BeforePtr = ListPtr;
		ListPtr = ListPtr->GetNextListItem();
	}
}

pCListItem
CListHead::GetListItem( LHANDLE Task)
{
	pCListItem ListPtr = cFirstListItem;
	return ListPtr;
}

lbool EditIconProc(HWND hOwner, lulong lpCustom)
{
	FILEDLG FileStruc;

	memset(&FileStruc, 0, sizeof(FILEDLG));
	FileStruc.cbSize = sizeof(FILEDLG);
	FileStruc.fl = FDS_CUSTOM | FDS_OPEN_DIALOG;
	FileStruc.pfnDlgProc = EditIconDlg;
	FileStruc.hMod = NULLHANDLE;
	FileStruc.usDlgId = DLG_EDITICON;
	FileStruc.x = 59;
	FileStruc.y = 6;
	FileStruc.szFullFile[0] = '*';
	FileStruc.szFullFile[1] = '.';
	FileStruc.szFullFile[2] = 's';
	FileStruc.szFullFile[3] = 'm';
	FileStruc.szFullFile[4] = 'm';
	FileStruc.szFullFile[5] = '\0';
	FileStruc.ulUser = lpCustom;
	WinFileDlg(HWND_DESKTOP, hOwner, &FileStruc);
	return FileStruc.ulUser;
}

MRESULT EXPENTRY _export
EditIconDlg(HWND hDlg, lulong iMessage, MPARAM mp1, MPARAM mp2)
{
	BYTE Path[PATHLENGTH];
	BYTE description[LEN_HELP];
	lulong color;
	EDITCUSTOMICON *TmpPtr;
	RECTL rect;
	MainWindow *pWindow;
	lulong	lParam;
	lsshort	wParam;
	PFILEDLG pFileStruc;

	wParam = SHORT1FROMMP(mp1); 
	lParam = LONGFROMMP(mp2);
	switch (iMessage)
	{
		case WM_INITDLG:		   
			WinSetSysModalWindow(HWND_DESKTOP, hDlg);
			pFileStruc=(PFILEDLG)WinQueryWindowULong(hDlg, QWL_USER);
			lParam = pFileStruc->ulUser;
			// description field
			WinSendDlgItemMsg(hDlg,ID_EDIT2,EM_SETTEXTLIMIT,
				(MPARAM)(LEN_HELP-1),(MPARAM)0);

			pWindow = (MainWindow *)WinQueryWindowULong
				(WinWindowFromID(WinQueryWindow(hDlg, QW_OWNER),FID_CLIENT), 0);
			pWindow->MakeDialogIconBar(hDlg,(LPCUSTOMICON)lParam);
			WinSetPresParam(WinWindowFromID(hDlg, ID_EDIT2), PP_FONTNAMESIZE, 
					(ULONG)(strlen("8.Helv") + 1), (PVOID)"8.Helv");
			WinSetPresParam(WinWindowFromID(hDlg, ID_STATIC5), PP_FONTNAMESIZE, 
					(ULONG)(strlen("8.Helv") + 1), (PVOID)"8.Helv");
			WinSetPresParam(WinWindowFromID(hDlg, ID_STATIC6), PP_FONTNAMESIZE, 
					(ULONG)(strlen("8.Helv") + 1), (PVOID)"8.Helv");
			TmpPtr = pWindow->GetTmpPtr();
			TmpPtr->RColor = CLR_BLACK;
			TmpPtr->LColor = CLR_WHITE;
			break;

		case WM_CONTROL:		      
			// must get the OWNER for a dbox (returns frame handle)
			// the client handle has the this pointer though
			pWindow = (MainWindow *)GetPointer(WinWindowFromID(
				WinQueryWindow(hDlg, QW_OWNER), FID_CLIENT));
			TmpPtr = pWindow->GetTmpPtr();
			switch(wParam)
			{
				case DID_FILENAME_ED:
					CHAR	filename[PATHLENGTH];
					if (SHORT2FROMMP(mp1) == EN_CHANGE)
					{
						WinQueryDlgItemText(hDlg, DID_FILENAME_ED, 
							(lulong)PATHLENGTH - 9, (PSZ)filename);
						if (!(filename[0]))
							WinSetDlgItemText(hDlg, DID_FILENAME_ED, "*.smm");
					}
					return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);
		
				case DID_DIRECTORY_LB:
					// If change dir, update search type in filename field
					if (SHORT2FROMMP(mp1) == LN_ENTER)	// dbl-clicked
						WinSetDlgItemText(hDlg, DID_FILENAME_ED, "*.smm");
					return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);

			}
			return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);

		case WM_COMMAND:		      
			pWindow = (MainWindow *)GetPointer(WinWindowFromID(
				WinQueryWindow(hDlg, QW_OWNER), FID_CLIENT));
			TmpPtr = pWindow->GetTmpPtr();
			switch(wParam)
			{
				case DID_OK_PB:
					CHAR	FullPath[PATHLENGTH];
					CHAR	filename[PATHLENGTH];

					// We sent this msg to ourself for a special case -
					// to force the file dlg manager to acknowledge a 
					// change directory
					if (lParam == 200)	// flag to notify special processing
					{
						lParam = 0;		// restore 
						return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);
					}

					pFileStruc=(PFILEDLG)WinQueryWindowULong(hDlg, QWL_USER);
					strcpy(FullPath, pFileStruc->szFullFile);
					WinQueryDlgItemText(hDlg, DID_FILENAME_ED, 
						(lulong)PATHLENGTH - 9, (PSZ)filename);
					strcat(FullPath, filename);

					// We sent this message to ourself so that the
					// szFullFile name will be filled in
					// Actually,it only contains drive+dir, we must add
					// on the filename
					if (lParam == 100)		// flag to notify spec process
					{
						pWindow->DeselectIcon((char *)FullPath);
						return (MRESULT)FALSE;
					}

					pWindow->DeselectIcon((char *)FullPath);

					// Since this OK button belongs to the file dlg
					// manager, it will NOT dismiss the box unless the 
					// filename field has a valid name.  We don't care if
					// the user didn't pick a macro name.  They may not want
					// one right now.

					// We have already extracted and saved the file info
					// Stuff the filename field with a name so that the
					// manager will not try to process it - like changing
					// dir or something (ex. if c:\xxxx\ was entered)
					WinQueryDlgItemText(hDlg, DID_FILENAME_ED, 
						(lulong)PATHLENGTH - 9, (PSZ)filename);
					strcpy(filename, pFileStruc->szFullFile);
					strcat(filename, "junk");
					WinSetDlgItemText(TmpPtr->DialogBox, 
						DID_FILENAME_ED, (lfpbyte)filename);

					IconBarDestroy(pWindow->GetIconMan(), 
						TmpPtr->DialogIconBar);
					pFileStruc->ulUser = TmpPtr->AnyChanges;
					DosFreeMem((PPVOID)TmpPtr);
					// don't call WinDismissDlg - the def proc handles it
					return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);

				case DID_CANCEL_PB:
					IconBarDestroy(pWindow->GetIconMan(), 
						TmpPtr->DialogIconBar);
					IconEditDestroy(TmpPtr);
					pFileStruc=(PFILEDLG)WinQueryWindowULong(hDlg, QWL_USER);
					pFileStruc->ulUser = TmpPtr->AnyChanges;
					DosFreeMem((PPVOID)TmpPtr);
					// don't call WinDismissDlg - the def proc handles it
					return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);

				case ID_PUSH1:	// New Icon
					if (pWindow->CreateNewIcon(hDlg,0,FALSE,NULL) == FALSE)
						IconBarSelectCustomIcon(pWindow->GetIconMan(),
								&TmpPtr->LastCustomIcon);
					break;

				case ID_PUSH2:	// Save As
					if (pWindow->CreateNewIcon(hDlg,0,FALSE,TmpPtr->hDIB) 
							== FALSE)
						IconBarSelectCustomIcon(pWindow->GetIconMan(),
								&TmpPtr->LastCustomIcon);
					break;
			
				default:
					return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);
			}
			break;

		case WM_CHAR:
			// Shift+Ins will paste a bitmap from the clipboard
			if ((wParam & KC_KEYUP) && (wParam & KC_SHIFT)
				&& (wParam & KC_VIRTUALKEY) 
				&& (SHORT2FROMMP(mp2) == VK_INSERT))
			{
				pWindow = (MainWindow *)GetPointer(WinWindowFromID(
					WinQueryWindow(hDlg, QW_OWNER), FID_CLIENT));
				pWindow->CopyClipboard(hDlg);
			}
			return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);

		default:
			return WinDefFileDlgProc(hDlg, iMessage, mp1, mp2);
	}
	return (MRESULT)FALSE;
}

void 
MainWindow::MakeDialogIconBar(HWND hDlg,LPCUSTOMICON Custom )
{
	RECTL Rect;
	lrect	rect;

	(EDITCUSTOMICON *)DosAllocMem((PPVOID)&TmpPtr, sizeof(EDITCUSTOMICON), 
		PAG_COMMIT|PAG_WRITE|PAG_READ);
	TmpPtr->hDIB = NULL;
	TmpPtr->IconColors = NULL;
	TmpPtr->ColorsUsed = NULL;
	TmpPtr->DialogBox = hDlg;
	TmpPtr->AnyChanges = FALSE;

	TmpPtr->DialogIconBar = IconBarCreate(GetIconMan(),hDlg);

	IconBarMakeDialogIconBar(GetIconMan(), TmpPtr->DialogIconBar);

	IconBarDeselectIcon(GetIconMan());

	TmpPtr->LastCustom = 0;

	while (IconBarEnumIcons(GetIconMan()))
	{
		if (!(IconBarGetIconState(GetIconMan()) & ICS_NOTAVAILABLE)
				&& (IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
		{
			TmpPtr->LastCustom++;
			IconBarAddIcon(GetIconMan(), TmpPtr->DialogIconBar,-1);
		}
	}

	IconBarDeselectIcon(GetIconMan());

	while (IconBarEnumIcons(GetIconMan()))
	{
		if (!(IconBarGetIconState(GetIconMan()) & ICS_NOTAVAILABLE)
				&& !(IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
			IconBarAddIcon(GetIconMan(), TmpPtr->DialogIconBar,-1);
	}

	if (Custom)
		IconBarShowCustomIcon(GetIconMan(), TmpPtr->DialogIconBar,Custom);

	WinQueryWindowRect(WinWindowFromID(hDlg,ID_STATIC1),&Rect);

	WinMapWindowPoints(WinWindowFromID(hDlg, ID_STATIC1), hDlg, 
			(PPOINTL)&Rect, 2);
	rect.left = (lsshort)Rect.xLeft;
	rect.top = (lsshort)Rect.yBottom;
	rect.right = (lsshort)Rect.xRight;
	rect.bottom = (lsshort)Rect.yTop;	

	IconBarSetPosition(GetIconMan(), TmpPtr->DialogIconBar,&rect);
	IconBarSetSize(GetIconMan(), TmpPtr->DialogIconBar,&rect);

	IconBarShow(GetIconMan(), TmpPtr->DialogIconBar);
	IconBarPaint(GetIconMan(), TmpPtr->DialogIconBar);
}

void
MainWindow::DeselectIcon(char * filename)
{
	BYTE buffer[PATHLENGTH];
	BYTE Path[PATHLENGTH];
	PFILEDLG pFileStruc;

	strcpy(Path, filename);

	IconBarSelectChosenIcon(GetIconMan(),TmpPtr->DialogIconBar);
	if (!(IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
		return;
	SaveCustomBits();
	IconEditDestroy(TmpPtr);

	// if any wildcards in the filename, write out as null string
	// if only a path exists, and no filename, write out as null string
	GetFileNameInfo(buffer,Path,GFI_FILENAME);
	if (AnyWildcardsInName(buffer) || (buffer[0] == NULL))
		Path[0] = '\0';

	// save macro name
	// need to save it even if filename field is empty - in case the name
	// used to exist and has been deleted
	IconBarSetMacro(GetIconMan(),Path);

	SaveDescription();
	TmpPtr->AnyChanges = TRUE;
}

void 
MainWindow::SelectionChange()
{
	BYTE macro[PATHLENGTH];
	BYTE description[LEN_HELP];
	BYTE path[PATHLENGTH];
	BYTE filename[PATHLENGTH];
	HBITMAP hBitmap;
	lsshort	index;
	PFILEDLG pFileStruc;

	IconBarSelectChosenIcon(GetIconMan(), TmpPtr->DialogIconBar);

	if (!(IconBarGetIconState(GetIconMan()) & ICS_CUSTOM))
	{
		if (!CreateNewIcon(TmpPtr->DialogBox,
				(lsshort)IconBarGetIconActionID(GetIconMan()),
				TRUE, NULL))
			IconBarShowCustomIcon(GetIconMan(), TmpPtr->DialogIconBar,
				&TmpPtr->LastCustomIcon);
		return;
	}

	// get name of the macro associated with this icon
	strcpy(macro,IconBarGetMacro(GetIconMan()));
	strlwr(macro);
	if (macro[0] != NULL)
	{
		// check if no drive in path, if none, insert exepath\macros\macro
		AddMacroPathToMacro(macro);

		// strip down to drive+directory 
		GetFileNameInfo(path,macro,GFI_DIRPATH);

		/* sub the 7 to give a cushion for checking for directory */
		// isolate the macro name + function name, put into filename
		// (function name may\may not be present)
		GetMacroFilePlusFunction(filename,macro,PATHLENGTH - strlen(path) - 7);
	}
	else
	{
		// no macro name exists
		// get the default drive+dir
		AddMacroPathToMacro(macro);
		

		strcpy(path,macro);
		strlwr(path);
		macro[0] = 0;
		filename[0] = 0;
		WinSetDlgItemText(TmpPtr->DialogBox, DID_FILENAME_ED, (lfpbyte)path);
		WinSendMsg(TmpPtr->DialogBox, WM_COMMAND, 
			(MPARAM)DID_OK_PB, (MPARAM)200);
		WinSetDlgItemText(TmpPtr->DialogBox, DID_FILENAME_ED, (lfpbyte)"*.smm");
		// reload the files list box
		WinSendMsg(TmpPtr->DialogBox, WM_COMMAND, (MPARAM)DID_OK_PB, 
				(MPARAM)200);
	}

	strcpy((lfpbyte)description,IconBarGetDescription(GetIconMan()));
	if ((description[0] == NULL) && (macro[0] != NULL))
		strcpy(description,"description");
	WinSetDlgItemText(TmpPtr->DialogBox,ID_EDIT2,(lfpbyte)description);

	// need the file dlg manager to reload the filename, drive and
	// directory controls based on the new macro name (full path)
	// If a path exists, need to let the FileDlg manager know to change dir
	if (path[0] && macro[0])	
	{
		GetFileNameInfo(path,macro,GFI_DIRPATH);
		strcat(path, "\\");
		WinSetDlgItemText(TmpPtr->DialogBox, DID_FILENAME_ED, (lfpbyte)path);
		// force an OK msg to update the filename field
		WinSendMsg(TmpPtr->DialogBox, WM_COMMAND, 
			(MPARAM)DID_OK_PB, (MPARAM)200);
		GetFileNameInfo(path,macro,GFI_FILENAME);
		WinSetDlgItemText(TmpPtr->DialogBox, DID_FILENAME_ED, (lfpbyte)path);
	}

	strcpy((lfpbyte)path,IconBarGetCustomIconPath(GetIconMan()));
	strlwr(path);
	GetFileNameInfo(filename, path, GFI_FILENAME);
	WinSetDlgItemText(TmpPtr->DialogBox, ID_STATIC5, filename);

	if (IconBarGetIconState(GetIconMan()) & ICS_CUSTOM)
	{
		SaveCustomIconSelection();
		if (hBitmap = (HBITMAP)IconBarGetBitmap(GetIconMan()))
		{
			IconEditInit(TmpPtr,TmpPtr->DialogBox,CreateBorderLessDIB(hBitmap));
			WinInvalidateRect(WinWindowFromID(TmpPtr->DialogBox, ID_STATIC3),
				NULL, TRUE);
			WinInvalidateRect(WinWindowFromID(TmpPtr->DialogBox, ID_STATIC2),
				NULL, TRUE);
 			WinInvalidateRect(WinWindowFromID(TmpPtr->DialogBox, ID_STATIC4),
				NULL, TRUE);
		}
	}
}

lbool 
MainWindow::SaveMacroToIcon(BYTE * filepath)
{
	(void)filepath;

	BYTE tmpbuf[PATHLENGTH];

	if (AnyWildcardsInName(filepath))
		return FALSE;

	// isolate the macro name + function name, put into filename
	// (function name may\may not be present)
	GetMacroFilePlusFunction(tmpbuf,filepath,PATHLENGTH - 2);

	if (tmpbuf[0] != 0)
	{
		IconBarSetMacro(GetIconMan(),filepath);
		return TRUE;
	}
	return FALSE;
}

MRESULT EXPENTRY _export 	
CreateIconDlg(HWND hDlg, lulong iMessage, MPARAM mp1, MPARAM mp2)
{
	BYTE path[PATHLENGTH];
	BYTE filename[PATHLENGTH];
	MainWindow *pWindow;
	lsshort	wParam, maxlen;

	wParam = SHORT1FROMMP(mp1); 
	switch (iMessage)
	{
		case WM_INITDLG:		   
			pWindow = (MainWindow *)WinQueryWindowULong
				(WinWindowFromID(WinQueryWindow(
				WinQueryWindow(hDlg, QW_OWNER),  QW_OWNER),FID_CLIENT), 0);
			WinSendDlgItemMsg(hDlg,ID_EDIT1,EM_SETTEXTLIMIT,
				(MPARAM)FILELENGTH,(MPARAM)0);
			pWindow->GetDefaultCustomPath(path);
			strlwr(path);
			WinSetDlgItemText(hDlg,ID_FILEPATH,path);
			return (MRESULT)FALSE;

		case WM_COMMAND:		      
			pWindow = (MainWindow *)WinQueryWindowULong
				(WinWindowFromID(WinQueryWindow(
				WinQueryWindow(hDlg, QW_OWNER),  QW_OWNER),FID_CLIENT), 0);
			switch(wParam)
			{
				case ID_OK:
					WinQueryDlgItemText(hDlg, ID_EDIT1, 
						(lulong)FILELENGTH - 9, (PSZ)path);
					GetFileNameInfo(filename, path, GFI_FILENAME);

					/* if no filename */
					if (filename[0] == NULL)
					{
						WinSetFocus(HWND_DESKTOP, 
								WinWindowFromID(hDlg,ID_EDIT1));
						return (MRESULT)LTRUE;
					}

					pWindow->GetDefaultCustomPath(path);
					path[strlen(path) + 1] = NULL;
					path[strlen(path)] = '\\';
					strcat(path,filename);

					if (!AnyWildcardsInName(path))
					{
						BYTE Ext[5];
						Ext[0] = '.';
						Ext[1] = 'b';
						Ext[2] = 'm';
						Ext[3] = 'p';
						Ext[4] = NULL;
						SetFileExtension(path, Ext);

						// check filename after full path and filename
						// have been contructed
						if (!(CFileSystem::IsThisFileNameValid(path)))
						{
							CFileSystem::DisplayFileNameError(hDlg, 
								STR_INVALIDLEN);
							return (MRESULT)LTRUE;
						}

						strcpy(NewCustomIcon,path);
						WinDismissDlg(hDlg, LTRUE);	      
					}
					WinSetFocus(HWND_DESKTOP, WinQueryWindow(hDlg, QW_OWNER));
					return (MRESULT)LTRUE;

				case ID_CANCEL:
					WinDismissDlg(hDlg, FALSE);	      
					return (MRESULT)LTRUE;

			}
			break;

		default:
			return WinDefDlgProc(hDlg, iMessage, mp1, mp2);
	}
	return (MRESULT)LFALSE;
}

MRESULT EXPENTRY _export 	
SaveIconDlg( HWND hDlg, lulong iMessage, MPARAM mp1, MPARAM mp2 )
{
	BYTE path[PATHLENGTH];
	BYTE filename[LEN_HELP];
	MainWindow *pWindow;
	lsshort	wParam, maxlen;

	wParam = SHORT1FROMMP(mp1); 
	switch (iMessage)
	{
		case WM_INITDLG:		   
			pWindow = (MainWindow *)WinQueryWindowULong
				(WinWindowFromID(WinQueryWindow(
				WinQueryWindow(hDlg, QW_OWNER),  QW_OWNER),FID_CLIENT), 0);
			WinSendDlgItemMsg(hDlg,ID_EDIT1,EM_SETTEXTLIMIT,
				(MPARAM)FILELENGTH,(MPARAM)0);
			pWindow->GetDefaultCustomPath(path);
			strlwr(path);
			WinSetDlgItemText(hDlg,ID_FILEPATH,path);
			return (MRESULT)FALSE;

		case WM_COMMAND:		      
			pWindow = (MainWindow *)WinQueryWindowULong
				(WinWindowFromID(WinQueryWindow(
				WinQueryWindow(hDlg, QW_OWNER),  QW_OWNER),FID_CLIENT), 0);
			switch(wParam)
			{
				case ID_OK:
					WinQueryDlgItemText(hDlg, ID_EDIT1, 
						(lulong)PATHLENGTH - 9, (PSZ)path);
					GetFileNameInfo(filename, path, GFI_FILENAME);

					/* if no filename */
					if (filename[0] == NULL)
					{
						WinSetFocus(HWND_DESKTOP, 
							WinWindowFromID(hDlg,ID_EDIT1));
						return (MRESULT)TRUE;
					}

					pWindow->GetDefaultCustomPath(path);
					path[strlen(path) + 1] = NULL;
					path[strlen(path)] = '\\';
					strcat(path,filename);
					if (!AnyWildcardsInName(path))
					{
						BYTE Ext[5];
						Ext[0] = '.';
						Ext[1] = 'b';
						Ext[2] = 'm';
						Ext[3] = 'p';
						Ext[4] = NULL;
						SetFileExtension(path, Ext);

						// check filename after full path and filename
						// have been contructed
						if (!(CFileSystem::IsThisFileNameValid(path)))
						{
							CFileSystem::DisplayFileNameError(hDlg, 
								STR_INVALIDLEN);
							return (MRESULT)LTRUE;
						}
						strcpy(NewCustomIcon,path);
						WinDismissDlg(hDlg, TRUE);	   
					}
					return (MRESULT)TRUE;

				case ID_CANCEL:
					WinDismissDlg(hDlg, FALSE);	   
					return (MRESULT)TRUE;
			}
			break;

		default:
			return WinDefDlgProc(hDlg, iMessage, mp1, mp2);
	}
	return (MRESULT)FALSE;			      
}

lbool 
MainWindow::CreateNewIcon(HWND hDlg,int MenuID,BOOL CreateIcon,LHANDLE hDIB)
{
	(void)hDlg; (void)MenuID; (void)CreateIcon; (void)hDIB;

	CUSTOMICON NewIcon;
	LHANDLE NewhDIB;
	lfpbyte NewBits;
	HBITMAP hBitmap;
	LONG rval;

	NewIcon.MacroPath[0] = NULL;
	if (CreateIcon == FALSE)
	{
		rval = (LONG)WinDlgBox(HWND_DESKTOP, hDlg, CreateIconDlg, 
			(HMODULE)NULL, DLG_SAVEICON,  (PVOID)NULL);
	}
	else
	{
		rval = (LONG)WinDlgBox(HWND_DESKTOP, hDlg, SaveIconDlg, 
			(HMODULE)NULL, DLG_CREATEICON,  (PVOID)NULL);
	}

	if (rval == FALSE)
		return FALSE;

	strcpy(NewIcon.CustomPath,NewCustomIcon);
	if (hDIB == NULL)
	{
		IconBarSelectStandardIcon(GetIconMan(),MenuID,NULL);
		if (!(hBitmap = IconBarGetBitmap(GetIconMan())))
			return FALSE;
		if (!(NewhDIB = CreateBorderLessDIB(hBitmap)))
			return FALSE;
		if (!(NewBits = (lfpbyte)NewhDIB))
		{
			DosFreeMem((PVOID)NewhDIB);
			return FALSE;
		}
	}
	else
	{
		NewhDIB = hDIB;
		NewBits = (lfpbyte)hDIB;
		if (!NewBits)
			return FALSE;
	}
	IconBarNewCustomIcon(GetIconMan());
 	if (!IconBarSetCustomIconPath(GetIconMan(),NewIcon.CustomPath,TRUE))
	{
		IconBarRemoveIcon(GetIconMan());
		if (!hDIB)
			DosFreeMem((PVOID)NewhDIB);
		return FALSE;
	}
	if (!IconBarSetCustomBits(GetIconMan(),NewBits))
	{
		IconBarRemoveIcon(GetIconMan());
		if (!hDIB)
			DosFreeMem((PVOID)NewhDIB);
		return FALSE;
	}
	if (!hDIB)
		DosFreeMem((PVOID)NewhDIB);
	else
		/* they saved the changes to a new bitmap, so do not save changes */
		TmpPtr->CurrentDIBChanged = FALSE;

	IconBarAddIcon(GetIconMan(), TmpPtr->DialogIconBar,TmpPtr->LastCustom);
	TmpPtr->LastCustom++;

	IconBarShowCustomIcon(GetIconMan(), TmpPtr->DialogIconBar,&NewIcon);

 	// Invalidate the mouse bitmap.  It may be out of date.
 	WinInvalidateRect(WinWindowFromID(hDlg, ID_STATIC4), NULL, FALSE);

	return TRUE;
}

void 
MainWindow::GetDefaultCustomPath(BYTE * Path)
{
	GetStubPath(Path);
	strcat(Path,"ICONS");
}

void 
MainWindow::AddMacroPathToMacro(BYTE *Macro)
{
	BYTE Buffer[PATHLENGTH];

	if (Macro[1] != ':')
	{
		GetStubPath(Buffer);
		strlwr(Buffer);
		strcat(Buffer,"macros\\");
		strcat(Buffer,Macro);
		strcpy(Macro,Buffer);
	}
}

void 
MainWindow::SaveCustomIconSelection()
{
	IconBarSelectChosenIcon(GetIconMan(), TmpPtr->DialogIconBar);
	if (IconBarGetIconState(GetIconMan()) & ICS_CUSTOM)
	{
		strcpy(TmpPtr->LastCustomIcon.CustomPath,
				IconBarGetCustomIconPath(GetIconMan()));
		strcpy(TmpPtr->LastCustomIcon.MacroPath,
				IconBarGetMacro(GetIconMan()));
	}
}


void 
MainWindow::SetIconSize(BYTE NewSize)
{
	IconSize = NewSize;
}

void 
MainWindow::SaveCustomBits()
{
	lfpbyte Bits;

	if (TmpPtr->hDIB && TmpPtr->CurrentDIBChanged)
	{
		Bits = (lfpbyte)TmpPtr->hDIB;
		{
			IconBarSetCustomBits(GetIconMan(),Bits);
		}
	}
}

lbool 
MainWindow::GetLastRect(lrect * prect)
{
	BYTE Buffer[120];
	BYTE comma[2];
	BYTE *cp;
	lubyte Output[30];
	HINI	hini;

	strcpy(Output,"IconBarRect");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
	PrfQueryProfileString(hini, (lfpbyte)"SmartIcons", 
		(lfpbyte)Output, (lfpbyte)"", (lfpbyte)Buffer, sizeof Buffer);
	PrfCloseProfile(hini);

	if (!Buffer[0])
		return FALSE;

	comma[0] = ','; comma[1] = NULL;

	cp = strtok(Buffer,comma);
	prect->left = atoi(Buffer);

	cp = strtok(NULL,comma);
	prect->top = atoi(cp);

	cp = strtok(NULL,comma);
	prect->right = atoi(cp);

	cp = strtok(NULL,comma);
	prect->bottom = atoi(cp);

	return TRUE;
}

BYTE 
MainWindow::GetLastIconSize()
{
	BYTE Buffer[120];
	HINI	hini;

	hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
	PrfQueryProfileString(hini, (lfpbyte)"SmartIcons", 
		(lfpbyte)"IconSize", (lfpbyte)"", (lfpbyte)Buffer, sizeof Buffer);
	PrfCloseProfile(hini);

	if (!Buffer[0])
		return 0;

	return (BYTE)atoi(Buffer);
}

lbool 
MainWindow::GetLastPosition()
{
	BYTE Buffer[120];
	lubyte Output[30];
	HINI	hini;
	lulong	position;

	strcpy(Output,"IconBarPosition");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
	PrfQueryProfileString(hini, (lfpbyte)"SmartIcons", 
		(lfpbyte)Output, (lfpbyte)"", (lfpbyte)Buffer, sizeof Buffer);
	PrfCloseProfile(hini);

	if (!Buffer[0])
		return 0;

	position = atoi(Buffer);
	return position;
}

void 
MainWindow::SetLastRect()
{
	BYTE StrBuffer[120];
	HINI	hini;
	BYTE Key[8];
	BYTE comma[2];
	lrect rect;
	lubyte Output[30];


	IconBarGetLastRect(GetIconMan(), GetIconBar(),(lrect *)&rect);

	comma[0] = ','; comma[1] = NULL;

	itoa(rect.left,StrBuffer,10);
	strcat(StrBuffer,comma);

	itoa(rect.top,Key,10);

	strcat(StrBuffer,Key);
	strcat(StrBuffer,comma);
	
	itoa(rect.right,Key,10);

	strcat(StrBuffer,Key);
	strcat(StrBuffer,comma);
	
	itoa(rect.bottom,Key,10);

	strcat(StrBuffer,Key);

	strcpy(Output,"IconBarRect");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
	PrfWriteProfileString(hini, (lfpbyte)"SmartIcons",
		(lfpbyte)Output, (lfpbyte)StrBuffer);
	PrfCloseProfile(hini);
}

void 
MainWindow::SetLastIconSize()
{
	BYTE StrBuffer[120];
	HINI	hini;

	itoa(IconSize,StrBuffer,10);

	hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
	PrfWriteProfileString(hini, (lfpbyte)"SmartIcons",
		(lfpbyte)"IconSize", (lfpbyte)StrBuffer);
	PrfCloseProfile(hini);
}

void 
MainWindow::SetLastPosition()
{
	BYTE StrBuffer[120];
	BYTE Position;
	lubyte Output[30];
	HINI	hini;

	Position = IconBarGetPositionType(GetIconMan(), GetIconBar());
	if (Position == IBP_TOP)
		Position = IBP_BOTTOM;
	else if (Position == IBP_BOTTOM)
		Position = IBP_TOP;

	itoa(Position,StrBuffer,10);

	strcpy(Output,"IconBarPosition");
	itoa(cCurrentIconBar,Output + strlen(Output),10);
	hini = PrfOpenProfile(Main::hab, (lfpbyte)"iconstub.ini");
	PrfWriteProfileString(hini, (lfpbyte)"SmartIcons",
		(lfpbyte)Output, (lfpbyte)StrBuffer);
	PrfCloseProfile(hini);
}

lbool 
MainWindow::SaveDescription()
{
	BYTE description[LEN_HELP];
	BYTE description2[LEN_HELP];
	
	IconBarSetDescription(GetIconMan(),description2);
	WinQueryDlgItemText(TmpPtr->DialogBox,ID_EDIT2, 
		LEN_HELP - 1, (lfpbyte)description);
	if (strcmp(description,description2) != 0)
	{
		IconBarSetDescription(GetIconMan(),description);
		return TRUE;
	}
	return FALSE;
}

void 
GetMacroFilePlusFunction(BYTE * dest,BYTE * src,int maxlen)
{
	int	len, srclen;

	srclen = len = strlen(src);
	while (len > 0) {
		if (src[len] == DIRSEPARATOR || (src[len] == ':' && len == 1))
			break;
		len--;
	}

	if (srclen > len) 
	{
		if (src[len] == DIRSEPARATOR || src[len] == ':')
			len++;

		memcpy(dest,&src[len],min(maxlen,srclen - len));
		dest[min(maxlen,srclen - len)] = NULL;
	}
	else
		*dest = NULL;
}

void 
MainWindow::CopyClipboard(HWND hDlg)
{
	(void)hDlg;

	LHANDLE hDIB = NULL;
	HBITMAP hBitmap = NULL;

	if (!WinOpenClipbrd(Main::hab))
		return;

	if (!(hDIB = WinQueryClipbrdData(Main::hab, CF_DSPBITMAP)))
		hBitmap = WinQueryClipbrdData(Main::hab, CF_BITMAP);

	if (hDIB || hBitmap)
	{
		if (IconBarSelectStandardIcon(GetIconMan(),0,0))
		{
			lpoint size;
			POINTL Size;
			LHANDLE NewDIB;

			IconBarGetIconSize(GetIconMan(),&size);
			Size.x = (lulong)size.x;
			Size.y = (lulong)size.y;

			/* take off the border */
			Size.x -= 3;
			Size.y -= 3;

			if (NewDIB = MakeGraphicRightSize(hDIB, hBitmap, Size.x, Size.y))
			{
				IconEditDestroy(TmpPtr);
				IconEditInit(TmpPtr, hDlg, NewDIB);
				TmpPtr->CurrentDIBChanged = TRUE;
				WinInvalidateRect(WinWindowFromID(hDlg, ID_STATIC3),
					NULL, FALSE);
				WinInvalidateRect(WinWindowFromID(hDlg, ID_STATIC2),
					NULL, FALSE);
				WinInvalidateRect(WinWindowFromID(hDlg, ID_STATIC4),
					NULL, FALSE);
			}
		}
	}
	WinCloseClipbrd(Main::hab);
}

LHANDLE 
MakeGraphicRightSize(LHANDLE hDIB,HBITMAP hBitmap,int width,int height)
{
	HBITMAP NewBitmap,Old1;
	HPS MemDC1,ScreenDC;
	HPS	hps;
	LPBITMAPINFO_NEW lpbi;
	LHANDLE NewDIB;
	BITMAP bm;

	if (hDIB)
	{
		if (!(lpbi = (LPBITMAPINFO_NEW)hDIB))
			return NULL;

		if ((lpbi->BIHEIGHT == (int)height) 
				&& (lpbi->BIWIDTH == (int)width))
		{
			LHANDLE MemHandle;
			BYTE huge *MemPtr;
			lulong Size, flags;

			DosQueryMem((PVOID)hDIB, &Size, &flags);
			if (DosAllocMem((PPVOID)&MemHandle, Size, 
					PAG_COMMIT|PAG_WRITE|PAG_READ))
			{
				if (MemPtr = (BYTE *)MemHandle)
				{
					hmemcpydown(MemPtr, (BYTE huge *)lpbi, Size);
					return MemHandle;
				}
				DosFreeMem((PPVOID)MemHandle);
			}
		}
	}
	else if (hBitmap)
	{

		GetBitmapObject(hBitmap, sizeof(bm), (lfpbyte)&bm);
		if ((bm.BMWIDTH == width) && (bm.BMHEIGHT == height))
			return DIBFromBitmap(hBitmap, BI_RGB, 0);
	}
	else
		return NULL;

	if (!(ScreenDC = GetDC(HWND_DESKTOP)))
		return NULL;
	if (!(MemDC1 = CreateCompatibleDC(ScreenDC)))
	{
		WinReleasePS(ScreenDC);
		return NULL;
	}
	if (!(NewBitmap = CreateCompatibleBitmap(ScreenDC, width, height)))
	{
		WinReleasePS(ScreenDC);
		DeleteDC(MemDC1);
		return NULL;
	}
	WinReleasePS(ScreenDC);
	if (HBM_ERROR == (Old1 = GpiSetBitmap(MemDC1,NewBitmap)))
	{
		DeleteDC(MemDC1);
		return NULL;
	}

	/* clear off the DC */
	DevicePatBlt(MemDC1, 0, 0, width, height);

	if (hDIB)
	{
#ifdef STRETCHIT
		StretchDIBits(MemDC1, 0, 0, width, height, 0, 0,
			(int)lpbi->BIWIDTH, (int)lpbi->BIHEIGHT,(lfpbyte)lpbi + 
				(int)lpbi->BISIZE + DIBPaletteSize(lpbi), lpbi,
				DIB_RGB_COLORS,SRCCOPY);
#else
		if (width < (int)lpbi->BIWIDTH)
			width = (int)lpbi->BIWIDTH;
		if (height < (int)lpbi->BIHEIGHT)
			height = (int)lpbi->BIHEIGHT;

		StretchDIBits(MemDC1, 0, 0, width, height, 0, 0, width, height,
				(lfpbyte)lpbi + (int)lpbi->BISIZE + DIBPaletteSize(lpbi),
				lpbi, DIB_RGB_COLORS, SRCCOPY);
#endif
	}
	else
	{
		HPS MemDC2;
		HBITMAP Old2;

		if (!(MemDC2 = CreateCompatibleDC(MemDC1)))
		{
			GpiSetBitmap(MemDC1,Old1);
			DeleteDC(MemDC1);
			GpiDeleteBitmap(NewBitmap);
			return NULL;
		}
		if (HBM_ERROR == (Old2 = GpiSetBitmap(MemDC2,hBitmap)))
		{
			GpiSetBitmap(MemDC1,Old1);
			DeleteDC(MemDC1);
			DeleteDC(MemDC2);
			GpiDeleteBitmap(NewBitmap);
			return NULL;
		}

#ifdef USEBITBLT
		if (width < bm.BMWIDTH)
			width = bm.BMWIDTH;
		if (height < bm.BMHEIGHT)
			height = bm.BMHEIGHT;

		BitBlt(MemDC1, 0, 0, width, height, MemDC2, 0, 0, SRCCOPY);
#else
		RECTL	srcrect, destrect;
		srcrect.xLeft = 0;
		srcrect.yBottom = 0;
		srcrect.xRight = bm.BMWIDTH;
		srcrect.yTop = bm.BMHEIGHT;

		destrect.xLeft = 0;
		destrect.yBottom = 0;
		destrect.xRight = width;
		destrect.yTop = height;
		WinDrawBitmap(MemDC1, hBitmap, &srcrect, (PPOINTL)&destrect, 
			CLR_NEUTRAL, CLR_BACKGROUND, DBM_STRETCH);
#endif

		GpiSetBitmap(MemDC2,Old2);
		DeleteDC(MemDC2);
	}

	GpiSetBitmap(MemDC1,Old1);
	DeleteDC(MemDC1);

	NewDIB = DIBFromBitmap(NewBitmap, BI_RGB, 0);
	GpiDeleteBitmap(NewBitmap);
	return NewDIB;
}

/* copy cnt bytes from src to dst		*/
/* src and dst are huge pointers		*/
/* cnt is lulong							*/
/* makes sure segments are not violated	*/
void 
hmemcpydown(BYTE huge * dst, BYTE huge * src, lulong cnt)
{
	while (cnt != 0)
	{
		lulong dleft, sleft;

		/* calculate how much is left in each segment */
		dleft = 0x10000L - (int)dst;
		sleft = 0x10000L - (int)src;

		/* use the min of dleft and sleft	*/

		if (dleft > sleft)
			dleft = sleft;
		
		/* but of course don't copy more than count */
		if (dleft > cnt)
			dleft = cnt;
		
		/* go ahead and adjust loop variable */
		cnt -= dleft;

		/* lmemcpy can't copy 0x10000 at a time, so split it up if necessary */
		if (dleft == 0x10000L)
		{
			memcpy((void *)dst, (void *)src, 0x8000);
			dst += 0x8000;
			src += 0x8000;
			dleft -= 0x8000;
		}
		memcpy((void *)dst, (void *)src, (int)dleft);
		dst += dleft;
		src += dleft;
	}
}

void 
GetFileNameInfo(BYTE * dest,BYTE * src,int type)
{
	int	len, srclen;

	srclen = len = strlen(src);
	while (len > 0) {
		if (src[len] == DIRSEPARATOR || (src[len] == ':' && len == 1))
			break;
		len--;
	}

	if (srclen > len) 
	{
		switch (type) 
		{
			case GFI_FILENAME:
				if (src[len] == DIRSEPARATOR || src[len] == ':')
					len++;

				memcpy(dest,&src[len],min(PATHLENGTH - 1,
					srclen - len));
				dest[min(PATHLENGTH - 1,srclen - len)] = NULL;
				break;

			case GFI_DIRPATH:
				if ((src[len] == ':')
				|| ((len > 1) && src[len-1] == ':'))
					len++;
				memcpy(dest,src,len);
				dest[len] = NULL;
				break;

			default:
				*dest = NULL;
				break;
		}
	}
	else
		*dest = NULL;
}

/* Sets the file extension to the passed one. */
void 
SetFileExtension(BYTE * filename, BYTE * extension)
{
	BYTE *p;

	/* Get to last character of filename */
	p = &filename[strlen(filename)];

	/* Scan back until hit a . or a \ */
	while (p > filename) 
	{
		if (('.' == *p) || (DIRSEPARATOR == *p))
			break;
		p--;
	}

	/* Found no . - we'll just put the extension at the end of the whole */
	/* schmeer. */
	if ('.' != *p)
		p = &filename[strlen(filename)];
	else 
		filename = 0;
	strcpy(p, extension);
}

BOOL 
AnyWildcardsInName(BYTE * string)
{
	BOOL	wildcard;

	if (strchr(string, '?') 
	|| strchr(string, '*'))
		wildcard = TRUE;
	else
		wildcard = FALSE;

	return wildcard;
}

void
MainWindow::EndStub()
{
	if (IconManager)
	{
#ifdef NEVER
		IconBarDestroyManager(IconManager);
#endif
		IconManager = 0;
	}
	if (IconManLibrary)
	{
		DosFreeModule(IconManLibrary);
		IconManLibrary = 0;
	}
}
void		
MainWindow::TurnOnForce()
{
	IconFlags |= FORCED_SIZE;
}

void		
MainWindow::TurnOffForce()
{
	IconFlags &= ~FORCED_SIZE;
}

HICONBAR 
MainWindow::GetIconBar()
{
	return IconBar[cCurrentIconBar];
}

void
MainWindow::SetCurrentIconBar(lushort NewIB)
{
	HWND hMenu;

	hMenu = WinWindowFromID(WinQueryWindow(hWndClient, QW_PARENT), (USHORT)FID_MENU);
	if (hMenu)
		WinCheckMenuItem(hMenu,MF_ICONBAR1 + cCurrentIconBar, FALSE);

	cCurrentIconBar = NewIB;

	if (hMenu)
		WinCheckMenuItem(hMenu,MF_ICONBAR1 + cCurrentIconBar, TRUE);
}

void
MainWindow::SetIconBar(HICONBAR NewIconBar)
{
	IconBar[NumIconBars - 1] = NewIconBar;
}

void
MainWindow::SetIconMan(HWND NewMan)
{
	IconManager = NewMan;
}

HMANAGER 
MainWindow::GetIconMan()
{
	return IconManager;
}



inline lbool		
MainWindow::IsForceOn()
{
	return IconFlags & FORCED_SIZE;
}

void		
MainWindow::IncrementDialogBoxes(lushort NewDialogID)
{
	DialogBoxID[NumDialogBoxes++] = NewDialogID;
}

void		
MainWindow::DecrementDialogBoxes()
{
	NumDialogBoxes--;
}

lbool		
MainWindow::AnyDialogBoxes()
{
	return (lbool)(NumDialogBoxes > 0);
}


EDITCUSTOMICON *
MainWindow::GetTmpPtr()
{
	return TmpPtr;
}


void
ConstructExeFullDirectory(lsbyte *path)
{
	int		len;
	PTIB	pptib;
	PPIB	pppib;

	DosGetInfoBlocks(&pptib, &pppib);
	strcpy(path, pppib->pib_pchcmd);

	len = strlen(path) - 1;
	while (len && path[len] != '\\')
		path[len--] = '\0';
}

// The DLL send a message to this window.
lulong EXPENTRY _export
MessageProc(HWND ParentWnd, HWND ManagerWnd, HWND Inst, lulong Msg, lulong Param1, lulong Param2)
{
	lubyte StrBuffer[120];
	lfpbyte macroptr;
	lushort MenuID;
	MainWindow *pWindow = (MainWindow *)WinQueryWindowPtr(ParentWnd, 0);
	lbool retval;
	lubyte Index;
	RECTL	rect;

	switch ( Msg )
	{
		case IMM_ICONHITTEST:	/* no need for us to process this */
			return Param1;

		case IMM_GETLASTPOS:	
			return (lulong)pWindow->GetLastPosition();

		case IMM_GETLASTICONSIZE:
			return (lulong)pWindow->GetLastIconSize();

		case IMM_GETLASTRECT:
			return pWindow->GetLastRect((lrect *)Param1);

		case IMM_WHATICONS:
			/* manager wants to know what size the current icons are. */
			return pWindow->GetIconSize();

		case IMM_LOADICONS:
			/* manager wants the host to load a new size of icons */
			return pWindow->ChangeIconSize((lubyte)Param1);

		case IMM_DESELECT:
			/* only happens when EditIcon dialog box is up */
			if (pWindow->GetTmpPtr() 
				&& (Inst == pWindow->GetTmpPtr()->DialogIconBar))
			{
				WinSendMsg(pWindow->GetTmpPtr()->DialogBox, 
					WM_COMMAND, (MPARAM)DID_OK_PB, (MPARAM)100);
			}
			break;

		case IMM_SELECT:
			/* only happens when EditIcon dialog box is up */
			if (pWindow->GetTmpPtr()
				&& (Inst == pWindow->GetTmpPtr()->DialogIconBar))
				pWindow->SelectionChange();
			break;

		case IMM_ICONUP:
			if (IconBarGetIconState(ManagerWnd) & ICS_CUSTOM)
			{
				if (macroptr = IconBarGetMacro(ManagerWnd))
				{
					strcpy((lfpbyte)StrBuffer,macroptr);
					pWindow->SendMacro(StrBuffer);
				}
			}
			else
			{
				if (MenuID = IconBarGetIconActionID(ManagerWnd))
					pWindow->SendMenuItem(MenuID);
			}
			break;
		

		case IMM_ICONHELP:
			/* we need to display the help string in the Param2 */
			strcpy(StrBuffer,(lfpbyte)Param2);
			// Display this string on the title bar
			pWindow->PaintOneLineHelp(StrBuffer);
			return LTRUE;


		case IMM_ICONHELPDONE:
			// manager is done displaying help
			// restore title bar contents
			pWindow->InvalidateOneLineHelp();
			return LTRUE;
		
		case IMM_BARSIZED:
			/* icon bars size changed. */
			if (pWindow->IsForceOn() == LFALSE)
			{
				/* resize if we have other child windows */
			}
			break;


		case IMM_HOSTSIZEREQUEST:
			// manager wants us to put rectangle we can 
			// place a fixed iconbar inside of, in the 
			// rectangle pointed to by Param2. 
			WinQueryWindowRect(ParentWnd, (PRECTL)&rect);

			// MUST send back in "window" coords
			rect.yTop -= WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);
			((lrect *)Param2)->left = (lsshort)rect.xLeft;
			((lrect *)Param2)->top = (lsshort)rect.yBottom;
			((lrect *)Param2)->right = (lsshort)rect.xRight;
			((lrect *)Param2)->bottom = (lsshort)rect.yTop;
			pWindow->SetRect(Inst,(PRECTL)&rect);
			return LTRUE;

		case IMM_EDITICON:
			retval = pWindow->EditIcon((LPCUSTOMICON)Param1);
			return retval;

		case IMM_GETFOCUS:
			WinSetFocus(HWND_DESKTOP, ParentWnd);
			return LTRUE;

		case IMM_MANAGERDESTROY:	/* save all data needed */
			pWindow->DestroyIconManager(); 
			return TRUE;
	}
	return 0;
};

/***************************************************************************
***************************************************************************/
void 
IconEditInit(EDITCUSTOMICON *TmpPtr,HWND hDlg, LHANDLE hDIB)
{
	HWND hCtl;
	lushort BoxWidth, BoxHeight, BmpWidth, BmpHeight;
	LPBITMAPINFO_NEW lpbi;
	RECTL Rect;

	if (hDIB == NULL)
		return;

	TmpPtr->CurrentDIBChanged = FALSE;

	TmpPtr->hDIB = hDIB;

	lpbi = (LPBITMAPINFO_NEW)TmpPtr->hDIB;

	// Center the actual size bitmap in the box.
	hCtl = WinWindowFromID(hDlg, ID_STATIC3);
	WinQueryWindowRect(hCtl, &Rect);
	TmpPtr->ActualOffset.x = ((Rect.xRight - Rect.xLeft 
							- (lushort)lpbi->BIWIDTH) / 2) + 1;
	TmpPtr->ActualOffset.y = 0;
	TmpPtr->ActualOffset.y = ((Rect.yTop - Rect.yBottom 
							- (lushort)lpbi->BIHEIGHT) / 2);

	// Get the size of the window for the fat bits bitmap.
	hCtl = WinWindowFromID(hDlg, ID_STATIC2);
	WinQueryWindowRect(hCtl, &Rect);
	
	// Calculate the scale for the fat bits bitmap.
	BoxWidth = Rect.xRight - Rect.xLeft;
	BoxHeight = Rect.yTop - Rect.yBottom;
	BmpWidth = (lushort)lpbi->BMIHEADER_BIWIDTH;
	BmpHeight = (lushort)lpbi->BMIHEADER_BIHEIGHT;
	
	TmpPtr->Scale = min((BoxWidth-3) / (BmpWidth + 3), 
								(BoxHeight-3) / (BmpHeight + 3));

	TmpPtr->ZoomedSize.x = (lsshort)BmpWidth * TmpPtr->Scale;
	TmpPtr->ZoomedSize.y = (lsshort)BmpHeight * TmpPtr->Scale;

	// Center the fat bits bitmap in the box.
	// There is a border 2 units wide on right and bottom.  Each unit
	// is the size of scale.  So, center the image within the first
	// layer of border.

	TmpPtr->ZoomedOffset.x = 
		(BoxWidth - TmpPtr->ZoomedSize.x - TmpPtr->Scale) / 2;

	TmpPtr->ZoomedOffset.y = TmpPtr->Scale + 
		(BoxHeight - TmpPtr->ZoomedSize.y - TmpPtr->Scale) / 2;


	// Get the number of colors.  Put them in a list.  
	TmpPtr->NumColors = DIBNumColors(lpbi);
	if (TmpPtr->NumColors)
	{
		TmpPtr->IconColors = GetIconColors(lpbi, TmpPtr->NumColors);
	}

	TmpPtr->MButtonsSwapped = WinQuerySysValue(HWND_DESKTOP, SV_SWAPBUTTON);
	if (TmpPtr->MButtonsSwapped)
	{
		TmpPtr->LColor = TmpPtr->IconColors[1];
		TmpPtr->RColor = TmpPtr->IconColors[0];
	}
	else
	{
		TmpPtr->LColor = TmpPtr->IconColors[0];
		TmpPtr->RColor = TmpPtr->IconColors[1];
	}
}

/**************************************************************************/
void 
IconEditDestroy(EDITCUSTOMICON *TmpPtr)
{
	if (TmpPtr)
	{
		if (TmpPtr->IconColors)
			DosFreeMem((PVOID)TmpPtr->IconColors);
		if (TmpPtr->ColorsUsed)
			DosFreeMem((PVOID)TmpPtr->ColorsUsed);
		if (TmpPtr->hDIB)
			DosFreeMem((PVOID)TmpPtr->hDIB);
		TmpPtr->hDIB = NULL;
		TmpPtr->IconColors = NULL;
		TmpPtr->ColorsUsed = NULL;
	}
}

/**************************************************************************/
void 
DrawActualBitmap(EDITCUSTOMICON *TmpPtr, HPS hps)
{
	LPBITMAPINFO_NEW lpbi;
	
	if (TmpPtr->hDIB == 0)
		return;

	lpbi = (LPBITMAPINFO_NEW)TmpPtr->hDIB;

	// Paint it.
	StretchDIBits(hps, TmpPtr->ActualOffset.x, TmpPtr->ActualOffset.y,
		(lsshort)lpbi->BIWIDTH+1, (lsshort)lpbi->BIHEIGHT+1,
		0, 0, (lsshort)lpbi->BIWIDTH, (lsshort)lpbi->BIHEIGHT,
		((LPSTR)lpbi) + (lsshort)lpbi->BISIZE + DIBPaletteSize(lpbi), 
		(LPBITMAPINFO_NEW)lpbi, DIB_RGB_COLORS, SRCCOPY);

	DrawIconFrame(hps,TmpPtr->ActualOffset,(lushort)lpbi->BIWIDTH,
						(lushort)lpbi->BIHEIGHT,1);

}

/***************************************************************************
***************************************************************************/
// NOTE: If you have trouble with this, use the same coords as 
// used in the iconstub.dlg for the rectangle of this control!
void 
DrawZoomedBitmap(EDITCUSTOMICON *TmpPtr,HPS hdc)
{
	LPBITMAPINFO_NEW lpbi;
	RECTL LogRect;
	LONG	hOldPen, hPen;
	
	if (TmpPtr->hDIB == 0)
		return;

	lpbi = (LPBITMAPINFO_NEW)TmpPtr->hDIB;

	// First - Paint a black box as the boundary.
	hOldPen = GpiQueryColor(hdc);
	GpiSetColor(hdc, CLR_BLACK);

	LogRect.xLeft = TmpPtr->ZoomedOffset.x - TmpPtr->Scale;
	LogRect.xRight = LogRect.xLeft + TmpPtr->ZoomedSize.x + (TmpPtr->Scale * 3);
	LogRect.yBottom = TmpPtr->ZoomedOffset.y - (TmpPtr->Scale * 2);
	LogRect.yTop = LogRect.yBottom + TmpPtr->ZoomedSize.y + (TmpPtr->Scale * 3);

	DeviceRectangle(hdc, LogRect.xLeft - 1, LogRect.yBottom - 2, 
				LogRect.xRight + 1, LogRect.yTop + 1);

	GpiSetColor(hdc, hOldPen);

	// Paint it.
	StretchDIBits(hdc, TmpPtr->ZoomedOffset.x, TmpPtr->ZoomedOffset.y, 
		(lsshort)TmpPtr->ZoomedSize.x, (lsshort)TmpPtr->ZoomedSize.y,
		0, 0, (lsshort)lpbi->BIWIDTH, (lsshort)lpbi->BIHEIGHT,
		(LPSTR)lpbi + (lsshort)lpbi->BISIZE + DIBPaletteSize(lpbi),
		lpbi, DIB_RGB_COLORS, SRCCOPY);

	// Draw the border around the bitmap
	DrawIconFrame(hdc,TmpPtr->ZoomedOffset,TmpPtr->ZoomedSize.x,
						TmpPtr->ZoomedSize.y,TmpPtr->Scale);
}

/***************************************************************************
***************************************************************************/
lushort DIBNumColors(void *pv)
{
	lushort 		bits;
	LPBITMAPINFOHEADER_NEW	lpbi;
	LPBITMAPINFOHEADER_OLD	lpbc;

	lpbi = ((LPBITMAPINFOHEADER_NEW)pv);
	lpbc = ((LPBITMAPINFOHEADER_OLD)pv);

	/*	With the BITMAPINFO format headers, the size of the palette
	 *	is in biClrUsed, whereas in the BITMAPCORE (BITMAPINFO_OLD) - 
	 *  style headers, it is dependent on the bits per pixel ( = 2 raised 
	 *  to the power of bits/pixel).
	 */

	if(lpbi->BISIZE != sizeof(BITMAPINFOHEADER_OLD))
	{
		if (lpbi->BICLRUSED != 0)
			return (lsshort)lpbi->BICLRUSED;
		bits = lpbi->BIBITCOUNT;
	}
	else
		bits = lpbc->BCBITCOUNT;

	switch(bits)
	{
		case 1:
			return 2;
		case 4:
			return 16;
		case 8:
			return 256;
		default:
			/* A 24 bitcount DIB has no color table */
			return 0;
	}
}

/***************************************************************************
***************************************************************************/
/* get size of palette entries */
lushort DIBPaletteSize(void *pv)
{
	LPBITMAPINFOHEADER_NEW lpbi;
	lsshort	       NumColors;

	lpbi      = (LPBITMAPINFOHEADER_NEW)pv;
	NumColors = DIBNumColors(lpbi);

	if(lpbi->BISIZE == sizeof(BITMAPINFOHEADER_OLD))
		return NumColors * sizeof(RGBTRIPLE);
	else
		return NumColors * sizeof(RGBQUAD);
}

/***************************************************************************
***************************************************************************/
LHANDLE 
DIBFromBitmap(HBITMAP hbm,lulong biStyle,lushort biBits)
{
	BITMAP					bm;
	BITMAPINFOHEADER_NEW	bi;
	BITMAPINFOHEADER_NEW *	lpbi;
	lulong					dwLen;
	LHANDLE					hdib;
	LHANDLE					h;
	HPS						hdc, hps;
	HPALETTE				hpal;
	APIRET					rc;

	if(!hbm)
		return NULL;

	hpal = (LHANDLE)DEF_PALETTE;

	GetBitmapObject(hbm, sizeof(bm), (LPSTR)&bm);
	GetBitmapObject(hbm, sizeof(bi), (LPSTR)&bi);

	if(biBits == 0)
		biBits =  bm.BMPLANES * bm.BMBITSPIXEL;

	bi.BISIZE = sizeof(BITMAPINFOHEADER_NEW);
	bi.BIWIDTH = bm.BMWIDTH;
	bi.BIHEIGHT = bm.BMHEIGHT;
	bi.BIPLANES = 1;
	bi.BIBITCOUNT = biBits;
	bi.BICOMPRESSION = biStyle;
	bi.BISIZEIMAGE = 0;
	bi.BIXPELSPERMETER = 0;
	bi.BIYPELSPERMETER = 0;
	bi.BICLRUSED = 0;
	bi.BICLRIMPORTANT = 0;

	dwLen  = bi.BISIZE + DIBPaletteSize(&bi);

	hps = WinGetPS(HWND_DESKTOP);
	hdc = CreateCompatibleDC(hps);
	hpal = SelectPalette(hdc,hpal,FALSE);
	RealizePalette(hdc);

	if (DosAllocMem((PPVOID)&hdib, dwLen, PAG_COMMIT|PAG_WRITE|PAG_READ))
		return NULL;

	if(!hdib)
	{
		SelectPalette(hdc,hpal,FALSE);
		WinReleasePS(hdc);
		return NULL;
	}

	lpbi = (LPBITMAPINFOHEADER_NEW)hdib;

	*lpbi = bi;

	/* call GetDIBits with a NULL lpBits param, so it will calculate the
	*  biSizeImage field for us
	*/

	GetDIBits(hdc,hbm,0,(lsshort)bi.BIHEIGHT,NULL, lpbi, 
		DIB_RGB_COLORS);

	bi = *lpbi;

	/* If the driver did not fill in the biSizeImage field, make one up */
	if(bi.BISIZEIMAGE == 0)
	{
		bi.BISIZEIMAGE = WIDTHBYTES((lulong)bm.BMWIDTH * biBits) * bm.BMHEIGHT;

		if(biStyle != BI_RGB)
			bi.BISIZEIMAGE = (bi.BISIZEIMAGE * 3) / 2;
	}

	/* realloc the buffer big enough to hold all the bits */

	dwLen = bi.BISIZE + DIBPaletteSize(&bi) + bi.BISIZEIMAGE;
	if(h = MyDosReAllocMem(hdib,dwLen))
		hdib = h;
	else
	{
		// Note: if failed, original mem alloc is already free
		hdib = NULL;

		SelectPalette(hdc,hpal,FALSE);
		WinReleasePS(hdc);
		return hdib;
	}

	/*	call GetDIBits with a NON-NULL lpBits param, and actualy get the
	*  bits this time
	*/

	lpbi = (LPBITMAPINFOHEADER_NEW)hdib;

	if(GetDIBits(hdc,hbm,0,(lsshort)bi.BIHEIGHT,
		(LPSTR)lpbi + (lsshort)lpbi->BISIZE + DIBPaletteSize(lpbi),
		lpbi,DIB_RGB_COLORS) == 0)
	{
		hdib = NULL;
		SelectPalette(hdc,hpal,FALSE);
		WinReleasePS(hdc);
		return NULL;
	}

	/* If the driver did not fill in the biSizeImage field, make one up */

	if(lpbi->BISIZEIMAGE == 0)
	{
		lpbi->BISIZEIMAGE = WIDTHBYTES((lulong)lpbi->BIWIDTH * 
					biBits) * lpbi->BIHEIGHT;

		if(biStyle != BI_RGB)
			lpbi->BISIZEIMAGE = (lpbi->BISIZEIMAGE * 3) / 2;
	}

	SelectPalette(hdc,hpal,FALSE);
	WinReleasePS(hps);
	DeleteDC(hdc);
	return hdib;
}

/***************************************************************************
 * Allocate enough memory to hold all of the icon colors.   Keep them in
 * a list for easy retrieval.
 ***************************************************************************/
lulong * 
GetIconColors(LPBITMAPINFO_NEW lpbi, lushort NumColors)
{
	lulong *IconColors;
	lulong *dwp;
	lushort i;
	RGBQUAD *pQuad;

	DosAllocMem((PPVOID)&dwp, NumColors * sizeof(lulong), 
		PAG_COMMIT|PAG_WRITE|PAG_READ);
	IconColors = dwp;

	pQuad = (RGBQUAD *)((BYTE *)lpbi + lpbi->BMIHEADER_BISIZE);
	for (i = 0; i < (lushort)NumColors; i++)
	{
		*dwp = (LONG)RGB(pQuad->RGBRED, pQuad->RGBGREEN, pQuad->RGBBLUE);
		dwp++;
		pQuad++;
	}

	return IconColors;
}

/***************************************************************************
 * Change the bitmap to reflect the new color that we have added.
 ***************************************************************************/
void 
SetIconColors(LPBITMAPINFO_NEW lpbi, lushort index, lulong color)
{
	RGBQUAD * pQuad;

	pQuad = (RGBQUAD *)((BYTE *)lpbi + lpbi->BMIHEADER_BISIZE);
	pQuad += index;
	pQuad->RGBBLUE = (BYTE)((color & 0x00FF0000) >> 16);
	pQuad->RGBGREEN = (BYTE)((color & 0x0000FF00) >> 8);
	pQuad->RGBRED = (BYTE)(color & 0x000000FF);
}


/***************************************************************************
 * Search through the Icon Colors to find one that matches the color
 * passed in. Return the index into the IconColors array.
 ***************************************************************************/
BYTE 
GetColorIndex(LPBITMAPINFO_NEW lpbi, lulong color, lulong *IconColors, lushort NumColors, BOOL *ColorsUsed)
{
	BOOL found = FALSE;
	lulong *dwp;
	lushort i = 0;

	dwp = IconColors;
	while ((i < (lushort)NumColors) && !found)
	{
		if (color == *dwp)
			found = TRUE;

		dwp++;
		i++;
	}

	// If the color is not found, lets find an unused space and set it.
	if (!found && ColorsUsed)
		SetColorIndex(lpbi, color, NumColors, IconColors, ColorsUsed);

	return (BYTE)(i - 1);
}

/***************************************************************************
 * We did not find the color we were looking for.  Let's see if there is
 * room to add it.
 ***************************************************************************/
void 
SetColorIndex(LPBITMAPINFO_NEW lpbi, lulong color, lushort NumColors, lulong *IconColors, BOOL *ColorsUsed)
{
	BOOL found;
	lushort i;

	// look for a black one.
	i = 0;
	found = FALSE;
	while (!found && i < NumColors)
	{
		if (IconColors[i] == 0)
			found = TRUE;
		i++;
	}

	// look for a duplicate black one.
	found = FALSE;
	while (!found && i < NumColors)
	{
		if ((IconColors[i] == 0) && !ColorsUsed[i])
			found = TRUE;
		else 
			i++;
	}

	if (found)
	{
		// We found a space to put the new color, reflect it in our array.
		IconColors[i] = color;

		// Write the change to the bitmap.
		SetIconColors(lpbi, i, color);
	}
}

/***************************************************************************
 * This is for monochrome bitmaps.
 ***************************************************************************/
void 
SetBit(LPBITMAPINFO_NEW lpbi, lulong *IconColors, lulong color, lushort NumColors, lushort x, lushort y)
{
	lushort bite, pixel, width;
	BYTE mask, bit;
	BYTE *lpBits;
	BYTE *pBite;
	BYTE ColorIndex;

	// Calculate the real width in pixels.
	width = 
		((lushort)lpbi->BMIHEADER_BISIZEIMAGE / 
			(lushort)lpbi->BMIHEADER_BIHEIGHT) * 8;

	pixel = y * width + x;		// which pixel
	bite = pixel / 8;			// which byte
	bit = (BYTE) (pixel % 8);	// which bit

	// Now that we have figured out which nibble was affected.  Change it.
	// Find the index into the color table that will go in the nibble.
	ColorIndex = GetColorIndex(lpbi, color, IconColors, NumColors, 
							(BOOL *)NULL);

	// First get a pointer into the DIB.
	lpBits = (BYTE *)lpbi + (lsshort)lpbi->BMIHEADER_BISIZE 
										+ DIBPaletteSize(lpbi);
	pBite = lpBits + bite;

	switch (bit)
	{
		case 0:	// the first bit in the byte
			mask = 0x7F;
			break;
		case 1:	// the second bit in the byte
			mask = 0xBF;
			break;
		case 2:
			mask = 0xDF;
			break;
		case 3:
			mask = 0xEF;
			break;
		case 4:
			mask = 0xF7;
			break;
		case 5:
			mask = 0xFB;
			break;
		case 6:
			mask = 0xFD;
			break;
		case 7:
			mask = 0xFE;
			break;
	}
	*pBite = (BYTE)(*pBite & mask) + (BYTE)(ColorIndex << (7 - bit));
	return;
}

/***************************************************************************
 * This is for 4 bit per pixel bitmaps.  That is 16 colors.
 ***************************************************************************/
void 
SetNibble(LPBITMAPINFO_NEW lpbi, lulong *IconColors, lulong color, lushort NumColors, lushort x, lushort y, BOOL *ColorsUsed)
{
	lushort bite, nibble, pixel, width;
	BYTE *lpBits;
	BYTE *pBite;
	BYTE ColorIndex;

	// Calculate the real width in pixels.
	width = ((lushort)lpbi->BISIZEIMAGE / 
		(lushort)lpbi->BIHEIGHT) * 2;

	pixel = y * width + x;	// which pixel
	bite = pixel / 2;								// which byte
	nibble = pixel % 2;								// which nibble

	// Now that we have figured out which nibble was affected.  Change it.
	// Find the index into the color table that will go in the nibble.
	ColorIndex = GetColorIndex(lpbi, color, IconColors, NumColors, ColorsUsed);

	// First get a pointer into the DIB.
	lpBits = (BYTE *)lpbi + (lsshort)lpbi->BISIZE + DIBPaletteSize(lpbi);
	pBite = lpBits + bite;
	if (nibble == 0)
		*pBite = (BYTE)(*pBite & 0x0F) + (BYTE)(ColorIndex << 4);
	else
		*pBite = (BYTE)(*pBite & 0xF0) + (BYTE)ColorIndex;

	return;
}

/***************************************************************************
 * This is for 8 bits per pixel bitmaps.  That is 256 colors.
 ***************************************************************************/
void 
SetByte(LPBITMAPINFO_NEW lpbi, lulong *IconColors, lulong color, lushort NumColors, 
			lushort x, lushort y, BOOL *ColorsUsed)
{
	lushort bite, width;
	BYTE *lpBits;
	BYTE *pBite;
	BYTE ColorIndex;

	// Calculate the real width in pixels.
	width = ((lushort)lpbi->BMIHEADER_BISIZEIMAGE / (lushort)lpbi->BMIHEADER_BIHEIGHT);

	bite = y * width + x;	// which pixel

	// Now that we have figured out which byte was affected.  Change it.
	// Find the index into the color table that will go in the nibble.
	ColorIndex = GetColorIndex(lpbi, color, IconColors, NumColors, ColorsUsed);

	// First get a pointer into the DIB.
	lpBits = (BYTE *)lpbi + (lsshort)lpbi->BMIHEADER_BISIZE 
										+ DIBPaletteSize(lpbi);
	pBite = lpBits + bite;
	*pBite = (BYTE)ColorIndex;

	return;
}

/***************************************************************************
 * This is for 24 bit per pixel bitmaps.
 ***************************************************************************/
void 
SetDWord(LPBITMAPINFO_NEW lpbi, lulong color, lushort x, lushort y)
{
	lushort bite, width;
	BYTE *lpBits;
	BYTE *pBite;

	// Calculate the real width in pixels.
	width = 
		((lushort)lpbi->BMIHEADER_BISIZEIMAGE / 
				(lushort)lpbi->BMIHEADER_BIHEIGHT);

	bite = (y * width) + (x * 3);	// which pixel

	// First get a pointer into the DIB.
	lpBits = (BYTE *)lpbi + (lsshort)lpbi->BMIHEADER_BISIZE 
										+ DIBPaletteSize(lpbi);
	pBite = lpBits + bite;
	*pBite = (BYTE)((color & 0x00FF0000) >> 16);
	*(pBite+1) = (BYTE)((color & 0x0000FF00) >> 8);
	*(pBite+2) = (BYTE)(color & 0x000000FF);

	return;
}

/***************************************************************************
 ***************************************************************************/
lushort 
WhichPixelClicked(EDITCUSTOMICON *TmpPtr, HWND hWnd, lushort x, lushort y, 
						lushort WhichButton)
{
	HPS hDC, hps;
	lushort i, j;
	LPBITMAPINFO_NEW lpbi;
	lulong Color;
	POINTL	ptl;

	if (TmpPtr->hDIB == 0)
		return FALSE;

	if ((x < TmpPtr->ZoomedOffset.x) 
		|| ( x >= (TmpPtr->ZoomedOffset.x + TmpPtr->ZoomedSize.x))
		|| (y < TmpPtr->ZoomedOffset.y) 
		|| ( y >= (TmpPtr->ZoomedOffset.y + TmpPtr->ZoomedSize.y)))
	{
		// Mouse was not in the editable part of the window.
		// Notice they are not able to edit the first row or column or
		// the last two rows or columns.
		return FALSE;
	}

	// The click was in the editable part of the bitmap. 
	// Figure out which "pixel" was clicked.

	// Subtract the offset from x and y to make them map to the top of the icon
	x = x - TmpPtr->ZoomedOffset.x;
	y = y - TmpPtr->ZoomedOffset.y;

	// Dived by the scale to get the pixel.
	x = x / TmpPtr->Scale;
	y = y / TmpPtr->Scale;

	if (TmpPtr->MButtonsSwapped)
		WhichButton = !WhichButton;

	if (WhichButton)
		Color = TmpPtr->RColor;
	else
		Color = TmpPtr->LColor;

	// Update the DIB in memory.
	lpbi = (LPBITMAPINFO_NEW)TmpPtr->hDIB;
	switch (lpbi->BIBITCOUNT)
	{
		case 1:
			SetBit(lpbi, TmpPtr->IconColors, Color, TmpPtr->NumColors, x, y);
			break;
		case 4:
			SetNibble(lpbi, TmpPtr->IconColors, Color, TmpPtr->NumColors, x, y,
					 TmpPtr->ColorsUsed);
			break;
		case 8:
			SetByte(lpbi, TmpPtr->IconColors, Color, TmpPtr->NumColors, x, y, 
					TmpPtr->ColorsUsed);
			break;
		case 24:
			SetDWord(lpbi, Color, x, y);
			break;
	}

	// Update the picture on the screen.
	hDC = WinGetPS(hWnd);
	GpiCreateLogColorTable(hDC, 0L, LCOLF_RGB, 0L, 0, NULL);
	GpiSetColor(hDC, Color);
	x = x * TmpPtr->Scale + TmpPtr->ZoomedOffset.x;
	y = y * TmpPtr->Scale + TmpPtr->ZoomedOffset.y;
	for (i = x; i < x + TmpPtr->Scale; i++)
	{
		for (j = y; j < y + TmpPtr->Scale; j++)
		{
			ptl.x = i;
			ptl.y = j;
			// May need to change color here somewhere
			GpiSetPel(hDC, &ptl);
		}
	}

	WinReleasePS(hDC);

	TmpPtr->CurrentDIBChanged = TRUE;

	return TRUE;
}

/***************************************************************************
***************************************************************************/
MRESULT EXPENTRY
IconControlProc(HWND hwnd, lulong message, MPARAM mp1, MPARAM mp2)
{
	HPS hps;
	HWND hCtl;
	RECTL	rect;
	lsshort id;
	MainWindow *pWindow;
	lushort	wParam;
	HWND	hdlg;

	wParam = SHORT1FROMMP(mp1);
	hdlg = WinQueryWindow(hwnd, QW_PARENT);
	switch (message) 
	{
		case WM_PAINT:
			pWindow = (MainWindow *)GetPointer(WinWindowFromID
				(WinQueryWindow(hdlg, QW_OWNER), FID_CLIENT));
			hps = WinBeginPaint(hwnd, NULL, &rect);
			wParam = WinQueryWindowUShort(hwnd, QWS_ID);	

			if (wParam == ID_STATIC2)
			{
				// The coordinates used in the dialog box 
				// for this control are critical here.
				DrawZoomedBitmap(pWindow->GetTmpPtr(), hps);
			}
			else if (wParam == ID_STATIC3)
			{
				DrawActualBitmap(pWindow->GetTmpPtr(), hps);
			}
			else if (wParam == ID_STATIC4)
			{
				DrawMouseBitmap(hps);
				DrawMouseButtons(pWindow->GetTmpPtr(), hps, hwnd);
			}
			WinEndPaint(hps);
			break;

		case WM_BUTTON1DOWN:
			Lmousedown = TRUE;
		case WM_BUTTON2DOWN:		// right button on 2 button mouse
		case WM_BUTTON3DOWN:		// right button on a 3 button mouse
			if (!Lmousedown)
				Rmousedown = TRUE;
			WinSetCapture(HWND_DESKTOP, hwnd);	
			id = WinQueryWindowUShort(hwnd, QWS_ID);
			if (id == ID_STATIC2)
			{
				pWindow = (MainWindow *)GetPointer(WinWindowFromID
					(WinQueryWindow(hdlg, QW_OWNER), FID_CLIENT));
				if (WhichPixelClicked(pWindow->GetTmpPtr(), hwnd,
					SHORT1FROMMP(mp1), SHORT2FROMMP(mp1), 
					message == WM_BUTTON1DOWN ? 0 : 1))
				{
					// Update the little one
					hCtl = WinWindowFromID(WinQueryWindow(hwnd, QW_PARENT), 
						ID_STATIC3);
					WinInvalidateRect(hCtl, NULL, FALSE);
				}
			}
			break;

		case WM_BUTTON1UP:
		case WM_BUTTON2UP:
		case WM_BUTTON3UP:
			Lmousedown = Rmousedown = FALSE;
			WinSetCapture(HWND_DESKTOP, NULL);	
			break;

		case WM_MOUSEMOVE:
			if ((WinQueryCapture(HWND_DESKTOP) == hwnd) 
				&& Lmousedown || Rmousedown) 
			{
				id = WinQueryWindowUShort(hwnd, QWS_ID);
				if (id == ID_STATIC2)
				{
					pWindow = (MainWindow *)GetPointer(WinWindowFromID
						(WinQueryWindow(hdlg, QW_OWNER), FID_CLIENT));
					if (WhichPixelClicked(pWindow->GetTmpPtr(), hwnd, 
							SHORT1FROMMP(mp1), SHORT2FROMMP(mp1), 
							Lmousedown ? 0 : 1))
					{
						// Update the little one
						hCtl = WinWindowFromID(
							WinQueryWindow(hwnd, QW_PARENT), ID_STATIC3);
						WinInvalidateRect(hCtl, NULL, FALSE);
					}
				}
			}
			break;

		default:
			return WinDefWindowProc(hwnd, message, mp1, mp2);
	}
	return (MRESULT)FALSE;
}

/***************************************************************************
***************************************************************************/
void 
DrawIconFrame(HPS hdc,POINTL Offset,lushort Width,lushort Height,lushort Scale)
{
	RECTL rect;
	LONG GrayPen,WhitePen,OldPen;
	lushort i, OuterBorder;
	POINTL	pt;
	lushort	ReflectY;

	if (Scale >  1)
		OuterBorder = Scale + 1;
	else
		OuterBorder = Scale;
	rect.xLeft = Offset.x;
	rect.xRight = Offset.x + Width ;
	rect.yBottom = Offset.y;
	rect.yTop = Offset.y + Height ;

	OldPen = GpiQueryColor(hdc);
	GpiSetColor(hdc, CLR_DARKGRAY);
	for (i = 0; i < Scale; i++)
	{
		pt.x = rect.xRight + i;
		pt.y = rect.yTop;
		GpiMove(hdc, &pt);
		// have to subtract an extra 1 because PM draws from bottom -- up
		// not from top -- down
		pt.y = rect.yBottom - i - 1;
		GpiLine(hdc, &pt);
		pt.x = rect.xLeft;
		pt.y = rect.yBottom - i - 1;
		GpiLine(hdc, &pt);
	}

	// this paints the gray along right and bottom past the first layer
	// of border that is the width of scale
	for (i = 0; i < OuterBorder; i++)
	{
		pt.x = rect.xRight + Scale + i;
		pt.y = rect.yTop + Scale;
		GpiMove(hdc, &pt);
		pt.y = rect.yBottom - Scale - i - 1;
		GpiLine(hdc, &pt);
		pt.x = rect.xLeft - Scale;
		pt.y = rect.yBottom - Scale - i - 1;
		GpiLine(hdc, &pt);
	}

	GpiSetColor(hdc, CLR_WHITE);

	for (i = 0; i < Scale; i++)
	{
		pt.x = rect.xLeft - Scale + i;
		pt.y = rect.yBottom - Scale;
		GpiMove(hdc, &pt);
		pt.y = rect.yTop + Scale - i;
		GpiLine(hdc, &pt);
		pt.x = rect.xRight + Scale;
		pt.y = rect.yTop + Scale - i;
		GpiLine(hdc, &pt);
	}

	pt.x = rect.xLeft - Scale + i;
	pt.y = rect.yTop + Scale - i;
	GpiMove(hdc, &pt);
	pt.x = rect.xRight + Scale;
	pt.y = rect.yTop + Scale - i;
	GpiLine(hdc, &pt);

	GpiSetColor(hdc, OldPen);
}

/***************************************************************************
***************************************************************************/
// Draw the mouse in the dialog box. We display the colors for the
// left and right mouse buttons in the mouse bitmap.
void 
DrawMouseBitmap(HPS hDC)
{
	BITMAP Bitmap;
	LHANDLE hBitmap, hOldBitmap;
	HPS hMemDC;

	if ((hBitmap = GpiLoadBitmap(hDC, NULL, RS_BMP_MOUSE,
			(LONG)NULL, (LONG)NULL)) == LNULL)
		return;

	hMemDC = CreateCompatibleDC(hDC); 		// Create compatible memory dc.
	hOldBitmap = GpiSetBitmap(hMemDC, hBitmap); // Select the bitmap into dc
	
	// Get bitmap info.
	GetBitmapObject(hBitmap, sizeof(BITMAP), (LPSTR)&Bitmap);	

	// Paint it.
	BitBlt(hDC, 0, 0, Bitmap.BMWIDTH, Bitmap.BMHEIGHT, hMemDC, 0, 0, SRCCOPY);

	GpiSetBitmap(hMemDC, hOldBitmap);	// restore the old bitmap
	GpiDeleteBitmap(hBitmap);			// delete the bitmap
	DeleteDC(hMemDC);					// delete the dc
}

/***************************************************************************
***************************************************************************/
// Fill in the left and right buttons on the mouse bitmap that is displayed.
// If you choose to add a color bar, the colors selected from the color bar will
// be displayed in this mouse bitmap.
void 
DrawMouseButtons(EDITCUSTOMICON *TmpPtr, HPS hps, HWND hwnd)
{
	POINTL	ptl;
	lushort i, j;

	(void)hwnd;

	if (TmpPtr->hDIB == 0)
		return;

	GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0, NULL);
	GpiSetColor(hps, TmpPtr->LColor);
	// Show mouse left button with the left color
	for (i = 8; i < 19; i++)
		for (j = 38; j > 30; j--)
		{
			ptl.x = i;
			ptl.y = j;
			GpiSetPel(hps, &ptl);
		}

	// Show mouse right button with the right color
	GpiSetColor(hps, TmpPtr->RColor);
	for (i = 20; i < 30; i++)
		for (j = 38; j > 30; j--)
		{
			ptl.x = i;
			ptl.y = j;
			// color should be TmpPtr->RColor
			GpiSetPel(hps, &ptl);
		}
}

/***************************************************************************
***************************************************************************/
LHANDLE 
CreateBorderLessDIB(HBITMAP hBitmap)
{
	HBITMAP NoBorderBitmap,Old1,Old2;
	HPS MemDC1,MemDC2,ScreenDC;
	BITMAP bm;
	LHANDLE hDIB;

	GetBitmapObject(hBitmap, sizeof(BITMAP), (LPSTR)&bm);
	if (!(ScreenDC = WinGetScreenPS(HWND_DESKTOP)))
		return NULL;
	if (!(MemDC1 = CreateCompatibleDC(ScreenDC)))
	{
		WinReleasePS(ScreenDC);
		return NULL;
	}
	if (!(NoBorderBitmap = 
		CreateCompatibleBitmap(ScreenDC,bm.BMWIDTH - 3, bm.BMHEIGHT - 3)))
	{
		WinReleasePS(ScreenDC);
		DeleteDC(MemDC1);
		return NULL;
	}
	WinReleasePS(ScreenDC);
	if (HBM_ERROR == (Old1 = GpiSetBitmap(MemDC1,NoBorderBitmap)))
	{
		DeleteDC(MemDC1);
		return NULL;
	}
	if (!(MemDC2 = CreateCompatibleDC(MemDC1)))
	{
		GpiSetBitmap(MemDC1,Old1);
		DeleteDC(MemDC1);
		return NULL;
	}
	if (HBM_ERROR == (Old2 = GpiSetBitmap(MemDC2,hBitmap)))
	{
		GpiSetBitmap(MemDC1,Old1);
		DeleteDC(MemDC1);
		DeleteDC(MemDC2);
		return NULL;
	}
	BitBlt(MemDC1,0,0,bm.BMWIDTH - 3,bm.BMHEIGHT - 3,MemDC2,1,2,SRCCOPY);
	GpiSetBitmap(MemDC2,Old2);
	DeleteDC(MemDC2);
	GpiSetBitmap(MemDC1,Old1);
	DeleteDC(MemDC1);

	// Convert the bitmap into a Device Independent Bitmap.
	hDIB = DIBFromBitmap(NoBorderBitmap, BI_RGB, 0);
	GpiDeleteBitmap(NoBorderBitmap);
	return hDIB;
}

void
SetDefaultFile(HMANAGER manager,lubyte * pathname)
{
	// iconstub.tbl
	IconBarSetDefaultFile(manager,pathname);
}
void
SetDefaultSMIFile(HMANAGER manager,lubyte * path)
{
	// default.smi (could be system-wide, could be read-only)
	IconBarSetDefaultSMIPath(manager, path);
}
