#ifndef IBMACRO_H
#define IBMACRO_H

typedef  HWND 			HMANAGER;
typedef  HWND			HPARENT;
typedef  HWND			HWINDOW;
typedef  LHANDLE		HRESOURCE;
typedef  LHANDLE		HMEMORY;
typedef  HBITMAP		HGRAPHIC;
typedef  int 			RESOURCEOFFSET;
typedef  HWND			HICONBAR;
typedef  lfpbyte		LPUSERDATA;

// This must NOT be changed because this is the fixed field length for
// Windows ini and configuration icon slot records!!!
#define LEN_PATH				82

#define LEN_HELP				121
#define	INIDESCRIPTION_SIZE		16


typedef struct tagIBHITTEST
{
	LONG lParam;
	int wParam;
	LHANDLE Window;
} IBHITTEST;

typedef IBHITTEST far *LPIBHITTEST;

typedef struct tagSTANDARDICON
{
	int 		ActionID;
	HRESOURCE 	Library;
} STANDARDICON;

typedef STANDARDICON far *LPSTANDARDICON;

typedef struct tagCUSTOMICON
{
	CHAR 		CustomPath[LEN_PATH];
	CHAR		MacroPath[LEN_PATH];
} CUSTOMICON;

typedef CUSTOMICON far *LPCUSTOMICON;

/* PROCS	*/
typedef HMEMORY (cdecl *FARALLOCPROC)(lulong);
typedef lulong (cdecl *FARREALLOCPROC)(HMEMORY,lulong);
typedef lubyte *(cdecl *FARLOCKPROC)(HMEMORY);
typedef BOOL (cdecl *FARUNLOCKPROC)(HMEMORY);
typedef BOOL (cdecl *FARFREEPROC)(HMEMORY);
typedef lulong (cdecl *FARSIZEPROC)(HMEMORY);
typedef lulong EXPENTRY _export (*FARMESSAGEPROC)(HWND, HWND, HWND, lulong,
						MPARAM, MPARAM);

typedef struct tagICONPROC
{
	FARALLOCPROC	MemoryAlloc;		
	FARREALLOCPROC	MemoryReAlloc;		
	FARLOCKPROC		MemoryLock;		
	FARUNLOCKPROC	MemoryUnlock;		
	FARSIZEPROC		MemorySize;
	FARFREEPROC		MemoryFree;		
	FARMESSAGEPROC	MessageProc;		
}ICONPROC;

typedef ICONPROC *PICONPROC;
typedef ICONPROC NEAR *NPICONPROC;
typedef ICONPROC far *LPICONPROC;


/* Messages.	*/
#define 	IB_SETPROCS						WM_USER + 1
#define 	IB_PAINT						WM_USER + 2
#define 	IB_SHOW							WM_USER + 3
#define 	IB_HIDE							WM_USER + 4
#define		IB_SETSCREENPOSITION			WM_USER + 5
#define		IB_SETPOSITION					WM_USER + 6
#define		IB_SETRESOURCE					WM_USER + 7
#define		IB_HOSTSIZECHANGED				WM_USER + 8
#define		IB_SETCONFIGURATIONPATH			WM_USER + 9
#define		IB_SELECTCONFIGURATION			WM_USER + 10
#define		IB_LOADCONFIGURATION			WM_USER + 11
#define		IB_CONFIGURE					WM_USER + 12
#define		IB_GETICONSTATE					WM_USER + 13
#define		IB_GETICONACTIONID				WM_USER + 14
#define		IB_SETCUSTOMPATH				WM_USER + 15
#define		IB_SELECTSTANDARDICON			WM_USER + 16
#define		IB_SELECTCUSTOMICON				WM_USER + 17
#define		IB_REPLACEWITHSTANDARDICON		WM_USER + 18
#define		IB_REPLACEWITHCUSTOMICON		WM_USER + 19
#define		IB_DESELECTCONFIGURATION		WM_USER + 20
#define		IB_ENUMCONFIGURATIONS			WM_USER + 21
#define		IB_GETCONFIGURATIONDESCRIPTION	WM_USER + 22
#define		IB_SELECTCONFIGURATIONBYDESC 	WM_USER + 23
#define		IB_MAKEICONDEPRESSIBLE			WM_USER + 24
#define		IB_DESELECTICON					WM_USER + 25
#define		IB_ENUMICONS					WM_USER + 26
#define		IB_MAKEICONNOTDEPRESSIBLE		WM_USER + 27
#define		IB_SETROWSPACING				WM_USER + 28
#define		IB_SETNUMBERROWS				WM_USER + 29
#define		IB_CREATEICONBAR				WM_USER + 30
#define		IB_ADDICON						WM_USER + 31
#define		IB_MAKEDIALOGICONBAR			WM_USER + 32
#define		IB_SETSIZE						WM_USER + 33
#define		IB_SHOWSTANDARDICON				WM_USER + 34
#define		IB_GETMACRO						WM_USER + 35
#define		IB_GETDESCRIPTION				WM_USER + 36
#define		IB_SETMACRO						WM_USER + 37
#define		IB_SETDESCRIPTION				WM_USER + 38
#define		IB_SETDEFAULTFILE				WM_USER + 39
#define		IB_GETCUSTOMICONPATH			WM_USER + 40
#define		IB_GETSTATE						WM_USER + 41
#define		IB_GETSCREENPOSITION			WM_USER + 42
#define		IB_GETPOSITION					WM_USER + 43
#define		IB_ENABLE						WM_USER + 44
#define		IB_DISABLE						WM_USER + 45
#define		IB_DESTROYICONBAR				WM_USER + 46
#define		IB_TURNOFFTITLEBAR				WM_USER + 47
#define		IB_TURNONTITLEBAR				WM_USER + 48
#define		IB_TURNOFFSCALING				WM_USER + 49
#define		IB_TURNONSCALING				WM_USER + 50
#define		IB_TURNOFFFILESAVE				WM_USER + 51
#define		IB_TURNONFILESAVE				WM_USER + 52
#define		IB_SELECTLOADCONFIG				WM_USER + 53
#define		IB_SETCUSTOMBITS				WM_USER + 55
#define		IB_GETBITMAP					WM_USER + 56
#define		IB_NEWCUSTOMICON				WM_USER + 57
#define		IB_SETCUSTOMICONPATH			WM_USER + 58
#define		IB_SELECTCHOSENICON				WM_USER + 59
#define		IB_SHOWCUSTOMICON				WM_USER + 60
#define		IB_REMOVEICON					WM_USER + 61
#define		IB_GETLASTRECT					WM_USER + 62
#define		IB_GETRESOURCELIBRARY			WM_USER + 63
#define		IB_GETICONSIZE					WM_USER + 64
#define		IB_NEWSTANDARDICON				WM_USER + 65
#define		IB_TURNONWINCLOSEBOX			WM_USER + 66
#define		IB_TURNOFFWINCLOSEBOX			WM_USER + 67
#define		IB_TURNONTHICKFRAMES			WM_USER + 68
#define		IB_TURNOFFTHICKFRAMES			WM_USER + 69
#define		IB_DEPRESSICON					WM_USER + 70
#define		IB_LETUPICON					WM_USER + 71
#define		IB_GETCONFIGFILEPATH			WM_USER + 72
#define		IB_TURNONONEHELP				WM_USER + 73
#define		IB_TURNOFFONEHELP				WM_USER + 74
#define		IB_SETPRIMITIVE					WM_USER + 75
#define		IB_SETCACHE						WM_USER + 76
#define		IB_SETDEFAULTSMIPATH			WM_USER + 77

/* Manager Macros.	*/

#define IconBarCreateManager(Parent,hab) \
	((HWND)WinCreateWindow(Parent, (PSZ)"Manager03", (PSZ)NULL, \
		0, 0, 0, 0, 0, \
		Parent, HWND_BOTTOM, (ULONG)0, (PVOID)0, (PVOID)NULL))

#define	IconBarSetProcs(Manager,Procs)	\
			((BOOL)WinSendMsg(Manager, IB_SETPROCS, 0, Procs))

#define IconBarCreate(Manager,Parent) \
			((HICONBAR)WinSendMsg(Manager,IB_CREATEICONBAR,0,(MPARAM)Parent))

#define	IconBarSetResource(Manager,Path,Offset)	\
			((lbool)WinSendMsg(Manager, IB_SETRESOURCE, (MPARAM)Offset,\
						(MPARAM)(lfpbyte)Path))

#define	IconBarHostSizeChange(Manager)	\
			((lbool)WinSendMsg(Manager,IB_HOSTSIZECHANGED,0,0L))

#define	IconBarSetConfigPath(Manager,RegNumber,Path)	\
 			((lbool)WinSendMsg(Manager,IB_SETCONFIGURATIONPATH, \
					(MPARAM)RegNumber, (MPARAM)(lfpbyte)Path))

#define	IconBarSelectConfig(Manager,Name)	\
				((BOOL)WinSendMsg(Manager,IB_SELECTCONFIGURATION,0, \
						(MPARAM)(lfpbyte)Name))

#define	IconBarGetIconState(Manager)	\
				(BOOL)(WinSendMsg(Manager,IB_GETICONSTATE,0,0))

#define	IconBarGetIconActionID(Manager)	\
				((int)WinSendMsg(Manager,IB_GETICONACTIONID,0,0))

#define	IconBarSetCustomPath(Manager,Path)	\
				((BOOL)WinSendMsg(Manager,IB_SETCUSTOMPATH,0, \
					MPFROMP((lfpbyte)Path)))

#define	IconBarSelectStandardIcon(Manager,MenuID, Resource)	\
				((BOOL)WinSendMsg(Manager,IB_SELECTSTANDARDICON, \
				(MPARAM)MenuID, Resource))

#define	IconBarSelectCustomIcon(Manager,CustomStrings)	\
				((BOOL)WinSendMsg(Manager,IB_SELECTCUSTOMICON,0 \
					,MPFROMLONG((LPCUSTOMICON)CustomStrings)))

#define	IconBarChangeToStandardIcon(Manager,MenuID, Resource)	\
				((BOOL)WinSendMsg(Manager,IB_REPLACEWITHSTANDARDICON, \
				(MPARAM)MenuID, Resource))

#define	IconBarChangeToCustomIcon(Manager,CustomStrings)	\
				((BOOL)WinSendMsg(Manager,IB_REPLACEWITHCUSTOMICON,0 \
					,MPFROMLONG((LONG)(lfpbyte)CustomStrings)))

#define	IconBarDeselectConfig(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_DESELECTCONFIGURATION,0,0))

#define	IconBarEnumConfig(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_ENUMCONFIGURATIONS,0,0))

#define	IconBarGetConfigDesc(Manager)	\
				((lfpbyte)WinSendMsg(Manager,IB_GETCONFIGURATIONDESCRIPTION,0 \
						, 0))

#define	IconBarSelectConfigByDesc(Manager,Description)	\
				((BOOL)WinSendMsg(Manager,IB_SELECTCONFIGURATIONBYDESC,0, \
						(MPARAM)(lfpbyte)Description))

#define	IconBarMakeIconDepressible(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_MAKEICONDEPRESSIBLE,0,0))

#define	IconBarMakeIconNotDepressible(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_MAKEICONNOTDEPRESSIBLE,0,0))

#define	IconBarDeselectIcon(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_DESELECTICON,0,0))

#define	IconBarEnumIcons(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_ENUMICONS,0,0))

#define IconBarGetMacro(Manager)	\
				((lfpbyte)WinSendMsg(Manager,IB_GETMACRO, (MPARAM)(int)0,0))

#define IconBarGetDescription(Manager)	\
				((lfpbyte)WinSendMsg(Manager,IB_GETDESCRIPTION, (MPARAM)(int)0,0))

#define IconBarSetMacro(Manager,Macro)	\
				((lfpbyte)WinSendMsg(Manager,IB_SETMACRO, (int)0, \
					(MPARAM)(LONG)(lfpbyte)Macro))

#define IconBarSetDescription(Manager,Description)	\
				((lfpbyte)WinSendMsg(Manager,IB_SETDESCRIPTION, (int)0, \
						(MPARAM)(lfpbyte)Description))

#define IconBarSetDefaultFile(Manager,File)	\
				((BOOL)WinSendMsg(Manager,IB_SETDEFAULTFILE, (int)0, \
						(MPARAM)(lfpbyte)File))

#define IconBarSetDefaultSMIPath(Manager,File)	\
				((BOOL)WinSendMsg(Manager,IB_SETDEFAULTSMIPATH, (int)0, \
						(MPARAM)(lfpbyte)File))

#define IconBarGetCustomIconPath(Manager)	\
				((lfpbyte)WinSendMsg(Manager,IB_GETCUSTOMICONPATH, (MPARAM)(int)0,0))

#define IconBarDestroyManager(Manager)	\
				WinDestroyWindow(Manager)
 
#define IconBarSetCustomBits(Manager,Bits)	\
				((BOOL)WinSendMsg(Manager,IB_SETCUSTOMBITS, (MPARAM)0, \
						(MPARAM)(lfpbyte)Bits))
 
#define IconBarGetBitmap(Manager)	\
				((HBITMAP)WinSendMsg(Manager,IB_GETBITMAP, (MPARAM)0, 0))
 
#define IconBarNewCustomIcon(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_NEWCUSTOMICON, (MPARAM)0, 0))
 
#define IconBarNewStandardIcon(Manager,ResourceID,lpStIcon)	\
				((BOOL)WinSendMsg(Manager,IB_NEWSTANDARDICON,(MPARAM)ResourceID \
					, (MPARAM)(LONG)(LPSTANDARDICON)lpStIcon))
 
#define IconBarSetCustomIconPath(Manager,Path,New)	\
				((BOOL)WinSendMsg(Manager,IB_SETCUSTOMICONPATH, (MPARAM)New, \
						(MPARAM)(lulong)(lfpbyte)Path))
 
#define IconBarRemoveIcon(Manager)	\
				((BOOL)WinSendMsg(Manager,IB_REMOVEICON, (MPARAM)0, 0))
 
#define IconBarGetResourceLibrary(Manager)	\
				((HRESOURCE)WinSendMsg(Manager,IB_GETRESOURCELIBRARY, \
					(MPARAM)0, 0))

#define IconBarGetIconSize(Manager,Pt)	\
				((BOOL)WinSendMsg(Manager,IB_GETICONSIZE, (MPARAM)0, \
					(MPARAM)(lulong)(lplpoint)Pt))

/* IconBar Macros */

#define	IconBarPaint(Manager, IconBar)	\
			((BOOL)WinSendMsg(Manager,IB_PAINT, (MPARAM)IconBar,0L))

#define	IconBarShow(Manager, IconBar)	\
			((BOOL)WinSendMsg(Manager,IB_SHOW, (MPARAM)IconBar,0L))

#define	IconBarHide(Manager, IconBar)	\
				((BOOL)WinSendMsg(Manager,IB_HIDE, (MPARAM)IconBar,0L))

#define	IconBarSetPositionType(Manager,IconBar,Type)	\
			((BOOL)WinSendMsg(Manager,IB_SETPOSITION, (MPARAM)IconBar,Type))

#define	IconBarSetPosition(Manager, IconBar,Point)	\
			((BOOL)WinSendMsg(Manager,IB_SETSCREENPOSITION \
				,(MPARAM)IconBar,(MPARAM)(lulong)(PPOINTL)Point))

#define	IconBarSetSize(Manager,IconBar,BarRect)	\
			((BOOL)WinSendMsg(Manager,IB_SETSIZE \
				,(MPARAM)IconBar,(MPARAM)(lulong)(PRECTL)BarRect))

#define	IconBarLoadConfig(Manager,IconBar)	\
			((BOOL)WinSendMsg(Manager, IB_LOADCONFIGURATION,(MPARAM)IconBar,0))

#define	IconBarConfigure(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager,IB_CONFIGURE, \
					(MPARAM)IconBar,0))

#define	IconBarSetRowSpacing(Manager,IconBar,Spacing)	\
				((BOOL)WinSendMsg(Manager,IB_SETROWSPACING \
					,(MPARAM)IconBar,(MPARAM)Spacing))

#define	IconBarSetNumberRows(Manager,IconBar,NumRows)	\
				((BOOL)WinSendMsg(Manager,IB_SETNUMBERROWS,\
					(MPARAM)IconBar,(MPARAM)NumRows))

#define IconBarAddIcon(Manager,IconBar,Position)	\
				((BOOL)WinSendMsg(Manager,IB_ADDICON, \
					(MPARAM)IconBar,(MPARAM)Position))

#define IconBarMakeDialogIconBar(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager,\
						IB_MAKEDIALOGICONBAR,(MPARAM)IconBar,0))

#define IconBarShowStandardIcon(Manager,IconBar,StandardIcon)	\
				((BOOL)WinSendMsg(Manager,	\
						IB_SHOWSTANARDICON, (MPARAM)IconBar, \
						(MPARAM)(lulong)(LPSTANDARDICON)StandardIcon))

#define IconBarShowCustomIcon(Manager,IconBar,CustomIcon)	\
				((BOOL)WinSendMsg(Manager,	\
						IB_SHOWCUSTOMICON, (MPARAM)IconBar, \
						(MPARAM)(LONG)(LPCUSTOMICON)CustomIcon))

#define IconBarGetState(Manager,IconBar)	\
				(WinSendMsg(Manager,IB_GETSTATE, \
						(MPARAM)IconBar,0))

#define IconBarGetPosition(Manager, IconBar,BarRect)	\
				(WinSendMsg(Manager,	IB_GETSCREENPOSITION, \
						(MPARAM)IconBar,(MPARAM)(PRECTL)BarRect))

#define IconBarGetPositionType(Manager,IconBar)	\
				((BYTE)WinSendMsg(Manager,IB_GETPOSITION, \
						(MPARAM)IconBar,0))

#define IconBarEnable(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager, IB_ENABLE, \
						(MPARAM)IconBar,0))

#define IconBarDisable(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager, IB_DISABLE, \
						(MPARAM)IconBar,0))

#define IconBarDestroy(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager, \
						IB_DESTROYICONBAR, (MPARAM)IconBar,0))

#define IconBarTurnOffSystemBar(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager, \
						IB_TURNOFFTITLEBAR, (MPARAM)IconBar,0))

#define IconBarTurnOnSystemBar(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager,\
						IB_TURNONTITLEBAR, (MPARAM)IconBar,0))

#define IconBarTurnOffScaling(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager,\
						IB_TURNOFFSCALING, (MPARAM)IconBar,0))

#define IconBarTurnOnScaling(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager,\
						IB_TURNONSCALING, (MPARAM)IconBar,0))

#define IconBarTurnOffFileSave(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager,\
						IB_TURNOFFFILESAVE, (MPARAM)IconBar,0))

#define IconBarTurnOnFileSave(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager, \
						IB_TURNONFILESAVE, (MPARAM)IconBar,0))

#define	IconBarSelectLoadedConfig(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager, \
						IB_SELECTLOADCONFIG, (MPARAM)IconBar,0))

#define	IconBarSelectChosenIcon(Manager,IconBar)	\
				((BOOL)WinSendMsg(Manager, \
						IB_SELECTCHOSENICON, (MPARAM)IconBar,(MPARAM)0))

#define	IconBarGetLastRect(Manager,IconBar,lpRect)	\
				((BOOL)WinSendMsg(Manager, \
						IB_GETLASTRECT, (MPARAM)IconBar,(MPARAM)lpRect))

#define	IconBarTurnOnWinCloseBox(Manager, IconBar)	\
				((BOOL)WinSendMsg(Manager, \
						IB_TURNONWINCLOSEBOX, (MPARAM)IconBar,(MPARAM)0))

#define	IconBarTurnOffWinCloseBox(Manager, IconBar)	\
				((BOOL)WinSendMsg(Manager, \
						IB_TURNOFFWINCLOSEBOX, (MPARAM)IconBar,(MPARAM)0))

/* Messages for MessageProc	*/
#define 	IMM_ICONDOWN		0x0001	/* user clicked down on icon	*/
#define		IMM_ICONUP			0x0002	/* user let up on icon	*/
#define		IMM_ICONHELP		0x0003	/* user wants help on icon	*/
#define		IMM_BARSIZED		0x0004	/* icon bar resized.	*/
#define		IMM_HOSTSIZEREQUEST	0x0005	/* lparam is a pointer to a lrect.	*/
										/* fill in the client area.	*/
#define		IMM_ICONHELPDONE	0x0006	/* finished sending help.	*/
#define		IMM_ICONDEPRESSED	0x0007	/* depressable icon set down.	*/
#define		IMM_ICONLETUP		0x0008	/* depressable icon set up.	*/
#define		IMM_WHATICONS		0x0009	/* what is the current icon size	*/
#define		IMM_LOADICONS		0x000A	/* request to load wParam icons	*/
#define		IMM_EDITICON		0x000B	/* the icon manager destroyed.	*/
#define		IMM_GETFOCUS		0x000C	/* set the focus to the host */
#define		IMM_DESELECT		0x000D	/* deselecting */
#define		IMM_SELECT			0x000E	/* selecting */
#define		IMM_MANAGERDESTROY	0x000F	/* Manager about to be destroyed */
#define		IMM_GETLASTRECT		0x0010	/* Manager about to be destroyed */
#define		IMM_GETLASTPOS		0x0011	/* Manager about to be destroyed */
#define		IMM_GETLASTICONSIZE	0x0012	/* Manager about to be destroyed */
#define		IMM_ICONHITTEST		0x0013	/* hit test on iconbar */
#define		IMM_ICONBARSHOW		0x0014	/* the user has hidden or shown the
											iconabr */

/* Icon States	*/
#define 	ICS_CUSTOM 			0x01
#define 	ICS_DEPRESSED		0x02
#define		ICS_DOWN			0x04
#define		ICS_NOTAVAILABLE	0x08

/* Icon Sizes	*/
#define 	IS_EGA				0x01
#define 	IS_VGA				0x02
#define 	IS_SUPERVGA			0x03

/* iconbar positions	*/

#define			IBP_LEFT			0x01
#define			IBP_TOP				0x02
#define			IBP_RIGHT			0x03
#define			IBP_BOTTOM			0x04
#define			IBP_FLOATING		0x05

/* Icon Bar States	*/

#define IBS_LEFT				0x0001	/* fixed at left		*/
#define IBS_TOP					0x0002	/* fixed at top			*/
#define IBS_RIGHT				0x0004	/* fixed at right		*/
#define IBS_BOTTOM				0x0008	/* fixed at bottom		*/
#define IBS_FIXED				0x0010	/* in fixed position	*/
#define IBS_SHOWING				0x0020	/* iconbar is showing	*/
#define IBS_SCROLL				0x0040	/* has scroll bar 		*/
#define IBS_HORZSYSTEMBAR		0x0080	/* has scroll bar 		*/
#define IBS_DONEWITHSLOTS		0x0100	/* has scroll bar 		*/
#define IBS_DIALOG				0x0200	/* depress the selection*/
#define IBS_STOPRESIZE			0x0400	/* being destroyed 		*/
#define IBS_INFLUX				0x0800	/* in between hide/show	*/
 
/* Registered Applications */
#define		REG_DONTCARE	0
#define		REG_AMIPRO		1
#define		REG_ROCKPORT	2
#define		REG_WALDEN		3
#define		REG_REMINGTON	4
#define		REG_SMARTEXT	5
#define		REG_IMPROV		6
#define		REG_123G		7
#define		REG_ADS			8
#define		REG_AGENDA		9
#define		REG_CCMAIL		10
#define		REG_AMIDLGED	11
#define		REG_DARWIN		12
#define		REG_AMIOUTDLL	13
#define		REG_ORGANIZER	14
#define		REG_NOTES		15
#define		REG_NOTEBOOK	16
#endif
