
#include "wpddefs.h"
#include "filesys.h"
#include "types.h"
#include "dialogs.h"
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "iconstub.h"

extern HAB Hab;
/*+
CFileSystem::Constructor
SYNTAX		void CFileSystem()
SYNOPSIS	This is a constructor for the file system
AUTHOR		Karen Emerson
RETURNVALUE	None.
*/
void
CFileSystem::Constructor(void)
{
}

/*+
CFileSystem::Destructor
SYNTAX		void Destructor()
SYNOPSIS	This is a destructor for the file system
AUTHOR		Karen Emerson
RETURNVALUE	None.
*/
void
CFileSystem::Destructor(void)
{
}

lbool
CFileSystem::IsThisFileNameValid(lfpbyte filename)
{
	FILESTATUS	buf;
	SHORT		rc;

	rc = DosQueryPathInfo((PSZ)filename, FIL_STANDARD, (PVOID)&buf, 
		(ULONG)sizeof(FILESTATUS));

	if (rc == 0	|| rc == ERROR_FILE_NOT_FOUND) // good name
	{
		// PM thinks that the name is good. Now we have an additional check.
		// PM allows spaces in file name on an OS/2 FAT drive. We WILL NOT
		// support this, since the file is thereafter useless on a 
		// DOS FAT system. So now, if the drive is a FAT drive, look for
		// spaces in the filename. 
		// ONE EXCEPTION: if the file is already exists and the 
		// drive is a FAT drive, we will allow

		if (!(IsHPFSDrive(filename)))
		{
			// this is a FAT drive, continue with checking for spaces
			if (0 != strchr(filename, ' ')) 
				return LFALSE;
		}
		return LTRUE;		// valid name whether HPFS or FAT
	}
	else if (rc == ERROR_PATH_NOT_FOUND)
		return LFALSE;
	else
		return LFALSE;
}

/*+
CFileSystem::IsHPFSDrive
SYNTAX		lbool IsHPFSDrive(lfpbyte driveletter)
SYNOPSIS	Checks if the drive letter corresponds to a HPFS drive
AUTHOR		Karen Emerson
RETURNVALUE	Returns true if the drive is a HPFS drive
*/
lbool
CFileSystem::IsHPFSDrive(lfpbyte driveletter)
{
	lubyte	type;

	type = GetDriveType(driveletter);
	if (type == DRIVETYPE_HPFS)
		return LTRUE;
	else
		return LFALSE;
}
/*+
CFileSystem::GetDriveType
SYNTAX		lubyte GetDriveType(lfpbyte driveletter)
SYNOPSIS	Ask PM for the type of drive based on the drive letter
AUTHOR		Karen Emerson
RETURNVALUE	Returns a number indicating the drive type for the specified drive letter.
*/
lubyte
CFileSystem::GetDriveType(lfpbyte driveletter)
{
	typedef struct _FIXFSQBUF       /* fsqbuf Data structure for QFSAttach*/
	{
		USHORT  iType;
		USHORT  cbName;
		USHORT  cbFSDName;
		USHORT  cbFSAData;
		UCHAR   szName[10];
		UCHAR   szFSDName[10];
		UCHAR   rgFSAData[50];
	} FIXFSQBUF;

	typedef FIXFSQBUF *PFIXFSQBUF;

	FIXFSQBUF	DataBuffer;
	ULONG	DataBufferLen;
	APIRET	rc;
	ULONG	len;
	CHAR	driveHPFS[5];
	CHAR	drivername[5];
	lubyte *	nameptr;
	CHAR	drive[PATHLENGTH];


	// The DosQueryFSAttach will only work here if the string
	// contains the drive letter, a color, and a NULL. A full
	// path including backslash and directory WILL NOT WORK!!!
	// KPE 10/25/93
	strcpy(drive, driveletter);
	if (drive[1] != ':')
		return DRIVETYPE_FAT;
	else
		drive[2] = 0;	// truncate after colon for DosQueryFSAttach to work

	DataBufferLen = sizeof(FIXFSQBUF);

	DosQueryFSAttach(drive, (ULONG)1, 1, 
			(PFSQBUFFER2)&DataBuffer, &DataBufferLen);

	len = strlen(DataBuffer.szName);
	// Move the driver name from the location where it seems to
	// be placed - don't rely on null at end
	nameptr = DataBuffer.szName + len + 1;
	drivername[0] = nameptr[0];
	drivername[1] = nameptr[1];
	drivername[2] = nameptr[2];
	drivername[3] = nameptr[3];
	drivername[4] = 0;

	driveHPFS[0] = 'H';
	driveHPFS[1] = 'P';
	driveHPFS[2] = 'F';
	driveHPFS[3] = 'S';
	driveHPFS[4] = 0;

	if (strcmp(drivername, driveHPFS) == 0)
		return DRIVETYPE_HPFS;
	return DRIVETYPE_FAT;
}

/*+
CFileSystem::DisplayFileNameError
SYNTAX		lbool DisplayFileNameError(HWND Parent, int msgnum)
SYNOPSIS	Displays msg box with error 
AUTHOR		Karen Emerson
RETURNVALUE	None.
*/
void
CFileSystem::DisplayFileNameError(HWND Parent, int msgnum)
{
	lubyte Help[LEN_MESSAGE];
	lubyte Warning[LEN_MESSAGE];

	WinLoadString(Hab, LNULL, msgnum, LEN_MESSAGE, Help);
	WinLoadString(Hab, LNULL, STR_WARNING, LEN_MESSAGE, Warning);
	WinMessageBox(HWND_DESKTOP, Parent, Help, Warning, 0, MB_OK);
}
