
#ifndef WPDDEFS
#define WPDDEFS
#if !defined(OS2) && !defined(macintosh) && !defined(UNIX) && !defined(NT)
#define MSWIN16
#endif

#if defined(UNIX)
#include <OS/os.h>              /* pick up libunix stuff            */
#endif

#include <stddef.h>		/* make sure we know what size_t is */

// daw - define defaults for these, platform must undef and def
// This are all used to make the engine a dll

#define	EXPORTCLASS			// windows dll exported class for the ui exe
#define	EXEEXPORTCLASS 		// windows exe exported class for the engine dll
#define LEXPORT2			// export a single class method for the engine dll
#define DEBUGEXPORT2		// export a single class method for the engine dll
							// This export only needed for the debugger

#if defined(MSWIN16)		/* 16-bit MS Windows */
#include "wpdmswin.h"
#elif defined(OS2)			/* OS/2 2.0 */
#include "wpdos2.h"
#elif defined(macintosh)	/* Mac */
#include "wpdmac.h"
#elif (defined(__hp9000s800) || defined(__hp9000s300))		/* Unix HP */
#include "wpdhpx.h"
#elif defined(__alpha)		/* Unix DEC */
#include "wpddecx.h"
#elif (_OS == _OS_AIX)        /* Unix IBM */
#include "wpdibmx.h"
#elif (_OS == _OS_SOLARIS)    /* Unix SUN */
#if (_OS_REV < 500)
#include "wpdsun41.h"
#else
#include "wpdsun5x.h"
#endif
#elif defined(NT)			/* Microsoft Windows NT */
#include "wpdnt.h"
#endif

/* scrollbar defines */
#define HORZSCROLL	1
#define VERTSCROLL	2

#define VERTICAL	1
#define HORIZONTAL	2

/* platform independent stuff */
#define MAX_OBJECTNAMESIZE	64
#define MAXDESCRIPTION				128
#define MAX_DOC_DESCRIPTION_LENGTH	120


#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#define ABS(x)	  (((x) < 0) ? -(x) : (x))

typedef lubyte far *lfpbyte;	/* like the old LPSTR */
typedef lubyte far *lplubyte;

typedef lushort lchar;			/* For 1- or 2-byte characters */
typedef lushort lchartype;		/* See charset.h */

typedef lulong L24COLOR;		/* a 24 bit RGB color */
typedef lulong ldate;			/* Date - seconds since 1/1/1970 */

typedef double lnumber;			/* native floating point number */
enum lValueStatus {VALUE_OK, VALUE_ERROR, VALUE_BAD_REFERENCE, VALUE_NONE,
	VALUE_NULL};

/* convert two lushorts into an lulong */
#define lmakeulong(lo, hi) \
	((lulong)(((lushort)(lo)) | (((lulong)((lushort)(hi))) << 16)))
/* retrieve low 16 bits of a lulong as lushort */
#define lloushort(lul) ((lushort)(lul))
/* retrieve low 16 bits of a lslong as lsshort */
#define llosshort(lsl) ((lsshort)(lsl))
/* retrieve high 16 bits of a lulong as lushort */
#define lhiushort(lul) ((lushort)(((lulong)(lul) >> 16) & 0xFFFF))
/* retrieve high 16 bits of a lslong as lsshort */
#define lhisshort(lsl) ((lsshort)(((lslong)(lsl) >> 16) & 0xFFFF))
/* retrieve low 8 bits of a lushort as lubyte */
#define lloubyte(lus) ((lubyte)(lus))
/* retrieve high 8 bits of a lushort as lubyte */
#define lhiubyte(lus) ((lubyte)(((lushort)(lus) >> 8) & 0xFF))

#define LTRUE	1
#define LFALSE	0
#define LNULL	0
#define BAD_ATOM (-1)					// Invalid Atom ID

/* Define a generic way to specify diminsions in inches.  The INCHES	*/
/* macro can take a floating point argument and convert it to the		*/
/* nearest UNIT of measurement.											*/
#ifdef	TWIP_UNITS
#	define INCHES(x)	UNIT(1440 * (x))
#	define POINTS(x)	UNIT((x) * 20)
#	define TWIPS(x)		(x)

/* These two functions are used by filters to interact with other file	*/
/* formats that work with twips and need to be converted to UNITs.		*/
/* If the internal value of a UNIT changes, either change these two		*/
/* functions or contact John Evans so I can change them.  Thanks.		*/
inline	UNIT	ToUnits( lushort Twips ) { return((UNIT)Twips); }
inline	lushort	ToTwips( UNIT Units ) { return( lushort(Units)); }

#else
#	define INCHES(x)	UNIT(72 * 65536L * (x))
#	define POINTS(x)	UNIT((x) * 65536L)
#	define TWIPS(x)		INCHES(double(x) / 1440)
#	define WHOLEPART(x)	lhisshort(x)
#	define ROUNDTOPIXEL(x)	lhisshort((x) + 0x8000)
#	define ROUNDTOWHOLE(x)	(((x) + 0x8000) & 0xFFFF0000L)
#	define FRACTPART(x)	lloushort(x)
#	define TOINCHES(x)	((double)x / (double)0x480000L)
#	define TOCM(x)		((double)x / (double)0x1C58B1L)
#	define TOPOINTS(x)	((double)x / (double)65536L)
#	define TOPICAS(x)	((double)x / (double)0x60000L)
#	define TOTWIPS(x)	((double)(x + 1600) / (double)3276.8)
#	define FROMINCHES(x)	((double)x * (double)0x480000L)
#	define FROMCM(x)		((double)x * (double)0x1C58B1L)
#	define FROMPOINTS(x)	((double)x * (double)65536L)
#	define FROMPICAS(x)		((double)x * (double)0x60000L)
#	define MAKELFIXED(x)	((x) * 65536L)
/* These two functions are used by filters to interact with other file	*/
/* formats that work with twips and need to be converted to UNITs.		*/
/* If the internal value of a UNIT changes, either change these two		*/
/* functions or contact John Evans so I can change them.  Thanks.		*/
inline	UNIT
ToUnits( lushort Twips )
{
	return UNIT((((lulong)Twips) << 16) / 20);
}

inline	UNIT
SignedToUnits( lsshort Twips )
{	/* added 2/93 pjs */
	return UNIT((((lslong)Twips) << 16) / 20);
}

inline	lushort
ToTwips( UNIT Units )
{
	return lushort(((Units * 5) + 0x2000) >> 14);
//orig	return lushort((Units * 20) >> 16);
}

inline	lushort
ToMillimeters( UNIT Units )
{
	return lushort(((Units * 18288) / 10) >> 16);
}

#endif
#define DEGREES(x)	angle((x) * 10)

#ifdef	DEVUNITisUNIT
#define TODEVUNIT(u) (u)
#else
#define TODEVUNIT(u) DEVUNIT(u)
#endif

class lbox;	// forward ref

#include "point.h"

class lrect
{
public:
	UNIT left;
	UNIT top;
	UNIT right;
	UNIT bottom;
	inline lrect& operator = (const lbox &);
	inline void un(lrect *);
	inline lrect& operator += (const lpoint &);
	inline lrect& operator -= (const lpoint &);
	inline lbool operator==(lrect &);
	inline lbool operator!=(lrect &);
	inline lbool Contains(plpoint);
	inline lpoint &TopLeft(void);
	inline lpoint &BottomRight(void);
	lbool NeedToMoveToMakeVisible(lrect *pVisibleRect, lpoint *pVisiblePoint,
		lpoint *pMoveAmount,lrect *ExcludeRect = LNULL);
	lbool ClipLineSegment(lpoint &p1, lpoint &p2);
	inline lbool Overlaps(lrect *);
	inline UNIT Width(void);
	inline UNIT Height(void);
protected:
	enum
	{
		TOLEFT = 1,
		TORIGHT = 2,
		ABOVE = 4,
		BELOW = 8
	};
	lushort ClassifyPoint(const lpoint &pt);
	void PushPoint(lpoint &p1, lpoint &p2, lushort p1bits);
};

typedef lrect			*plrect;
typedef lrect near		*nplrect;
typedef lrect far		*lplrect;

class lbox
{
	public:
		inline lbox& operator = (const lrect &);
		inline lbool operator!=(lbox &);
		inline lbool operator==(lbox &);
		inline lbool Contains(plpoint);

		lpoint origin;
		UNIT width;
		UNIT height;
};

typedef lbox			*plbox;
typedef lbox near		*nplbox;
typedef lbox far		*lplbox;

inline lbool 
lbox::operator!=(lbox &test)
{
	return ((test.origin.x != origin.x)
			|| (test.origin.y != origin.y)
			|| (test.height != height)
			|| (test.width != width));
}

inline lbool 
lbox::operator==(lbox &test)
{
	return ((test.origin.x == origin.x)
			&& (test.origin.y == origin.y)
			&& (test.height == height)
			&& (test.width == width));
}

inline lrect&
lrect::operator = (const lbox &box)
{
	left = box.origin.x;
	top = box.origin.y;
	right = left + box.width;
	bottom = top + box.height;
	return *this;
}

inline void
lrect::un(plrect rect)
{
	if(rect->left < left)
		left = rect->left;
	if(rect->right > right)
		right = rect->right;
	if(rect->top < top)
		top = rect->top;
	if(rect->bottom > bottom)
		bottom = rect->bottom;
}

inline lrect &
lrect::operator -= (const lpoint &pt)
{
	left -= pt.x;
	right -= pt.x;
	top -= pt.y;
	bottom -= pt.y;
	return *this;
}

inline lrect &
lrect::operator += (const lpoint &pt)
{
	left += pt.x;
	right += pt.x;
	top += pt.y;
	bottom += pt.y;
	return *this;
}

inline lbool 
lrect::Overlaps(lrect *test)
{
	return ((test->left < right) && (test->right > left)
			&& (test->top < bottom) && (test->bottom > top));
}

inline lbool
lrect::Contains(plpoint pPoint)
{
	return ((pPoint->x >= left) &&
			(pPoint->y >= top) &&
			(pPoint->x < right) &&
			(pPoint->y < bottom));
}

inline lpoint &
lrect::TopLeft(void)
{
	return *(lpoint *)&left;
}

inline lpoint &
lrect::BottomRight(void)
{
	return *(lpoint *)&right;
}

inline lbool 
lrect::operator==(lrect &test)
{
	return ((test.left == left)
			&& (test.right == right)
			&& (test.top == top)
			&& (test.bottom == bottom));
}

inline lbool 
lrect::operator!=(lrect &test)
{
	return !operator==(test);
}

inline UNIT
lrect::Width(void)
{
	return right - left;
}

inline UNIT
lrect::Height(void)
{
	return bottom - top;
}

inline lbox&
lbox::operator = (const lrect &rect)
{
	origin.x = rect.left;
	origin.y = rect.top;
	width = rect.right - rect.left;
	height = rect.bottom - rect.top;
	return *this;
}

inline lbool
lbox::Contains(plpoint pPoint)
{
	return ((pPoint->x >= origin.x) &&
			(pPoint->y >= origin.y) &&
			(pPoint->x < origin.x + width) &&
			(pPoint->y < origin.y + height));
}


enum ScrollType {
	LST_NULL = 0,
	LST_LINEUP = 1,
	LST_LINEDOWN = 2,
	LST_PAGEUP = 3,
	LST_PAGEDOWN = 4,
	LST_POSITION = 5
};

#define LINEAMOUNT	INCHES(1.0 / 6)	/* 1/6 of an inch */
#define OVERLAP		INCHES(1.0 / 3 )	/* 1/3 of an inch */

enum ldirection {L_LEFT, L_RIGHT, L_UP, L_DOWN, L_NONE, L_HOME, L_END, L_INTO};
enum FormatWhen {FOREGROUND, BACKGROUND, ALL};
enum CanChangeRetval { CCR_CANCHANGE, CCR_CANNOTCHANGE, CCR_FIXEDCHANGE };

// kludge for far blob constructors, last param is a dummy variable
inline void far * operator new(size_t x, void far *p, unsigned y){(void)x; (void)y; return p;}

inline void * operator new(size_t, void *p){return p;}

#endif
