// Defines for the status.dlls exported funcitions.
#define CREATE_STATUS_AREA	2
#define SET_STATUS_AREA		3
#define SHOW_STATUS_AREA	4
#define DESTROY_STATUS_AREA	5
#define GET_STATUS_AREA		6
#define INVALIDATE_STATUS_AREA	7
#define GET_STATUS_STRING_WIDTH	8
#define SET_STATUS_CURSOR_STATE	9
#define GET_STATUS_AREA_HEIGHT	10
#define STATUS_CREATE_OBJECT	11
#define STATUS_INVALIDATE_OBJECT	12
#define STATUS_SET_OBJECT_TEXT	13
#define STATUS_DELETE_OBJECT	14
#define STATUS_SET_OBJECT_STATE	15
#define STATUS_SET_OBJECT_GRAPHIC	16
#define HIDE_STATUS_AREA	17
#define STATUS_ACTIVATE_BUTTON	19
#define STATUS_ACTIVATE_BUTTON_RIGHT	20

// macro to get the procedure address for one of the above routines
#define GETSTATUSPROC(x, y) (GetProcAddress(x, MAKEINTRESOURCE(y)))

// Function prototypes for routines in the status.dll

// Status Area routines
typedef	lulong (far pascal *FP_CREATE_STATUS_AREA)(lulong, lushort, LPSTATCALLBACK);
typedef	lbool (far pascal *FP_DESTROY_STATUS_AREA)(lulong);
typedef	lbool (far pascal *FP_SET_STATUS_AREA)(lulong, lsshort, lsshort, lsshort, lsshort);
typedef	lbool (far pascal *FP_GET_STATUS_AREA)(lulong, lsshort far *, lsshort far *, lsshort far *, lsshort far *);
typedef	lsshort (far pascal *FP_GET_STATUS_STRING_WIDTH)(lulong, lplubyte);
typedef	lbool (far pascal *FP_SHOW_STATUS_AREA)(lulong);
typedef	lbool (far pascal *FP_HIDE_STATUS_AREA)(lulong);
typedef	lbool (far pascal *FP_INVALIDATE_STATUS_AREA)(lulong);
typedef	lbool (far pascal *FP_SET_STATUS_CURSOR_STATE)(lulong, lushort);
typedef	lbool (far pascal *FP_GET_STATUS_AREA_HEIGHT)(lulong, lsshort far *);
typedef	void (far pascal *FP_STATUS_ENABLE_HITTEST)(void);

// Button routines
typedef	lulong (far pascal *FP_STATUS_CREATE_OBJECT)(lulong, lulong, lulong, lsshort, lushort);
typedef	lbool (far pascal *FP_STATUS_DELETE_OBJECT)(lulong);
typedef	lbool (far pascal *FP_STATUS_INVALIDATE_OBJECT)(lulong, lbool);
typedef	lbool (far pascal *FP_STATUS_SET_OBJECT_STATE)(lulong, lbool);
typedef	lbool (far pascal *FP_STATUS_SET_OBJECT_TEXT)(lulong, lplubyte, lbool);
typedef	lbool (far pascal *FP_STATUS_SET_OBJECT_GRAPHIC)(lulong, lulong);

typedef	lbool (far pascal *FP_STATUS_ACTIVATE_BUTTON)(lulong);

// Host to StatusBar API. 

typedef struct tagSTATPROC
{
	FP_CREATE_STATUS_AREA CreateStatusArea;
	FP_DESTROY_STATUS_AREA DestroyStatusArea;
	FP_SET_STATUS_AREA SetStatusArea;
	FP_GET_STATUS_AREA GetStatusArea;
	FP_GET_STATUS_STRING_WIDTH GetStatusStringWidth;
	FP_SHOW_STATUS_AREA ShowStatusArea;
	FP_HIDE_STATUS_AREA HideStatusArea;
	FP_INVALIDATE_STATUS_AREA InvalidateStatusArea;
	FP_SET_STATUS_CURSOR_STATE SetStatusCursorState;
	FP_GET_STATUS_AREA_HEIGHT GetStatusAreaHeight;

	// Button routines
	FP_STATUS_CREATE_OBJECT StatusCreateObject;
	FP_STATUS_DELETE_OBJECT StatusDeleteObject;
	FP_STATUS_INVALIDATE_OBJECT InvalidateObject;
	FP_STATUS_SET_OBJECT_STATE SetObjectState;
	FP_STATUS_SET_OBJECT_TEXT SetObjectText;
	FP_STATUS_SET_OBJECT_GRAPHIC SetObjectGraphic;

	// Activate Button is sent from the host to simulate a click.
	FP_STATUS_ACTIVATE_BUTTON ActivateButton;
	FP_STATUS_ACTIVATE_BUTTON ActivateButtonRight;
} STATPROC;
