#if !defined(STATUSBARDEFS_H) 
#define	STATUSBARDEFS_H

#define OBJ_TEXT		0x01
#define OBJ_GRAPHICS	0x02
								// behavior
#define OBJ_POPUP		0x04
#define OBJ_LEFTCLICK	0x08	// button clickable with left button
#define OBJ_CLICKABLE	0x08	// same as LEFTCLICK
#define OBJ_COLLAPSIBLE	0x10
#define OBJ_CONTAINER	0x20
								// attributes 
#define OBJ_LEFT		0x40
#define OBJ_CENTER		0x80
#define OBJ_RIGHT		0x100
#define OBJ_GRAY		0x200
#define OBJ_HILITE		0x400
#define OBJ_USEDLLSTEXT	0x800	// on get object text dll is instructed to use
								// its own text - the host will not be 
								// providing any

#define OBJ_RIGHTCLICK	0x1000
#define OBJ_DBLCLICK	0x2000
#define OBJ_AUTOREPEAT	0x4000	// an auto repeat button

#define OBJ_CHILD		0x8000	// used internally by the status dll

#define		CUR_NORMAL		1
#define		CUR_WAIT		2
#define		CUR_HELP		3

typedef		lulong			OBJECTID;

//	Typedefs for the StatusBar-to-Host API
typedef 	lbool 	(STATPROTO * GETTEXTCALLBACK)(OBJECTID, lfpbyte, void far *); 
typedef 	lulong 	(STATPROTO * GETGRAPHICCALLBACK)(OBJECTID, void far *);
typedef 	void 	(STATPROTO * ACTIVATECALLBACK)(OBJECTID, void far *);
typedef 	int 	(STATPROTO * LOADDATACALLBACK)(OBJECTID, lsshort far *, void far *);
typedef 	lbool 	(STATPROTO * GETITEMCALLBACK)(OBJECTID, lsshort, lfpbyte, void far *);
typedef 	lbool 	(STATPROTO * SELECTCALLBACK)(OBJECTID, lsshort, lfpbyte, void far *);
typedef	lslong (STATPROTO *HITTESTCALLBACK)(lslong, luint, luint, luint, lulong, void far * UserData);

typedef struct tagSTATCALLBACK 
{ 
	GETTEXTCALLBACK			StatusGetObjectText;
	void far				*textData;
	GETGRAPHICCALLBACK		StatusGetObjectGraphic;
	void far				*graphicData;
	ACTIVATECALLBACK		StatusObjectClicked;
	void far				*objClickData;
	ACTIVATECALLBACK		StatusObjectDblClicked;
	void far				*objDblClickData;
	LOADDATACALLBACK		StatusPopupLoadData;
	void far				*popupLoadData;
	GETITEMCALLBACK			StatusPopupGetItem;
	void far				*popupItemData;
	SELECTCALLBACK			StatusPopupItemSelected;
	void far				*popupSelectData;
	HITTESTCALLBACK			StatusHitTest;
	void far				*hitTestData;
	ACTIVATECALLBACK		StatusObjectRightClicked;
	void far				*objRightClickData;
} STATCALLBACK;

typedef		STATCALLBACK	far * LPSTATCALLBACK;

#endif	//	STATUSBARDEFS_H
