/****************************************************************************** 
 * This program is kind of a jig for the status dll.  It is intended to clone
 * the real Ami Pro status bars looks and functionally.
 *****************************************************************************/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "wpddefs.h"
#include "defaults.h"
#include "resource.h"
#include "statdefs.h"
#include "statfp.h"

HANDLE	hLib = 0;	// Handle to the Status Bar Library
int	StatusHeight;	// Height of the Status Area
int	IconHeight = ICONVGAHEIGHT;	// Height of the Status Area
HANDLE hInstance;	// instance
HWND MainWnd;		// Handle to the main window
lulong StatusWnd;		// Handle to the StatusBar window

#define MAXWNDS 10
#define MAXBUTTONS 15
#define MAXPROCS 7

#define TAG_BUTTON_WIDTH		((IconHeight <= ICONVGAHEIGHT) ? 30 : 30)
#define FONT_BUTTON_WIDTH		((IconHeight <= ICONVGAHEIGHT) ? 110 : 176)
#define POINTSIZE_BUTTON_WIDTH	((IconHeight <= ICONVGAHEIGHT) ? 25 : 40)
#define PATH_BUTTON_WIDTH		60
#define TIME_BUTTON_WIDTH		30
#define DATE_BUTTON_WIDTH		30
#define TYPEMODE_BUTTON_WIDTH	((IconHeight <= ICONVGAHEIGHT) ? 31 : 49)
#define SPACE_BUTTON_WIDTH		((IconHeight <= ICONVGAHEIGHT) ? 31 : 49)
#define SIDEBAR_BUTTON_WIDTH	((IconHeight <= ICONVGAHEIGHT) ? 31 : 49)
#define PAGE_UP_BUTTON_WIDTH	((IconHeight <= ICONVGAHEIGHT) ? 17 : 27)
#define PAGE_NUMBER_BUTTON_WIDTH	((IconHeight <= ICONVGAHEIGHT) ? 26 : 41)
#define PAGE_DOWN_BUTTON_WIDTH	((IconHeight <= ICONVGAHEIGHT) ? 17 : 27)

#define TAG_BUTTON_TYPE			OBJ_TEXT | OBJ_POPUP | OBJ_LEFTCLICK | OBJ_RIGHTCLICK
#define FONT_BUTTON_TYPE		OBJ_TEXT | OBJ_POPUP | OBJ_LEFTCLICK 
#define POINTSIZE_BUTTON_TYPE	OBJ_TEXT | OBJ_POPUP | OBJ_LEFTCLICK | OBJ_CENTER
#define PATH_BUTTON_TYPE		OBJ_COLLAPSIBLE | OBJ_CONTAINER | OBJ_LEFTCLICK | OBJ_DBLCLICK
#define CONTAINER_BUTTON_TYPE	OBJ_CONTAINER | OBJ_LEFTCLICK
#define TIME_BUTTON_TYPE		OBJ_TEXT | OBJ_LEFTCLICK
#define DATE_BUTTON_TYPE		OBJ_TEXT | OBJ_LEFTCLICK
#define TYPEMODE_BUTTON_TYPE	OBJ_TEXT | OBJ_LEFTCLICK | OBJ_CENTER
#define SPACE_BUTTON_TYPE		OBJ_TEXT | OBJ_LEFTCLICK | OBJ_AUTOREPEAT
#define SIDEBAR_BUTTON_TYPE		OBJ_GRAPHICS | OBJ_LEFTCLICK
#define PAGE_UP_BUTTON_TYPE		OBJ_GRAPHICS | OBJ_LEFTCLICK
#define PAGE_NUMBER_BUTTON_TYPE	OBJ_TEXT | OBJ_LEFTCLICK | OBJ_RIGHT
#define PAGE_DOWN_BUTTON_TYPE	OBJ_GRAPHICS | OBJ_LEFTCLICK

lulong TagButton, FontButton, PointSizeButton, PathButton, PageNumberButton;
lulong TypeModeButton, SideBarButton, PageUpButton, PageDownButton;
lulong SpaceButton, TimeButton, DateButton, ContainerButton, Container1, Container2;

struct ButtonStruct
{
	lulong id;		// unique identifer for the button
	lushort Parent;	// null if not a sub button
	lbool Clicked;	// This button has been clicked on - used to toggle color
	lbool State;		// clickable ?
	lushort Type;		// graphic or text , popup or container
};

STATCALLBACK CallBack;
STATPROC StatProcs;

// function prototypes
HWND CreateParentWindow(HANDLE hinst);
BOOL IsButtonText(lulong id);
BOOL IsButtonGraphic(lulong id);
void GetButtonText(lulong id, BYTE * string);
void GetPopupText(lulong id, BYTE * string);

/**********************************************************************
 * Call back functions
 **********************************************************************/

/**********************************************************************
 **********************************************************************/
lbool pascal far _export 
StatusGetObjectText(lulong id, lplubyte string, void far * UserData)
{
	BYTE	tmpbuff[MAXBUTTONCHARS];
	lushort HiliteFlag;
	(void)UserData;

	// convert the id to an ascii string
	GetButtonText(id, tmpbuff);
	lstrcpy(string, tmpbuff);

	HiliteFlag = 0;

	return HiliteFlag;
}

/**********************************************************************
 **********************************************************************/
lulong pascal far _export
StatusGetObjectGraphic(lulong id, void far *UserData)
{
	HANDLE hBitmap;
	int	resource = 0;;
	(void)UserData;

	if (id == SideBarButton)
	{
		if (IconHeight <= ICONEGAHEIGHT)
			resource = RS_E_ICONPAL;
		else if (IconHeight >= ICON8514HEIGHT)
			resource = RS_8_ICONPAL;
		else
			resource = RS_V_ICONPAL;
	}
	else if (id == PageUpButton)
	{
		if (IconHeight <= ICONEGAHEIGHT)
			resource = RS_E_SHADUPLFT;
		else if (IconHeight >= ICON8514HEIGHT)
			resource = RS_8_SHADUPLFT;
		else
			resource = RS_V_PAGEUP;
	}
	else if (id == PageDownButton)
	{
		if (IconHeight <= ICONEGAHEIGHT)
			resource = RS_E_SHADUPRT;
		else if (IconHeight >= ICON8514HEIGHT)
			resource = RS_8_SHADUPRT;
		else
			resource = RS_V_PAGEDOWN;
	}

	if (resource)
	{
		hBitmap = LoadBitmap(hInstance, MAKEINTRESOURCE(resource));
		return (lulong)hBitmap;
	}

	return 0;
}

/**********************************************************************
 **********************************************************************/
void pascal far _export
StatusObjectClicked(lulong id, void far *UserData)
{
	int	resource;
	lbool	HiliteFlag = FALSE;
	BYTE	tmpbuf[40];
	HANDLE	hBitmap;
	(void)UserData;

	if (id == TagButton
		|| id == FontButton
		|| id == PointSizeButton
		|| id == PathButton
		|| id == Container1
		|| id == Container2
		|| id == TimeButton
		|| id == DateButton
		|| id == PageNumberButton
		|| id == TypeModeButton
		|| id == SpaceButton)
	{
		// Get the text for the object
		GetButtonText(id, tmpbuf);
		(*StatProcs.SetObjectText)(id, (LPSTR)tmpbuf, HiliteFlag);

		if (id == SpaceButton)
			MessageBeep(0);
	}
	else if (id == SideBarButton
			|| id == PageUpButton
			|| id == PageDownButton)
	{
		resource = RS_V_ICONPAL;
		hBitmap = LoadBitmap(hInstance, MAKEINTRESOURCE(resource));
		(*StatProcs.SetObjectGraphic)(id, (lulong)hBitmap);
	}
}

/**********************************************************************
 **********************************************************************/
void pascal far _export
StatusObjectRightClicked(lulong id, void far *UserData)
{
	(void) id;
	(void)UserData;
	MessageBox(MainWnd, "HOST: Status Object RIGHT Clicked.", "Main Window", MB_OK);
}


/**********************************************************************
 **********************************************************************/
void pascal far _export
StatusObjectDblClicked(lulong id, void far *UserData)
{
	(void) id;
	(void)UserData;
	MessageBox(MainWnd, "HOST: StatusObjectDblClicked.", "Main Window", MB_OK);
}

/**********************************************************************
 **********************************************************************/
lsshort pascal far _export
StatusPopupLoadData(lulong id, lsshort far *index, void far *UserData)
{
	int count;
	(void)UserData;

	(void) id;

	if (id == PointSizeButton)
		// This is a test for a zero size list box - ie the list box
		// should not be created.
		*index = count = 0;
	else
	{
		// This is to tell the dll to select the third one in the list.  
		// The base is zero.  If none are to be selected index = -1.
		*index = 2;

		// For now let the dll know that x number of strings are here
		count = 5;
	}
	return count;
}

/**********************************************************************
 **********************************************************************/
lbool pascal far _export
StatusPopupGetItem(lulong id, lsshort index, lplubyte string, void far *UserData)
{
	BYTE	TmpBuffer[30];

	(void) id;
	(void)UserData;

	GetPopupText(index+1, TmpBuffer);
	lstrcpy(string, TmpBuffer);

	return TRUE;
}

/**********************************************************************
 **********************************************************************/
lbool pascal far _export
StatusPopupItemSelected(lulong id, lsshort index, lfpbyte string, void far *UserData)
{
	BYTE	TmpBuffer[30];

	(void) id;
	(void)UserData;
	(void)string;

	if (index == -1)
		// no item was selected
		return FALSE;

	GetPopupText(index+1, TmpBuffer);
	MessageBox(MainWnd, TmpBuffer, "HOST: You Selected", MB_OK);

	return FALSE;
}

/**********************************************************************
 *  		Button Support Routines
 **********************************************************************/

/**********************************************************************
 **********************************************************************/
void
GetButtonText(lulong id, BYTE *tmpbuff)
{
	// convert the id to an ascii string
	if (id == TagButton)
		strcpy(tmpbuff, "BodyText");
	else if (id == FontButton)
		strcpy(tmpbuff, "Helv");
	else if (id == PointSizeButton)
		strcpy(tmpbuff, "10");
	else if (id == PathButton)
		strcpy(tmpbuff, "c:\\melanie\\status");
	else if (id == Container1)
		strcpy(tmpbuff, "Con1");
	else if (id == Container2)
		strcpy(tmpbuff, "Con2");
	else if (id == TimeButton)
		strcpy(tmpbuff, "Time");
	else if (id == DateButton)
		strcpy(tmpbuff, "Date");
	else if (id == TypeModeButton)
		strcpy(tmpbuff, "Type");
	else if (id == SpaceButton)
		strcpy(tmpbuff, "");
	else if (id == PageNumberButton)
		strcpy(tmpbuff, "1");
	else
		itoa(id, tmpbuff, 10); 
}

//*******************************************************************
// This routine simply gives some text based on the id given.
// It is just so that we can fill up the popup list boxes with 
// stuff.
//*******************************************************************
void
GetPopupText(lulong id, BYTE *tmpbuff)
{
	// convert the id to an ascii string
	switch(id)
	{
		case 1: strcpy(tmpbuff, "Melanie"); break;
		case 2: strcpy(tmpbuff, "Ed"); break;
		case 3: strcpy(tmpbuff, "Mike"); break;
		case 4: strcpy(tmpbuff, "Mark"); break;
		case 5: strcpy(tmpbuff, "Karen"); break;
		case 6: strcpy(tmpbuff, "Joe"); break;
		case 7: strcpy(tmpbuff, "David"); break;
		case 8: strcpy(tmpbuff, "Diane"); break;
		case 9: strcpy(tmpbuff, "John"); break;
		case 10: strcpy(tmpbuff, "Bruce"); break;
		default: itoa(id, tmpbuff, 10); break;
	}
	
	return;
}

/**********************************************************************
 **********************************************************************/
void
SizeStatusWindow(HWND MainWnd, lulong StatusWnd)
{
	RECT	rect;

	// Get the client rect of the main window and size status bar to fit
	GetClientRect(MainWnd, &rect);
	(*StatProcs.SetStatusArea)((lulong)StatusWnd, 
		rect.left - 1, rect.bottom - StatusHeight + 1, rect.right + 2, 0);
}

/**********************************************************************
 *						Status Area Stuff
 **********************************************************************/

//************************************************************************
// Create a window with a status area and show it
//************************************************************************
lulong
CreateStatusWindow(HWND MainWnd)
{
	RECT	rect;

	// Create it
	StatusWnd = (*StatProcs.CreateStatusArea)((lulong)MainWnd, 
						sizeof(STATCALLBACK), (LPSTATCALLBACK)&CallBack);

	// Get its height - height is calculated by the dll
	(*StatProcs.GetStatusAreaHeight)(StatusWnd, (lsshort far *)&StatusHeight);

	// Get the client rect of the main window and size status bar to fit
	GetClientRect(MainWnd, &rect);
	(*StatProcs.SetStatusArea)((lulong)StatusWnd,
		rect.left - 1, rect.bottom - StatusHeight + 1, rect.right + 2, 0);

	// Show the status bar
	(*StatProcs.ShowStatusArea)((lulong)StatusWnd);
	return StatusWnd;
}

/**********************************************************************
 **********************************************************************/
HWND 
CreateMainWindow(HANDLE hinst)
{
	// build the caption for the window
	MainWnd = CreateParentWindow(hinst);
	ShowWindow(MainWnd, SW_SHOWNORMAL);
	UpdateWindow(MainWnd);

	return MainWnd;
}

/**********************************************************************
 *						Main Window Stuff
 **********************************************************************/

/**********************************************************************
 **********************************************************************/
LONG FAR _export pascal
WndProc(HWND hwnd, luint message, luint wParam, LONG lparam)
{
	HDC	hdc;
	PAINTSTRUCT	ps;
	RECT	rect;
	HWND	tmpwnd;
	int	x, y, w, h;
	BYTE	tmpbuf[20];

	switch (message)
	{
		case WM_SIZE:
			if (MainWnd && StatusWnd)
				SizeStatusWindow(MainWnd, StatusWnd);
			break;

		case WM_PAINT:
			hdc = BeginPaint(hwnd, &ps);
			GetClientRect(hwnd, &rect);
			DrawText(hdc, "MELANIE'S STATUS BAR TEST JIG", -1, &rect,
				DT_SINGLELINE | DT_CENTER | DT_VCENTER);
			EndPaint(hwnd, &ps);
			return 0;

		case WM_CLOSE:
			StatProcs.DestroyStatusArea(StatusWnd);
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
	}
	return DefWindowProc(hwnd, message, wParam, lparam);
}

/**********************************************************************
 **********************************************************************/
HWND
CreateParentWindow(HANDLE hinst)
{
	static char WinClass[] = "Clone";
	HWND hWnd;

	// Create the window
	hWnd = CreateWindow(WinClass,
		(LPSTR)"Status Bar Test Jig",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		NULL,
		NULL,
		hinst,
		(LPSTR)NULL);
	return hWnd;
}

/***********************************************************************
 ***********************************************************************/
lushort
RegisterParentWindow(HANDLE hinst)
{
	WNDCLASS	wnd;
	static char WinClass[] = "Clone";

	// Register the window class
	wnd.style = CS_VREDRAW | CS_HREDRAW;
	wnd.lpfnWndProc = WndProc;
	wnd.cbClsExtra = 0;
	wnd.cbWndExtra = 0;
	wnd.hInstance = hinst;
	wnd.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wnd.hCursor = LoadCursor(NULL, IDC_ARROW);
	wnd.hbrBackground = GetStockObject(WHITE_BRUSH);
	wnd.lpszMenuName = NULL;
	wnd.lpszClassName = WinClass;

	return RegisterClass((LPWNDCLASS)&wnd);
}

/**************************************************************************/
/*+
::BuildStatusBar
SYNTAX		void BuildStatusBar()
SYNOPSIS	Build a status bar to look like Ami Pros status bar.
AUTHOR		Melanie Armstrong
DESCRIPTION	Build a status bar to look like Ami Pros status bar.
PARAMETERS		TYPE			DESCRIPTION
	hInstance	HANDLE			Handle to this instance of this program.
RETURNVALUE	None.
*/
void
BuildStatusBar(HANDLE hInstance)
{
	// Create the Main Window
	MainWnd = CreateMainWindow(hInstance);

	// Create the status bar to go in the window
	StatusWnd = CreateStatusWindow(MainWnd);

	// Add Each Button
	TagButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, 0, 
									TAG_BUTTON_WIDTH, 
									TAG_BUTTON_TYPE);
	FontButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, TagButton, 
									FONT_BUTTON_WIDTH, 
									FONT_BUTTON_TYPE);
	PointSizeButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, FontButton, 
									POINTSIZE_BUTTON_WIDTH, 
									POINTSIZE_BUTTON_TYPE);

	PathButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, PointSizeButton, 
									PATH_BUTTON_WIDTH, 
									PATH_BUTTON_TYPE);
		TimeButton = (*StatProcs.StatusCreateObject)(StatusWnd, PathButton, 0, 
										TIME_BUTTON_WIDTH, 
										TIME_BUTTON_TYPE);
		DateButton = (*StatProcs.StatusCreateObject)(StatusWnd, PathButton, 
										TimeButton, 
										DATE_BUTTON_WIDTH, 
										DATE_BUTTON_TYPE);

	ContainerButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, PathButton, 
										60, 
										CONTAINER_BUTTON_TYPE);
		Container1 = (*StatProcs.StatusCreateObject)(StatusWnd, ContainerButton,
										 0, 
										TIME_BUTTON_WIDTH, 
										TIME_BUTTON_TYPE);
		Container2 = (*StatProcs.StatusCreateObject)(StatusWnd, ContainerButton,
										Container1, 
										DATE_BUTTON_WIDTH, 
										DATE_BUTTON_TYPE);

	TypeModeButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, 
									ContainerButton, 
									TYPEMODE_BUTTON_WIDTH, 
									TYPEMODE_BUTTON_TYPE);
	SpaceButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, TypeModeButton, 
									SPACE_BUTTON_WIDTH, 
									SPACE_BUTTON_TYPE);
	SideBarButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, SpaceButton, 
									SIDEBAR_BUTTON_WIDTH, 
									SIDEBAR_BUTTON_TYPE);
	PageUpButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, SideBarButton, 
									PAGE_UP_BUTTON_WIDTH, 
									PAGE_UP_BUTTON_TYPE);
	PageNumberButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, 
									PageUpButton, 
									PAGE_NUMBER_BUTTON_WIDTH, 
									PAGE_NUMBER_BUTTON_TYPE);
	PageDownButton = (*StatProcs.StatusCreateObject)(StatusWnd, 0, 
									PageNumberButton, 
									PAGE_DOWN_BUTTON_WIDTH, 
									PAGE_DOWN_BUTTON_TYPE);
	// Invalidate the entire status area to cause a repaint.
	(*StatProcs.InvalidateStatusArea)(StatusWnd);
	(*StatProcs.InvalidateObject)(SpaceButton, LFALSE);
	
}

/**********************************************************************
 * Init CallBackStruct
 * 
 * This array contains the address of all the callback routines that
 * the dll can access.  All of these routines must be exported!
 **********************************************************************/
void
InitCallBackStruct()
{
	CallBack.StatusGetObjectText = (GETTEXTCALLBACK)
			MakeProcInstance((FARPROC)StatusGetObjectText, hInstance);
	CallBack.textData = NULL;

	CallBack.StatusGetObjectGraphic = (GETGRAPHICCALLBACK)
			MakeProcInstance((FARPROC)StatusGetObjectGraphic, hInstance);
	CallBack.graphicData = NULL;

	CallBack.StatusObjectClicked = (ACTIVATECALLBACK)
			MakeProcInstance((FARPROC)StatusObjectClicked, hInstance);
	CallBack.objClickData = NULL;

	CallBack.StatusObjectRightClicked = NULL;
/*
	CallBack.StatusObjectRightClicked = (ACTIVATECALLBACK)
			MakeProcInstance((FARPROC)StatusObjectRightClicked, hInstance);
*/
	CallBack.objRightClickData = NULL;

	CallBack.StatusObjectDblClicked = (ACTIVATECALLBACK)
			MakeProcInstance((FARPROC)StatusObjectDblClicked, hInstance);
	CallBack.objDblClickData = NULL;

	CallBack.StatusPopupLoadData = (LOADDATACALLBACK)
			MakeProcInstance((FARPROC)StatusPopupLoadData, hInstance);
	CallBack.popupLoadData = NULL;

	CallBack.StatusPopupGetItem = (GETITEMCALLBACK)
			MakeProcInstance((FARPROC)StatusPopupGetItem, hInstance);
	CallBack.popupItemData = NULL;

	CallBack.StatusPopupItemSelected = (SELECTCALLBACK)
			MakeProcInstance((FARPROC)StatusPopupItemSelected, hInstance);
	CallBack.popupSelectData = NULL;

	CallBack.StatusHitTest = NULL;
	CallBack.hitTestData = NULL;
}

/*
 * The structure initialized here contains the address for any function that 
 * we may want to access in the dll.
*/
void
InitStatProcs(HANDLE hDLL)
{
	// Status Area routines
	StatProcs.CreateStatusArea = (FP_CREATE_STATUS_AREA)
			GetProcAddress(hDLL, MAKEINTRESOURCE(CREATE_STATUS_AREA));
	StatProcs.DestroyStatusArea = (FP_DESTROY_STATUS_AREA)
			GetProcAddress(hDLL, MAKEINTRESOURCE(DESTROY_STATUS_AREA));
	StatProcs.SetStatusArea = (FP_SET_STATUS_AREA)
			GetProcAddress(hDLL, MAKEINTRESOURCE(SET_STATUS_AREA));
	StatProcs.GetStatusArea = (FP_GET_STATUS_AREA)
			GetProcAddress(hDLL, MAKEINTRESOURCE(GET_STATUS_AREA));
	StatProcs.GetStatusStringWidth = (FP_GET_STATUS_STRING_WIDTH)
			GetProcAddress(hDLL, MAKEINTRESOURCE(GET_STATUS_STRING_WIDTH));
	StatProcs.ShowStatusArea = (FP_SHOW_STATUS_AREA)
			GetProcAddress(hDLL, MAKEINTRESOURCE(SHOW_STATUS_AREA));
	StatProcs.HideStatusArea = (FP_HIDE_STATUS_AREA)
			GetProcAddress(hDLL, MAKEINTRESOURCE(HIDE_STATUS_AREA));
	StatProcs.InvalidateStatusArea = (FP_INVALIDATE_STATUS_AREA)
			GetProcAddress(hDLL, MAKEINTRESOURCE(INVALIDATE_STATUS_AREA));
	StatProcs.SetStatusCursorState = (FP_SET_STATUS_CURSOR_STATE)
			GetProcAddress(hDLL, MAKEINTRESOURCE(SET_STATUS_CURSOR_STATE));
	StatProcs.GetStatusAreaHeight = (FP_GET_STATUS_AREA_HEIGHT)
			GetProcAddress(hDLL, MAKEINTRESOURCE(GET_STATUS_AREA_HEIGHT));

	// Button routines
	StatProcs.StatusCreateObject = (FP_STATUS_CREATE_OBJECT)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_CREATE_OBJECT));
	StatProcs.StatusDeleteObject = (FP_STATUS_DELETE_OBJECT)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_DELETE_OBJECT));
	StatProcs.InvalidateObject = (FP_STATUS_INVALIDATE_OBJECT)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_INVALIDATE_OBJECT));
	StatProcs.SetObjectState = (FP_STATUS_SET_OBJECT_STATE)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_SET_OBJECT_STATE));
	StatProcs.SetObjectText = (FP_STATUS_SET_OBJECT_TEXT)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_SET_OBJECT_TEXT));
	StatProcs.SetObjectGraphic = (FP_STATUS_SET_OBJECT_GRAPHIC)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_SET_OBJECT_GRAPHIC));
	StatProcs.ActivateButton = (FP_STATUS_ACTIVATE_BUTTON)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_ACTIVATE_BUTTON));
	StatProcs.ActivateButtonRight = (FP_STATUS_ACTIVATE_BUTTON)
			GetProcAddress(hDLL, MAKEINTRESOURCE(STATUS_ACTIVATE_BUTTON_RIGHT));
}
/***********************************************************************
 ***********************************************************************/
int PASCAL WinMain(HANDLE hinst, HANDLE hPrevInstance, LPSTR lpszCmdLine,
	int nCmdShow)
{
	MSG	msg;

	(void) hPrevInstance; (void) lpszCmdLine; (void) nCmdShow;

	hInstance = hinst;

	// register the main window
	RegisterParentWindow(hinst);

	// Load the status bar library
	hLib = LoadLibrary("ltssb03.dll");
	if (hLib > 32)
	{
		// Initialize call backs - this is passed to the dll - this structure
		// contains the address for each routine that the status bar dll can
		// call
		InitCallBackStruct();

		// Initialize status bar procs - this is just a nice way of keeping
		// together all of the routines that we can call in the dll.
		InitStatProcs(hLib);
		
		// Build the status bar to look like the Ami Pro status bar.
		BuildStatusBar(hInstance);
	}
	else
		MessageBox(MainWnd, 
			"The library was not successfully loaded.", "Main Window", MB_OK);

	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	if (hLib)
		FreeLibrary(hLib);
	return msg.wParam;
}
