(* Floating-point exceptions.  Works for 64-bit arithmetic on PCs *)

val MAXDOUBLE = 8.98846567431157E307;
val MINDOUBLE = 4.94065645841246544E~324
val pi = 3.14159265358979323846;
val eps = 1E~15;

fun check1 (opr, a, r) =
    let val res = opr a
    in
	if r = 0.0 andalso abs res <= eps orelse (res/r - 1.0) <= eps
	then "OK" else "WRONG"
    end;

check1(abs, 1.9E~212, 1.9E~212);
check1(abs, ~1.9E~212, 1.9E~212);
check1(~, 1.9E~212, ~1.9E~212);
check1(~, ~1.9E~212, 1.9E~212);
check1(real, 515, 515.0);
check1(real, ~515, ~515.0);
check1(sqrt, 64.0, 8.0);
check1(sin, 0.0, 0.0);
check1(sin, pi/2.0, 1.0);
check1(sin, pi, 0.0);
check1(sin, 3.0*pi/2.0, ~1.0);
check1(cos, 0.0, 1.0);
check1(cos, pi/2.0, 0.0);
check1(cos, pi, ~1.0);
check1(cos, 3.0*pi/2.0, 0.0);

fun check2 (opr, a1, a2, r) =
    let val res = opr(a1, a2)
    in
	if r = 0.0 andalso abs res <= eps orelse (res/r - 1.0) <= eps
	then "OK" else "WRONG"
    end;

check2(op+, 1.6, 2.3, 3.9);
check2(op+, ~1E123, 2E124, 190E122);
check2(op-, 16.0, 28.0, ~12.0);
check2(op-, ~8E23, 4E24, ~480E22);
check2(op*, 1E100, 1.234E8, 1.234E108);
check2(op*, 1E~100, 1.234E~8, 1.234E~108);
check2(op/, 0E500, 1.0, 0.0);
check2(op/, 1.0, ~1E~234, ~1E234);

(1.0/0.0;  "WRONG") handle Quot => "OK";
((~1.0)/0.0; "WRONG") handle Quot => "OK";
(1.0/(~0.0); "WRONG") handle Quot => "OK";

(MAXDOUBLE + 1E300; "WRONG") handle Sum => "OK";
(~MAXDOUBLE - 1E300; "WRONG") handle Diff => "OK";
(MAXDOUBLE * 1.000000001; "WRONG") handle Prod => "OK";
(1.0 / MINDOUBLE; "WRONG") handle Quot => "OK";

val maxexp = ln MAXDOUBLE * 0.999999999999;
(exp maxexp; "OK") handle Exp => "WRONG";
(exp (maxexp + 0.000001); "WRONG") handle Exp => "OK";

if MAXDOUBLE + ~MAXDOUBLE = 0.0 then "OK" else "WRONG";

fun f x = let val x2 = x / 2.0;
	  in MINDOUBLE/x2 + f x2 handle Div => 1.17 end;
