(* This test works only for 32-bit implementations! *)

val maxint = 1073741823;
val minint = ~maxint -1;

(~minint;  "WRONG") handle Neg => "OK";
(maxint+1; "WRONG") handle Sum => "OK";
(minint-1; "WRONG") handle Diff => "OK";

val sum = (op+) : int * int -> int;
val diff = (op-) : int * int -> int;
(sum (maxint,1);  "WRONG") handle Sum => "OK";
(diff (minint,1); "WRONG") handle Diff => "OK";

(minint * ~1;  "WRONG") handle Prod => "OK";

val prod = (op * ) : int * int -> int;
(prod (minint,~1);  "WRONG") handle Prod => "OK";

fun checkDivMod i d =
  let val q = i div d
      val r = i mod d
  in print i; output(std_out, " "); print d; output(std_out, "   ");
     if (d * q + r = i) andalso
        ((0 <= r andalso r < d) orelse (d < r andalso r <= 0))
     then "OK" else "WRONG: problems with div, mod"
  end;

checkDivMod 23 10;
checkDivMod ~23 10;
checkDivMod 23 ~10;
checkDivMod ~23 ~10;

checkDivMod 100 10;
checkDivMod ~100 10;
checkDivMod 100 ~10;
checkDivMod ~100 ~10;

checkDivMod 100 1;
checkDivMod 100 ~1;
checkDivMod 0 1;
checkDivMod 0 ~1;

(100 div 0;  "WRONG") handle Div => "OK";
(100 mod 0;  "WRONG") handle Mod => "OK";
(minint div ~1;  "WRONG") handle Div => "OK";

val maxri = real maxint;
val minri = real minint;

if floor 3.0 = 3 then "OK" else "WRONG";
if floor 3.14 = 3 then "OK" else "WRONG";
if floor ~3.0 = ~3 then "OK" else "WRONG";
if floor ~3.14 = ~4 then "OK" else "WRONG";
if floor(maxri + 0.9) = maxint then "OK" else "WRONG";
if floor minri = minint then "OK" else "WRONG";
(floor (minri - 0.1);  "WRONG") handle Floor => "OK";
(floor (maxri + 1.0);  "WRONG") handle Floor => "OK";

(sqrt ~10.0;  "WRONG") handle Sqrt => "OK";
(ln 0.0;  "WRONG") handle Ln => "OK";
