/*                      BISEARCH_

   
    The base class BISEARCH_ defines a skeleton search class from
    which more the actual search classes such as BIDEPTH_GRAPH_
    are derived, cf class SEARCH_! Class BISEARCH_ differs from class
    SEARCH_ in that it implements a bidirectional search instead of 
    a uni-directional search like class SEARCH_. It uses two sets of
    lists to search both forward from the start (s_open, s_closed) and
    backward to the goal (t_open, t_closed) simultaneously.

*/ 
  
#ifndef _bisearch_H_
#define _bisearch_H_

#include <stdio.h>
#include "object.h"
#include "nodes.h"
#include "list.h"

class BISEARCH_
{
    public:
        BISEARCH_(NODE_ *start, NODE_ *goal, int numop);
	virtual ~BISEARCH_();

        void generate();
        NODE_ *bisolve();
               // determines in which direction the search continues	
        NODE_ *solve(SORTEDLIST_ *, SORTEDLIST_ *, SORTEDLIST_ *);
               // expand a node and pass it to open 

        void print_sol(NODE_ *) const;        // print backwards
	void print_sol_2(NODE_ *) const;      // print forwards

        virtual int add(SORTEDLIST_ *, SORTEDLIST_ *, NODE_ *) = 0;
    private:
        int num_op;
    protected:     // protected since several classes need access through add() 
        SORTEDLIST_ s_open,
                    s_closed,
                    t_open,
		    t_closed;
};

#endif

