#include <stdio.h>
#include "graph.h"


/*                     DEMO4

    The object of this problem is the same as in demo3. The only difference
    is in the search method used. In this problem we want to use the best
    first algorithm and, therefore, derive class PUZZLE_ from class BEST_.
    Because of this we need to implement the functions compute_g() and
    compute_h() in PUZZLE_.

*/ 



/*                       PNODE.H

    This class resembles class PNODE_ in demo3 except that it's derived
    from class BEST_NODE_, instead of class NODE_. We derive it from this
    class because we want to perform a best first search using class
    BEST_ and this class processes (derivatives of) class BEST_NODE_.

*/

class PNODE_ : public BEST_NODE_
{
    public:
        PNODE_(const char *, int empty_x, int empty_y);
        PNODE_(const char *, int, int, int, int);
        int get_x() const;
        int get_y() const;
        const char (*get_board() const)[3];

// implementation of virtual functions
        int equal(const VOBJECT_ &) const;
        void display() const;
        NODE_ *do_operator(int) const;
    private:
        PNODE_
            *do_left() const,
            *do_right() const,
            *do_up() const,
            *do_down() const;
            int compare_board(const char [3][3]) const;
        int
            x,
            y;
        char
            board[3][3];
};



class PUZZLE_ : public BEST_
{
    public:
        PUZZLE_(PNODE_ *start, PNODE_ *target);
        int compute_g(const NODE_ &);
        int compute_h(const NODE_ &);
    private:
        int totdist(const char [3][3], const char[3][3]);
                       // computes manhatten distance
	PNODE_ *goal;  // goal node, needed by totdist()
};

