#include <stdio.h>
#include "graph.h"

/*		      DEMO1

    In this example problem a simple 15-puzzle will be solved. The
    start state has the empty tile in the lower right corner (3,3).
    Operators are up, down, right and left. The goalstate has the empty
    tile in its upperleft corner (0,0). For the solution of this simple
    problem only the coordinates of the empty tile are required. The
    actual configuration of the board is considered unimportant here.
  
*/



/*                    PNODE_

    Class PNODE_ defines the objects used in this problem. A PNODE_ object
    represents a single board configuration as a node in a tree search or
    as a state in a state space. 

*/

enum OP_USED_             // defines operators used to get to current state
{
    none_used,            // start state
    left_used,
    right_used,
    up_used,
    down_used
};

class PNODE_ : public NODE_
{
    public:
        PNODE_(OP_USED_ operator_used, int empty_x, int empty_y);
        int get_x() const;                   // get x-coordinate of empty tile
        int get_y() const;                   // get y-coordinate of empty tile

// implementation of virtual functions
        int equal(const VOBJECT_ &) const;   // compare two configurations
        void display() const;                // display configuration
        NODE_ *do_operator(int) const;       // apply operator n
    private:
        PNODE_
            *do_left() const,                // called by do_operator()
            *do_right() const,
            *do_up() const,
            *do_down() const;
        OP_USED_
            operator_used;            // operator used to get to current state
        int
            x,
            y;                        // coordinates of empty tile
};



/*                     PUZZLE_

    Class PUZZLE_ determines which search algorithm is to be used,
    in this case: a depth first graph search.

*/

class PUZZLE_ : public DEPTH_GRAPH_
{
    public:
        PUZZLE_(PNODE_ *start, PNODE_ *goal);
};



