VERSION 2.00
Begin Form Form1 
   AutoRedraw      =   -1  'True
   Caption         =   "Paint"
   Height          =   3570
   Icon            =   0
   Left            =   1275
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MousePointer    =   2  'Cross
   ScaleHeight     =   2880
   ScaleWidth      =   4920
   Top             =   1320
   Width           =   5040
   Begin CommandButton DrawButton 
      Caption         =   "Draw"
      Height          =   495
      Left            =   0
      MousePointer    =   1  'Arrow
      TabIndex        =   0
      Top             =   0
      Width           =   1215
   End
   Begin CommandButton LineButton 
      Caption         =   "Line"
      Height          =   495
      Left            =   0
      MousePointer    =   1  'Arrow
      TabIndex        =   1
      Top             =   480
      Width           =   1215
   End
   Begin CommandButton BoxButton 
      Caption         =   "Box"
      Height          =   495
      Left            =   0
      MousePointer    =   1  'Arrow
      TabIndex        =   2
      Top             =   960
      Width           =   1215
   End
   Begin CommandButton CircleButton 
      Caption         =   "Circle"
      Height          =   495
      Left            =   0
      MousePointer    =   1  'Arrow
      TabIndex        =   3
      Top             =   1440
      Width           =   1215
   End
   Begin CommandButton TextButton 
      Caption         =   "Text"
      Height          =   495
      Left            =   0
      MousePointer    =   1  'Arrow
      TabIndex        =   4
      Top             =   1920
      Width           =   1215
   End
   Begin CommandButton ClearButton 
      Caption         =   "Clear"
      Height          =   495
      Left            =   0
      MousePointer    =   1  'Arrow
      TabIndex        =   5
      Top             =   2400
      Width           =   1215
   End
   Begin Menu FileMenu 
      Caption         =   "&File"
      Begin Menu SaveItem 
         Caption         =   "&Save File..."
      End
      Begin Menu LoadItem 
         Caption         =   "&Load File..."
      End
      Begin Menu DrawingItem 
         Caption         =   "&Drawing Color..."
      End
      Begin Menu PrintItem 
         Caption         =   "&Print"
      End
      Begin Menu FromItem 
         Caption         =   "Paste &From Clipboard"
      End
      Begin Menu ToItem 
         Caption         =   "Paste &To Clipboard"
      End
      Begin Menu ExitItem 
         Caption         =   "E&xit"
      End
   End
End

Sub BoxButton_Click ()
    DrawFlag = False
    LineFlag = False
    BoxFlag = True
    CircleFlag = False
    TextFlag = False
End Sub

Sub CircleButton_Click ()
    DrawFlag = False
    LineFlag = False
    BoxFlag = False
    CircleFlag = True
    TextFlag = False
End Sub

Sub ClearButton_Click ()
    Cls
End Sub

Sub Command5_KeyPress (KeyAscii As Integer)
    Form1.Print Chr$(KeyAscii);
End Sub

Sub DrawButton_Click ()
    DrawFlag = True
    LineFlag = False
    BoxFlag = False
    CircleFlag = False
    TextFlag = False
End Sub

Sub DrawingItem_Click ()
    ControlPanel.NewColor.BackColor = ForeColor
    ControlPanel.Show
End Sub

Sub ExitItem_Click ()
    End
End Sub

Sub Form_Load ()
    DrawFlag = True
End Sub

Sub Form_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then      'Left Button
        AnchorX = X
        AnchorY = Y
        CurrentX = X
        CurrentY = Y
    End If
End Sub

Sub Form_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If (Button = 1) Then
        If DrawFlag Then
            Line -(X, Y)
        End If

        If LineFlag Then
            TempFore& = ForeColor
            TempMode% = DrawMode
            ForeColor = BackColor
            DrawMode = 7            'Xor mode
            Line (AnchorX, AnchorY)-(CurrentX, CurrentY)
            Line (AnchorX, AnchorY)-(X, Y)
            ForeColor = TempFore&
            DrawMode = TempMode%
        End If

        If BoxFlag Then
            TempFore& = ForeColor
            TempMode% = DrawMode
            ForeColor = BackColor
            DrawMode = 7            'Xor mode
            Line (AnchorX, AnchorY)-(CurrentX, CurrentY), , B
            Line (AnchorX, AnchorY)-(X, Y), , B
            ForeColor = TempFore&
            DrawMode = TempMode%
        End If

        If CircleFlag Then
            TempFore& = ForeColor
            TempMode% = DrawMode
            ForeColor = BackColor
            DrawMode = 7            'Xor mode
            radius! = Sqr((AnchorX - CurrentX) ^ 2 + (AnchorY - CurrentY) ^ 2)
            Circle (AnchorX, AnchorY), radius!
            radius! = Sqr((AnchorX - X) ^ 2 + (AnchorY - Y) ^ 2)
            Circle (AnchorX, AnchorY), radius!
            CurrentX = X
            CurrentY = Y
            ForeColor = TempFore&
            DrawMode = TempMode%
        End If


    End If
End Sub

Sub Form_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        If LineFlag Then
            Line (AnchorX, AnchorY)-(X, Y)
        End If

        If BoxFlag Then
            Line (AnchorX, AnchorY)-(X, Y), , B
        End If

        If CircleFlag Then
            radius! = Sqr((AnchorX - X) ^ 2 + (AnchorY - Y) ^ 2)
            Circle (AnchorX, AnchorY), radius!
        End If
    End If
End Sub

Sub FromItem_Click ()
    Picture = Clipboard.GetData()
End Sub

Sub LineButton_Click ()
    DrawFlag = False
    LineFlag = True
    BoxFlag = False
    CircleFlag = False
    TextFlag = False
End Sub

Sub LoadItem_Click ()
    LoadForm.Show
End Sub

Sub PasteItem_Click ()
    Picture = Clipboard.GetData()
End Sub

Sub PrintItem_Click ()
    DrawButton.Visible = False
    LineButton.Visible = False
    BoxButton.Visible = False
    CircleButton.Visible = False
    TextButton.Visible = False
    ClearButton.Visible = False
    PrintForm
    DrawButton.Visible = True
    LineButton.Visible = True
    BoxButton.Visible = True
    CircleButton.Visible = True
    TextButton.Visible = True
    ClearButton.Visible = True
End Sub

Sub SaveItem_Click ()
    SaveForm.Show
End Sub

Sub TextButton_Click ()
    DrawFlag = False
    LineFlag = False
    BoxFlag = False
    CircleFlag = False
    TextFlag = True
End Sub

Sub TextButton_KeyPress (KeyAscii As Integer)
    Print Chr$(KeyAscii);
End Sub

Sub ToItem_Click ()
    Clipboard.SetData Form1.Image
End Sub

