#include <windows.h>
#include "vbapi.h"
#include "box.h"

PROPINFO Property_BoxColor =
{
    "BoxColor",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    (USHORT)&(((BOX *)0)->BoxColor), 0, /* get offset */
    0,
    NULL, 0
};

PPROPINFO Box_Properties[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_TAG,
    &Property_BoxColor,
    PPROPINFO_STD_HWND,         //VB2
    NULL
};

WORD Paramtypes_ClickInside[] = {ET_R4, ET_R4};

EVENTINFO Event_ClickOutside =
{
    "ClickOutside",
    0,
    0,
    NULL,
    NULL
};

EVENTINFO Event_ClickInside =
{
    "ClickInside",
    2,
    4,
    Paramtypes_ClickInside,
    "X As Single,Y As Single"
};

PEVENTINFO Box_Events[] =
{
    &Event_ClickInside,
    &Event_ClickOutside,
    PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    NULL
};

MODEL modelBox =
{
    VB_VERSION,         
    0,                  
    (PCTLPROC)BoxCtlProc,   
    CS_VREDRAW | CS_HREDRAW,
    0L,
    sizeof(BOX),    
    IDBMP_BOX,      
    "Box",          
    "BoxClass",          
    NULL,            
    Box_Properties,   
    Box_Events,        
    IPROP_BOX_COLOR,         // VB2 Default property
    IEVENT_BOX_CLICKINSIDE,  // VB2 Default event
    IPROP_BOX_COLOR          // VB2 Property representing value of ctl
};

HANDLE hmodDLL;

int FAR PASCAL LibMain       //C7
(
    HANDLE hModule,
    WORD   wDataSeg,
    WORD   cbHeapSize,
    LPSTR  lpszCmdLine
)
{
    wDataSeg    = wDataSeg;
    cbHeapSize    = cbHeapSize;
    lpszCmdLine = lpszCmdLine;

    hmodDLL = hModule;

    return 1;
}

BOOL FAR PASCAL _export VBINITCC
(
    USHORT usVersion,
    BOOL   fRuntime
)
{
    fRuntime  = fRuntime;
    usVersion = usVersion;

    return VBRegisterModel(hmodDLL, &modelBox);
}



