#include <windows.h>
#include "vbapi.h"
#include "box.h"

VOID NEAR PaintBox(PBOX pbox, HWND hwnd, HDC hdc);
BOOL NEAR InBox(PBOX pbox, SHORT x, SHORT y);
VOID NEAR FireClickInside(HCTL hctl, SHORT x, SHORT y);
VOID NEAR FireClickOutside(HCTL hctl);

LONG FAR PASCAL _export BoxCtlProc
        (HCTL hctl, 
        HWND hwnd, 
        USHORT msg,
        USHORT wp, 
        LONG lp)
{
  PBOX pbox;
  LPRECT prect;   

  pbox = (PBOX)VBDerefControl(hctl);
  /* Note: Must dereferece hctl whenever we invalidate */
  /* pbox -- including after calls to VB API */

  switch (msg){
    case WM_CREATE:             /* Perform initialization here */
        pbox->BoxColor = FALSE;
        break;

    case WM_LBUTTONDOWN:        /* Button down in our control */
        case WM_LBUTTONDBLCLK:
        if (InBox(pbox, LOWORD(lp), HIWORD(lp))){
            FireClickInside(hctl, LOWORD(lp), HIWORD(lp));
        }
        else
            FireClickOutside(hctl);
        break;

    case WM_PAINT:              /* Repaint our control */
        if (wp)
            PaintBox(pbox, hwnd, (HDC)wp);
        else{
            PAINTSTRUCT ps;

            BeginPaint(hwnd, &ps);
            PaintBox(pbox, hwnd, ps.hdc);
            EndPaint(hwnd, &ps);
        }
        break;

    case WM_SIZE:               /* Our control was resized */
        prect = &pbox->rectDrawRegion;

        GetClientRect(hwnd, prect);        /* Draw box in a box */
        prect->left = prect->right / 4;
        prect->right = 3 * prect->right / 4;
        prect->top = prect->bottom / 4;
        prect->bottom = 3 * prect->bottom / 4;
        break;

    case VBM_SETPROPERTY:                 /* BoxColor was set */
        switch (wp){
        case IPROP_BOX_COLOR:
            pbox->BoxColor = (SHORT)lp;
            InvalidateRect(hwnd, NULL, TRUE);
            return 0;
        }
        break;
    }
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}

VOID NEAR PaintBox (PBOX pbox, HWND hwnd, HDC hdc)
{
    HBRUSH  hbr;
    HBRUSH  hbrOld = NULL;
    LPRECT  prect = &pbox->rectDrawRegion;
    hwnd = hwnd;

    if(pbox->BoxColor){
        hbr = CreateSolidBrush(RGB(0, 0, 255)); /* Blue brush */
        hbrOld = SelectObject(hdc, hbr);
    }
    Rectangle(hdc, prect->left, prect->top, prect->right, prect->bottom);
    if(pbox->BoxColor){
        SelectObject(hdc, hbrOld);         /* Restore old brush */
    }
}

BOOL NEAR InBox(PBOX pbox, SHORT x, SHORT y)
{
    LPRECT  prect = &pbox->rectDrawRegion;

    return ((prect->left < x) & (prect->right > x) & \
        (prect->top < y) & (prect->bottom > y));
}

VOID NEAR FireClickOutside(HCTL hctl)
{
    VBFireEvent(hctl, IEVENT_BOX_CLICKOUTSIDE, NULL);
}

typedef struct tagCLICKINSIDEPARMS
{
    float   far *Y;
    float   far *X;
    LPVOID  Index;
} CLICKINSIDEPARMS;

VOID NEAR FireClickInside(HCTL hctl, SHORT x, SHORT y)
{
    CLICKINSIDEPARMS EventParams;
    float     VisBasX, VisBasY;

    VisBasX = (float)VBXPixelsToTwips(x);
    VisBasY = (float)VBYPixelsToTwips(y);
    EventParams.X = &VisBasX;
    EventParams.Y = &VisBasY;

    VBFireEvent(hctl, IEVENT_BOX_CLICKINSIDE, &EventParams);
}


