=================================================================
README.MCR                                                         10/01/93
=================================================================

This README file contains a list and brief description of the
predefined macros that are included with WordPerfect 6.0 for
Windows. This file also contains information regarding macro
commands that were not included in the online macros manual.

Included in the following information.

1    Macros Included with WordPerfect 6.0 for Windows
2    SendKeys Information
3    SYSTEM VARIABLES - ?LeftCode and ?RightCode

MACROS
======
ABBREV.WCM
Lets you create and expand multiple abbreviations.

ADRS2MRG.WCM
Copies the address book (for automated templates) into a merge
data file.

ADRSBOOK.WCM
Allows manipulation of the address book.

ALLFONTS.WCM
Creates a document listing the every font available to the
current printer and some sample text in each font.

AUTOFILL.WCM
Used by the ExpressDocs Templates to automate the template
fill-in process.

CAPITAL.WCM
Capitalizes the first letter of the current word.

CLIPBRD.WCM
Opens the Windows Clipboard.

CLOSEALL.WCM
Closes all open documents and prompts you to save the modified
ones.

CTRLSFTF.WCM
For Equation Editor - prompts for FROM and TO values.

DROPCAP.WCM
Changes the first letter in a paragraph to a drop cap.

ENDFOOT.WCM
Converts endnotes to footnotes in document or selected text.

EXPNDALL.WCM
Expands all abbreviations in the document in one step.

FILESTMP.WCM
Places the filename and path of the current document in a header
or footer.

FONTDN.WCM
Decreases the font size of the selected text by 2 points.

FONTUP.WCM
Increases the font size of the selected text by 2 points.

FOOTEND.WCM
Converts footnotes to endnotes in document or selected text.

GOTODOS.WCM
Opens a DOS window.

LINENUM.WCM
Places the insertion point at a specified line and character for
debugging macros.

PAGEXOFY.WCM
Places "Page x of y pages" (or other pagination formats) in a
specified position on the page.

PARABRK.WCM
Inserts graphical paragraph breaks between paragraphs.

PGBORDER.WCM
Uses graphics (.WPG files) to create decorative page borders.

PROMPTS.WCM
Helps you create prompts for automated templates.

READCLP.WCM
Reads text in the clipboard.  Requires ProVoice or Monologue text
to speech software.

READFILE.WCM
Reads a text file or plays a .WAV, .AVI or .MID file.  Requires
ProVoice or Monologue text to speech software.

READSEL.WCM
Reads text selected in the document.  Requires ProVoice or
Monologue text to speech software.

REVERSE.WCM
Creates white text on black background (or other color options as
set by the user) in document text or tables.

SAVEALL.WCM
Saves all documents open documents and prompts you to save
modified ones.

SQCONFIG.WCM
Configures the Smart Quotes utility.

SQTOGGLE.WCM
Turns on and off the Smart Quotes utility.

TRANSPOS.WCM
Transposes the two characters preceding the insertion point.

WATERMRK.WCM
Prompts for text or watermark graphic that will be placed in
watermark (centered vertically and horizontally).

SENDKEYS
========
SENDKEYS allows the user to send key codes to the active window. 
This allows users to create keystroke macros.  

syntax
SENDKEYS WAIT (KeyCode; MarkupLanguage)

parameters
KeyCode(Character Expression)

You now have a choice of languages to use for this parameter. 
The MarkUp Language is the same language used in the WPWin
5.1/5.2 commands (See the Documentation in Macro Help for
SendKeys).  The Keystring language has been added for WPWin 6.0
(See Keystring Language below).


KEYSTRING LANGUAGE
The following meta-symbols can be used to specify a key or
keystring.

{VKnnn}             nnn = ANSI character number

{Alt}
{Ctrl}
{Control}
{Shift}

{0} - {9}           Digits
{A} - {Z}           Alphabet
{F1} - {F16}        Function keys

{NumLock}
{NumAdd}
{NumSubtract}
{NumMultiply}
{NumDivide}
{NumDecimal}
{Num0} - {Num9}     Numpad numbers

{Left}
{Right}
{Up}
{Dn}
{Down}

{PgDn}
{PageDown}
{PgUp}
{PageUp}

{Bksp}
{Backspace}
{Break}             Cancel
{CapsLock}
{Clear}
{Del}
{Delete}
{End}
{Enter}
{Esc}
{Escape}
{Help}              VK Help key
{Home}
{Ins}
{Insert}
{Minus}
{Pause}
{ScrLock}
{ScrollLock}
{PrintScrn}
{PrintScreen}
{Space}
{Tab}

{LeftBrace}         "{"
{RightBrace}        "}"


The meta-symbols are translated into a keydown message
(WM_KEYDOWN or WM_SYSKEYDOWN) and a keyup message (WM_KEYUP or
WM_SYSKEYUP).

The meta-symbols are not case-sensitive.  Spaces or other defined
symbols ('+' and '-') are delimiters.  For example, the keystring
"A B C Enter" would cause "ABC[Enter]" to be sent to the
application.

The plus (+) and minus (-) characters can be used to combine
metasymbols.  The '+' causes the preceding meta-symbol to defer
its keyup message until the following meta-symbol has processed
its keyup message.  For example, the keystring {Shift + Tab}
would cause the Shift key to be pressed and held while Tab was
pressed and released.  The Shift key would then be released.


If a meta-symbol does not follow a '+' character, then all keys
that were previously combined with the "+' character are left in
the down state until released.  For example, {Shift+Control+}
would cause both the Shift and Control keys to be left in a down
state.

Keys can be released (have their keyup message immediately
processed) by using the '-' character.  For example, the
keystring "-Control-Shift" would cause the Control key to be
released, followed by a release of the Shift key.

The '+' and '-' keys can be combined.  For example, the keystring
{Shift+Del- Del+Ins} would cause the selected text to be cut to
the Clipboard (Shift+Del) and then pasted at the insertion point
(Shift+Ins).

An example of SENDKEYS using the Keystring Language

This example will open the Open File Dialog box and list files
with the extension .DOC.

Application (A1;"WordPerfect"; Default;  "US")
InhibitInput(Off!)
SENDKEYS("{Alt+F}{O}*.DOC{Enter}";1)

This example will open the Windows Clipboard, remove the
contents, and close.

Application (A1;"WordPerfect"; Default;  "US")
APPEXECUTE("C:\Windows\Clipbrd.exe")
SENDKEYS WAIT("{Alt+E}{D}Y";1)
SENDKEYS WAIT("{Ctrl+Esc}{Alt+E}";1)

MarkupLanguage (Numeric Expression) (optional)
Specifies which Markup Language is used to interpret the key
codes.  If this parameter is not specified, the language defaults
to 1.

0    5.1/5.2 MarkUp Language
1    6.0 KeyString Language

SYSTEM VARIABLES - ?LeftCode and ?RightCode
===========================================
The values for ?LeftCode and ?RightCode do not match those of
WordPerfect 6.0 for DOS (WP60DOS).  This will be changed in a
future release of WordPerfect 6.0 for Windows (WPWin60).  Until
then, if you have a WP60DOS macro which uses ?LeftCode or
?RightCode, you will need to manually change the values in the
macro in order for it to play correctly in WPWin60.

Also, in order to find the correct values for ?LeftCode and
?RightCode, we suggest you use the Type command in a macro.  For
example, the following macro types the value of a code
immediately to the left of the insertion point: 

Application (A1; "WordPerfect"; Default; "US")
Type (?LeftCode)
