uses crt;

const max = 15;

type
  str20          = string[20];
  userrecord = RECORD
                 name,
                 location : STRING[30];
                 pwd,
                 phone : STRING[15];
                 lasttime,
                 lastdate,
                 firstdate,
                 birthdate,
                 subdate : STRING[8];

                 highmsgread : ARRAY[1..9] OF INTEGER;
                 highmsgauto : ARRAY[1..9] OF INTEGER;

                 timesposted,
                 timesrecived,
                 seclvl,
                 confaccess,
                 lastconf,
                 times,
                 ups,
                 downs,
                 ratio,
                 ratiotype,
                 lines,
                 computertype,
                 timeday,
                 time : WORD;

                 downbday,
                 todaydown,
                 upk,
                 downk : LONGINT;

                 extra,
                 cleared,
                 hidden,
                 deleted,
                 elite,
                 pause,
                 sendclearscreen,
                 nokill,
                 fullscreen,
                 filelistcolors,
                 subenabled,
                 transferlimitsoverride,
                 vip : BOOLEAN;

                 dateformat : BYTE;
                 groups : ARRAY[1..10] OF BYTE;
                 { 10 sets of 8 bit flags}
                 comment : STRING[45];
                 weekup : LONGINT; {For use by utilities}
                 weekdown : LONGINT; {For use by utilities}
                 expirepreset : BYTE; {What preset the user should have after expiration}
                 topupcps : WORD; {Users topcps}
                 topdowncps : WORD; {Users topcps}
                 creditbytes : LONGINT;
                 creditfiles : INTEGER;
 { Used to Credit User's a certain amount of bytes for download,
  This can be used in the following way :
    When the user selects to download the bytes or Files are FIRST taken off
   their bytes/files and then added to their download if the fields hit 0.
   This would be useful for things like - giving new users a certain amount of
   files/k they can download before having to worry about ratios, for paying
   users on systems, or for utils such as faker or games where users are given
   credits... This would anull users from being put on downloader charts, and
   would not muck up other top downloader per week/month etc type stuff and
   guarantee anomnity for users without having to make them hidden}
                 ibmansi : BOOLEAN;
 { This could be changed by the user with the 'W' command. This would be true
  if the user supported IBM Ansi type chars  which cannot be seen under normal
  circumstances by amiga/st/mac etc users }
                 avatar : BOOLEAN;
                 { For Avatar type gfx support - as above }
                 monthup,
                 monthdown : LONGINT;
 {As with weekly but for month! - Good for systems who dont have a huge amount
  of file xfer activity }
                 protocol : BYTE;
 { Default Download/Upload Protocol - Zmodem, Ymodem, HS-Link etc. - For when 
  it is supported or for external doors. }
               END;



var user   : userrecord;
    user_f : file of userrecord;
    out    : text;
    i,n,x  : integer;
    names  : array [1..max] of str20;

procedure logo;
begin
  textcolor (12);
  write ('WAITAXS 1.00; NEW USER VALIDATION!; (C)oded by Tedric 02/94');
  writeln;
end;

function richte (var s: str20) : str20;
var i : integer;
begin
  for i := 1 to length(s) do s[i] := upcase(s[i]);
  s := s + '                     ';
  richte := copy (s,1,20);
end;

procedure outputansi;
begin
  write (out,chr(27)+'[2J');
  write (out,chr(27)+'[1;37;42m');
  write (out,' WaitForAxs v1.0 bY TeDRiC [February 1994]                   (C)1994 by HTT ');
  write (out,chr(27)+'[0;37;40m');
  writeln (out);
  writeln (out, chr(27)+'[0;37m');
  for i := 1 to n do begin
    write (out, '    ',richte(names[i]));
    if i mod 3 = 0 then writeln (out);
  end;
  writeln (out);
  writeln (out,chr(27)+'[1;37;42m');
  write (out,' These people are awaiting access. If you know any of them, leave a Comment! ');
  writeln (out,chr(27)+'[0;34;40m');
  writeln (out, chr(27)+'[0m');
  write (out, chr(1));
  close (out);
end;

begin
  logo;
  if paramcount <> 1 then begin
    textcolor (4);
    writeln ('Usage: WAITAXS.EXE <path\name of .ANS file>');
    halt;
  end;
  assign (user_f, 'USERS.DAT');
  assign (out, paramstr(1));
  {$I-}
  reset (user_f);
  if ioresult <> 0 then begin
    textcolor (4);
    writeln ('ERROR opening USERS.DAT!');
    halt;
  end;
  rewrite (out);
  if ioresult <> 0 then begin
    textcolor (4);
    writeln ('ERROR opening ',paramstr(1));
    halt;
  end;
  {$I+}

  for i := 1 to max do names[i] := ' ';
  n := 0;

  while (not eof (user_f)) and (n <= max) do begin
    read (user_f,user);
    if user.seclvl = 10 then begin
      n := n + 1;
      names[n] := user.name;
    end;
  end;
  close (user_f);
  outputansi;
end.
