
'*********************************
' NETBIOS node name for NOSS
'*********************************
Global Const nossname = "APTNOSS"

Global Const OPEN_ABS = 1
Global Const OPEN_SET = 2
Global Const OPEN_CUR = 3
Global Const OPEN_END = 4

Global Const READONLY = 1
Global Const permanent = 2

Global Const A_READ = 0
Global Const A_WRITE = 1
Global Const A_APPEND = 2

'*********************************
' Error code definitions
'*********************************
Global Const DIAG_ERROR_TYPE = &H100               ' NOSSDiag() type errors
Global Const DIAG_NO_NAME = &H101                  ' No name for the node
Global Const DIAG_NO_NOSS = &H102                  ' NOSS not running
Global Const DIAG_NO_NETBIOS = &H103               ' NET BIOS not running
Global Const DIAG_BAD_RESPONSE = &H104             ' Bad BYTECOUNT field pattrn

Global Const CSF_ERROR_TYPE = 200                  ' General CSF type errors
Global Const CSF_MALLOC = &H201                    ' system malloc() error
Global Const CSF_EOT = &H202                       ' Read beyond EOT
Global Const CSF_RC_XFER_LENGTH = &H203            ' Request/Confirm mismatch
Global Const CSF_NB_XFER_LENGTH = &H204            ' Request/Confirm mismatch
Global Const CSF_NOSSST_USAGE = &H205              ' Usage error for NOSSST
Global Const CSF_BAD_MODE = &H206                  ' Bad MODE   for OPEN
Global Const CSF_BAD_ACCESS = &H207                ' Bad ACCESS for OPEN
Global Const CSF_BAD_NAME = &H208                  ' Bad station name given
Global Const CSF_TOO_MANY_OBJECT = &H209           ' Try to open too many object
Global Const CSF_BAD_OBJ_PTR = &H20A               ' An invalid OBJECT given

Global Const SRB_ERROR_TYPE = &H300                ' STATUS WORD of RSB
Global Const SRB_BAD_LFN = &H301                   ' Bad Logical Folder Number
Global Const SRB_BAD_OBJN = &H302                  ' Object Not Found
Global Const SRB_BAD_SID = &H303                   ' Bad Service ID
Global Const SRB_BAD_BYTECOUNT = &H304             ' Bad transfer length
Global Const SRB_BAD_SRN = &H305                   ' Bad Service Request Number
Global Const SRB_BAD_ACCESS = &H306                ' Read/Write access conflict or other improper access
Global Const SRB_NO_OBJN = &H307                   ' Error allocating obj num
Global Const SRB_FOLDER_ACTIVE = &H308             ' Not all objs closed
Global Const SRB_SIMUL_ADDPLAT = &H30A             ' ADDPLAT alread running
Global Const SRB_NOSS_ACTIVE = &H30B               ' Cannot ADDPLAT:NOSS in use.
Global Const SRB_OBJN_DELETED = &H30C              ' Object deleted
Global Const SRB_OBJN_READ_ONLY = &H30D            ' Object is readonly
Global Const SRB_OBJN_PERMANENT = &H30E            ' Object is permanent
Global Const SRB_SIMUL_SETATTRIB = &H30F           ' DEL* or SETATTRIB already running
Global Const SRB_OBJN_BADPLATID = &H310            ' Obj has bad platter id
Global Const SRB_OBJ_TOO_BIG = &H311               ' Cache too small for object for writing
Global Const SRB_FOLDER_TOO_BIG = &H312            ' Cache too small for read folder

Global Const NB_ERROR_TYPE = &H400                 ' &H04?? are for NETBIOS
' error codes from the global
' error variable nberror

' The following errors can be retried after a delay
Global Const NOSS_BUSY_TYPE = &H500
Global Const NOSS_NO_LFN = &H501                   ' No available LFN
Global Const NOSS_NO_SID = &H502                   ' No available SID
Global Const NOSS_FOLDER_NOT_DONE = &H503          ' Openning incomplete folder
Global Const NOSS_NB_SEND = &H504                  ' NB SEND error
Global Const NOSS_SMDB_BUSY = &H505                ' SMDB busy. Retry later
Global Const NOSS_CACHE_FULL = &H506               ' No room in cache storage
Global Const NOSS_MALLOC = &H507                   ' NOSS malloc error


' The following errors are fatal and requires rebooting NOSS
Global Const NOSS_FATAL_ERROR_TYPE = &H600
Global Const NOSS_NB_XFER_LENGTH = &H602           ' Transfer length mismatch
Global Const NOSS_BAD_BAM_LBA = &H603              ' bad BAM block address
Global Const NOSS_HARDDISK_CRASH = &H604           ' Cannot happen!!!
Global Const NOSS_LOST_SMDB = &H605                ' Serious Pointer BUG.
Global Const NOSS_OBJDB_LOST = &H606               ' Error in OBJDB management
Global Const NOSS_GET_OBJREC = &H607               ' OBJDB chainning error
Global Const NOSS_GET_OBJ = &H608                  ' Error doing get_obj()
Global Const NOSS_DISK_SYNCH = &H609               ' Primary and Backup disk
					     ' miss-synchronized.
Global Const NOSS_JUKEBOX_ERROR = &H60A            ' All jukebox access error
Global Const NOSS_NO_STORAGE_DRIVE = &H60B         ' No drive available
Global Const NOSS_NO_STORAGE_SLOT = &H60C          ' No storage slot available

' The following errors are related to disk management
Global Const NOSS_NO_OPTICAL_SPACE = &H701         ' All active platter full
Global Const NOSS_DISK_OFFLINE = &H702             ' Disk not inside jukebox

' The following are errors related to DOS operation
Global Const DOS_ERROR_TYPE = &H800
Global Const DOS_FILE_ACCESS = &H801               ' General DOS file error
Global Const DOS_USAGE = &H802                     ' Usage errors
Global Const DOS_ABORTED = &H803                   ' User abort

Global Const SCSI_ERROR = &H1000                   ' 1xxx: xxx is retcode of
					     '       aptcall()
Global Const HARDDRIVE_ERROR = &H2000              ' 2xxx: xxx is DOS err code for int 25H and 26H

'************************************************
' Platter Management Database   (PLTDB)
'  Each platter in the NOSS system will have
'  up to 2 PLTDB records (one per side).
'  Backup platters do not have a record since
'  they are mirror immages of the originals.
'************************************************
Type PLTDBtype
    
    id As Integer'                  ' platter id 0 to 7fffh
											'      (bits 0 to 14)
				    ' highest bit set means it
				    ' is a backup platter.
   rev_id As Integer'              ' platter id of rev side
   home As Integer'                ' home physical slot number
   location As Integer'            ' current phys. slot number
   space As Long'              ' Number of free sectors
   next_write As Long'         ' next sector to be written
   Status As Integer'              ' 0xSSCC
				    ' CC is condition:
				    '     x0 : fresh, unused
				    '     x1 : active write
				    '     x2 : read only
				    '     x3 : add_plat in use
				    '   x4 : RO src platter
				    '     0x : in jukebox
				    '     1x : don't touch!
				    '     fx : out of jukebox
				    ' SS is status (bits 8-15):
				    ' bit  8 : moving/stationed
				    ' bit  9 : being loaded
				    ' bit 10 : being unloaded
				    ' bit 11 : being flipped
				    ' bit 12 : already loaded
				    ' bit 13 : spung up, ready
				    ' bit 14 : flipped
				    ' bit 15 : 0:load for read
				    '          1:load for write
   lock As Integer'                ' #of locks on the platter
   class As Integer'               ' 0xBGTT
				    '  where B is backup mode
				    '    0: No auto backup
				    '    1: Dynamic
				    '    2: Periodic
				    '
				    '        G is group number
				    '    0 - F, user defined
				    '
				    '        TT is platter type
				    '    00-FF, user defined.
   ssize As Integer'                                      ' sector size (bytes)
   backup1 As Integer'             ' backup parameter 1
												' bit 0-4  time zone start
												' bit 5-15 last backup time
   backup2 As Integer'             ' backup parameter 2
												' bit 0-4  time zone stop
												' bit 8-15 backup interval
   mtype As String * 1'                                                              ' media type: 2=WORM 3=MO
												' drives so that approriate
												' ignored if non-multifunction
												' drives are used.
   reserved As String * 3'                 ' unused
End Type

'************************************************
' Noss Infomation Structure (NOSSINFO)
'  This is for the nossdiag function.
'************************************************
Type nossinfostr
   hfree As Long       ' space available for halloc()
   cfree As Long       ' space available for calloc() and malloc
   bamsize As Integer  ' byte size of BAMMAP size
   bam As Long         ' char far*
End Type

'*****************************************************
' The OBJECT Structure
'  (For open/create/close/read/write operations
'  to objects.  Analogus to "C" FILE structure.)
' WARNING: User applications shall not change the
'          the contents of these fields.   These
'          fields are considered read-only.
'*****************************************************
Type objectstr

    lfn As Integer         ' Logical Folder Number
    sid As Integer         ' Service ID
    objn As Long           ' Object Number
    dtp As Long            ' Data Transfer Pointer
    first_obj As Long      ' obj num of 1st obj in folder
    num_objs As Integer    ' Number of objs in the folder
    folder_size As Long    ' Total Storage Occupied by folder
    obj_size As Long       ' Size of current object
    bytes_unread As Long   ' Number of un-read bytes
    attribute As Integer   ' Attribute of object
    lsn As String * 1      ' LSN
End Type
Type objdb
   obj_f_obj As Long '               /* Pointer to first object     */   _
   obj_b_link As Long'              /* Pointer to previous         */   _
   obj_f_link As Long'              /* Pointer to next entry       */   _
   obj_obj_size As Long'            /* Byte size of the object     */   _
   obj_start_sector As Long'        /* Starting sector of the obj  */   _
   obj_platter As Integer'              /* Platter number. Even:side A */   _
   obj_date As Integer '                /* Standard DOS date           */   _
   obj_time As Integer'                 /* Standard DOS time           */   _
   obj_status As String * 1'              /* Status of entry             */   _
		       '                   /*    Bit 0: 1 if valid        */   _
		       '                   /*    Bit 1: 1 if obj closed   */
		       '                   /*    Bit 2: 1 if folder closed*/   _
		       '                   /*    Bit 3: 1 if deleted           _
		       '                   /*    Bit 4: 1 if read only    */   _
		       '                   /*    Bit 5: 1 if permanent    */   _
		       '                   /*    Bit 6: 1 if being loaded */   _
		       '                   /*    Bit 7: 1 if archived     */   _
   bam_addr As Integer  '                             /* first bam blk for the f_
   reserved As String * 3'             /* Unused. All 0's             */   _
End Type


'*********************************
'  CSF declarations
'*********************************
' terminates a folder operation:
Declare Function apt_closefolder_% Lib "CSFDLL.DLL" (ByVal lfn%)

' terminates an object operation: objptr
Declare Function apt_closeobject_% Lib "CSFDLL.DLL" (objptr As Any)

' creates a new folder: object class
Declare Function apt_createfolder_% Lib "CSFDLL.DLL" (ByVal objc%, lfn%)

' creates a new object:lfn,objnumptr,attribute
Declare Function apt_createobject_% Lib "CSFDLL.DLL" (ByVal lfn%, objptr As Any, ByVal attribute%)

' marks an obj as deleted
Declare Function apt_deleteobject_% Lib "CSFDLL.DLL" (ByVal objn&)

' checks end of transmission: objptr
Declare Function apt_eot_% Lib "CSFDLL.DLL" (objptr As Any)

' gets the workstation name from local name table
Declare Function apt_getname_% Lib "CSFDLL.DLL" (ByVal nbname$)

' gets platter record from NOSS
Declare Function apt_getplatinfo_% Lib "CSFDLL.DLL" (buffer As Any, num_platters%)

' gets the APTNOSS server name (group name) from name table
Declare Function apt_getrname_% Lib "CSFDLL.DLL" (ByVal sname$)

' get an object and store as DOS file
Declare Function apt_getobject_% Lib "CSFDLL.DLL" (ByVal lfn%, ByVal objn&, ByVal fname$, ByVal smode$)

' get infor about an object:objn
Declare Function apt_getobjinfo_% Lib "CSFDLL.DLL" (objptr As Any)

' performs Netbios Reset
Declare Function apt_netreset_% Lib "CSFDLL.DLL" ()

' performs NOSS diagnostics: niptr
Declare Function apt_nossdiag_% Lib "CSFDLL.DLL" ()

' opens an existing folder: objn,access="R" for read or "A" for append
Declare Function apt_openfolder_% Lib "CSFDLL.DLL" (ByVal objn&, ByVal accessm$, lfn%)

' retrieves an object :lfn,objn,mode="D","A", or "R" ,access
Declare Function apt_openobject_% Lib "CSFDLL.DLL" (ByVal lfn%, ByVal objn&, ByVal objptr As Any, ByVal mode$, ByVal accessm$)

' stores a DOS file as an object into a folder
Declare Function apt_putobject_% Lib "CSFDLL.DLL" (ByVal lfn%, ByVal fname$, ByVal attribute%, objn&)

' reads from an opened object:objptr,buffer,bytecount
Declare Function apt_readobject_% Lib "CSFDLL.DLL" (objptr As Any, ByVal buffer$, ByVal count%)

' sets local and noss name: localname,nossname
Declare Function apt_setname_% Lib "CSFDLL.DLL" (ByVal LocalName$, ByVal nossname$)

' writes to an object:objptr,buffer,count
Declare Function apt_writeobject_% Lib "CSFDLL.DLL" (objptr As Any, ByVal buffer$, ByVal count%)

'FILE HISTORY

'12-04-90:      Added errors &H311 and &H312 to handle inadaquit cache size problems
'01-16-91:      Added error &H209 for too many object open.
'06-24-91:      'oved netbios related GLOBAL CONSTants.  Netbios.h will have them.
'08-30-91:      Modify from apt_func.h to fit the csfdll.
'05-05-91:      Created VBCSFDLL.TXT Visual Basic declarations file from CSFDLL.H

Global lfn As Integer
Global Folders() As Integer
Global Ccount As Integer


