/******************************************************************************

		Program: wcsf.h 
		
		Purpose: Header file of CSFDLL demo program
		
		Copyright (c) 1991 by Applied Programming Technologies, Inc. 
		
*******************************************************************************/		

/*  for dialog  box */

#define  IDC_Class 200
#define  IDC_LFN   201
#define  IDC_FName 202
#define  IDC_EDIT  203
#define  IDC_EDIT1 204
#define  IDC_EDIT2 205
#define  IDC_LName 206
#define  IDC_RName 207
#define  IDC_ONum  208
#define  IDC_Mode  209
#define  IDC_EDIT3 210
#define  IDM_DYNAMIC 211
#define  IDM_STATIC 212
#define  IDM_ABOUT  213
#define  IDM_GO     214
#define  IDC_logn1  215
#define  IDC_logn2  216
#define  IDM_RESTART 217


int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, int);
long FAR PASCAL MainWndProc(HWND, unsigned, WORD, LONG);
int FAR PASCAL FOpen(HWND, unsigned, WORD, LONG);
int FAR PASCAL FClose(HWND, unsigned, WORD, LONG);
int FAR PASCAL SetName(HWND, unsigned, WORD, LONG);
int FAR PASCAL UnSetName(HWND, unsigned, WORD, LONG);
int FAR PASCAL PutObj(HWND, unsigned, WORD, LONG);
int FAR PASCAL GetObj(HWND, unsigned, WORD, LONG);
int FAR PASCAL GetObIn(HWND, unsigned, WORD, LONG);
int FAR PASCAL FCreate(HWND, unsigned, WORD, LONG);
long FAR PASCAL GetPInfoWndProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL About(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL AboutCSF(HWND, unsigned, WORD, LONG);
long FAR PASCAL PutdirWndProc(HWND, unsigned, WORD, LONG);
long FAR PASCAL VerdirWndProc(HWND, unsigned, WORD, LONG);
int FAR PASCAL PutdirInput(HWND, unsigned, WORD, LONG);
int FAR PASCAL VerdirInput(HWND, unsigned, WORD, LONG);

/**************************************************/
/* Platter Management Database   (PLTDB)          */
/*  Each platter in the NOSS system will have     */
/*  up to 2 PLTDB records (one per side).         */
/*  Backup platters do not have a record since    */
/*  they are mirror immages of the originals.     */
/**************************************************/
#define PLTDB struct pltdbstr

PLTDB
{
   unsigned int id;                 /* platter id 0 to 7fffh     */
   											/*      (bits 0 to 14)       */
                                    /* highest bit set means it  */
                                    /* is a backup platter.      */
   unsigned int rev_id;             /* platter id of rev side    */
   unsigned int home;               /* home physical slot number */
   unsigned int location;           /* current phys. slot number */
   unsigned long space;             /* Number of free sectors    */
   unsigned long next_write;        /* next sector to be written */
   unsigned int status;             /* 0xSSCC                    */
                                    /* CC is condition:          */
                                    /*     x0 : fresh, unused    */
                                    /*     x1 : active write     */
                                    /*     x2 : read only        */
                                    /*     x3 : add_plat in use  */
                                    /* 	 x4 : RO src platter   */
                                    /*     0x : in jukebox       */
                                    /*     1x : don't touch!     */
                                    /*     fx : out of jukebox   */
                                    /* SS is status (bits 8-15): */
                                    /* bit  8 : moving/stationed */
                                    /* bit  9 : being loaded     */
                                    /* bit 10 : being unloaded   */
                                    /* bit 11 : being flipped    */
                                    /* bit 12 : already loaded   */
                                    /* bit 13 : spung up, ready  */
                                    /* bit 14 : flipped          */
                                    /* bit 15 : 0:load for read  */
                                    /*          1:load for write */
   unsigned int lock;               /* #of locks on the platter  */
   unsigned int class;              /* 0xBGTT                    */
                                    /*  where B is backup mode   */
                                    /*    0: No auto backup      */
                                    /*    1: Dynamic             */
                                    /*    2: Periodic            */
                                    /*                           */
                                    /*        G is group number  */
                                    /*    0 - F, user defined    */
                                    /*                           */
                                    /*        TT is platter type */
                                    /*    00-FF, user defined.   */
	unsigned int ssize;					/* sector size (bytes)       */
   unsigned int backup1;            /* backup parameter 1        */
												/* bit 0-4  time zone start  */
												/* bit 5-15 last backup time */
   unsigned int backup2;            /* backup parameter 2        */
												/* bit 0-4  time zone stop   */
												/* bit 8-15 backup interval  */
	char mtype;								/* media type: 2=WORM 3=MO       */
												/* used only for Multifunction   */
												/* drives so that approriate     */
												/* mode change can occure.       */
												/* ignored if non-multifunction  */
												/* drives are used.              */
   char reserved[3];                /* unused                    */
};

/* File History */
/*
09-18-91:	First create
*/
