/******************************************************************************

	
    PROGRAM: wcsf.c  Version 1.02

    PURPOSE: CSF DEMO Program for Windows applications
    
    Copyright (c) 1991 Applied Programming Technologies, Inc.
    
    
******************************************************************************/    
/******************************************************************************


    FUNCTIONS:

	WinMain() 			- calls initialization function, processes message loop
	InitApplication() - initializes window data and registers window
	InitInstance() 	- saves instance handle and creates main window
	MainWndProc() 		- processes messages
	FOpen() 				- processes open folder
	FClose() 			- processes close folder
	FCreate() 			- processes create folder
	PutObj() 			- processes put object
	GetObj() 			- processes get object
	GetObjIn() 			- processes get object information
	GetPInfo() 			- processes get platter information
	
	

    COMMENTS:

        Windows can have several copies of your application running at the
        same time.  The variable hInst keeps track of which instance this
        application is so that processing will be to the correct window.

****************************************************************************/

#define  NOCOMM 1
#include <windows.h>		    /* required for all Windows applications */
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "wcsf.h"		       /* specific to this program		     */
#include "..\h\apt_func.h"  /* for apt functions */

#define  button_num  12      // number of button window
#define  UCHAR unsigned char
#define  button_version 0
#define  button_setname 1
#define  button_unsetname 2
#define  button_fopen   3
#define  button_fclose  4
#define  button_getobj  5
#define  button_putobj  6
#define  button_getpinfo 7
#define  button_getobin 8
#define  button_fcreate 9
#define  button_putdir  10
#define  button_verdir  11

#define  BUFSIZE  2048

HANDLE hInst;			   /* current instance			     */
HANDLE hHourGlass;      /* handle to hourglass cursor      */
HANDLE hSaveCursor;     /* current cursor handle      */
unsigned long object_number;		// object number 
UCHAR mode[2];				// "D", "R" or "W" 
unsigned lfn; 				// logical folder number
unsigned Objc=0;          // Object class
static char str[80];				// for displayed message
static char str1[20][80];		// for displayed message
static char find_name[500][80];	// for store file name
unsigned dir_num=0;					// indecate the # dir name found
unsigned first;
unsigned current=0;
char lname[17];         // Local name
char rname[17];         // Noss name
static UCHAR fname[80];        // file name
static UCHAR logfname1[80]="";    // log file name
static UCHAR logfname2[80]="";    // log file name
int idTimer;				// handle of timer
PLTDB *platter;			// point to platter 
unsigned totalnum;    // total platter number
unsigned totalline,pretotalline;
RECT rect,title;		
int Height = 16;
BOOL screen = FALSE;	// default is static screen
unsigned line=0,Preline=0;
BOOL gpi=FALSE;
BOOL copy_gpi=FALSE;
char s1[]="   ID        R_ID    Home  Group Class Sector Mode Time_Zone   Interval"; 
char s2[]="   ID            Slot       Next_write       Available       Lock    Status"; 
int outf,inf;
unsigned changed=0;
unsigned char *buffer,*buffer2;
unsigned verdirEnd =0;

void GetVscroll(unsigned *line,unsigned totalnum,WORD wParam,LONG lParam);
WORD Putdir(HWND hWnd);
WORD Verdir(HWND hWnd);
void fill_fname(char *p);
unsigned do_Putfile(HWND htmpWnd,char *p,unsigned lfn);
void sort(HWND htmpWnd,RECT *rect);
unsigned char hexdigit(unsigned char c);
WORD GetPInfo(HWND hWnd);
unsigned long hex2num(char *s);
unsigned long dec2num(char *s);

void *lAlloc(unsigned memsize);
void lFree(void *bufptr);
unsigned _fgets(char *buf,unsigned count,int fh);
void PostMessageProc(HWND hWnd,WORD wsmg,WORD wP,DWORD lP);

/* This function is undocumented */
WORD FAR PASCAL apt_get_version(void);

/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

    COMMENTS:

        Windows recognizes this function by name as the initial entry point 
        for the program.  This function calls the application initialization 
        routine, if no other instance of the program is running, and always 
        calls the instance initialization routine.  It then executes a message 
        retrieval and dispatch loop that is the top-level control structure 
        for the remainder of execution.  The loop is terminated when a WM_QUIT 
        message is received, at which time this function exits the application 
        instance by returning the value passed by PostQuitMessage(). 

        If this function must abort before entering the message loop, it 
        returns the conventional value NULL.  

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;			     /* current instance	     */
HANDLE hPrevInstance;		  /* previous instance	     */
LPSTR lpCmdLine;			     /* command line		     */
int nCmdShow;				     /* show-window type (open/icon) */
{
    MSG msg;				     /* message			     */

    if (!hPrevInstance)			         /* Other instances of app running? */
   	if (!InitApplication(hInstance)) /* Initialize shared things */
	    return (FALSE);		            /* Exits if unable to initialize     */

    /* Perform initializations that apply to a specific instance */

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    /* Acquire and dispatch messages until a WM_QUIT message is received. */

    while (GetMessage(&msg,	   /* message structure			     */
	    NULL,		   /* handle of window receiving the message */
	    NULL,		   /* lowest message to examine		     */
	    NULL))		   /* highest message to examine	     */
	{
	TranslateMessage(&msg);	   /* Translates virtual key codes	     */
	DispatchMessage(&msg);	   /* Dispatches message to window	     */
    }
    return (msg.wParam);	   /* Returns the value from PostQuitMessage */
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

        This function is called at initialization time only if no other 
        instances of the application are running.  This function performs 
        initialization tasks that can be done once for any number of running 
        instances.  

        In this case, we initialize a window class by filling out a data 
        structure of type WNDCLASS and calling the Windows RegisterClass() 
        function.  Since all instances of this application use the same window 
        class, we only need to do this when the first instance is initialized.  


****************************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;			       /* current instance	     */
{
    WNDCLASS  wc;
    BOOL success;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.                                                           */

    wc.style = NULL;//CS_VREDRAW | CS_HREDRAW | CS_SAVEBITS;     /* Class style(s).                    */
    wc.lpfnWndProc = MainWndProc;       /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance,"wcsf");/* Load own icon */
    wc.hCursor = LoadCursor(NULL,IDC_ARROW);/* Load cursor ARROW */
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "MainMenu";			    /* Name of menu resource in .RC file. */
    wc.lpszClassName = "WcsfWClass"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    success=RegisterClass(&wc);
    if(!success)
    	return(success);
    	
    wc.style = NULL;//CS_VREDRAW | CS_HREDRAW | CS_SAVEBITS;     /* Class style(s).                    */
    wc.lpfnWndProc = GetPInfoWndProc;       /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance,"gpi");/* Load own icon */
    wc.hCursor = NULL;						 /* Load cursor ARROW */
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "GPIMenu";			    /* Name of menu resource in .RC file. */
    wc.lpszClassName = "GetPInfoWClass"; /* Name used in call to CreateWindow. */
    
    success=RegisterClass(&wc);
    if(!success)
    	return(success);
    	
    wc.style = NULL;//CS_VREDRAW | CS_HREDRAW | CS_SAVEBITS;     /* Class style(s).                    */
    wc.lpfnWndProc = PutdirWndProc;       /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance,"display");/* Load own icon */
    wc.hCursor = NULL;						 /* Load cursor ARROW */
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "PutdirMenu";			    /* Name of menu resource in .RC file. */
    wc.lpszClassName = "PutdirWClass"; /* Name used in call to CreateWindow. */
    
    success=RegisterClass(&wc);
    if(!success)
    	return(success);
    	
    wc.style = NULL;//CS_VREDRAW | CS_HREDRAW | CS_SAVEBITS;     /* Class style(s).                    */
    wc.lpfnWndProc = VerdirWndProc;       /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance,"display");/* Load own icon */
    wc.hCursor = NULL;						 /* Load cursor ARROW */
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "VerdirMenu";			    /* Name of menu resource in .RC file. */
    wc.lpszClassName = "VerdirWClass"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return(RegisterClass(&wc));

}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

    COMMENTS:

        This function is called at initialization time for every instance of 
        this application.  This function performs initialization tasks that 
        cannot be shared by multiple instances.  

        In this case, we save the instance handle in a static variable and 
        create and display the main program window.  
        
****************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE          hInstance;          /* Current instance identifier.       */
    int             nCmdShow;           /* Param for first ShowWindow() call. */
{
    HWND            hWnd;               /* Main window handle.                */

    /* Save the instance handle in static variable, which will be used in  */
    /* many subsequence calls from this application to Windows.            */

    hInst = hInstance;

    /* Create a main window for this application instance.  */

    hWnd = CreateWindow(
        "WcsfWClass",                /* See RegisterClass() call.          */
        "APT Client Service Function DEMO Program",   /* Text for window title bar.         */
        WS_OVERLAPPEDWINDOW
        /*|WS_CAPTION|WS_SYSMENU*/,            /* Window style.                      */
        0,                  /*  horizontal position.       */
        0,                  /*  vertical position.         */
        640, 				    /*  width.                     */
        200,                /*  height.                    */
        NULL,                           /* Overlapped windows have no parent. */
        NULL,                           /* Use the window class menu.         */
        hInstance,                      /* This instance owns this window.    */
        NULL                            /* Pointer not needed.                */
    );

    /* If window could not be created, return "failure" */

    if (!hWnd)
      return (FALSE);

    /* Make the window visible; update its client area; and return "success" */

    hHourGlass = LoadCursor(NULL, IDC_WAIT);
    
    ShowWindow(hWnd, nCmdShow);  /* Show the window                        */
    UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
    return (TRUE);               /* Returns the value from PostQuitMessage */

}


long FAR PASCAL GetPInfoWndProc(hGPIWnd, message, wParam, lParam)
HWND hGPIWnd;			   	  /* window handle		     */
unsigned message;			  /* type of message		     */
WORD wParam;				  /* additional information	     */
LONG lParam;				  /* additional information	     */
{
	int i,count;
	HDC hdc;
	static PAINTSTRUCT ps;
	static TEXTMETRIC  textmetric;
	int         nLineHeight;
	int	DrawX,DrawY;
	PLTDB *p;
   FARPROC lpProcAbout;
   unsigned Hpos;
	HANDLE mhandle;
   HMENU hMenu;
	PSTR temp;
   switch (message) 
    {
		case WM_CREATE:
			gpi=FALSE;
			mhandle=LocalAlloc(LMEM_DISCARDABLE|LMEM_ZEROINIT,
	                   (unsigned long)(30*sizeof(PLTDB)));
			if (mhandle!=NULL) 
			{
				temp=LocalLock(mhandle);			// Lock the memory
				if (temp!=NULL)
					platter=(PLTDB *)temp;			// return pointer allocated
				else
				{
					LocalFree(mhandle);				// free the memory
					goto error;
				}	
			}	
			else
			{
error:;			
				MessageBox(hGPIWnd,"no enough memory",NULL,MB_OK );
				gpi=TRUE;
	   		PostQuitMessage(0);
				return(0L);
			}   
			if(apt_getplatinfo(platter,&totalnum))
			{
				sprintf(str,"Can't Get Platter information,Error code %d",apt_status);
				MessageBox(hGPIWnd,str,NULL,MB_OK );
				LocalUnlock((HANDLE)LocalHandle((WORD)platter));			// unlock the memory buffer
				LocalFree((HANDLE)LocalHandle((WORD)platter));				// free the memory buffer
				gpi=TRUE;
	   		PostQuitMessage(0);
				return(0L);
			}
			if(!SetTimer(hGPIWnd,2,5000,(FARPROC)NULL))
			{
				sprintf(str,"Too many clocks");
				MessageBox(hGPIWnd,str,NULL,MB_OK );
				LocalUnlock((HANDLE)LocalHandle((WORD)platter));			// unlock the memory buffer
				LocalFree((HANDLE)LocalHandle((WORD)platter));				// free the memory buffer
				gpi=TRUE;
	   		PostQuitMessage(0);
				return(0L);
			}
			line = 0;
			SetScrollRange(hGPIWnd,SB_VERT,0,100,FALSE);
			SetScrollPos(hGPIWnd,SB_VERT,0,TRUE);
	  		InvalidateRect(hGPIWnd,&rect,TRUE);
	  		InvalidateRect(hGPIWnd,&title,TRUE);
  		 	copy_gpi = TRUE;
			break;
	  case WM_TIMER:
	  		InvalidateRect(hGPIWnd,&rect,TRUE);
			break;
	  case WM_COMMAND:
	  		switch(wParam)
	  		{
	  			case IDM_STATIC:
	  				if(screen == TRUE)
	  				{
		    			hMenu = GetMenu(hGPIWnd);
		    			CheckMenuItem(hMenu, IDM_STATIC, MF_CHECKED);
		    			CheckMenuItem(hMenu, IDM_DYNAMIC, MF_UNCHECKED);
	  					screen = FALSE;
	  					InvalidateRect(hGPIWnd,&title,TRUE);
	  				}	
	  				break;
	  			case IDM_DYNAMIC:
	  				if(screen == FALSE)
	  				{
		    			hMenu = GetMenu(hGPIWnd);
		    			CheckMenuItem(hMenu, IDM_DYNAMIC, MF_CHECKED);
		    			CheckMenuItem(hMenu, IDM_STATIC, MF_UNCHECKED);
	  					screen = TRUE;
	  					InvalidateRect(hGPIWnd,&title,TRUE);
	  				}	
	  				break;
	  			case IDM_ABOUT:
					lpProcAbout = MakeProcInstance(About, hInst);

					DialogBox(hInst,		 /* current instance	     */
		    			"About",			 /* resource to use	     */
		    			hGPIWnd,			 /* parent handle	     */
		    			lpProcAbout);		 /* About() instance address */

					FreeProcInstance(lpProcAbout);
	  				break;
	  		}		
	  		break;
		case WM_VSCROLL:
			GetVscroll(&line,totalnum,wParam,lParam);		// Calculate new y offset
			if (Preline!=line)
			{
				// if something changes
				Hpos = 100*line / totalnum;
				SetScrollPos(hGPIWnd,SB_VERT,Hpos,TRUE);// Set scroll bar position
				InvalidateRect(hGPIWnd,&rect,TRUE);
				Preline=line;
			}
			break;
	  case WM_PAINT:
			if(apt_getplatinfo(platter,&totalnum))
			{
				sprintf(str,"Can't Get Platter information,Error code %d",apt_status);
				MessageBox(hGPIWnd,str,NULL,MB_OK );
				DestroyWindow(hGPIWnd);
				return(0L);
			}
			count = 0;
	  		hdc = BeginPaint(hGPIWnd,&ps);
   		GetTextMetrics(hdc,&textmetric);
   		nLineHeight = textmetric.tmExternalLeading + textmetric.tmHeight;
   		title.left   = rect.left  = GetDeviceCaps(hdc,LOGPIXELSX) / 4 ;
   		title.right  = rect.right = GetDeviceCaps(hdc,HORZRES);
   		title.top    = GetDeviceCaps(hdc,LOGPIXELSY) / 4 ;
   		title.bottom = title.top + 2 * nLineHeight;
   		rect.top     = title.bottom + nLineHeight;
   		rect.bottom  = GetDeviceCaps(hdc,VERTRES) ;
	  		DrawX=rect.left;
	  		DrawY=rect.top;
			for(i=line;i<totalnum;i++)
			{
				p=platter+i;
				if(screen == FALSE)		// static screen
					wsprintf(str,"%04XH  %04XH   %04XH      %3d      %3d      %4d       %1d      %02d-%02d  %4d Min.",
					p->id,p->rev_id,p->home,(p->class&0x0f00)>>8,(p->class&0x00ff),p->ssize,(p->class>>12),(p->backup1&0x001f),(p->backup2&0x001f),(((p->backup2&0xffe0)>>5)*5));
				else							// dynamic screen
					wsprintf(str,"%04XH      %04XH      %0.8ld      %0.8ld %2ld%%     %3d     %x",
					p->id,p->location,p->next_write,p->space*(long)p->ssize/0x400L,p->space*100L/(p->space+p->next_write),p->lock,p->status);
	  			TextOut(hdc,DrawX,DrawY,str,lstrlen(str));
				DrawY += textmetric.tmExternalLeading + textmetric.tmHeight;
	  		}
	  		if(screen == FALSE)
  				TextOut(hdc,title.left,title.top,s1,lstrlen(s1));
  			else
  				TextOut(hdc,title.left,title.top,s2,lstrlen(s2));
  			TextOut(hdc,title.left,title.top+nLineHeight,
  			"------------------------------------------------------------------------------------------------------------------------------------",132);
	  		EndPaint(hGPIWnd,&ps);	
      break;
	case WM_DESTROY:		  /* message: window being destroyed */
		KillTimer(hGPIWnd,2);
		LocalUnlock((HANDLE)LocalHandle((WORD)platter));			// unlock the memory buffer
		LocalFree((HANDLE)LocalHandle((WORD)platter));				// free the memory buffer
		copy_gpi = FALSE;
	   PostQuitMessage(0);
	   break;

   default:			  /* Passes it on if unproccessed    */
	    return (DefWindowProc(hGPIWnd, message, wParam, lParam));
    }
    return (0L);
}
void  GetVscroll(WORD *line,WORD totalnum,WORD wParam,LONG lParam)
{
	switch(wParam)
	{
		case SB_TOP:
			*line=0;
			break;
		case SB_BOTTOM:
			*line = totalnum;
			break;
		case SB_LINEUP:
			if(*line > 0)
				*line -= 1;
			break;
		case SB_LINEDOWN:
			if(*line < totalnum)
				*line += 1;
			break;
	}
}	  			
			
long FAR PASCAL PutdirWndProc(hPutdirWnd, message, wParam, lParam)
HWND hPutdirWnd;			   	  /* window handle		     */
unsigned message;			  /* type of message		     */
WORD wParam;				  /* additional information	     */
LONG lParam;				  /* additional information	     */
{
	int i;
	HDC hdc;
	static PAINTSTRUCT ps;
	static TEXTMETRIC  textmetric;
	int   nLineHeight;
	int	DrawX,DrawY;
	unsigned first,length;
	unsigned char sname[80];
	static struct find_t ft;
	static int keystop=0;
   switch (message) 
    {
		case WM_CREATE:
			totalline =0;
			first=1;
			pretotalline =0;
			keystop=0;
			if((*(fname+lstrlen(fname)-1) != '\\')&&(*(fname+lstrlen(fname)-1) != ':'))
			{
				*(fname+lstrlen(fname)+1) = 0;
				*(fname+lstrlen(fname)) = '\\';
			}
			lstrcpy(find_name[dir_num],fname);
			dir_num++;
			fill_fname(fname);
			outf=_lopen(logfname1,OF_READWRITE);
			if(outf==-1)
			{
				outf=_lcreat(logfname1,0);
				if(outf==-1) 
				{
			   	PostQuitMessage(0);
					return(0L);
				}
			}
			PostMessage(hPutdirWnd,WM_COMMAND,IDM_GO,0L);
			break;
   	case WM_KEYDOWN:
   		keystop=1;
			apt_status=NOSS_BUSY_TYPE;		/* set to busy */
			while((apt_status&0xf00)==NOSS_BUSY_TYPE)
			{
				apt_closefolder(lfn);
			}
			if(apt_status)
			{
				sprintf(str,"cannot close folder. error = %u\n",apt_status);
				_lwrite(outf,(LPSTR)str,lstrlen(str));
				_lclose(outf);
				lstrcpy(str1[totalline],str);
				sort(hPutdirWnd,&rect);
				InvalidateRect(hPutdirWnd,&rect,TRUE);
				PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
				return(0L);
			}
			sprintf(str,"Folder closed.\n");
			_lwrite(outf,(LPSTR)str,lstrlen(str));
			_lclose(outf);
			lstrcpy(str1[totalline],str);
			sort(hPutdirWnd,&rect);
			InvalidateRect(hPutdirWnd,&rect,TRUE);
			PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
   		break;
   	case WM_COMMAND:
   		if(wParam == IDM_RESTART)
   		{
				keystop=0;
				totalline =0;
				pretotalline =0;
				first=1;
				dir_num=0;
				current=0;
				if((*(fname+lstrlen(fname)-1) != '\\')&&(*(fname+lstrlen(fname)-1) != ':'))
				{
					*(fname+lstrlen(fname)+1) = 0;
					*(fname+lstrlen(fname)) = '\\';
				}
				lstrcpy(find_name[dir_num],fname);
				dir_num++;
				fill_fname(fname);
				outf=_lopen(logfname1,OF_READWRITE);
				if(outf==-1)
				{
					outf=_lcreat(logfname1,0);
					if(outf==NULL) 
					{
			   		PostQuitMessage(0);
						return(0L);
					}
				}
				PostMessage(hPutdirWnd,WM_COMMAND,IDM_GO,0L);
			}
   		else if(wParam == IDM_GO)
   		{
   			if(keystop) goto com_end;
   			if(current >= dir_num)
   			{
					_lclose(outf);
					sprintf(str,"Putdir End.\n");
					_lwrite(outf,(LPSTR)str,lstrlen(str));
					lstrcpy(str1[totalline],str);
					sort(hPutdirWnd,&rect);
					InvalidateRect(hPutdirWnd,&rect,TRUE);
					PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
					return(0L);
   			}	
				else if(first)
				{
					lstrcpy(sname,find_name[current]);
					lstrcpy(sname+lstrlen(sname),"*.*");
					if(_dos_findfirst(sname,_A_NORMAL|_A_RDONLY|_A_ARCH,&ft)) 
					{
						current++;
						PostMessage(hPutdirWnd,WM_COMMAND,IDM_GO,0L);
						return(0L);
					}
					first=0;
					lfn=apt_createfolder(Objc);
					if(lfn==0)
					{
						sprintf(str,"Cannot create folder for class=%d.\n",Objc);
						_lwrite(outf,(LPSTR)str,lstrlen(str));
						_lclose(outf);
						lstrcpy(str1[totalline],str);
						sort(hPutdirWnd,&rect);
						InvalidateRect(hPutdirWnd,&rect,TRUE);
						PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
						return(0L);
					}
					sprintf(str,"Folder created for directory %s.  LFN=%xh\n",find_name[current],lfn);
					_lwrite(outf,(LPSTR)str,lstrlen(str));
					lstrcpy(str1[totalline],str);
					sort(hPutdirWnd,&rect);
					InvalidateRect(hPutdirWnd,&rect,TRUE);
					PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
				}
				else
				{
					if(_dos_findnext(&ft)) 
						goto DirEnd; 
				}
				lstrcpy(sname,find_name[current]);
				lstrcpy(sname+lstrlen(sname),ft.name);
   			if(do_Putfile(hPutdirWnd,sname,lfn))
   			{
   				goto DirEnd;
   			}	
				InvalidateRect(hPutdirWnd,&rect,TRUE);
				PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
				PostMessage(hPutdirWnd,WM_COMMAND,IDM_GO,0L);
				goto com_end;
DirEnd:;
				first=1;
				current++;
				apt_status=NOSS_BUSY_TYPE;		/* set to busy */
				while((apt_status&0xf00)==NOSS_BUSY_TYPE)
				{
					apt_closefolder(lfn);
				}
				if(apt_status)
				{
					sprintf(str,"cannot close folder. error = %u\n",apt_status);
					_lwrite(outf,(LPSTR)str,lstrlen(str));
					_lclose(outf);
					lstrcpy(str1[totalline],str);
					sort(hPutdirWnd,&rect);
					InvalidateRect(hPutdirWnd,&rect,TRUE);
					PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
					return(0L);
				}
				sprintf(str,"Folder closed.\n");
				_lwrite(outf,(LPSTR)str,lstrlen(str));
				lstrcpy(str1[totalline],str);
				sort(hPutdirWnd,&rect);
				InvalidateRect(hPutdirWnd,&rect,TRUE);
				PostMessageProc(hPutdirWnd,WM_PAINT,0,0L);
				PostMessage(hPutdirWnd,WM_COMMAND,IDM_GO,0L);
   		}	
com_end:;   		
	  		break;
	  	case WM_PAINT:	
	  		if(!changed) return(0L);
	  		changed=0;
			hdc = BeginPaint(hPutdirWnd,&ps);
			GetTextMetrics(hdc,&textmetric);
			Height=nLineHeight = textmetric.tmExternalLeading + textmetric.tmHeight;
			DrawX=1;
			for(i=pretotalline;i<totalline;i++)
			{
				lstrcpy(str,str1[i]);
				length=lstrlen(str);
				DrawY = i*nLineHeight+1;
				length=TextOut(hdc,DrawX,DrawY,(LPSTR)str,length-1);
			}	
			pretotalline=totalline;
			if(totalline == 19)
				pretotalline=totalline-1;
			EndPaint(hPutdirWnd,&ps);	
			break;
		case WM_DESTROY:		  /* message: window being destroyed */
	   	PostQuitMessage(0);
	   	break;
	   
   	default:			  /* Passes it on if unproccessed    */
	   	 return (DefWindowProc(hPutdirWnd, message, wParam, lParam));
    }
	 return (DefWindowProc(hPutdirWnd, message, wParam, lParam));
}
long FAR PASCAL VerdirWndProc(hVerdirWnd, message, wParam, lParam)
HWND hVerdirWnd;			   	  /* window handle		     */
unsigned message;			  /* type of message		     */
WORD wParam;				  /* additional information	     */
LONG lParam;				  /* additional information	     */
{
	int i;
	HDC hdc;
	static PAINTSTRUCT ps;
	static TEXTMETRIC  textmetric;
	int   nLineHeight;
	int	DrawX,DrawY;
	int sfile;
	static char sname[255],*tmp;
	unsigned firstread,count,countf;
	unsigned long objn,basecount;
	OBJECT far *objptr;
	HANDLE mhandle;
   switch (message) 
    {
		case WM_CREATE:
				totalline =0;
				pretotalline =0;
				current=0;
   			verdirEnd=0;
				inf=_lopen(logfname1,OF_READ);
				outf=_lopen(logfname2,OF_READWRITE);
				if(outf==-1)
					outf=_lcreat(logfname2,0);
				if((outf==-1)||(inf==-1))
				{
					MessageBox(hVerdirWnd,"Can't open log file",NULL,MB_OK);
			   	PostQuitMessage(0);
					return(0L);
				}
				else _llseek(outf,0L,2);		/* seek to end of file */
				mhandle=LocalAlloc(LMEM_DISCARDABLE|LMEM_ZEROINIT,
	                   (unsigned long)BUFSIZE);
				if (mhandle!=NULL) 
				{
					buffer=(unsigned char *)LocalLock(mhandle);			// Lock the memory
					if (buffer==NULL)
					{
						LocalFree(mhandle);				// free the memory
						goto error1;
					}	
				}
				else 
					goto error1;
				mhandle=LocalAlloc(LMEM_DISCARDABLE|LMEM_ZEROINIT,
	                   (unsigned long)BUFSIZE);
				if (mhandle!=NULL) 
				{
					buffer2=(unsigned char *)LocalLock(mhandle);			// Lock the memory
					if (buffer2==NULL)
					{
						LocalFree(mhandle);				// free the memory
						LocalUnlock(LocalHandle((WORD)buffer));
						LocalFree(LocalHandle((WORD)buffer));
						goto error1;
					}	
				}	
				else 
					goto error1;
				PostMessage(hVerdirWnd,WM_COMMAND,IDM_GO,0L);
				return(0L);
error1:;					
				_lclose(inf);
				_lclose(outf);
				MessageBox(hVerdirWnd,"No enough memory",NULL,MB_OK);
		   	PostQuitMessage(0);
				return(0L);
			break;
   	case WM_COMMAND:
   		if(wParam == IDM_RESTART)
   		{
				totalline =0;
				pretotalline =0;
				current=0;
   			verdirEnd=0;
				inf=_lopen(logfname1,OF_READ);
				outf=_lopen(logfname2,OF_READWRITE);
				if(outf==-1)
					outf=_lcreat(logfname2,0);
				if((outf==-1)||(inf==-1))
				{
					MessageBox(hVerdirWnd,"Can't open log file",NULL,MB_OK);
			   	PostQuitMessage(0);
					return(0L);
				}
				else _llseek(outf,0L,2);		/* seek to end of file */
				PostMessage(hVerdirWnd,WM_COMMAND,IDM_GO,0L);
			}
   		else if(wParam == IDM_GO)
   		{
   			if(verdirEnd||(_fgets(sname,255,inf)==0))
   			{
   				if(!verdirEnd)
   				{
   					verdirEnd=1;
						_lclose(inf);
						sprintf(str,"Verdir End.\n");
						_lwrite(outf,(LPSTR)str,lstrlen(str));
						_lclose(outf);
						lstrcpy(str1[totalline],str);
						sort(hVerdirWnd,&rect);
						InvalidateRect(hVerdirWnd,&rect,TRUE);
						PostMessage(hVerdirWnd,WM_PAINT,0,0L);
					}	
					return(0L);
   			}	
				else
				{
					sname[lstrlen(sname)-1]=0;
					if(strncmp(sname,"Folder created",14)==0) lfn=0;
					else if(strncmp(sname,"Folder closed.",14)==0)
					{
						while(((apt_status=apt_closefolder(lfn))&0xf00)==NOSS_BUSY_TYPE);
						if(apt_status)
						{
							sprintf(str,"cannot close folder. error = %u\n",apt_status);
							_lwrite(outf,(LPSTR)str,lstrlen(str));
							_lclose(outf);
							lstrcpy(str1[totalline],str);
							sort(hVerdirWnd,&rect);
							InvalidateRect(hVerdirWnd,&rect,TRUE);
							PostMessage(hVerdirWnd,WM_PAINT,0,0L);
							return(0L);
						}
						lfn=0;
					}
					else
					{
						tmp=sname+5;
						while(*tmp==' ') tmp++;
						objn=hex2num(tmp);
						strcpy(fname,sname+20);
						if(lfn==0)
						{
							do
							{
								lfn=apt_openfolder(objn,"R");
							}
							while((apt_status&0x0f00)==NOSS_BUSY_TYPE);
							if (apt_status) 
							{
								sprintf(str,"cannot open folder. error = %u\n",apt_status);
								_lwrite(outf,(LPSTR)str,lstrlen(str));
								_lclose(outf);
								lstrcpy(str1[totalline],str);
								sort(hVerdirWnd,&rect);
								InvalidateRect(hVerdirWnd,&rect,TRUE);
								PostMessage(hVerdirWnd,WM_PAINT,0,0L);
								return(0L);
							}
						}
						do
						{
							objptr=apt_openobject(lfn,objn,"D","R");
						}
						while((apt_status&0x0f00)==NOSS_BUSY_TYPE);
						if(objptr==NULL) 
						{
							sprintf(str,"cannot open object. error = %u\n",apt_status);
							_lwrite(outf,(LPSTR)str,lstrlen(str));
							_lclose(outf);
							lstrcpy(str1[totalline],str);
							sort(hVerdirWnd,&rect);
							InvalidateRect(hVerdirWnd,&rect,TRUE);
							PostMessage(hVerdirWnd,WM_PAINT,0,0L);
							PostMessage(hVerdirWnd,WM_COMMAND,IDM_GO,0L);
							return(0L);
						}
						if((sfile=_lopen(fname,OF_READ))==NULL)
						{
							sprintf(str,"File %s  Objn %lxh\n",fname,objn);
							_lwrite(outf,(LPSTR)str,lstrlen(str));
							_lclose(outf);
							lstrcpy(str1[totalline],str);
							sort(hVerdirWnd,&rect);
							sprintf(str,"Source file cannot be openned.\n");
							_lwrite(outf,(LPSTR)str,lstrlen(str));
							strcpy(str1[totalline],str);
							sort(hVerdirWnd,&rect);
							InvalidateRect(hVerdirWnd,&rect,TRUE);
							PostMessage(hVerdirWnd,WM_PAINT,0,0L);
							goto VerError;
						}
						basecount=0L;
						firstread=1;
						while(!(apt_eot(objptr)))
						{
							if(firstread)
							{
								count=apt_readobject(objptr,buffer,BUFSIZE-32);
								firstread=0;
							}
							else
							{
								count=apt_readobject(objptr,buffer,BUFSIZE);
							}
							if(count==0) 
							{
								goto VerEnd;
							}
							if((countf=_lread(sfile,buffer2,count))!=count)
							{
								sprintf(str,"File %s  Objn %lxh\n",fname,objn);
								_lwrite(outf,(LPSTR)str,lstrlen(str));
								strcpy(str1[totalline],str);
								sort(hVerdirWnd,&rect);
								sprintf(str,"Object size mismatch. objn=%lx file=%s\n",objn,fname);
								_lwrite(outf,(LPSTR)str,lstrlen(str));
								strcpy(str1[totalline],str);
								sort(hVerdirWnd,&rect);
								InvalidateRect(hVerdirWnd,&rect,TRUE);
								PostMessage(hVerdirWnd,WM_PAINT,0,0L);
								goto VerError;
							}
							for(i=0;i<count;i++) if(buffer[i]!=buffer2[i])
							{
								sprintf(str,"File %s  Objn %lxh\n",fname,objn);
								_lwrite(outf,(LPSTR)str,lstrlen(str));
								strcpy(str1[totalline],str);
								sort(hVerdirWnd,&rect);
								sprintf(str,"Data mismatch at offset %lxh\n",basecount+(long)i);
								_lwrite(outf,(LPSTR)str,lstrlen(str));
								strcpy(str1[totalline],str);
								sort(hVerdirWnd,&rect);
								InvalidateRect(hVerdirWnd,&rect,TRUE);
								PostMessage(hVerdirWnd,WM_PAINT,0,0L);
								goto VerError;
							}
							basecount+=count;
						}
VerEnd:;						
						sprintf(str,"%s OK.",fname);
						strcpy(str1[totalline],str);
						sort(hVerdirWnd,&rect);
						InvalidateRect(hVerdirWnd,&rect,TRUE);
						PostMessage(hVerdirWnd,WM_PAINT,0,0L);
						PostMessage(hVerdirWnd,WM_COMMAND,IDM_GO,0L);
VerError:						
						do
						{
							apt_closeobject(objptr);
						} while((apt_status&0x0f00)==NOSS_BUSY_TYPE);
						if(apt_status)
						{
							sprintf(str,"cannot close object. error = %u\n",apt_status);
							_lwrite(outf,(LPSTR)str,lstrlen(str));
							_lclose(outf);
							lstrcpy(str1[totalline],str);
							sort(hVerdirWnd,&rect);
							InvalidateRect(hVerdirWnd,&rect,TRUE);
							PostMessage(hVerdirWnd,WM_PAINT,0,0L);
							PostMessage(hVerdirWnd,WM_COMMAND,IDM_GO,0L);
							return(0L);
						}
						_lclose(sfile);
					}
					PostMessage(hVerdirWnd,WM_COMMAND,IDM_GO,0L);
				}
			}	
	  		break;
	  	case WM_PAINT:	
	  		if(!changed) return(0L);
	  		changed=0;
			hdc = BeginPaint(hVerdirWnd,&ps);
			GetTextMetrics(hdc,&textmetric);
			Height=nLineHeight = textmetric.tmExternalLeading + textmetric.tmHeight;
			DrawX=1;
			for(i=pretotalline;i<totalline;i++)
			{
				lstrcpy(str,str1[i]);
				lstrlen(str);
				DrawY = i*nLineHeight+1;
				TextOut(hdc,DrawX,DrawY,(LPSTR)str,lstrlen(str)-1);
			}	
			pretotalline=totalline;
			if(totalline == 19)
				pretotalline=totalline-1;
			EndPaint(hVerdirWnd,&ps);	
			break;
		case WM_DESTROY:		  /* message: window being destroyed */
			LocalUnlock(LocalHandle((WORD)buffer));
			LocalFree(LocalHandle((WORD)buffer));
			LocalUnlock(LocalHandle((WORD)buffer2));
			LocalFree(LocalHandle((WORD)buffer2));
	   	PostQuitMessage(0);
	   	break;

   default:			  /* Passes it on if unproccessed    */
	    return (DefWindowProc(hVerdirWnd, message, wParam, lParam));
    }
    return (0L);
}
/****************************************************************************

    FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages

    MESSAGES:

   WM_CREATE     - main window first create
	WM_COMMAND    - application menu & button
	WM_DESTROY    - destroy window

    COMMENTS:

	To process the IDM_ABOUT message, call MakeProcInstance() to get the
	current instance address of the About() function.  Then call Dialog
	box which will create the box according to the information in your
	wcsf.rc file and turn control over to the About() function.	When
	it returns, free the intance address.

****************************************************************************/
/*  button name  */
struct button
{
    UCHAR *text;
} button[]={"version","setname","unsetname","fopen","fclose","getobj","putobj","getpinfo","getobjin","fcreate","putdir","verdir"};

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;			   	  /* window handle		     */
unsigned message;			  /* type of message		     */
WORD wParam;				  /* additional information	     */
LONG lParam;				  /* additional information	     */
{
    FARPROC lpProcFOpen, lpProcFClose, lpProcPutObj,lpProcFCreate,
    			lpProcSetName,lpProcUnSetName, lpProcGetObj, lpProcGetObIn,lpProcAbout,
    			lpProcPutdir,lpProcVerdir;
    HWND hBwnd[button_num]; // child window handle 
    unsigned i,x=30,y=20;	// button position
    int Success;
    OBJECT far *op;
    switch (message) 
    {
    case WM_CREATE:
    	for(i=0;i<button_num;i++)
    	{
    	 if((x+75) >= 600) 
    	 {
    	   x = 30;
    	   y += 50;
    	 } 
    	 
    	 /*  create the button  */
    	 
       hBwnd[i] = CreateWindow("button",button[i].text,   
       WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,x,y,75,30,hWnd,i,
       		((LPCREATESTRUCT) lParam)->hInstance,NULL);
    	 x += 87;
      } 		
    	 SetFocus(hWnd);
       break; 		
    case WM_COMMAND:	   /* message: command from application menu */
	 	switch(wParam)
	 	{
	 	/*   APT_OPENFOLDER    */
	 	  case button_fopen:
	 	  		 lpProcFOpen = MakeProcInstance(FOpen,hInst);
	 	  		 Success=DialogBox(hInst,"FOpen",hWnd,lpProcFOpen);
	 	  		 FreeProcInstance(lpProcFOpen);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)					// press OK button
             {
               if(object_number==-1)			// Input error
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               { 
                 /*  check the local and remote name  */
					  if((apt_getname((char far *)lname)==NULL)||(apt_getrname((char far *)rname)==NULL))
					  {
                   		SetCursor(hSaveCursor);
                   		MessageBox(hWnd,"Please first run setname",NULL,MB_OK | 
                  		MB_ICONEXCLAMATION);
					  }
					  else
					  {
                 		if(!(lfn=apt_openfolder(object_number,mode)))
                 		{
                   		SetCursor(hSaveCursor);
                   		sprintf(str,"can't open, Error code %xh",apt_status);
                   		MessageBox(hWnd,str,NULL,MB_OK | 
                  		MB_ICONEXCLAMATION);
                 		}
                 		else
                 		{
                   		SetCursor(hSaveCursor);
                   		sprintf(str,"Logical Folder Number is %d",lfn);
                   		MessageBox(hWnd,str,"Success",MB_OK );
                 		}
                 	}
              	}
             }  
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  
	 	  /*   APT_CLOSEFOLDER  */		 
	 	  case button_fclose:
	 	  		 lpProcFClose = MakeProcInstance(FClose,hInst);
	 	  		 Success=DialogBox(hInst,"FClose",hWnd,lpProcFClose);
	 	  		 FreeProcInstance(lpProcFClose);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)		// Press OK button
             {
               if(lfn==0)				// input error
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
                 /*  check the local and remote name  */
					  if((apt_getname((char far *)lname)==NULL)||(apt_getrname((char far *)rname)==NULL))
					  {
                   		SetCursor(hSaveCursor);
                   		MessageBox(hWnd,"Please first run setname",NULL,MB_OK | 
                  		MB_ICONEXCLAMATION);
					  }
					  else
					  {
		                 if(apt_closefolder(lfn))
      		           {
            		       SetCursor(hSaveCursor);
                  		 sprintf(str,"can't close, Error code %xh",apt_status);
                   		 MessageBox(hWnd,str,NULL,MB_OK | 
                   		 MB_ICONEXCLAMATION);
                 		  }
                 		  else
                 		  {
                   			SetCursor(hSaveCursor);
                   			sprintf(str,"Folder %d is closed",lfn);
                   			MessageBox(hWnd,str,"Success",MB_OK );
                 		  }
                 	}	  
               }
             }  
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  
	 	  /*   APT_CREATEFOLDER   */		 
	 	  case button_fcreate:
	 	  		 lpProcFCreate = MakeProcInstance(FCreate,hInst);
	 	  		 Success=DialogBox(hInst,"FCreate",hWnd,lpProcFCreate);
	 	  		 FreeProcInstance(lpProcFCreate);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(Objc==0)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
                 /*  check the local and remote name  */
					  if((apt_getname((char far *)lname)==NULL)||(apt_getrname((char far *)rname)==NULL))
					  {
                   		SetCursor(hSaveCursor);
                   		MessageBox(hWnd,"Please first run setname",NULL,MB_OK | 
                  		MB_ICONEXCLAMATION);
					  }
					  else
					  {
		                 lfn=apt_createfolder(Objc);
		                 if(!lfn)
      		           {
            		       SetCursor(hSaveCursor);
                  		 sprintf(str,"Can't Create folder.\n folder class is %d, Error code %xh",Objc,apt_status);
                   		 MessageBox(hWnd,str,NULL,MB_OK | 
                   		 MB_ICONEXCLAMATION);
                 		  }
                 		  else
                 		  {
                   			SetCursor(hSaveCursor);
                   			sprintf(str,"Logical Folder Number is %d",lfn);
                   			MessageBox(hWnd,str,"Success",MB_OK );
                 		  }
                 	}	  
               }
             }  
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  
	 	  /*  APT_SETNAME   */
	 	  case button_setname:
	 	  		 lpProcSetName = MakeProcInstance(SetName,hInst);
	 	  		 Success=DialogBox(hInst,"SetName",hWnd,lpProcSetName);
	 	  		 FreeProcInstance(lpProcSetName);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(lname[0]==0||rname[0]==0)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
                 if(apt_setname((char far*)lname,(char far *)rname))
                 {
                   SetCursor(hSaveCursor);
                   sprintf(str,"can't setname, Error code %xh",apt_status);
                   MessageBox(hWnd,str,NULL,MB_OK | 
                   MB_ICONEXCLAMATION);
                 }
                 else
                 {
                   SetCursor(hSaveCursor);
                   sprintf(str,"Local Name is %s",lname);
                   MessageBox(hWnd,str,"Success",MB_OK );
                 }
               }
             }  
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  
	 	  /*   APT_GETOBJECT  */
	 	  case button_getobj:
	 	  		 lpProcGetObj = MakeProcInstance(GetObj,hInst);
	 	  		 Success=DialogBox(hInst,"GetObj",hWnd,lpProcGetObj);
	 	  		 FreeProcInstance(lpProcGetObj);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(object_number==0)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
                 /*  check the local and remote name  */
					  if((apt_getname((char far *)lname)==NULL)||(apt_getrname((char far *)rname)==NULL))
					  {
                   		SetCursor(hSaveCursor);
                   		MessageBox(hWnd,"Please first run setname",NULL,MB_OK | 
                  		MB_ICONEXCLAMATION);
					  }
					  else
					  {
                 		if(apt_getobject(lfn,object_number,fname,mode))
                 		{
                   		SetCursor(hSaveCursor);
                   		sprintf(str,"Can't get object, Error code %xh",apt_status);
                   		MessageBox(hWnd,str,NULL,MB_OK | 
                   		MB_ICONEXCLAMATION);
                 		}
                 		else
                 		{
                   		SetCursor(hSaveCursor);
                   		sprintf(str,"Object in File %s",fname);
                   		MessageBox(hWnd,str,"Success",MB_OK );
                 		}
                 }		
               }
             }  
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  
	 	  /*   APT_PUTOBJECT   */
	 	  case button_putobj:
	 	  		 lpProcPutObj = MakeProcInstance(PutObj,hInst);
	 	  		 Success=DialogBox(hInst,"PutObj",hWnd,lpProcPutObj);
	 	  		 FreeProcInstance(lpProcPutObj);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(lfn==0)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
                 /*  check the local and remote name  */
					  if((apt_getname((char far *)lname)==NULL)||(apt_getrname((char far *)rname)==NULL))
					  {
                   		SetCursor(hSaveCursor);
                   		MessageBox(hWnd,"Please first run setname",NULL,MB_OK | 
                  		MB_ICONEXCLAMATION);
					  }
					  else
					  {
                 		if(!(object_number=apt_putobject(lfn,fname,NORMAL)))
                 		{
                   		SetCursor(hSaveCursor);
                   		sprintf(str,"Can't Put object, Error code %xh",apt_status);
                   		MessageBox(hWnd,str,NULL,MB_OK | 
                   		MB_ICONEXCLAMATION);
                 		}
                 		else
                 		{
                   		SetCursor(hSaveCursor);
                   		sprintf(str,"Object Number is %d",object_number);
                   		MessageBox(hWnd,str,"Success",MB_OK );
                 		}
                 	}	
               }
             }  
             SetCursor(hSaveCursor);
	 	  		 break;

		  /*   APT_GETPLATINFO   */	
	 	  case button_getpinfo:
	 	  		 if(copy_gpi == FALSE)
	 	  		 {
	 	  		 	GetPInfo(hWnd);
	 	  		 }	
	  		    break;
	 	  
	 	  /*   APT_UNSETNAME  */
	 	  case button_unsetname:
	 	  		 lpProcUnSetName = MakeProcInstance(UnSetName,hInst);
	 	  		 Success=DialogBox(hInst,(LPSTR)"UnSetName",hWnd,lpProcUnSetName);
	 	  		 FreeProcInstance(lpProcUnSetName);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(lname[0]==0||rname[0]==0)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
                 if(apt_unsetname((char far *)lname,(char far *)rname))
                 {
                   SetCursor(hSaveCursor);
                   sprintf(str,"can't unsetname, Error code %xh",apt_status);
                   MessageBox(hWnd,str,NULL,MB_OK | 
                   MB_ICONEXCLAMATION);
                 }
                 else
                 {
                   SetCursor(hSaveCursor);
                   sprintf(str,"Names have been deleted");
                   MessageBox(hWnd,str,"Success",MB_OK );
                 }
               }
             }  
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  
	 	  /*   APT_NETRESET    */
	 	  case button_version:
	 	  		 apt_status=apt_get_version();
             sprintf(str,"CSFDLL Version %1d.%0.2d",apt_status/100,apt_status%100);
             MessageBox(hWnd,str,"Version",MB_OK );
             apt_status=0;
	  		    break;
	 	  
	 	  /*   APT_GETOBJINFO   */
	 	  case button_getobin:
	 	  		 lpProcGetObIn = MakeProcInstance(GetObIn,hInst);
	 	  		 Success=DialogBox(hInst,"GetObIn",hWnd,lpProcGetObIn);
	 	  		 FreeProcInstance(lpProcGetObIn);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(object_number==-1)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
                 if((op=apt_getobjinfo(object_number)) == NULL)
                 {
                   SetCursor(hSaveCursor);
                   sprintf(str,"Can't get object information, Error code %xh",apt_status);
                   MessageBox(hWnd,str,NULL,MB_OK | 
                   MB_ICONEXCLAMATION);
                 }
                 else
                 {
                   SetCursor(hSaveCursor);
                   sprintf(str,"Platter id %u\nObject size: %lu\nFirst object: %lu\nPrev Object number:%lu\nnext Object %lu\nstarting sector %lu\nObject status: %u",
                   op->sid,op->obj_size,op->first_obj,op->dtp,op->objn,op->folder_size,op->lfn);
                   MessageBox(hWnd,str,"Success",MB_OK );
                 }
               }
             }  
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  		 
	 	  /*   PUTDIR   */		 
	 	  case button_putdir:
	 	  		 lpProcPutdir = MakeProcInstance(PutdirInput,hInst);
	 	  		 Success=DialogBox(hInst,"Putdir",hWnd,lpProcPutdir);
	 	  		 FreeProcInstance(lpProcPutdir);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(Objc==0)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
             		SetCursor(hSaveCursor);
               	Putdir(hWnd);
               }
             } 
             SetCursor(hSaveCursor);
	 	  		 break;
	 	  		 
	 	  /*   VERDIR   */		 
	 	  case button_verdir:
	 	  		 lpProcVerdir = MakeProcInstance(VerdirInput,hInst);
	 	  		 Success=DialogBox(hInst,"Verdir",hWnd,lpProcVerdir);
	 	  		 FreeProcInstance(lpProcVerdir);
             hSaveCursor=SetCursor(hHourGlass);
             if(Success == IDOK)
             {
               if(fname==NULL)
               {
                 SetCursor(hSaveCursor);
                 MessageBox(hWnd,"Error Input",NULL,MB_OK | MB_ICONEXCLAMATION);
               }
               else
               {
             		SetCursor(hSaveCursor);
               	Verdir(hWnd);
               }
             } 
             SetCursor(hSaveCursor);
	 	  		 break;
	  	  case IDM_ABOUT:
				 lpProcAbout = MakeProcInstance(AboutCSF, hInst);

				 DialogBox(hInst,		    /* current instance	     */
		    			"Aboutcsf",			 /* resource to use	     */
		    			hWnd,			       /* parent handle	     */
		    			lpProcAbout);		 /* About() instance address */

				 FreeProcInstance(lpProcAbout);
	  			 break;
		  default:
   		  return (DefWindowProc(hWnd, message, wParam, lParam));
		 }  
       break;
	case WM_DESTROY:		  /* message: window being destroyed */
	    PostQuitMessage(0);
	    break;

	  default:			  /* Passes it on if unproccessed    */
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (0L);
}
WORD GetPInfo(HWND hWnd)
{
	HWND hGPIWnd;
    MSG msg;				     			  /* message			     */
	hGPIWnd=CreateWindow(
	  "GetPInfoWClass",                /* See RegisterClass() call.          */
       "Get Platter Information",     /* Text for window title bar.         */
       WS_OVERLAPPEDWINDOW|
       WS_VSCROLL|WS_BORDER|
       WS_CAPTION|WS_SYSMENU,         /* Window style.                      */
       CW_USEDEFAULT,  					  /*  horizontal position.       */
       CW_USEDEFAULT,                 /*  vertical position.         */
       CW_USEDEFAULT,                 /*  width.                     */
       CW_USEDEFAULT,                 /*  height.                    */
       NULL,                          /* Overlapped windows have no parent. */
       NULL,                          /* Use the window class menu.         */
       hInst,		                    /* This instance owns this window.    */
       NULL                           /* Pointer not needed.                */
  		);
  	if(!hGPIWnd)
  	{
		DestroyWindow(hWnd);
		return(0);
	}	
	if(gpi == FALSE)
	{
  		ShowWindow(hGPIWnd,1);		
  		UpdateWindow(hGPIWnd);
  	}	
    while (GetMessage(&msg,	/* message structure			     */
	    NULL,		   			/* handle of window receiving the message */
	    NULL,		   			/* lowest message to examine		     */
	    NULL))		   			/* highest message to examine	     */
	{
	TranslateMessage(&msg);	   /* Translates virtual key codes	     */
	DispatchMessage(&msg);	   /* Dispatches message to window	     */
    }
    return (msg.wParam);	   /* Returns the value from PostQuitMessage */
}	
WORD Putdir(HWND hWnd)
{
	HWND hPutdirWnd;
    MSG msg;				     				/* message			     */
	hPutdirWnd=CreateWindow(
	  "PutdirWClass",                	/* See RegisterClass() call.          */
       "Putdir",   							/* Text for window title bar.         */
       WS_OVERLAPPEDWINDOW|
       WS_BORDER|WS_MAXIMIZEBOX|
       WS_CAPTION|WS_SYSMENU,          /* Window style.                      */
       0,				  						/*  horizontal position.       */
       0,				                  /*  vertical position.         */
       640,				                  /*  width.                     */
       400,								      /*  height.                    */
       NULL,                           /* Overlapped windows have no parent. */
       NULL,                           /* Use the window class menu.         */
       hInst,		                     /* This instance owns this window.    */
       NULL                           	/* Pointer not needed.                */
  		);
  	if(!hPutdirWnd)
  	{
		DestroyWindow(hWnd);
		return(0);
	}	
	ShowWindow(hPutdirWnd,1);		
	UpdateWindow(hPutdirWnd);
    while (GetMessage(&msg,	   		/* message structure			     */
	    NULL,		   						/* handle of window receiving the message */
	    NULL,		   						/* lowest message to examine		     */
	    NULL))		   						/* highest message to examine	     */
	{
	TranslateMessage(&msg);	   			/* Translates virtual key codes	     */
	DispatchMessage(&msg);	   			/* Dispatches message to window	     */
    }
    return (msg.wParam);	   			/* Returns the value from PostQuitMessage */
}

WORD Verdir(HWND hWnd)
{
	HWND hVerdirWnd;
    MSG msg;				     					/* message			     */
	hVerdirWnd=CreateWindow(
	  "VerdirWClass",                		/* See RegisterClass() call.          */
       "Verdir",   								/* Text for window title bar.         */
       WS_OVERLAPPEDWINDOW|
       WS_BORDER|WS_MAXIMIZEBOX|
       WS_CAPTION|WS_SYSMENU,             /* Window style.                      */
       0,					  						/*  horizontal position.       */
       0,                 						/*  vertical position.         */
       640,					                  /*  width.                     */
       400,             					   /*  height.                    */
       NULL,                           	/* Overlapped windows have no parent. */
       NULL,                           	/* Use the window class menu.         */
       hInst,		                     	/* This instance owns this window.    */
       NULL                           		/* Pointer not needed.                */
  		);
  	if(!hVerdirWnd)
  	{
		DestroyWindow(hWnd);
		return(0);
	}	
	ShowWindow(hVerdirWnd,1);		
	UpdateWindow(hVerdirWnd);
    while (GetMessage(&msg,	   /* message structure			     */
	    NULL,		   /* handle of window receiving the message */
	    NULL,		   /* lowest message to examine		     */
	    NULL))		   /* highest message to examine	     */
	{
	TranslateMessage(&msg);	   /* Translates virtual key codes	     */
	DispatchMessage(&msg);	   /* Dispatches message to window	     */
    }
    return (msg.wParam);	   /* Returns the value from PostQuitMessage */
}	
/****************************************************************************

    FUNCTION: FOpen(HWND, unsigned, WORD, LONG)

    PURPOSE:  Open Folder

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL FOpen(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   BOOL lpTranslated;
   char temp[80];
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
        case IDC_EDIT1:
          break;
        case IDOK:
          /*  get object number from IDC_EDIT  */
          if(GetDlgItemText(hDlg,IDC_EDIT,temp,16)==0) object_number=-1;
          else
          {
          	object_number=dec2num(temp);
          }	
          if((lpTranslated == FALSE) || (GetDlgItemText(hDlg,IDC_EDIT1,mode,2) == 0))
            object_number=-1;
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }  
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: FClose(HWND, unsigned, WORD, LONG)

    PURPOSE:  Close Folder

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL FClose(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   BOOL lpTranslated;
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
          break;
        case IDOK:
        	 /*  get lfn from IDC_EDIT  */
          lfn=GetDlgItemInt(hDlg,IDC_EDIT,&lpTranslated,TRUE);
          if(lpTranslated == FALSE )
            lfn=0;
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: FCreate(HWND, unsigned, WORD, LONG)

    PURPOSE:  Create Folder

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL FCreate(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   BOOL lpTranslated;
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
          break;
        case IDOK:
        	 /*  get object class from IDC_EDIT  */
          Objc=GetDlgItemInt(hDlg,IDC_EDIT,&lpTranslated,TRUE);
          if(lpTranslated == FALSE )
            Objc=0;
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: SetName(HWND, unsigned, WORD, LONG)

    PURPOSE:  Set local and remote name

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL SetName(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
        case IDC_EDIT1:
          break;
        case IDOK:
        	 /*  get local name from IDC_EDIT  */
          GetDlgItemText(hDlg,IDC_EDIT,(LPSTR)lname,16);
        	 
        	 /*  get remote name from IDC_EDIT1  */
          GetDlgItemText(hDlg,IDC_EDIT1,(LPSTR)rname,16);
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: UnSetName(HWND, unsigned, WORD, LONG)

    PURPOSE:  UnSet local and remote name

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL UnSetName(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
        case IDC_EDIT1:
          break;
        case IDOK:
        	 /*  get local name from IDC_EDIT  */
          GetDlgItemText(hDlg,IDC_EDIT,(LPSTR)lname,16);
        	 
        	 /*  get remote name from IDC_EDIT1  */
          GetDlgItemText(hDlg,IDC_EDIT1,(LPSTR)rname,16);
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: PutObj(HWND, unsigned, WORD, LONG)

    PURPOSE:  Put Object

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL PutObj(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   BOOL lpTranslated;
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
        case IDC_EDIT1:
          break;
        case IDOK:
        	 /*  get lfn number from IDC_EDIT  */
          lfn=GetDlgItemInt(hDlg,IDC_EDIT,&lpTranslated,TRUE);
          if((lpTranslated == FALSE) || (GetDlgItemText(hDlg,IDC_EDIT1,fname,80) == 0))
            lfn=0;
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
           EndDialog(hDlg,IDCANCEL);
           return(TRUE);
      }
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: GetObj(HWND, unsigned, WORD, LONG)

    PURPOSE:  Get Object

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL GetObj(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   BOOL lpTranslated;
   BOOL lpTranslated1;
   char temp[80];
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
        case IDC_EDIT1:
        case IDC_EDIT2:
        case IDC_EDIT3:
          break;
        case IDOK:
        	 /*  get lfn from IDC_EDIT  */
          lfn=GetDlgItemInt(hDlg,IDC_EDIT,&lpTranslated,TRUE);
        	 
        	 /*  get object number from IDC_EDIT1  */
          if(GetDlgItemText(hDlg,IDC_EDIT1,temp,16)==0) object_number=0;
          else
          {
          	object_number=dec2num(temp);
          }	
          if((lpTranslated1 == FALSE) || 
        	 
        	 /*  get file name from IDC_EDIT2  */
          (GetDlgItemText(hDlg,IDC_EDIT2,fname,80) == 0) || 
        	 
        	 /*  get mode from IDC_EDIT3  */
          (GetDlgItemText(hDlg,IDC_EDIT3,mode,2) == 0))
            object_number=0;
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: GetObIn(HWND, unsigned, WORD, LONG)

    PURPOSE:  Get Object Information

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/
int FAR PASCAL GetObIn(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   BOOL lpTranslated;
   char temp[80];
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
          break;
        case IDOK:
          /*  get object number from IDC_EDIT  */
          if(GetDlgItemText(hDlg,IDC_EDIT,temp,16)==0) object_number=-1;
          else
          {
          	object_number=dec2num(temp);
          }	
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{
	switch (message) 
	{
		case WM_INITDIALOG:		   /* message: initialize dialog box */
			return (TRUE);
		case WM_COMMAND:		      /* message: received a command */
			if (wParam == IDOK) 		 /* "OK" box selected?	     */
			{
				EndDialog(hDlg, TRUE);	      /* Exits the dialog box	     */
				return (TRUE);
			}	
		break;
	}	
	return (FALSE);			      /* Didn't process a message    */
}
BOOL FAR PASCAL AboutCSF(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{
    switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box */
	    return (TRUE);

	case WM_COMMAND:		      /* message: received a command */
		if (wParam == IDOK)                /* "OK" box selected?	     */
		{
			EndDialog(hDlg, TRUE);	      /* Exits the dialog box	     */
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message    */
}
int FAR PASCAL PutdirInput(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   BOOL lpTranslated;
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
        case IDC_EDIT1:
        case IDC_EDIT2:
          break;
        case IDOK:
        	 /*  get object class from IDC_EDIT  */
          Objc=GetDlgItemInt(hDlg,IDC_EDIT,&lpTranslated,TRUE);
        	 
          if((lpTranslated == FALSE) || 

        	 /*  get path name from IDC_EDIT1  */
          (GetDlgItemText(hDlg,IDC_EDIT1,fname,80) == 0)) 
            Objc=0;
        	 
        	 /*  get log file name from IDC_EDIT2  */
          GetDlgItemText(hDlg,IDC_EDIT2,logfname1,80); 
          
          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
int FAR PASCAL VerdirInput(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   switch(message)
   {
     case WM_INITDIALOG:
     	return(TRUE);
     case WM_COMMAND:
      switch(wParam)
      {
        case IDC_EDIT:
        case IDC_EDIT1:
          break;
        case IDOK:
        	 /*  get Putdir log file name from IDC_EDIT  */
          if(GetDlgItemText(hDlg,IDC_EDIT,logfname1,80) == 0) 
            logfname1[0]=0;
        	 
        	 /*  get verdir log file name from IDC_EDIT1  */
          if(GetDlgItemText(hDlg,IDC_EDIT1,logfname2,80)==0)
          	lstrcpy(logfname2,"verdir.log"); 

          EndDialog(hDlg,IDOK);
          return(TRUE);
        case IDCANCEL:
          EndDialog(hDlg,IDCANCEL);
          return(TRUE);
      }
      break;
    }
    return(FALSE);
}
void fill_fname(char *p)
{
	struct find_t ft;
	unsigned first=1;
	char sname[80];
	lstrcpy(sname,p);
	lstrcpy(sname+lstrlen(sname),"*.*");
	while(1) 
	{
		if(first)
		{
			if(_dos_findfirst(sname,_A_SUBDIR,&ft)) break;
			first=0;
		}
		else
		{
			if(_dos_findnext(&ft)) break;
		}
		if((ft.attrib&0x10)&&lstrcmp(ft.name,"..")&&lstrcmp(ft.name,"."))
		{
			lstrcpy(sname,p);
			lstrcpy(sname+lstrlen(sname),ft.name);
			lstrcpy(sname+lstrlen(sname),"\\");
			lstrcpy(find_name[dir_num],sname);
			dir_num++;
			fill_fname(sname);
		}
	}
}
void sort(HWND htmpWnd,RECT *rect)
{
	unsigned i;
	totalline++;
	if(totalline >=20)
	{
		ScrollWindow(htmpWnd,0,-Height,NULL,NULL);	
		for(i=0;i<19;i++)
		{
			lstrcpy(str1[i],str1[i+1]);
		}
		totalline = 19;
		if(changed)
			pretotalline--;
	}	
	changed=1;
   rect->left   = 1;
   rect->right  = 600;
   rect->top    = pretotalline*Height;
   rect->bottom = totalline*Height;
}
unsigned do_Putfile(HWND htmpWnd,char *p,unsigned lfn)
{
	unsigned long objn;
	
   objn=apt_putobject(lfn,p,NORMAL);
	sprintf(str,"OBJN:%8lx %cFILE:%s\n",objn,9,p);
	_lwrite(outf,(LPSTR)str,lstrlen(str));
	lstrcpy(str1[totalline],str);
	sort(htmpWnd,&rect);
	if(apt_status)
	{
		_lclose(outf);
		sprintf(str,"line 241:cannot put object.\n");
   	_lwrite(outf,(LPSTR)str,(unsigned)lstrlen(str)); // write to file 
		lstrcpy(str1[totalline],str);
		sort(htmpWnd,&rect);
		return(apt_status);
	}	
	return(0);
}
unsigned char hexdigit(unsigned char c)
{
	if((c>='0')&&(c<='9')) return(c-'0');
	if((c>='a')&&(c<='f')) return(c-'a'+10);
	if((c>='A')&&(c<='F')) return(c-'A'+10);
	return(0xff);
}

/*****************************************************/
/* hex2num()  Converts a hex string to a long        */
/*	             Given: s = pointer to a hex string   */
/*             Return: long integer represented by   */
/*                     by the hex string.            */
/*   Note: The string may have upper or lower cased  */
/*         characters for the hex digits a to f.     */
/*         The conversion is from left to right and  */
/*         stops on a NULL character or on a non-hex */
/*         char.                                     */
/*****************************************************/
unsigned long hex2num(char *s)
{
	unsigned long n=0L;
	unsigned char q;
	for(;;)
	{
		q=hexdigit(*s);
		if (q!=0xff) n=16*n+(unsigned long)q;
		else return(n);
		s++;
	}
}
/*****************************************************/
/* dec2num()  Converts a dec string to unsigned long */
/*	             Given: s = pointer to a dec string   */
/*             Return: unsigned long represented by  */
/*                     the dec string.               */
/*   Note:                                           */
/*         The conversion is from left to right and  */
/*         stops on a NULL character or on a non-num */
/*         char.                                     */
/*****************************************************/
unsigned long dec2num(char *s)
{
	unsigned long n=0L;
	int i;
	for(i=0;i<strlen(s);i++)
	{
		if((s[i]>='0')&&(s[i]<='9')) n=10*n+s[i]-'0';
		else break;
	}
	return(n);
}
///////////////////////////////////////////////////////////////////
// lAlloc()
//
// Function to allocate memory
//
// Given: memsize=# of bytes to allocate
//
// Return: pointer to memory buffer allocated
///////////////////////////////////////////////////////////////////
void *lAlloc(unsigned memsize)
{
	PSTR temp;
	HANDLE mhandle;
	/* 072192 */
	mhandle=LocalAlloc(LMEM_DISCARDABLE|LMEM_ZEROINIT,memsize);
	if (mhandle==NULL) return(NULL);	// return NULL if error
	temp=LocalLock(mhandle);			// Lock the memory
	if (temp==NULL)
	{
		LocalFree(mhandle);				// free the memory
		return(NULL);						// return NULL if locking fails
	}
	return(temp);			// return pointer allocated
}

///////////////////////////////////////////////////////////////////
// lFree()
//
// Function to free memory
//
// Given: pointer to memory buffer.
//
// Return: None
//////////////////////////////////////////////////////////////////
void lFree(void *bufptr)
{
	LocalUnlock(LocalHandle((unsigned)bufptr));			// Unlock the memory buffer
	LocalFree(LocalHandle((unsigned)bufptr));				// free the memory buffer
	return;
}
unsigned _fgets(char *buf,unsigned count,int fh)
{
	static unsigned fcount=0,j;
	static char buffer2[255];
	unsigned i=0;
	while(1)
	{
		if(fcount==0)
		{
			fcount=_lread(fh,buffer2,count);
			if(fcount==0) return(0);		
			j=0;
		}
		if((buffer2[j]==0xd)||(buffer2[j]==0xa))
		{	
			if(i)
			{
				fcount--;
				buf[i++]=buffer2[j++];
				if(fcount&&((buffer2[j]==0xd)||(buffer2[j]==0xa)))
				{
					fcount--;
					j++;
				}
				buf[i]=0;
				return(i);
			}	
			else
			{
				fcount--;
				j++;
				continue;
			}
		}
		buf[i++]=buffer2[j++];
		fcount--;
	}	
}
void PostMessageProc(HWND hWnd,WORD wsmg,WORD wP,DWORD lP)
{
	MSG msg;
	if(PeekMessage(&msg,hWnd,WM_KEYDOWN,WM_KEYDOWN,PM_NOYIELD|PM_NOREMOVE))
	{
		return;
	}
	if(PeekMessage(&msg,hWnd,WM_SYSCOMMAND,WM_SYSCOMMAND,PM_NOYIELD|PM_NOREMOVE))
	{
		if((msg.wParam == SC_CLOSE)||(msg.wParam==SC_ICON))
		{
			MessageBeep(0);
			return;
		}
	}
	PostMessage(hWnd,wsmg,wP,lP);
}
/* File History */
/*
08-23-91:	Change GetPInfo from messagebox to regular window.
09-06-91:	Added putdir and verdir.
*/
