#include<stdio.h>
#include<string.h>
#include<ctype.h>

#include "..\h\apt_func.h"
#include "..\h\numstr.h"

extern void far _afree_objptr(OBJECT far *);

void main(int argc,char **argv)
{
	OBJECT far *objptr;
	unsigned long objn;
	unsigned char lname[17],rname[17];
	
	if(argc!=2)
	{
		apt_print_err(DOS_USAGE);
		printf("Usage: getobjinf objn\n");
		printf("      objn is the object number returned by putobj.\n");
		printf("      objn must be a hex number ending with an 'H'\n");
		apt_exit(DOS_USAGE);
	}
	if((apt_getname((char far *)lname)==NULL)||(apt_getrname((char far *)rname)==NULL))
	{
		apt_print_err(DIAG_NO_NAME);
		printf("Local/Remote not found.  Please first run SETNAME.EXE\n");
		apt_exit(DIAG_NO_NAME);
	}
	if(toupper(argv[1][_a_strlen(argv[1])-1])=='H') objn=_a_hex2num(argv[1]);
	else objn=_a_dec2num(argv[1]);
	if((objptr=apt_getobjinfo(objn))==NULL)
	{
		apt_exit_err(apt_status);
	}
	printf("0\n");
	printf("%0.4x\n",objptr->sid);		/* platter ID */
	printf("%lu\n",objptr->obj_size);	/* size */
	printf("%lu\n",objptr->first_obj);	/* first obj num */
	printf("%lu\n",objptr->dtp);			/* previous obj num */
	printf("%lu\n",objptr->objn);			/* next obj num */
	printf("%lu\n",objptr->folder_size); /* starting sector */
	printf("%u\n",objptr->lfn);			/* attribute (status) */
	_afree_objptr(objptr);
	apt_exit(0);
}
/* File History */
/*
04-09-92:	Added _afree_objptr() to free objptr.
*/
