
/***************************************************************/
/*           APT-NOSS CSF For Windows  								*/
/*                                                             */
/*  (C) Copyright 1991, Applied Programming Technologies, Inc. */
/*                  Lake Success, New York                     */
/*                                                             */
/*  DLL Translation Module: Translates traditional NOSS calls  */
/*  to DLL format. To be compiled and linked into the caller's */
/*  application. (any memory model)                            */
/***************************************************************/
#define NOCOMM 1			/* This allows Microsoft C to compile with /W3 option */
#include "windows.h"
#include "..\h\csfdll.h"

unsigned apt_status=0;
unsigned _apt_data_valid=0;

/****************************************************************
	APT_CLOSEFOLDER
****************************************************************/
unsigned far apt_closefolder(unsigned lfn)
{
	return(apt_status=apt_closefolder_(lfn));
}

/****************************************************************
	APT_CLOSEOBJECT
****************************************************************/
unsigned far apt_closeobject(OBJECT far *objptr)
{
	apt_status=apt_closeobject_(objptr);
	if ((apt_status&0xff00) != NOSS_BUSY_TYPE)
	{
		LocalUnlock(LocalHandle((unsigned)objptr));
		LocalFree(LocalHandle((unsigned)objptr));
	}
	return(apt_status);
}

/****************************************************************
	APT_CREATEFOLDER
****************************************************************/
unsigned far apt_createfolder(unsigned objclass)
{
	unsigned lfn;
	apt_status=apt_createfolder_(objclass,&lfn);
	if (apt_status) return(0);
	return(lfn);
}

/****************************************************************
	APT_CREATOBJECT
****************************************************************/
OBJECT far * far apt_createobject(unsigned lfn,unsigned long far *objn,
	unsigned attribute)
{
	OBJECT far *objptr;
	HANDLE hmem;

	if ((hmem=LocalAlloc(LMEM_FIXED|LMEM_ZEROINIT,sizeof(OBJECT)))==0)
	{
badmalloc:;
		apt_status=CSF_MALLOC;
		return(NULL);
	}
	if ((objptr=(OBJECT far *)LocalLock(hmem))==NULL)
	{
		LocalFree(hmem);
		goto badmalloc;
	}

	apt_status=apt_createobject_(lfn,objptr,attribute);
	if (apt_status)
	{
		*objn=0L;
		return(NULL);
	}
	*objn=objptr->objn;
	return(objptr);
}

/****************************************************************
	APT_EOT
****************************************************************/
unsigned far apt_eot(OBJECT far *objptr)
{
	return(apt_eot_(objptr));
}

/****************************************************************
	APT_GETOBJINFO
****************************************************************/
OBJECT far * far apt_getobjinfo(unsigned long objn)
{
	HANDLE hmem;
	OBJECT far *objptr;

	/* NOTE: Caller is responsible for unlocking and freeing this memory */
	if ((hmem=LocalAlloc(LMEM_FIXED|LMEM_ZEROINIT,sizeof(OBJECT)))==0)
	{
badmalloc:;
		apt_status=CSF_MALLOC;
		return(NULL);
	}
	if ((objptr=(OBJECT far *)LocalLock(hmem))==NULL)
	{
		LocalFree(hmem);
		goto badmalloc;
	}

	objptr->objn=objn;
	apt_status=apt_getobjinfo_(objptr);
	if (apt_status)
	{
		LocalUnlock(hmem);
		LocalFree(hmem);
		return(NULL);
	}
	return(objptr);
}

/****************************************************************
	APT_GETPLATINFO
****************************************************************/
unsigned far apt_getplatinfo(void far *buffer,unsigned *numplatters)
{
	return(apt_status=apt_getplatinfo_((LPSTR)buffer,numplatters));
}

/****************************************************************
	APT_GETOBJECT
****************************************************************/
unsigned far apt_getobject(unsigned lfn,unsigned long objn,
	char far *fname,char far *mode)
{
	return(apt_status=apt_getobject_(lfn,objn,fname,mode));
}

/****************************************************************
	APT_OPENFOLDER
****************************************************************/
unsigned far apt_openfolder(unsigned long objn, char far *access)
{
	unsigned lfn;
	apt_status=apt_openfolder_(objn,(LPSTR)access,&lfn);
	if (apt_status) return(0);
	return(lfn);
}

/****************************************************************
	APT_OPENOBJECT
****************************************************************/
OBJECT far * far apt_openobject(unsigned lfn,unsigned long objn,
	char far *mode ,char far *access)
{
	HANDLE hmem;
	OBJECT far *objptr;

	/* NOTE: This memory is unlocked and freed during closeobject */
	if ((hmem=LocalAlloc(LMEM_FIXED|LMEM_ZEROINIT,sizeof(OBJECT)))==0)
	{
badmalloc:;
		apt_status=CSF_MALLOC;
		return(NULL);
	}
	if ((objptr=(OBJECT far *)LocalLock(hmem))==NULL)
	{
		LocalFree(hmem);
		goto badmalloc;
	}
	
	apt_status=apt_openobject_(lfn, objn, (LPOBJ)objptr,(LPSTR)mode, (LPSTR)access);
	if (apt_status)
	{
		LocalUnlock(hmem);
		LocalFree(hmem);
		return(NULL);
	}
	return(objptr);
}

/****************************************************************
	APT_PUTOBJECT
****************************************************************/
unsigned long far apt_putobject(unsigned lfn,char far *fname,
	unsigned attribute)
{
	unsigned long objn;

	apt_status=apt_putobject_(lfn,(LPSTR)fname,attribute,&objn);
	if (apt_status) return(0L);
	return(objn);
}

/****************************************************************
	APT_READOBJECT
****************************************************************/
unsigned far apt_readobject(OBJECT far *objptr,void far *buffer,
	unsigned bytecount)
{
	unsigned long count;
	count=objptr->bytes_remain;
	apt_status=apt_readobject_((LPOBJ)objptr,(LPSTR)buffer,bytecount);
	if (apt_status) return(0);
	count-=objptr->bytes_remain;
	return((unsigned)count);
}

/****************************************************************
	APT_SETNAME
****************************************************************/
unsigned far apt_setname(char far *localname,char far *nossname)
{
	return(apt_status=apt_setname_((LPSTR)localname,(LPSTR)nossname));
}
/****************************************************************
	APT_UNSETNAME
****************************************************************/
unsigned far apt_unsetname(char far *localname,char far *nossname)
{
	return(apt_status=apt_unsetname_((LPSTR)localname,(LPSTR)nossname));
}

/****************************************************************
	APT_WRITEOBJECT
****************************************************************/
unsigned far apt_writeobject(OBJECT far *objptr,void far *buffer,
	unsigned bytecount)
{
	unsigned long count;
	count=objptr->bytes_remain;
	apt_status=apt_writeobject_((LPOBJ)objptr,(LPSTR)buffer,bytecount);
	if (apt_status) return(0);
	count-=objptr->bytes_remain;
	return((unsigned)count);
}

/****************************************************************
	APT_DELOBJECT
****************************************************************/
unsigned far apt_deleteobject(unsigned long objn,unsigned verify_flag)
{
	return(apt_status=apt_deleteobject_(objn,verify_flag));
}
/****************************************************************
	APT_GETNAME
*****************************************************************/
char far * far apt_getname(char far *name)
{
	if(apt_status=apt_getname_((LPSTR)name))
		return(NULL);
	return(name);	
}
/****************************************************************
	APT_GETRNAME
*****************************************************************/
char far * far apt_getrname(char far *name)
{
	if(apt_status=apt_getrname_((LPSTR)name))
		return(NULL);
	return(name);	
}
/****************************************************************
	APT_NETRESET
*****************************************************************/
unsigned far apt_netreset(void)
{
	return(apt_status=apt_netreset_());
}
/****************************************************************
	APT_NOSSDIAG
*****************************************************************/
unsigned far apt_nossdiag(void)
{
	return(apt_status=apt_nossdiag_());
}

/* File History */
/*
09-18-91:	First create from stand alone version.
*/
