/***********************************/
/* NETBIOS node name for NOSS      */
/***********************************/
#define NOSSNAME "APTNOSS"

#define OPEN_ABS  1
#define OPEN_SET  2
#define OPEN_CUR  3
#define OPEN_END  4

#define NORMAL 0
#define READONLY 1
#define PERMANENT 2

#define A_READ		0
#define A_WRITE	1
#define A_APPEND	2

/***********************************/
/* Error code definitions          */
/***********************************/
#define DIAG_ERROR_TYPE 0x0100               /* NOSSDiag() type errors     */
#define DIAG_NO_NAME 0x0101                  /* No name for the node       */
#define DIAG_NO_NOSS 0x0102                  /* NOSS not running           */
#define DIAG_NO_NETBIOS 0x0103               /* NET BIOS not running       */
#define DIAG_BAD_RESPONSE 0x0104             /* Bad BYTECOUNT field pattrn */

#define CSF_ERROR_TYPE 0200                  /* General CSF type errors    */
#define CSF_MALLOC 0x0201                    /* system malloc() error      */
#define CSF_EOT 0x0202                       /* Read beyond EOT            */
#define CSF_RC_XFER_LENGTH 0x0203            /* Request/Confirm mismatch   */
#define CSF_NB_XFER_LENGTH 0x0204            /* Request/Confirm mismatch   */
#define CSF_NOSSST_USAGE 0x0205              /* Usage error for NOSSST     */
#define CSF_BAD_MODE 0x0206                  /* Bad MODE   for OPEN        */
#define CSF_BAD_ACCESS 0x0207                /* Bad ACCESS for OPEN        */
#define CSF_BAD_NAME 0x208                   /* Bad station name given     */
#define CSF_TOO_MANY_OBJECT 0x209				/* Try to open too many object*/
#define CSF_BAD_OBJ_PTR 0x20a						/* An invalid OBJECT given    */
#define CSF_MAX_DB_SECTOR 0x20b					/* exceed Max. # of db Secs. per read */
#define CSF_BAD_SERVER_NAME 0x20c				/* Bad server name given	  */
#define CSF_USERS_EXCEEDED 0x20d					/* too many name in the user name table */

#define SRB_ERROR_TYPE 0x0300                /* STATUS WORD of RSB          */   
#define SRB_BAD_LFN 0x0301                   /* Bad Logical Folder Number   */
#define SRB_BAD_OBJN 0x0302                  /* Object Not Found            */
#define SRB_BAD_SID 0x0303                   /* Bad Service ID              */
#define SRB_BAD_BYTECOUNT 0x0304             /* Bad transfer length         */
#define SRB_BAD_SRN 0x0305                   /* Bad Service Request Number  */
#define SRB_BAD_ACCESS 0x0306                /* Read/Write access conflict  */
                                             /* or other improper access    */
#define SRB_NO_OBJN 0x0307                   /* Error allocating obj num    */
#define SRB_FOLDER_ACTIVE 0x0308             /* Not all objs closed         */
#define SRB_SIMUL_ADDPLAT 0x30a              /* ADDPLAT alread running      */
#define SRB_NOSS_ACTIVE 0x30b                /* Cannot ADDPLAT:NOSS in use. */
#define SRB_OBJN_DELETED 0x30c					/* Object deleted              */
#define SRB_OBJN_READ_ONLY 0x30d					/* Object is readonly          */
#define SRB_OBJN_PERMANENT 0x30e 				/* Object is permanent         */
#define SRB_SIMUL_SETATTRIB 0x30f				/* DEL* or SETATTRIB already running */
#define SRB_OBJN_BADPLATID	 0x310				/* Obj has bad platter id		*/
#define SRB_OBJ_TOO_BIG 0x311						/* Cache too small for object for writing */
#define SRB_FOLDER_TOO_BIG 0x312					/* Cache too small for read folder */
#define SRB_BAD_DBSECTOR 0x313					/* exceed last object db sector */
#define SRB_OBJ_NOT_CLOSED 0x314					/* attemp to open an unclosed obj*/
#define SRB_BAD_SECTOR_SIZE 0x315				/* invalid sector size for read platter */
#define SRB_BAD_PLATID 0x316						/* platter id not found */
#define SRB_USERS_EXCEEDED 0x317					/* too many user to use NOSS  */
#define SRB_USER_EXIST	0x318						/* user register already		*/

#define NB_ERROR_TYPE   0x0400               /* 0x04?? are for NETBIOS     */
                                             /* error codes from the global*/
                                             /* error variable nberror     */

/* The following errors can be retried after a delay */
#define NOSS_BUSY_TYPE 0x500
#define NOSS_NO_LFN 0x501                    /* No available LFN           */
#define NOSS_NO_SID 0x502                    /* No available SID           */
#define NOSS_FOLDER_NOT_DONE 0x503           /* Openning incomplete folder */
#define NOSS_NB_SEND 0x0504                  /* NB SEND error              */
#define NOSS_SMDB_BUSY 0x0505                /* SMDB busy. Retry later     */
#define NOSS_CACHE_FULL 0x506                /* No room in cache storage   */
#define NOSS_MALLOC 0x507                    /* NOSS malloc error          */


/* The following errors are fatal and requires rebooting NOSS */
#define NOSS_FATAL_ERROR_TYPE 0x600
#define NOSS_NB_XFER_LENGTH 0x0602           /* Transfer length mismatch   */
#define NOSS_BAD_BAM_LBA 0x0603              /* bad BAM block address      */
#define NOSS_HARDDISK_CRASH 0x604            /* Cannot happen!!!           */
#define NOSS_LOST_SMDB 0x605                 /* Serious Pointer BUG.       */
#define NOSS_OBJDB_LOST 0x606                /* Error in OBJDB management  */
#define NOSS_GET_OBJREC 0x607                /* OBJDB chainning error      */
#define NOSS_GET_OBJ 0x608                   /* Error doing get_obj()      */
#define NOSS_DISK_SYNCH 0x0609               /* Primary and Backup disk    */
                                             /* miss-synchronized.         */
#define NOSS_JUKEBOX_ERROR 0x060a            /* All jukebox access error   */
#define NOSS_NO_STORAGE_DRIVE 0x060b         /* No drive available         */
#define NOSS_NO_STORAGE_SLOT 0x060c          /* No storage slot available  */

/* The following errors are related to disk management */
#define NOSS_NO_OPTICAL_SPACE 0x0701         /* All active platter full    */
#define NOSS_DISK_OFFLINE	0x702					/* Disk not inside jukebox    */

/* The following are errors related to DOS operation */
#define DOS_ERROR_TYPE 0x800
#define DOS_FILE_ACCESS 0x801                /* General DOS file error     */
#define DOS_USAGE 0x802								/* Usage errors               */
#define DOS_ABORTED 0x803							/* User abort                 */

#define SCSI_ERROR 0x1000                    /* 1xxx: xxx is retcode of    */
                                             /*       aptcall()            */
#define HARDDRIVE_ERROR 0x2000               /* 2xxx: xxx is DOS err code  */
                                             /* for int 25H and 26H        */
#define NOSSINFO struct nossinfostr

/**************************************************/
/* Noss Infomation Structure (NOSSINFO)           */
/*  This is for the nossdiag function.            */
/**************************************************/
struct nossinfostr
{
   unsigned long hfree;       /* space available for halloc()            */
   unsigned long cfree;       /* space available for calloc() and malloc */
   unsigned int bamsize;      /* byte size of BAMMAP size                */
   char far *bam;
};

struct folderinfostr
{
	unsigned FldSts;				//Folder status
	unsigned NumObj;				//Number of objects
	unsigned NumPltr;				//Number of Platters
	unsigned long FstObjNum;	//First Object Number
	unsigned FldAct;				//Folder Activity 
	char far *ObjArry;			//Object Number Arry
};
#define FLDINF struct folderinfostr

/*******************************************************/
/* The OBJECT Structure                                */
/*  (For open/create/close/read/write operations       */
/*  to objects.  Analogus to "C" FILE structure.)      */
/* WARNING: User applications shall not change the     */
/*          the contents of these fields.   These      */
/*          fields are considered read-only.           */
/*******************************************************/
struct objectstr
{
   unsigned int lfn;             /* Logical Folder Number            */
   unsigned int sid;             /* Service ID                       */
   unsigned long objn;           /* Object Number                    */
   unsigned long dtp;            /* Data Transfer Pointer            */
   unsigned long first_obj;      /* obj num of 1st obj in folder     */
   unsigned int num_objs;        /* Number of objs in the folder     */
   unsigned long folder_size;    /* Total Storage Occupied by folder */
   unsigned long obj_size;       /* Size of current object           */
   unsigned long bytes_remain;   /* Number of un-read bytes          */
	unsigned attribute;				/* Attribute of object              */
   unsigned char lsn;				/* LSN                              */
};

#define OBJECT struct objectstr
#define LPOBJ OBJECT far *


typedef struct
{
	void *fptr;
	unsigned handle;
} FILE_DSC;

/***********************************/
/*  CSF declarations               */
/***********************************/
/* terminates a folder operation: */
WORD FAR PASCAL apt_closefolder_(WORD lfn);

/* terminates an object operation: objptr  */
WORD FAR PASCAL apt_closeobject_(LPOBJ objptr); 

/* creates a new folder: object class */
WORD FAR PASCAL apt_createfolder_(WORD objc,LPWORD lfn);

/* creates a new object:lfn,objnumptr,attribute */
WORD FAR PASCAL apt_createobject_(WORD lfn,LPOBJ objptr,WORD attribute);

/* marks an obj as deleted */
WORD FAR PASCAL apt_deleteobject_(DWORD objn,WORD verify_flag);

/* checks end of transmission: objptr */
WORD FAR PASCAL apt_eot_(LPOBJ objptr);

/* gets the workstation name from local name table */
WORD FAR PASCAL apt_getname_(LPSTR name);

/* gets platter record from NOSS */
WORD FAR PASCAL apt_getplatinfo_(LPVOID platter_buffer,LPWORD num_platters);

/* gets the APTNOSS server name (group name) from name table */
WORD FAR PASCAL apt_getrname_(LPSTR name);

/* get an object and store as DOS file */
WORD FAR PASCAL apt_getobject_(WORD lfn,DWORD objn,LPSTR fname,LPSTR smode);

/* get infor about an object:objn */
WORD FAR PASCAL apt_getobjinfo_(LPOBJ objptr);

/* performs Netbios Reset */
WORD FAR PASCAL apt_netreset_(void);

/* performs NOSS diagnostics: niptr  */
WORD FAR PASCAL apt_nossdiag_(void);

/* opens an existing folder: objn,access="R" for read or "A" for append */
WORD FAR PASCAL apt_openfolder_(DWORD objn,LPSTR access,LPWORD lfn);

/* retrieves an object :lfn,objn,mode="D","A", or "R" ,access*/
WORD FAR PASCAL apt_openobject_(WORD lfn,DWORD objn,LPOBJ objptr,LPSTR mode,LPSTR access);

/* stores a DOS file as an object into a folder */
WORD FAR PASCAL apt_putobject_(WORD lfn,LPSTR fname,WORD attribute,LPDWORD objn);

/* reads from an opened object:objptr,buffer,bytecount */
WORD FAR PASCAL apt_readobject_(LPOBJ objptr,LPVOID buffer,WORD count);

/* sets local and noss name: localname,nossname */
WORD FAR PASCAL apt_setname_(LPSTR localname,LPSTR nossname);

/* unsets local and noss name: localname,nossname */
WORD FAR PASCAL apt_unsetname_(LPSTR name,LPSTR noss);

/* writes to an object:objptr,buffer,count */
WORD FAR PASCAL apt_writeobject_(LPOBJ objptr,LPVOID buffer,WORD count);

int FAR PASCAL LibMain(HANDLE hModule,WORD wDataSeg,WORD cbHeapSize,LPSTR lpszCmdLine);
int FAR PASCAL WEP(int bSystemExit);
/*FILE HISTORY*/
/*
12-04-90:	Added errors 0x311 and 0x312 to handle inadaquit cache size problems
01-16-91:	Added error 0x209 for too many object open.
06-24-91:	Removed netbios related constants.  Netbios.h will have them.
08-30-91:	Modify from apt_func.h to fit the csfdll.
*/
