all: sample.exe

# Update the resource if necessary

sample.res: sample.rc sample.h
    rc -r sample.rc

# Update the object file if necessary

sample.obj: sample.c sample.h
    BCC -c -w-ccc -Od  -a -P  -v -DQE_OS232  -I$(include) -o$*.obj sample.c

# Update the executable file if necessary, and if so, add the resource back in.

sample.exe: sample.obj sample.def
    tlink /L$(lib) /Toe /aa /v c02 sample,sample.exe,sample.map, qelib32 c2 os2, sample.def
    rc sample.res

# If the .res file is new and the .exe file is not, update the resource.
# Note that the .rc file can be updated without having to either
# compile or link the file.

sample.exe: sample.res
    rc sample.res
