		/*----------------------------------------+
		|		  SAMP.C		  |
		+-----------------------------------------+
		|  Sample Code from QELIB 2.0 User Guide  |
		+----------------------------------------*/

/*--------------------------------------------------------------+
|  Purpose: To provide the sample code that appears in the	|
|	QELIB User's Guide.					|
|								|
|  Copyright: 1993 Q+E Software, Inc.				|
+--------------------------------------------------------------*/

#define INCL_WINSYS
#define INCL_WINMLE
#define INCL_WINBUTTONS
#define INCL_WINWINDOWMGR
#define INCL_DOSRESOURCES

#define MessageBox(hWnd, title, msg, style) WinMessageBox(HWND_DESKTOP,NULLHANDLE, (PSZ)title, (PSZ)msg, (U16)0, (U32)style)

#include <os2.h>
#include "..\..\include\qelib.h"
#include "sample.h"
#include <stdlib.h>
#include <string.h>

HWND	hWnd = 0;
HWND	hWndClient = 0;
HWND	hCodeWnd = 0;
HWND	hButWnd = 0;
int	nCurCode = 0;


int main (void)
{
	static CHAR  szClientClass[] = "BookWClass" ;
	HAB	  hab ;
	HMQ	  hmq ;
	HWND	  hwndFrame, hwndClient ;
	QMSG	  qmsg ;

	hab = WinInitialize (0) ;

	hmq = WinCreateMsgQueue (hab, 0) ;

	WinRegisterClass (hab, szClientClass, MainWndProc, 0, 0) ;

	InitInstance(hwndFrame, szClientClass);

	while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0, 0))
		WinDispatchMsg (hab, &qmsg) ;

	WinDestroyWindow (hwndFrame) ;
	WinDestroyMsgQueue (hmq) ;
	WinTerminate (hab) ;
	return 0 ;
}


BOOL InitInstance(HWND	  hWndClient,
		  char	  szClientClass[])
{

	ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU  |
			     FCF_MINMAX	       | FCF_BORDER   |
			     FCF_SHELLPOSITION | FCF_TASKLIST |
			     FCF_MENU	       | FCF_ICON ;

	//int	result;			/* Result from dialog procedure */

	HWND hWnd;


	hWnd = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE, &flFrameFlags,
			     szClientClass, "QELIB Example 1",
			     CS_SIZEREDRAW, NULLHANDLE,
			     ID_RESOURCE, &hWndClient) ;


/* If window could not be created, return "failure" */
	if (!hWnd) return (FALSE);


	WinSetWindowPos (hWnd, HWND_TOP,
	       WinQuerySysValue(HWND_DESKTOP,SV_CXICON) * 2,
	       WinQuerySysValue(HWND_DESKTOP,SV_CYICON) * 2,
	       WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN) - 200,
	       WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN) - 200,
	       SWP_SHOW | SWP_ACTIVATE | SWP_ZORDER | SWP_SIZE | SWP_MOVE);


/* Create window for code */

	RECTL rcl;
	WinQueryWindowRect(hWndClient, (PRECTL)&rcl);
	hCodeWnd = WinCreateWindow(hWndClient, WC_MLE, (PSZ)NULL,
			      MLS_HSCROLL | MLS_VSCROLL | MLS_WORDWRAP | MLS_BORDER
			      | MLS_READONLY | WS_VISIBLE,
			      (SHORT)rcl.xLeft, (SHORT)rcl.yBottom,
			      //(SHORT)rcl.xRight, (SHORT)rcl.yTop - 100,
			      (SHORT)rcl.xRight, (SHORT)rcl.yTop,
			      hWndClient, HWND_TOP, 1, NULL, NULL);

	if (!hCodeWnd)
		return (FALSE);


/* Create run button */

#if 0
	hButWnd = WinCreateWindow(hWndClient, WC_BUTTON, (PSZ)"Run Code",
			      WS_VISIBLE | BS_PUSHBUTTON,
			      (SHORT) ((rcl.xRight - rcl.xLeft)/2) - 45,
			      (SHORT)rcl.yTop - 80, (SHORT)90, (SHORT)40,
			      hWndClient, HWND_TOP, IDB_BUTTON, NULL, NULL);

	if (!hButWnd) return (FALSE);
#endif


	return (TRUE);


}


MRESULT EXPENTRY MainWndProc(
	HWND hWnd,			  /* window handle */
	ULONG message,		       /* type of message */
	MPARAM mp1,			 /* additional information */
	MPARAM mp2)			 /* additional information */
{
/* Handle Windows messages */


	HPS	hps;
	
	switch (message) {

	case WM_PAINT:
		hps = WinBeginPaint(hWnd, 0, 0);
		GpiErase(hps);
		WinEndPaint(hps);
		return 0;


	case WM_COMMAND:	   /* message: command from application menu*/
		switch (COMMANDMSG(&message)->cmd) {
		case IDM_CONNECT:
			LoadCode(IDM_CONNECT, CONNECT);
			break;
		case IDM_COLINFO:
			LoadCode(IDM_COLINFO, COLINFO);
			break;
		case IDM_DATADICT:
			LoadCode(IDM_DATADICT, DATADICT);
			break;
		case IDM_BINDFETCH:
			LoadCode(IDM_BINDFETCH, BINDFETCH);
			break;
		case IDM_VALFETCH:
			LoadCode(IDM_VALFETCH, VALFETCH);
			break;
		case IDM_RECORDOP:
			LoadCode(IDM_RECORDOP, RECORDOP);
			break;
		case IDM_DML:
			LoadCode(IDM_DML, DML);
			break;
		case IDM_PARAMS:
			LoadCode(IDM_PARAMS, PARAMS);
			break;
		case IDM_PARSE:
			LoadCode(IDM_PARSE, PARSE);
			break;
		case IDM_QB:
			LoadCode(IDM_QB, QB);
			break;
		case IDM_QBE:
			LoadCode(IDM_QBE, QBE);
			break;
		case IDM_TRACE:
			LoadCode(IDM_TRACE, TRACE);
			break;
		case IDM_TRANS:
			LoadCode(IDM_TRANS, TRANS);
			break;
			
		case IDB_BUTTON:	/* A menu command has been chosen */
			switch (nCurCode) {
			case IDM_CONNECT:
				connect ();
				break;
			case IDM_COLINFO:
				colinfo ();
				break;
			case IDM_DATADICT:
				datadict ();
				break;
			case IDM_BINDFETCH:
				bindfetch ();
				break;
			case IDM_VALFETCH:
				valfetch ();
				break;
			case IDM_RECORDOP:
				recordop ();
				break;
			case IDM_DML:
				dml ();
				break;
			case IDM_PARAMS:
				params ();
				break;
			case IDM_PARSE:
				parse ();
				break;
			case IDM_QB:
				querybuilder ();
				break;
			case IDM_QBE:
				qbe ();
				break;
			case IDM_TRACE:
				trace ();
				break;
			case IDM_TRANS:
				trans ();
				break;

			default:
				break;
			}
			break;
			
		case IDM_QUIT:
			WinPostMsg(hWnd, WM_QUIT, 0L, 0L) ;
			break;
		default:		    /* Lets Windows process it */
			return (WinDefWindowProc(hWnd, message, mp1, mp2));
		}
		break;
	case WM_DESTROY:		  /* message: window being destroyed*/
		WinPostMsg(hWnd, WM_QUIT, 0L, 0L) ;
		break;

	default:			  /* Passes it on if unproccessed */
		return (WinDefWindowProc(hWnd, message, mp1, mp2));
	}
	return (NULL);
}

/*----------------------------------------------------------------------*/
/* Routines corresponding to the menu commands				*/
/*----------------------------------------------------------------------*/

qeSTATUS connect () {

/* This routine connects to the dBASE driver, and then disconnects. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Insert code here to execute SQL statements, fetch records, etc. */

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Connect", MB_OK);
	return (res_code);
}


qeSTATUS datadict () {

/* This routine demonstrates calls to qeSources, a data dictionary routine */
/* that returns an hstmt whose result set contains a list of the available */
/* database system sources. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	char		source [qeSRC_MAX_LEN+1];
	long		source_len = qeSRC_MAX_LEN+1;
	char		extension [qeSRC_MAX_LEN+1];
	long		extension_len = qeSRC_MAX_LEN+1;
	short		source_hdbc;
	long		source_hdbc_len = sizeof (source_hdbc);
	char		remark [qeSRC_REMARK_MAX_LEN+1];
	long		remark_len = qeSRC_REMARK_MAX_LEN+1;

/* Call qeLibInit to initialize QELIB, check for errors */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Note: you do not have to be connected to get the list of Sources */

/* Get an hstmt whose result set contains records that describe each Source. */
	hstmt = qeSources (1);
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Bind local variables to the columns returned for each record */
	res_code = qeBindColChar (hstmt, 1, source, &source_len, "");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qeBindColChar (hstmt, 2, extension, &extension_len, "");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qeBindColInt (hstmt, 3, &source_hdbc, &source_hdbc_len);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qeBindColChar (hstmt, 4, remark, &remark_len, "");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Fetch rows and display each source name in a message box. */
	while (qeFetchNext (hstmt) == qeSUCCESS) {
		MessageBox (hWnd, source, "Data Dictionary: qeSources", MB_OK);
	}
	if ((qeErr () != qeSUCCESS) && (qeErr () != qeEOF))
		return (err_handler (hdbc, hstmt));

/* Close the data dictionary statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Data Dictionary", MB_OK);
	return (res_code);
}



qeSTATUS bindfetch () {

/* This routine demonstrates how to use the bind functions to fetch data */
/* from Select statements directly into program variables. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	char		last_name [11];
	long		last_name_len = 11;
	float		salary;
	long		salary_len = sizeof(salary);

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the select statement. Check if hstmt == 0, */
/* which indicates that the statement did not execute successfully. */
	hstmt = qeExecSQL (hdbc, "Select last_name, salary from emp");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Bind the result columns to program variables. */
	res_code = qeBindColChar (hstmt, 1, last_name, &last_name_len, "");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qeBindColFloat (hstmt, 2, &salary, &salary_len);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Fetch the records from the select statement. */
	while (qeFetchNext (hstmt) == qeSUCCESS) {
		MessageBox (hWnd, last_name, "Bind Fetch", MB_OK);
	}

/* Check for errors, EOF is ok. */
	res_code = qeErr ();
	if ((res_code != qeSUCCESS) && (res_code != qeEOF))
		return (err_handler (hdbc, hstmt));

/* Close the SQL statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Bind Fetch", MB_OK);
	return (res_code);
}

qeSTATUS valfetch () {

/* This routine demonstrates how to fetch data from SELECT statements using */
/* the qeVal functions. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	qeLPSTR		last_name;
	qeLPSTR		nameptr;
	float		salary;

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the select statement. If hstmt == 0, */
/* then the statement did not execute successfully. */
	hstmt = qeExecSQL (hdbc, "Select last_name, salary from emp");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Fetch the records from the select statement, and get the individual */
/* column values. */
	while (qeFetchNext (hstmt) == qeSUCCESS) {

		nameptr = qeValChar (hstmt, 1, "", 0);
		if (qeErr () != qeSUCCESS && qeErr () != qeNULL_DATA) break;
		MessageBox (hWnd, nameptr, "Val Fetch", MB_OK);
		salary = qeValFloat (hstmt, 2);
		if (qeErr () != qeSUCCESS && qeErr () != qeNULL_DATA) break;
	}

/* Check for errors, EOF is ok. */
	res_code = qeErr ();
	if ((res_code != qeSUCCESS) && (res_code != qeEOF))
		return (err_handler (hdbc, hstmt));

/* Close the SQL statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Val Fetch", MB_OK);
	return (res_code);
}



qeSTATUS recordop (){

/* This routine demonstrates the use of the qeRec functions.  These */
/* functions operate on the current record of an hstmt resulting from */
/* executing a Select statement. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */

/* Call qeLibInit to initialize QELIB, check for errors */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the select statement. Check if hstmt == 0, */
/* which indicates that the statement did not execute successfully. */
	hstmt = qeExecSQL (hdbc, "Select first_name, last_name from emp");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Position to the first record. */
	res_code = qeFetchNext (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Update the employee's first name to Gerald. */
	res_code = qePutChar (hstmt, 1, "", "Gerald");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));
	res_code = qeRecUpdate (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Position on second record and delete it. */
	res_code = qeFetchNext (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));
	res_code = qeRecDelete (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Create a new record, make it record number 2 in the result set. */
/* Set the new employee's name to Ed Allen. The call to qeRecUpdate */
/* will insert the record into the database table. */
	res_code = qeRecNew (hstmt, 2);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qePutChar (hstmt, 1, "", "Ed");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qePutChar (hstmt, 2, "", "Allen");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qeRecUpdate (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Close the statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Current Record", MB_OK);
	return (res_code);
}

qeSTATUS dml () {

/* This routine demonstrates how to execute an SQL Update statement. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	long		modrecs;

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the update statement. Check if hstmt == 0, */
/* which indicates that the statement did not execute successfully. */
	hstmt = qeExecSQL (hdbc, "Update emp set first_name = 'Joe' where first_name = 'Richard'");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Find out how many records were affected by the statement. */
	modrecs = qeNumModRecs (hstmt);
	if (qeErr () != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Close the statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "SQL Update Statement", MB_OK);
	return (res_code);
}

qeSTATUS params () {

/* This routine demonstrates the use of bound parameters in SQL Update */
/* statements. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	char		new_name[31], old_name[31];
	long		new_name_len = 30, old_name_len = 30;

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Call qeSQLPrepare to prepare the update statement. The Update statement */
/* will change the first_name of an employee.  Check if hstmt == 0, */
/* which indicates that the function did not succeed. */
	hstmt = qeSQLPrepare (hdbc, "Update emp set first_name = ? where first_name = ?");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Bind the parameters to local variables that contain the parameter values. */
	res_code = qeBindParamChar (hstmt, 1, new_name, &new_name_len);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qeBindParamChar (hstmt, 2, old_name, &old_name_len);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Set the parameters. */
	strcpy (new_name, "Joe");
	new_name_len = strlen (new_name);
	strcpy (old_name, "Tim");
	old_name_len = strlen (old_name);

/* Execute the statement. */
	res_code = qeSQLExecute (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Note: To make repeated updates, you simply change the new_name and */
/* old_name variables and call qeSQLExecute. */

/* Close the statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Binding Parameters", MB_OK);
	return (res_code);
}

qeSTATUS parse () {

/* This routine demonstrates the functions which return individual clauses */
/* from a SELECT statement. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	qeLPSTR		clause;

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the update statement. Check if hstmt == 0, */
/* which indicates that the statement did not execute successfully. */
	hstmt = qeSQLPrepare (hdbc, "select * from emp where first_name = ?");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Set the statement parameters. */
	res_code = qeSetParamChar (hstmt, 1, "Joe", 20);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Execute the statement. */
	res_code = qeSQLExecute (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Get the Where clause. */
	clause = qeClauseGet (hstmt, qeCLAUSE_WHERE);
	if (qeErr () != qeSUCCESS) return (err_handler (hdbc, hstmt));
	MessageBox (hWnd, clause, "Parsing", MB_OK);

/* Close the statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Parse Functions", MB_OK);
	return (res_code);
}

qeSTATUS querybuilder () {

/* This routine demonstrates the execution of the Query Builder from within */
/* a QELIB program. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	qeHANDLE	hqry = 0;	/* Handle to query object */

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Allocate a query structure to be used for Query Builder calls. */
	hqry = qeQryAllocate (hdbc, "");
	if (hqry == 0) return (err_handler (hdbc, hstmt));

/* Run the query builder.  The resulting statement will be stored in hqry. */
	res_code = qeQryBuilder (hqry, hWnd,
		qeQRY_BIG_ICONS + qeQRY_TABLES + qeQRY_VIEWS, qeQRY_DEFAULT);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Prepare & execute the statement created in the query builder. */
	hstmt = qeQryPrepare (hqry);
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

	res_code = qeSQLExecute (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Free query structure. */
	res_code = qeQryFree (hqry);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Query Builder", MB_OK);
	return (res_code);
}

qeSTATUS qbe (){

/* This routine demonstrates the use of Query By Example (QBE). */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	qeLPSTR		first_name;

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Select first & last names from emp. */
	hstmt = qeExecSQL (hdbc, "select first_name, last_name from emp");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Set a condition to search for all first names starting with 'T'. */
	res_code = qeRecSetConditionChar (hstmt, 1, qeFIND_LIKE, "T%", "",
					  FALSE);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Re-Execute the Select statement incorporating the QBE conditions. */
	res_code = qeSQLExecute (hstmt);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Fetch and display the first names of the records found. */
	while (qeFetchNext (hstmt) == qeSUCCESS) {
		first_name = qeValChar (hstmt, 1, "", 0);
		if (qeErr () != qeSUCCESS && qeErr () != qeNULL_DATA) break;
		MessageBox (hWnd, first_name, "Query By Example", MB_OK);
	}
	if ((qeErr () !=qeSUCCESS) && (qeErr () != qeEOF))
		return (err_handler (hdbc, hstmt));

/* Close the statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "QBE Conditions", MB_OK);
	return (res_code);
}


qeSTATUS trace () {

/* This routine demonstrates the use of the tracing facilities. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	long		modrecs;

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Turn tracing on, set options to trace everything. */
	res_code = qeTraceOn ("c:\\qelib\\trace.txt");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

	res_code = qeSetTraceOptions (qeTRACE_NON_VAL_CALLS + qeTRACE_USER +
				   qeTRACE_VAL_CALLS + qeTRACE_ODBC);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeConnect to connect to a data source.	Check if hdbc == 0, which */
/* indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Set the ODBC tracefile. */
	res_code = qeSetDriverTracefile (hdbc, "c:\\qelib\\odbc.txt");
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the update statement. Check if hstmt == 0, */
/* which indicates that the statement did not execute successfully. */
	hstmt = qeExecSQL (hdbc, "Update emp set first_name = 'Joe' where first_name = 'Richard'");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Find out how many records were affected by the statement. */
	modrecs = qeNumModRecs (hstmt);
	if (qeErr () != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Close the statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Close the tracefiles. */
	res_code = qeTraceOff ();
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Trace Functions", MB_OK);
	return (res_code);
}

qeSTATUS trans () {

/* This routine demonstrates the use of transactions to rollback changes */
/* made by an SQL Update statement. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Start a transaction. */
	res_code = qeBeginTran (hdbc);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the update statement. Check if hstmt == 0, */
/* which indicates that the statement did not execute successfully. */
	hstmt = qeExecSQL (hdbc, "Update emp set first_name = 'Richard' where first_name = 'Joe'");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Rollback the transaction. */
	res_code = qeRollback (hdbc);
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Close the statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Transactions", MB_OK);
	return (res_code);
}

qeSTATUS colinfo () {

/* This routine demonstrates how to use the qeCol functions functions to */
/* get information about the columns returned by a Select statement. */

	qeHANDLE	hdbc = 0;	/* Handle to database connection */
	qeHANDLE	hstmt = 0;	/* Handle to SQL statement execution */
	qeSTATUS	res_code;	/* Result code from QELIB functions */
	short		col_count, col;
	qeLPSTR		col_name_ptr;

/* Call qeLibInit to initialize QELIB, check for errors. */
	res_code = qeLibInit ();
	if (res_code != qeSUCCESS) return (res_code);

/* Call qeConnect to connect to a data source.	Check to see */
/* if hdbc == 0, which indicates that the connection failed. */
	hdbc = qeConnect ("DSN=QEDBF");
	if (hdbc == 0) return (err_handler (hdbc, hstmt));

/* Call qeExecSQL to execute the select statement. Check if hstmt == 0, */
/* which indicates that the statement did not execute successfully. */
	hstmt = qeExecSQL (hdbc, "Select * from emp");
	if (hstmt == 0) return (err_handler (hdbc, hstmt));

/* Get the column names returned by the Select statement */
	for (col_count = qeNumCols (hstmt), col = 1; col_count--; col++ ) {
		if (qeErr () != qeSUCCESS)
			return (err_handler (hdbc, hstmt));

		col_name_ptr = qeColName (hstmt, col);
		if (qeErr () != qeSUCCESS)
			return (err_handler (hdbc, hstmt));
		MessageBox (hWnd, col_name_ptr, "Column Name", MB_OK);
	}

/* Close the SQL statement. */
	res_code = qeEndSQL (hstmt);
	hstmt = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeDisconnect to disconnect from a data source. */
	res_code = qeDisconnect (hdbc);
	hdbc = 0;
	if (res_code != qeSUCCESS) return (err_handler (hdbc, hstmt));

/* Call qeLibTerm to free memory allocated by QELIB. */
	res_code = qeLibTerm ();
	MessageBox (hWnd, "Sample succeeded.", "Column Info", MB_OK);
	return (res_code);
}


qeSTATUS err_handler (qeHANDLE hdbc, qeHANDLE hstmt) {

/* This routine functions as an error handler for the demonstration */
/* routines. It displays an error message in a message box, terminates the */
/* active statement, closes the connection, ends the QELIB session, and */
/* returns the result code from the most recent QELIB call. */

	qeSTATUS	res_code;	/* Result code from QELIB functions */

	res_code = qeErr ();		/* Get the QELIB error number */
	if (res_code > 0)		/* Display an error message */
		MessageBox (hWnd, qeErrMsg (), "Sample Failed", MB_OK);
	else {	/* Display error number for negative result codes */
		char	buf[10];
		MessageBox (hWnd, qeIntToChar (res_code, ""), "Sample Failed",
			    MB_OK);
	}
	if (hstmt != 0)	  qeEndSQL (hstmt);	/* End statement if active */
	if (hdbc != 0)	  qeDisconnect (hdbc);	/* Close connection if open */
	qeLibTerm ();				/* Last call to QELIB */
	return (res_code);
}


VOID LoadCode(ULONG ulCurCode, ULONG ulNameID)
{ 

	PVOID	pResource = 0;
	static ULONG	size = 0;
	CHAR	*szMleBuf;
	IPT	lOffset = 0;

	//
	// Clear the MLE
	//
	WinSendMsg(hCodeWnd, MLM_SETSEL,
		MPFROMP(lOffset), MPFROMP(size));
	WinSendMsg(hCodeWnd, MLM_CLEAR, 0L, 0L);

	
	DosGetResource((HMODULE)0, RT_CODE, ulNameID, &pResource);
	DosQueryResourceSize(0, RT_CODE, ulNameID, &size);
	szMleBuf = (CHAR *)malloc(size);
	memset(szMleBuf, 0, size);
	WinSendMsg(hCodeWnd, MLM_SETIMPORTEXPORT,
		   MPFROMP(szMleBuf),
		   MPFROMSHORT((USHORT)size));
	WinSendMsg(hCodeWnd, MLM_FORMAT,
		   MPFROMSHORT((USHORT)MLFIE_CFTEXT),
		   0L);
	memcpy(szMleBuf, pResource, size);
	WinSendMsg(hCodeWnd, MLM_IMPORT,
			 MPFROMP(&lOffset), MPFROMP(&size));
	DosFreeResource ((PVOID)pResource);
	free(szMleBuf);
	nCurCode = ulCurCode;
	WinEnableWindow (hButWnd, TRUE);
}