/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/*                 Copyright Powersoft Corporation 1990 - 1993             */
/*                                                                         */
/*       Powersoft Corporation ("Powersoft") claims copyright in this      */
/*     program and documentation as an unpublished work, versions of       */
/*     which were first licensed on the date indicated in the foregoing    */
/*     notice. Claim of copyright does not imply waiver of Powersoft's     */
/*     other rights. See Notice of Proprietary Rights.                     */
/*                                                                         */
/*                 NOTICE OF PROPRIETARY RIGHTS                            */
/*                                                                         */
/*       This program and documentation are confidential trade             */
/*     secrets and the property of Powersoft.  Use, examination,           */
/*     reproduction, copying, disassembly, decompilation, transfer         */
/*     and/or disclosure to others are strictly prohibited except by       */
/*     express written agreement with Powersoft.                           */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*    Filename : pborca.h                                                  */
/*                                                                         */
/*    Purpose  : PowerBuilder Open Repository CASE API                     */
/*                DLL public header file.                                  */
/*                                                                         */
/*    Notes    : 1. This header file should be included after <windows.h>  */
/*                                                                         */
/* *********************************************************************** */

#ifndef PB_ORCA                              /* First time defined?  */
#define PB_ORCA                              /* Yes, make sure of it */

#ifndef CHAR                                 /* We have a CHAR definiton? */
#define CHAR char                            /* No, then do it */
#endif

/* *********************************************************************** */
/* ORCA Interface assorted #defines                                        */
/* *********************************************************************** */

#define HPBORCA           LPVOID             /* ORCA session handle */
#define PBORCA_MSGBUFFER  256                /* Suggested msg buffer size */
#define PBORCA_MAXCOMMENT 255                /* Maximum comment size */


/* *********************************************************************** */
/* ORCA Interface result #defines                                          */
/* *********************************************************************** */

#define PBORCA_OK              0             /* Operation successful */
#define PBORCA_INVALIDPARMS   -1             /* Invalid parameter list */
#define PBORCA_DUPOPERATION   -2             /* Duplicate operation */    
#define PBORCA_OBJNOTFOUND    -3             /* Object not found */ 
#define PBORCA_BADLIBRARY     -4             /* Bad library name */
#define PBORCA_LIBLISTNOTSET  -5             /* Library list not set */
#define PBORCA_LIBNOTINLIST   -6             /* Library not in lib list */
#define PBORCA_LIBIOERROR     -7             /* Library I/O error */          
#define PBORCA_OBJEXISTS      -8             /* Object exists */          
#define PBORCA_INVALIDNAME    -9             /* Invalid name */          
#define PBORCA_BUFFERTOOSMALL -10            /* Buffer size is too small */          
#define PBORCA_COMPERROR      -11            /* Compile error */
#define PBORCA_LINKERROR      -12            /* Link error */
#define PBORCA_CURRAPPLNOTSET -13            /* Current appl not set */
#define PBORCA_OBJHASNOANCS   -14            /* Object has no ancestors */          
#define PBORCA_OBJHASNOREFS   -15            /* Object has no references */          

/* *********************************************************************** */
/* ORCA entry types                                                        */
/* *********************************************************************** */

typedef enum pborca_type
{

  PBORCA_APPLICATION,     
  PBORCA_DATAWINDOW,      
  PBORCA_FUNCTION,      
  PBORCA_MENU,      
  PBORCA_QUERY,      
  PBORCA_STRUCTURE,      
  PBORCA_USEROBJECT,      
  PBORCA_WINDOW       

} PBORCA_TYPE, FAR *PPBORCA_TYPE;

typedef enum pborca_reftype
{

  PBORCA_REFTYPE_SIMPLE,  
  PBORCA_REFTYPE_OPEN  

} PBORCA_REFTYPE, FAR *PPBORCA_REFTYPE;

/* *********************************************************************** */
/* Structure for PBORCA_CompileEntryImport callback function.              */
/* *********************************************************************** */
typedef struct pborca_comperr  
{

  int            iLevel;                     /* Error level */
  LPSTR          lpszMessageNumber;          /* Pointer to message number */ 
  LPSTR          lpszMessageText;            /* Pointer to message text */ 
  UINT           iColumnNumber;              /* Column number */
  UINT	         iLineNumber;                /* Line number */

} PBORCA_COMPERR, FAR *PPBORCA_COMPERR;

/* *********************************************************************** */
/* Prototype for PBORCA_CompileEntryImport callback function.              */
/* *********************************************************************** */
typedef void (FAR PASCAL *PBORCA_ERRPROC) ( PPBORCA_COMPERR, LPVOID );


/* *********************************************************************** */
/* Structure for PBORCA_LibraryDirectory callback function.                */
/* *********************************************************************** */
typedef struct pborca_direntry 
{
					     /* Comments */
  CHAR           szComments[PBORCA_MAXCOMMENT + 1];

  LONG           lCreateTime;                /* Time of entry create/mod */ 
  LONG           lEntrySize;                 /* Size of entry */
  LPSTR          lpszEntryName;              /* Pointer to entry name */
  PBORCA_TYPE    otEntryType;                /* Entry type */

} PBORCA_DIRENTRY, FAR *PPBORCA_DIRENTRY;


/* *********************************************************************** */
/* Prototype for PBORCA_LibraryDirectory callback function.                */
/* *********************************************************************** */
typedef void (FAR PASCAL *PBORCA_LISTPROC) ( PPBORCA_DIRENTRY, LPVOID );


/* *********************************************************************** */
/* Structure for PBORCA_LibraryEntryInformation callback function.         */
/* *********************************************************************** */
typedef struct pborca_entryinfo 
{
					     /* Comments */
  CHAR           szComments[PBORCA_MAXCOMMENT + 1];

  LONG           lCreateTime;                /* Time of entry create/mod */ 
  LONG           lObjectSize;                /* Size of object */
  LONG           lSourceSize;                /* Size of source */

} PBORCA_ENTRYINFO, FAR *PPBORCA_ENTRYINFO;


/* *********************************************************************** */
/* Structure for PBORCA_ObjectQueryHierarchy callback function.            */
/* *********************************************************************** */
typedef struct pborca_hierarchy
{

  LPSTR          lpszAncestorName;           /* Pointer to ancestor name */ 

} PBORCA_HIERARCHY, FAR *PPBORCA_HIERARCHY;

/* *********************************************************************** */
/* Prototype for PBORCA_ObjectQueryHierarchy callback function.            */
/* *********************************************************************** */
typedef void (FAR PASCAL *PBORCA_HIERPROC) ( PPBORCA_HIERARCHY, LPVOID );


/* *********************************************************************** */
/* Structure for PBORCA_ObjectQueryReference callback function.            */
/* *********************************************************************** */
typedef struct pborca_reference
{

  LPSTR          lpszLibraryName;            /* Pointer to library name */ 
  LPSTR          lpszEntryName;              /* Pointer to entry name */
  PBORCA_TYPE    otEntryType;                /* Entry type */
  PBORCA_REFTYPE otEntryRefType;             /* Entry reference type */

} PBORCA_REFERENCE, FAR *PPBORCA_REFERENCE;

/* *********************************************************************** */
/* Prototype for PBORCA_ObjectQueryReference callback function.            */
/* *********************************************************************** */
typedef void (FAR PASCAL *PBORCA_REFPROC) ( PPBORCA_REFERENCE, LPVOID );


/* *********************************************************************** */
/* Session function prototypes                                             */
/* *********************************************************************** */

void    FAR PASCAL PBORCA_SessionClose          ( HPBORCA hORCASession );

void    FAR PASCAL PBORCA_SessionGetError       ( HPBORCA hORCASession,
                                                  LPSTR   lpszErrorBuffer,
                                                  int     iErrorBufferSize );

HPBORCA FAR PASCAL PBORCA_SessionOpen           ( void );

int     FAR PASCAL PBORCA_SessionSetCurrentAppl ( HPBORCA hORCASession,
                                                  LPSTR   lpszApplLibName,  
                                                  LPSTR   lpszApplName );

int     FAR PASCAL PBORCA_SessionSetLibraryList ( HPBORCA    hORCASession,
                                                  LPSTR FAR *pLibNames, 
                                                  int        iNumberOfLibs );


/* *********************************************************************** */
/* Library management function prototypes                                  */
/* *********************************************************************** */

int FAR PASCAL PBORCA_LibraryCommentModify ( HPBORCA hORCASession,
                                             LPSTR   lpszLibName,  
                                             LPSTR   lpszLibComments );

int FAR PASCAL PBORCA_LibraryCreate    ( HPBORCA hORCASession,
                                         LPSTR   lpszLibName,  
                                         LPSTR   lpszLibComments );

int FAR PASCAL PBORCA_LibraryDelete    ( HPBORCA hORCASession,
                                         LPSTR   lpszLibName );   

int FAR PASCAL PBORCA_LibraryDirectory ( HPBORCA         hORCASession,
                                         LPSTR           lpszLibName,       
                                         LPSTR           lpszLibComments,  
                                         int             iCmntsBuffSize, 
                                         PBORCA_LISTPROC pListProc, 
                                         LPVOID          pUserData );

int FAR PASCAL PBORCA_LibraryEntryCopy ( HPBORCA     hORCASession,
                                         LPSTR       lpszSourceLibName,  
                                         LPSTR       lpszDestLibName,  
                                         LPSTR       lpszEntryName, 
                                         PBORCA_TYPE otEntryType );

int FAR PASCAL PBORCA_LibraryEntryDelete ( HPBORCA     hORCASession,
                                           LPSTR       lpszLibName,  
                                           LPSTR       lpszEntryName, 
                                           PBORCA_TYPE otEntryType );

int FAR PASCAL PBORCA_LibraryEntryExport ( HPBORCA     hORCASession,
                                           LPSTR       lpszLibName,  
                                           LPSTR       lpszEntryName, 
                                           PBORCA_TYPE otEntryType,    
                                           LPSTR       lpszExportBuffer, 
                                           LONG        lExportBufferSize );

int FAR PASCAL PBORCA_LibraryEntryInformation ( HPBORCA           hORCASession,
                                                LPSTR             lpszLibName,  
                                                LPSTR             lpszEntryName, 
                                                PBORCA_TYPE       otEntryType,    
                                                PPBORCA_ENTRYINFO pEntryInfo );

int FAR PASCAL PBORCA_LibraryEntryMove ( HPBORCA     hORCASession,
                                         LPSTR       lpszSourceLibName,  
                                         LPSTR       lpszDestLibName,  
                                         LPSTR       lpszEntryName, 
                                         PBORCA_TYPE otEntryType );

/* *********************************************************************** */
/* Compilation function prototypes                                         */
/* *********************************************************************** */

int FAR PASCAL PBORCA_CompileEntryImport ( HPBORCA        hORCASession,
                                           LPSTR          lpszLibraryName,  
                                           LPSTR          lpszEntryName, 
                                           PBORCA_TYPE    otEntryType, 
                                           LPSTR          lpszComments,  
                                           LPSTR          lpszEntrySyntax,
                                           LONG           lEntrySyntaxBuffSize, 
                                           PBORCA_ERRPROC pCompErrProc, 
                                           LPVOID         pUserData );

int FAR PASCAL PBORCA_CompileEntryImportList ( HPBORCA          hORCASession,
                                               LPSTR far       *pLibraryNames,  
                                               LPSTR far       *pEntryNames, 
                                               PBORCA_TYPE far *otEntryType, 
                                               LPSTR far       *pComments,  
                                               LPSTR far       *pEntrySyntaxBuffers,
                                               LONG far        *pEntrySyntaxBuffSizes, 
                                               int              iNumberOfEntries, 
                                               PBORCA_ERRPROC   pCompErrProc, 
                                               LPVOID           pUserData );

int FAR PASCAL PBORCA_CompileEntryRegenerate ( HPBORCA        hORCASession,
                                               LPSTR          lpszLibraryName,  
                                               LPSTR          lpszEntryName, 
                                               PBORCA_TYPE    otEntryType, 
                                               PBORCA_ERRPROC pCompErrProc, 
                                               LPVOID         pUserData );

/* *********************************************************************** */
/* Executable construction function prototypes                             */
/* *********************************************************************** */

/* *********************************************************************** */
/* Object query function prototypes                                        */
/* *********************************************************************** */

int FAR PASCAL PBORCA_ObjectQueryHierarchy ( HPBORCA         hORCASession,
                                             LPSTR           lpszLibraryName,  
                                             LPSTR           lpszEntryName, 
                                             PBORCA_TYPE     otEntryType, 
                                             PBORCA_HIERPROC pHierarchyProc, 
                                             LPVOID          pUserData );

int FAR PASCAL PBORCA_ObjectQueryReference ( HPBORCA         hORCASession,
                                             LPSTR           lpszLibraryName,  
                                             LPSTR           lpszEntryName, 
                                             PBORCA_TYPE     otEntryType, 
                                             PBORCA_REFPROC  pReferenceProc, 
                                             LPVOID          pUserData );

#endif    /* PB_ORCA */

