/* clib1.c -- Minimal C run-time library for emx.dll
   Copyright (c) 1993-1994 by Eberhard Mattes

This file is part of emx.

emx is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

emx is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emx; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

As special exception, emx.dll can be distributed without source code
unless it has been changed.  If you modify emx.dll, this exception
no longer applies and you must remove this paragraph from all source
files for emx.dll.  */


#include "clib.h"

#define FALSE 0
#define TRUE  1

void _defext (char *dst, const char *ext)
{
  int dot, sep;

  dot = FALSE; sep = TRUE;
  while (*dst != 0)
    switch (*dst++)
      {
      case '.':
        dot = TRUE;
        sep = FALSE;
        break;
      case ':':
      case '/':
      case '\\':
        dot = FALSE;
        sep = TRUE;
        break;
      default:
        sep = FALSE;
        break;
      }
  if (!dot && !sep)
    {
      *dst++ = '.';
      strcpy (dst, ext);
    }
}


char *_getname (const char *path)
{
  const char *p;

  p = path;
  while (*path != 0)
    {
      switch (*path)
        {
        case ':':
        case '/':
        case '\\':
          p = path + 1;
          break;
        }
      ++path;
    }
  return ((char *)p);
}


int stricmp (const char *string1, const char *string2)
{
  int d;

  for (;;)
    {
      d = tolower ((unsigned char)*string1)
        - tolower ((unsigned char)*string2);
      if (d != 0 || *string1 == 0 || *string2 == 0)
        return (d);
      ++string1; ++string2;
    }
}
