/* sys/ioctl1.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <errno.h>
#include <os2emx.h>
#include "syscalls.h"


int __ioctl1 (int handle, int code)
{
  ULONG rc;
  ULONG htype, hflags;

  if (code != 0)
    {
      errno = EINVAL;
      return (-1);
    }
  rc = DosQueryHType (handle, &htype, &hflags);
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return (-1);
    }
  if ((htype & 0xff) == 0)
    return (0);
  return ((hflags & 0x0f) | 0x80);
}
