/* omflibcl.c (emx+gcc) -- Copyright (c) 1993-1994 by Eberhard Mattes */

/* Copy an OMFLIB. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "omflib0.h"
#include <sys/omflib.h>

int omflib_copy_lib (struct omflib *dst, struct omflib *src, char *error)
{
  int i;

  if (src->mod_count == -1 && omflib_make_mod_tab (src, error) != 0)
    return (-1);
  for (i = 0; i < src->mod_count; ++i)
    if (!(src->mod_tab[i].flags & FLAG_DELETED))
      {
        fseek (src->f, src->mod_tab[i].page * src->page_size, SEEK_SET);
        if (omflib_copy_module (dst, dst->f, src, src->f,
                                src->mod_tab[i].name, error) != 0)
          return (-1);
      }
  return (0);
}
