/* fpathcon.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <unistd.h>
#include <limits.h>
#include <errno.h>

/* Return the POSIX.1  minimum values, for now. */

long fpathconf (int handle, int name)
{
  switch (name)
    {
    case _PC_LINK_MAX:
      return (_POSIX_LINK_MAX);

    case _PC_MAX_CANON:
      return (_POSIX_MAX_CANON);

    case _PC_MAX_INPUT:
      return (_POSIX_MAX_INPUT);

    case _PC_NAME_MAX:
      return (_POSIX_NAME_MAX);

    case _PC_PATH_MAX:
      return (_POSIX_PATH_MAX);

    case _PC_PIPE_BUF:
      return (_POSIX_PIPE_BUF);

    case _PC_CHOWN_RESTRICTED:
      return (1);

    case _PC_NO_TRUNC:
      return (1);               /* TODO */

    case _PC_VDISABLE:
      return (0);

    default:
      errno = EINVAL;
      return (-1);
    }
}
