/* utime.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <time.h>
#include <sys/time.h>
#include <sys/utime.h>

int utime (const char *name, const struct utimbuf *times)
{
  struct timeval tv[2];

  if (times == NULL)
    {
      tv[0].tv_sec = tv[1].tv_sec = time (NULL);
      tv[0].tv_usec = tv[1].tv_usec = 0;
    }
  else
    {
      tv[0].tv_sec = times->actime;
      tv[0].tv_usec = 0;
      tv[1].tv_sec = times->modtime;
      tv[1].tv_usec = 0;
    }
  if (!_tzset_flag) tzset ();
  tv[0].tv_sec -= timezone;
  tv[1].tv_sec -= timezone;
  return (__utimes (name, tv));
}
