/* sys/time.h (emx+gcc) */

#if !defined (_SYS_TIME_H)
#define _SYS_TIME_H

#include <time.h>

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_TIMEVAL)
#define _TIMEVAL
struct timeval
{
  long tv_sec;
  long tv_usec;
};
#endif

#if !defined (_TIMEZONE)
#define _TIMEZONE
struct timezone
{
  int tz_minuteswest;
  int tz_dsttime;
};
#endif

int utimes (__const__ char *name, __const__ struct timeval *tvp);
int gettimeofday (struct timeval *tp, struct timezone *tzp);
int settimeofday (__const__ struct timeval *tp,
    __const__ struct timezone *tzp);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_SYS_TIME_H) */
