
/*
 * This file was generated by the SOM Compiler.
 * FileName: DM2Test.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */

/*
 * 
 * 
 * 
 *      DM2Test.CSC - DeskMan/2 setup test object.
 * 
 *   Ŀ
 *     DM2Test object - setup string manipulation methods.                
 *                      Part of DeskMan/2.                                
 *                                                                        
 *     (C) Copyright 1993-1994 Development Technologies, Inc.             
 *         Portions Copyright 1993 Gregory Czaja                          
 *         All rights reserved                                            
 *         DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image    
 *         are trademarks of Development Technologies, Inc. (DevTech),    
 *         a Pennsylvania Corporation                                     
 *                                                                        
 *     version 1: initial release                          April 1994     
 *   
 */


#define DM2Test_Class_Source

#pragma checkout(suspend)
#include "DM2Test.ih"
#pragma checkout(resume)
      /* Dm2Test.ih will include the DM2Setup.H file required for the direct
         Dm2Setup's method invocation. See DM2Setup.H file for the methods 
         description.

         This (enclosed) code demonstrates how to use the Dm2Setup's public
         methods for saving and retrieving of private object's instance data
         utilizing setup strings.
         Currently, those methods can be invoked using DeskMan/2 starting with
         version 1.50. To test the DM/2 Test object, run the DM2TEST.CMD, which
         registers the DM2Test object class and creates a DM/2 Test object on
         the Desktop. Then, DeskMan/2's "Save" or "Query object settings on drop"
         Special function can be used to test the code. When PMPrintf is active
         on the system, additional information will be put in the PMPrintf LOG
         window.

         How does it work: if an object (class) responds to the DeskMan2QuerySetup
         method, DeskMan/2 (or any other object) may create a DM2Setup object.
         This object implements a set of setup string manipulation methods which
         allow the receiver to pass private setup strings back to the caller.
         Those setup string can be saved for the purpose of restoring/recreating
         the original object with all instance data preserved, on the same or
         a different system. The setup strings have to be constructed in a way
         making them "environment-independent", i.e. pointers, handles, etc.
         should not be used. Any inter-object dependencies need to be resolved
         based on unique identifiers, such as object ID's or object titles/
         locations. References to absolute directory names are allowed but should
         be documented to the user, so, he would be able to modify the generated
         object data before restoring the object. Generally, a better approach
         would be providing the object with enough intelligence to either acquire
         this kind of information by itself or ask the user during the restoration
         process or before the first use.

       */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include "DM2Test2.h"

HMODULE MyQueryModuleHandle(VOID);

MRESULT EXPENTRY ProdInfoDlgProc( HWND hwnd, ULONG msg, MPARAM mp1,
                                  MPARAM mp2);

HMODULE hmodDLL = NULLHANDLE;         /* class DLL handle */

/*Ŀ
 DeskMan2QuerySetup - query private setup string                  94/03/31 
 DeskMan2QuerySetup - your class has to support it!               94/03/31 
*/
SOM_Scope APIRET   SOMLINK DM2TestX_DeskMan2QuerySetup(DM2Test *somSelf,
		WPObject *setupObject)
{
    DM2TestData *somThis = DM2TestGetData(somSelf);
    DM2TestMethodDebug("DM2Test","DM2TestX_DeskMan2QuerySetup");

              /* Note: there are two ways to invoke the DM2Setup methods:  */
              /*                                                           */
              /*       1. direct invocation (using the method's name).     */
              /*          In this case, the DEF file for your object       */
              /*          invoking the methods needs to contain the        */
              /*          following IMPORT statements:                     */
              /*                                                           */
              /*          IMPORTS                                          */
              /*             DM2Setup.DM2SetupCClassData                   */
              /*             Dm2Setup.DM2SetupClassData                    */
              /*             DM2Setup.DM2SetupNewClass                     */
              /*             DM2Setup.M_DM2SetupCClassData                 */
              /*             DM2Setup.M_DM2SetupClassData                  */
              /*             DM2Setup.M_DM2SetupNewClass                   */
              /*                                                           */
              /*          and the DM2Setup.DLL needs to be located in a    */
              /*          directory on the LIBPATH!                        */
              /*          Note also that the SOM compiler will REPLACE the */
              /*          DEF file for your class when you change the CSC  */
              /*          file and re-run the SOM compile!                 */
              /*                                                           */
              /*          NOTE: since DM2Test uses this method, it locks   */
              /*          the DM2Setup.DLL. This (currently) prevents      */
              /*          DeskMan from being re-installed if the Dm2Test   */
              /*          object is present on the Desktop!                */
              /*          You have to delete DM2Test to be able to install */
              /*          DeskMan/2!                                       */
              /*                                                           */
              /*       2. invocation using the SOM dispatching mechanism.  */
              /*          This one may be not as pretty and readable,      */
              /*          and has not as good performancend but it may be  */
              /*          easier to implement and is less error-prone.     */
              /*          It does NOT require neither inclusion of the     */
              /*          DM2Setup.H file nor IMPORTS statements nor       */
              /*          DM2Setup.DLL presence on the LIBPATH.            */
              /*                                                           */
              /*          Both methods are presented below.                */

              /* This one sets the entire setup string to the   */
              /* character string specified.                    */             
              /* Note: SEMICOLON(s) need to be included!        */
              /*       The current contents of the setup buffer */
              /*       will be destroyed.                       */

              /* Note: direct invocation.                       */
    _fromString(setupObject, "SETUP1=First setup value;");

              /* Adds a setup string keyword/value pair to the  */
              /* current contents of the setup buffer           */
              /* Note: SEMICOLON will be appended by DM2Setup   */
              /*       for the pair added. The EQUAL SIGN will  */
              /*       be inserted automatically, too.          */

              /* Note: direct invocation.                       */
    _addSetup(setupObject, "SETUP2", "Second setup value");

              /* Note: invocation using the somDispatch method  */
    _somDispatchL(setupObject,
                  SOM_IdFromString("addSetup"),
                  NULL,
                  "SETUP3", "Third setup value");

              /* display the LENGTH of the current setup string */
              /* Note: direct invocation.                       */
    printf("The current setup string length is: %d.\n",
                                               _queryLength(setupObject));

              /* display the current contents of the setup buffer*/
              /* Note: invocation using the somDispatch method  */
    printf("The current setup string is:\n%s.\n", 
                                  _somDispatchA(setupObject,
                                                SOM_IdFromString("queryBuffer"),
                                                NULL));


    return (APIRET) 0;
}

/*Ŀ
 wpSetup - override                                               94/03/31 
*/
SOM_Scope BOOL   SOMLINK DM2TestX_wpSetup(DM2Test *somSelf,
		PSZ pszSetupString)
{
    DM2TestData *somThis = DM2TestGetData(somSelf);

    ULONG   ulLength = 0;                          /* setup value length */
    CHAR    szValue[256];                          /* setup value        */

    DM2TestMethodDebug("DM2Test","DM2TestX_wpSetup");

                 /* in wpSetup, expect the setup string passed during the */
                 /* object creation to contain your private setup strings */
                 /* in addition to the other (default) WPS setups.        */
                 /* Process your PRIVATE setup strings and pass the string*/
                 /* to your parent. The private values do NOT need to be  */
                 /* removed from the setup string passed!                 */

    printf("Setup string passed:\n%s.\n", pszSetupString);

                 /* Note: wpScanSetupString with szValue==NULL seems to   */
                 /*       be broken in 2.11. Do NOT use to get the szValue*/
                 /*       length!                                         */
    if (_wpScanSetupString(somSelf, pszSetupString,
                           "SETUP1", szValue, &ulLength))
       printf("SETUP1 value is: %s.\n", szValue);

    if (_wpScanSetupString(somSelf, pszSetupString,
                           "SETUP2", szValue, &ulLength))
       printf("SETUP2 value is: %s.\n", szValue);
                      
    if (_wpScanSetupString(somSelf, pszSetupString,
                           "SETUP3", szValue, &ulLength))
       printf("SETUP3 value is: %s.\n", szValue);

    return (parent_wpSetup(somSelf,pszSetupString));
}

/*Ŀ
 wpModifyPopupMenu - override                                     94/03/31 
*/
SOM_Scope BOOL   SOMLINK DM2TestX_wpModifyPopupMenu(DM2Test *somSelf,
		HWND hwndMenu,
		HWND hwndCnr,
		ULONG iPosition)
{
    DM2TestData *somThis = DM2TestGetData(somSelf);
    DM2TestMethodDebug("DM2Test","DM2TestX_wpModifyPopupMenu");

                            /* insert the Product information menu item */
    _wpInsertPopupMenuItems(somSelf, hwndMenu, 0,
                            MyQueryModuleHandle(), 
                            MI_HELP_MENU, WPMENUID_HELP);
                           
    return (parent_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition));
}

/*Ŀ
 wpMenuItemSelected - override                                    94/03/31 
*/
SOM_Scope BOOL   SOMLINK DM2TestX_wpMenuItemSelected(DM2Test *somSelf,
		HWND hwndFrame,
		ULONG ulMenuId)
{
    DM2TestData *somThis = DM2TestGetData(somSelf);
    DM2TestMethodDebug("DM2Test","DM2TestX_wpMenuItemSelected");

    switch (ulMenuId) {

       case MI_DMTEST_PRODINFO:         /* display product information */
          {
            DLGDATA dlgData;              /* data passed to the dialog */

            dlgData.cb=sizeof(DLGDATA);
            dlgData.ulLogoTime=0;
            
            WinDlgBox( HWND_DESKTOP,    /* Place anywhere on desktop    */
                       HWND_DESKTOP,    /* Owned by the desktop         */
                       ProdInfoDlgProc,          /* Addr. of procedure  */
                       MyQueryModuleHandle(),    /* Module handle       */
                       ID_PRODINFO,     /* Dialog identifier in resource*/
                       &dlgData);
          };
          return TRUE;
    } 

    return (parent_wpMenuItemSelected(somSelf,hwndFrame,ulMenuId));
}

/*Ŀ
 wpAddObjectWindowPage - override                                 94/03/31 
*/
SOM_Scope ULONG   SOMLINK DM2TestX_wpAddObjectWindowPage(DM2Test *somSelf,
		HWND hwndNotebook)
{
    DM2TestData *somThis = DM2TestGetData(somSelf);
    DM2TestMethodDebug("DM2Test","DM2TestX_wpAddObjectWindowPage");

    /* don't insert the Window - Settings page - not used ! */
    return (SETTINGS_PAGE_REMOVED);
}
/*Ŀ
 Class methods                                                    94/03/31 
*/
#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta

/*Ŀ
 wpclsInitData - override                                         94/03/31 
*/
SOM_Scope void   SOMLINK DM2TestC_wpclsInitData(M_DM2Test *somSelf)
{
    /* M_DM2TestData *somThis = M_DM2TestGetData(somSelf); */
    M_DM2TestMethodDebug("M_DM2Test","DM2TestC_wpclsInitData");

    MyQueryModuleHandle();       /* initialize our class DLL handle */

    parent_wpclsInitData(somSelf);
}

/*Ŀ
 wpclsUnInitData - override                                       94/03/31 
*/
SOM_Scope void   SOMLINK DM2TestC_wpclsUnInitData(M_DM2Test *somSelf)
{
    /* M_DM2TestData *somThis = M_DM2TestGetData(somSelf); */
    M_DM2TestMethodDebug("M_DM2Test","DM2TestC_wpclsUnInitData");

    parent_wpclsUnInitData(somSelf);
}

/*Ŀ
 wpclsQueryIconData - override                                    94/03/31 
*/
SOM_Scope ULONG   SOMLINK DM2TestC_wpclsQueryIconData(M_DM2Test *somSelf,
		PICONINFO pIconInfo)
{
    /* M_DM2TestData *somThis = M_DM2TestGetData(somSelf); */
    M_DM2TestMethodDebug("M_DM2Test","DM2TestC_wpclsQueryIconData");

    if (pIconInfo != NULL) {          /* return our default ICON data */
       pIconInfo->fFormat = ICON_RESOURCE;
       pIconInfo->hmod    = MyQueryModuleHandle();
       pIconInfo->resid   = ID_DM2TEST_MAIN;
    } /* endif */

    return (sizeof(ICONINFO));       /* and ALWAYS return the SIZE OF */
}

/*Ŀ
 wpclsQueryTitle - override                                       94/03/31 
*/
SOM_Scope PSZ   SOMLINK DM2TestC_wpclsQueryTitle(M_DM2Test *somSelf)
{
    /* M_DM2TestData *somThis = M_DM2TestGetData(somSelf); */
    M_DM2TestMethodDebug("M_DM2Test","DM2TestC_wpclsQueryTitle");

    return ("DM/2 Test");      /* this is our default object title */
}

/**************************  ORDINARY CODE SECTION  ***************************
*****                                                                     *****
*****                  Any non-method code should go here.                *****
*****                                                                     *****
******************************************************************************/
#undef SOM_CurrentClass

/*Ŀ
 What's it called: MyQueryModuleHandle                                    
                                                                          
 What does it do : returns the module handle for this DLL                 
*/
HMODULE MyQueryModuleHandle(VOID)
{
   ULONG rc;
   PSZ   pszPathName;

   if (hmodDLL == NULLHANDLE) {

      pszPathName = _somLocateClassFile(SOMClassMgrObject,
                                        SOM_IdFromString(DM2TEST_CLASSNAME),
                                        0,0);
      rc = DosQueryModuleHandle(pszPathName, &hmodDLL);

      if (rc) 
         return NULLHANDLE;

   }/* end if */

   return(hmodDLL);

}  /* end MyQueryModuleHandle */

/*Ŀ
   Name : ProdInfoDlgProc                                              
                                                                       
   Description : Processes all messages sent to the Product            
                 Information dialog box.                               
*/
MRESULT EXPENTRY ProdInfoDlgProc( HWND hwnd, ULONG msg, MPARAM mp1,
                                  MPARAM mp2)
{
   switch(msg) {
      case WM_INITDLG:
         {
            SWP      swp;
            HAB      hab = WinQueryAnchorBlock(HWND_DESKTOP);
 
            WinQueryTaskSizePos(hab, 0, &swp);   
            WinSetWindowPos(hwnd,
                            HWND_TOP,
                            swp.x, swp.y, 0, 0,
                            SWP_MOVE);
         };
         break;

      case WM_COMMAND:
         {
         /*
          * No matter what the command, close the dialog
          */
          WinDismissDlg(hwnd, TRUE);
         };
         break;

      case WM_PAINT:
      {
         SWP      swpTxt, swpDlg;
         HPS      hps;
         POINTL   ptl;
         HBITMAP  hbm = NULLHANDLE;

         WinDefDlgProc(hwnd, WM_PAINT, mp1, mp2);  /* normal dialog painting */

         hps = WinGetPS(hwnd);                         /* now, add our stuff */
                                                    /* load and draw Example */
         hbm = GpiLoadBitmap(hps,
                             MyQueryModuleHandle(),
                             ID_DM2TEST_BITMAP, 0L, 0L);

                             /* position the logo bitmap */
         WinQueryWindowPos(WinWindowFromID(hwnd, ID_PROD_DESKMAN), &swpTxt);
         WinQueryWindowPos(hwnd, &swpDlg);
         ptl.x = (LONG)((swpDlg.cx - 30) / 2);
         ptl.y = (LONG)((((swpDlg.cy - swpTxt.y) - 53) / 2) + swpTxt.y);
         WinDrawBitmap(hps,
                       hbm,
                       NULL,
                       &ptl,
                       0L,
                       0L,
                       DBM_IMAGEATTRS);
         WinReleasePS(hps);

         return (MRESULT)0;
      }

      default:
         return(WinDefDlgProc(hwnd, msg, mp1, mp2));
   }

   return (MRESULT)0;
}

