/* REXX OS/2 - PerfWPSO.CMD  perform a wpSaveImmediate object function*/
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Saves the settings of the name-object located in the        
        FolderName-folder.                                          
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformWPSaveObject=name,FolderName;                        
                                                                    
        name can be:         . object title                         
                             . object ID                            
                             . fully qualified path                 
                             . ALL                                  
          note: if ALL is used, all objects located in the folder   
                specified will be saved (not allowed with ANYWHERE) 
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used. Not allowed with ALL.                         
                                                                    
*/
/*ͻ
 Note: this is a DIFFERENT function than the PerformSaveObject.     
 PerformSaveObject saves the object description in the DeskMan/2    
 DRC file.                                                          
 PerformWPSaveObject saves the current state of the WPS object(s)   
 on the Desktop. It can be used to customize (install) the objects  
 on the desktop using a batch process and force a SAVE in a similar 
 way as a Shut down does, in case the installation process is run   
 unattended and a (software driven) re-boot is required by means    
 of a SETBOOT /IBD:x command.                                       
*/

/* Execute as: PERFWPSO Name Folder                                 */

Parse Arg args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' .;
   Else Parse Var args    folder    .;

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'PerformWPSaveObject='object','folder';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing WPSave object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: WPSave object initiated successfully!';
Exit 0;                

