/* REXX OS/2 - PerfSS.CMD  perform a System Settings Save function  */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Performs a SaveSystemSettings function.                     
                                                                    
        Note: no REXX generation is performed.                      
                                                                    
        The IRC file specified will be used to save the settings    
                                                                    
        The format is:                                              
        PerformSaveSystemSettings=x:\path\fileI.drc;                
                                                                    
*/

/* Execute as: PERFSS x:\deskman\test.IRC                           */

Arg IRCfile . ;  /* accept the IRC file name as parameter           */

If IRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the IRC file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

If Right(IRCfile, 1) <> ';'
   Then IRCfile=IRCfile||';';     /* remember! SEMICOLON */

rc=SysSetObjectData('<DeskMan1>', 'PerformSaveSystemSettings='IRCfile);
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Save System Settings!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Save System Settings initiated successfully!';
Exit 0;                

/* ----------------------------------------------------------------*/
